/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class JewelBlasterCanvas
extends Canvas
implements CommandListener,
Runnable {
    private static final int GS_LOAD = 0;
    private static final int GS_XING = 1;
    private static final int GS_LOGO = 2;
    private static final int GS_PRESENT = 3;
    private static final int GS_TITLE = 4;
    private static final int GS_MENU = 5;
    private static final int GS_LEVEL = 6;
    private static final int GS_PLAY = 7;
    private static final int GS_GAMEOVER = 8;
    private static final int GS_WIN = 9;
    private static final int GS_GAME_CONTROLS = 10;
    private static final int GS_CREDITS = 11;
    private static final int GS_HIGHSCORES = 12;
    private int m_iGameState = 0;
    public int m_iResumeState = 0;
    public static final int VK_STAR = 0;
    public static final int VK_POUND = 1;
    public static final int VK_LEFT = 2;
    public static final int VK_RIGHT = 3;
    public static final int VK_UP = 4;
    public static final int VK_DOWN = 5;
    public static final int VK_FIRE = 6;
    public boolean[] m_pressedKeys = new boolean[7];
    public boolean[] m_releasedKeys = new boolean[7];
    public static final int TARGET_GAME_WIDTH = 176;
    public static final int TARGET_GAME_HEIGHT = 208;
    private final JewelBlasterMIDlet m_midlet;
    private final Display m_display;
    private final byte FPS = (byte)50;
    private long m_oldFrameTick;
    private volatile Thread m_animationThread = null;
    private long m_lFrameTickDiff;
    private boolean m_bPaused = false;
    public Image m_imgBackground;
    public Image m_imgLogo;
    public Image m_imgTitle;
    public Image m_imgXing;
    public Image m_imgBat;
    public Image m_imgJewels;
    public Image m_imgPyramid;
    private Image m_imgBlack = null;
    private Font m_fontTexts1;
    private Font m_fontTexts2;
    private Font m_fontTexts3;
    private Random m_rnd;
    private long m_lLogoTick = 0L;
    private long m_lXingTick = 0L;
    private long m_lLevelTick = 0L;
    private long m_lWinTick = 0L;
    private long m_lGameOverTick = 0L;
    private long m_lPresentTick = 0L;
    private long m_lBlinkTick = 0L;
    private boolean m_bBlinkShow = true;
    private String[] m_strMenuTexts = new String[]{TextResources.getString(0), TextResources.getString(1), TextResources.getString(29), TextResources.getString(2), TextResources.getString(3), TextResources.getString(4), TextResources.getString(5), TextResources.getString(6)};
    private static final int m_iNumMenuTexts = 8;
    private NvMenu m_menu;
    private boolean m_bSoundOn = true;
    public NvTone m_music;
    private int m_iCreditTextYPos;
    private NvHighScores m_highScores;
    private NvProfile m_profile;
    private boolean m_bWin = false;
    private boolean m_bPauseDone = false;
    private static final int FLAG_KEY_LEFT = 0;
    private static final int FLAG_KEY_RIGHT = 1;
    private static final int FLAG_KEY_UP = 2;
    private static final int FLAG_KEY_DOWN = 3;
    private static final int FLAG_KEY_ACTION = 4;
    private static final int NUM_KEY_FLAGS = 5;
    private boolean[] m_bKeyPressedFlags = new boolean[5];
    private int m_relX = 0;
    private int m_relY = 0;
    private boolean m_bCanGameResume = false;
    private int m_iMaxJewels;
    private int m_iNumJewels;
    private int m_iScore;
    private int m_iLevel;
    private final int MAX_LEVELS;
    private int m_playerX;
    private ColumnsJewel m_sptCurrentJewel;
    private boolean m_bShot = false;
    private Vector m_jewels;
    private int m_iPosIdx;
    private boolean m_bReady;
    private int m_vanishIdxBegin;
    private int m_vanishIdxEnd;
    private boolean m_bVanishingJewels;
    private static final int[][] m_pos = new int[][]{{-18, 21}, {-1, 21}, {16, 21}, {33, 21}, {50, 21}, {67, 21}, {84, 21}, {101, 21}, {118, 21}, {135, 21}, {152, 21}, {152, 38}, {152, 55}, {135, 55}, {118, 55}, {101, 55}, {84, 55}, {67, 55}, {50, 55}, {33, 55}, {16, 55}, {16, 72}, {16, 89}, {33, 89}, {50, 89}, {67, 89}, {84, 89}, {101, 89}, {118, 89}, {135, 89}, {152, 89}, {152, 106}, {152, 123}, {135, 123}, {118, 123}, {101, 123}, {84, 123}, {67, 123}, {50, 123}, {33, 123}, {16, 123}};

    public JewelBlasterCanvas(JewelBlasterMIDlet jewelBlasterMIDlet, Display display) {
        this.MAX_LEVELS = 20;
        this.setFullScreenMode(true);
        this.m_fontTexts1 = Font.getFont((int)64, (int)0, (int)8);
        this.repaint();
        this.m_fontTexts2 = Font.getFont((int)64, (int)1, (int)0);
        this.m_fontTexts3 = Font.getFont((int)64, (int)1, (int)16);
        this.m_midlet = jewelBlasterMIDlet;
        this.m_display = display;
        this.m_lFrameTickDiff = 0L;
        this.m_rnd = new Random();
    }

    private void initSprites() {
        this.m_jewels = new Vector();
        this.m_jewels.removeAllElements();
    }

    private void initGame() {
        this.m_bSoundOn = true;
        this.m_music = new NvTone();
        this.m_imgXing = JewelBlasterMIDlet.loadImage("xingmobile");
        this.m_imgLogo = JewelBlasterMIDlet.loadImage("condetsoft");
        this.m_imgTitle = JewelBlasterMIDlet.loadImage("title");
        this.m_imgBackground = JewelBlasterMIDlet.loadImage("bkg");
        this.m_imgBat = JewelBlasterMIDlet.loadImage("bat");
        this.m_imgJewels = JewelBlasterMIDlet.loadImage("jewels");
        this.m_imgPyramid = JewelBlasterMIDlet.loadImage("pyramid");
        this.createBlackImage(this.getWidth(), this.getHeight());
        this.m_relX = (this.getWidth() - this.m_imgBackground.getWidth()) / 2;
        this.m_relY = (this.getHeight() - this.m_imgBackground.getHeight()) / 2;
        this.initSprites();
        this.m_menu = new NvMenu(this.m_strMenuTexts, 8, new NvRectangle(0, 0, this.getWidth(), this.getHeight()), this.m_fontTexts1);
        this.m_profile = new NvProfile(this.m_display, this);
        this.m_highScores = new NvHighScores(this.m_profile, this.getWidth(), this.getHeight(), this.m_fontTexts1);
        for (int i = 0; i < 5; ++i) {
            this.m_bKeyPressedFlags[i] = false;
        }
    }

    private void createBlackImage(int n, int n2) {
        this.m_imgBlack = Image.createImage((int)n, (int)n2);
        Graphics graphics = this.m_imgBlack.getGraphics();
        graphics.setColor(0);
        graphics.fillRect(0, 0, n, n2);
    }

    public synchronized void start() {
        this.initGame();
        this.m_animationThread = new Thread(this);
        this.m_oldFrameTick = System.currentTimeMillis();
        this.m_animationThread.start();
    }

    public synchronized void stop() {
        this.m_animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = 20L;
        Thread thread = Thread.currentThread();
        this.m_iGameState = 1;
        try {
            while (thread == this.m_animationThread && thread != null && !this.m_midlet.m_bNeedExit) {
                long l2 = System.currentTimeMillis();
                this.m_lFrameTickDiff = l2 - this.m_oldFrameTick;
                if (this.m_lFrameTickDiff == 0L) continue;
                this.m_oldFrameTick = l2;
                this.processInput();
                this.repaint(0, 0, this.getWidth(), this.getHeight());
                this.serviceRepaints();
                if (this.m_lFrameTickDiff < l) {
                    JewelBlasterCanvas jewelBlasterCanvas = this;
                    synchronized (jewelBlasterCanvas) {
                        this.wait(l - this.m_lFrameTickDiff);
                        continue;
                    }
                }
                if (thread == null) continue;
                thread.yield();
            }
            this.m_music.destroy();
            if (this.m_midlet != null) {
                this.m_midlet.exitRequested();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void blackened(Graphics graphics) {
        if (this.m_imgBlack == null) {
            graphics.setColor(0, 0, 0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            graphics.drawImage(this.m_imgBlack, 0, 0, 20);
        }
    }

    public void paint(Graphics graphics) {
        switch (this.m_iGameState) {
            case 0: {
                this.blackened(graphics);
                this.renderCenteredScreenYellowText(graphics, TextResources.getString(7), this.m_fontTexts1);
                break;
            }
            case 1: {
                this.blackened(graphics);
                this.renderLogo(graphics, this.m_imgXing);
                this.m_lXingTick += this.m_lFrameTickDiff;
                if (this.m_lXingTick <= 1000L) break;
                this.m_iGameState = 2;
                this.m_lLogoTick = 0L;
                break;
            }
            case 2: {
                this.blackened(graphics);
                this.renderLogo(graphics, this.m_imgLogo);
                this.m_lLogoTick += this.m_lFrameTickDiff;
                if (this.m_lLogoTick <= 1000L) break;
                this.m_iGameState = 3;
                this.m_lLogoTick = 0L;
                break;
            }
            case 3: {
                this.blackened(graphics);
                this.renderCenteredScreenYellowText(graphics, TextResources.getString(8), this.m_fontTexts2);
                this.m_lPresentTick += this.m_lFrameTickDiff;
                if (this.m_lPresentTick <= 1000L) break;
                this.newTitle();
                this.m_lPresentTick = 0L;
                break;
            }
            case 4: {
                this.blackened(graphics);
                this.renderSplash(graphics);
                break;
            }
            case 5: {
                this.blackened(graphics);
                this.m_menu.render(graphics);
                break;
            }
            case 6: {
                this.blackened(graphics);
                this.renderCenteredScreenYellowText(graphics, TextResources.getString(9) + " " + this.m_iLevel, this.m_fontTexts2);
                this.m_lLevelTick += this.m_lFrameTickDiff;
                if (this.m_lLevelTick <= 3000L) break;
                this.m_lLevelTick = 0L;
                this.play();
                break;
            }
            case 7: {
                this.updateNDrawAll(graphics);
                if (this.m_jewels.size() > 0) break;
                this.win();
                break;
            }
            case 8: {
                this.updateNDrawAll(graphics);
                if (this.m_bPaused) break;
                this.renderCenteredScreenYellowText(graphics, TextResources.getString(10), this.m_fontTexts3);
                this.m_lGameOverTick += this.m_lFrameTickDiff;
                if (this.m_lGameOverTick <= 3000L) break;
                this.m_lGameOverTick = 0L;
                if (this.m_highScores.isTopSix() != -1) {
                    this.newHighscores();
                    break;
                }
                this.newMenu();
                break;
            }
            case 9: {
                this.updateNDrawAll(graphics);
                if (this.m_bPaused) break;
                if (this.m_iLevel == 20) {
                    this.renderCenteredScreenYellowText(graphics, TextResources.getString(11), this.m_fontTexts3);
                } else {
                    this.renderCenteredScreenYellowText(graphics, TextResources.getString(12), this.m_fontTexts3);
                }
                this.m_lWinTick += this.m_lFrameTickDiff;
                if (this.m_lWinTick <= 3000L) break;
                this.m_lWinTick = 0L;
                if (this.m_iLevel == 20) {
                    this.m_bCanGameResume = false;
                    this.newCredits();
                    break;
                }
                int n = this.m_iLevel + 1;
                this.newGame(n);
                break;
            }
            case 11: {
                this.blackened(graphics);
                this.renderLogo(graphics, this.m_imgLogo);
                this.renderCredits(graphics);
                break;
            }
            case 10: {
                this.blackened(graphics);
                this.renderGameControls(graphics);
                break;
            }
            case 12: {
                this.blackened(graphics);
                this.m_highScores.render(graphics);
            }
        }
    }

    int getGameState() {
        return this.m_iGameState;
    }

    void setGameState(int n) {
        this.m_iGameState = n;
    }

    private void newTitle() {
        this.m_lBlinkTick = 0L;
        this.m_bBlinkShow = true;
        this.m_releasedKeys[6] = false;
        this.m_music.play(true);
        this.m_iGameState = 4;
    }

    private void newGameControls() {
        this.m_iGameState = 10;
    }

    private void newHighscores() {
        this.m_iGameState = 12;
    }

    private void renderSplash(Graphics graphics) {
        int n = (this.getWidth() - this.m_imgTitle.getWidth()) / 2;
        int n2 = (this.getHeight() - this.m_imgTitle.getHeight()) / 2;
        graphics.drawImage(this.m_imgTitle, n, n2, 20);
        if (this.m_bBlinkShow) {
            this.renderCenteredYellowText(graphics, TextResources.getString(13), this.m_fontTexts1, this.getWidth() / 2, this.m_imgBackground.getHeight() - 11 + this.m_relY);
        }
        this.m_lBlinkTick += this.m_lFrameTickDiff;
        if (this.m_lBlinkTick > 500L) {
            this.m_bBlinkShow = !this.m_bBlinkShow;
            this.m_lBlinkTick = 0L;
        }
    }

    private void renderPauseMsg(Graphics graphics, String string, Font font) {
        if (this.m_bBlinkShow) {
            this.renderCenteredScreenYellowText(graphics, string, font);
        }
        this.m_lBlinkTick += this.m_lFrameTickDiff;
        if (this.m_lBlinkTick > 500L) {
            this.m_bBlinkShow = !this.m_bBlinkShow;
            this.m_lBlinkTick = 0L;
        }
    }

    private void renderLogo(Graphics graphics, Image image) {
        int n = (this.getWidth() - image.getWidth()) / 2;
        int n2 = (this.getHeight() - image.getHeight()) / 2;
        graphics.drawImage(image, n, n2, 20);
    }

    private void renderCenteredYellowText(Graphics graphics, String string, Font font, int n, int n2) {
        int n3 = font.stringWidth(string) / 2;
        int n4 = font.getHeight() / 2;
        int n5 = n - n3;
        int n6 = n2 - n4;
        graphics.setFont(font);
        graphics.setColor(64, 32, 0);
        graphics.drawString(string, n5, n6, 20);
        graphics.setColor(255, 128, 0);
        graphics.drawString(string, n5 + 1, n6 + 1, 20);
    }

    private void renderCenteredScreenYellowText(Graphics graphics, String string, Font font) {
        int n = (this.getWidth() - font.stringWidth(string)) / 2;
        int n2 = (this.getHeight() - font.getHeight()) / 2;
        graphics.setFont(font);
        graphics.setColor(64, 32, 0);
        graphics.drawString(string, n, n2, 20);
        graphics.setColor(255, 128, 0);
        graphics.drawString(string, n + 1, n2 + 1, 20);
    }

    private void renderCredits(Graphics graphics) {
        String[] stringArray = new String[]{"Jewel Blaster", "Version 1.0", "", "Design & Programming", "Novel Yahya", "", "Arts", "Novel Yahya", "", "Thanks to", "Hurriah & Hafidz A."};
        int n = this.m_fontTexts1.getHeight() * stringArray.length + 3 * (stringArray.length - 1);
        int n2 = this.m_iCreditTextYPos;
        graphics.setFont(this.m_fontTexts1);
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = (this.getWidth() - this.m_fontTexts1.stringWidth(stringArray[i])) / 2;
            graphics.setColor(64, 64, 32);
            graphics.drawString(stringArray[i], n3, n2, 20);
            graphics.setColor(255, 128, 0);
            graphics.drawString(stringArray[i], n3 + 1, n2 + 1, 20);
            n2 += this.m_fontTexts1.getHeight() + 3;
        }
        --this.m_iCreditTextYPos;
        if (this.m_iCreditTextYPos <= -n) {
            this.m_iCreditTextYPos = this.getHeight();
        }
    }

    private void renderGameControls(Graphics graphics) {
        String string = TextResources.getString(14);
        String[] stringArray = new String[]{TextResources.getString(15), "2", "8", "4", "6", "5", "*", "#"};
        String[] stringArray2 = new String[]{TextResources.getString(27), TextResources.getString(17), TextResources.getString(18), TextResources.getString(19), TextResources.getString(20), TextResources.getString(21), TextResources.getString(22), TextResources.getString(23)};
        int n = (this.getHeight() - (this.m_fontTexts1.getHeight() * 11 + 10)) / 2;
        graphics.setFont(this.m_fontTexts1);
        int n2 = (this.getWidth() - this.m_fontTexts1.stringWidth(string)) / 2;
        graphics.setColor(64, 32, 0);
        graphics.drawString(string, n2, n, 20);
        graphics.setColor(255, 128, 0);
        graphics.drawString(string, n2 + 1, n + 1, 20);
        n += this.m_fontTexts1.getHeight() + this.m_fontTexts1.getHeight() + 1;
        n2 = (this.getWidth() - this.m_fontTexts1.stringWidth(TextResources.getString(15) + "   " + stringArray2[1])) / 2;
        int n3 = n2 + this.m_fontTexts1.stringWidth(TextResources.getString(15) + "   ");
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.setColor(64, 32, 0);
            graphics.drawString(stringArray[i], n2, n, 20);
            graphics.setColor(255, 128, 0);
            graphics.drawString(stringArray[i], n2 + 1, n + 1, 20);
            graphics.setColor(64, 32, 0);
            graphics.drawString(stringArray2[i], n3, n, 20);
            graphics.setColor(255, 128, 0);
            graphics.drawString(stringArray2[i], n3 + 1, n + 1, 20);
            n += this.m_fontTexts1.getHeight() + 1;
        }
    }

    private void newGame(int n) {
        this.m_rnd.setSeed(System.currentTimeMillis());
        this.m_iLevel = n;
        this.m_bPaused = false;
        this.m_bCanGameResume = true;
        if (this.m_iLevel == 1) {
            this.m_iScore = 0;
        }
        this.m_bWin = false;
        this.m_lLevelTick = 0L;
        this.m_bVanishingJewels = false;
        this.m_bReady = false;
        this.m_iMaxJewels = 10 * this.m_iLevel;
        this.m_iNumJewels = 1;
        this.m_jewels.removeAllElements();
        this.m_iPosIdx = 0;
        ColumnsJewel columnsJewel = new ColumnsJewel(this, this.m_imgJewels);
        columnsJewel.setPosition(this.m_relX + m_pos[this.m_iPosIdx][0], this.m_relY + m_pos[this.m_iPosIdx][1]);
        columnsJewel.reset();
        columnsJewel.setVisible(true);
        columnsJewel.m_uiMovingTime = 80;
        this.m_jewels.addElement(columnsJewel);
        this.m_playerX = this.m_relX + (this.m_imgBackground.getWidth() - this.m_imgBat.getWidth()) / 2;
        this.newPlayerJewel();
        this.m_iGameState = 6;
    }

    private void onCollideJewel(int n) {
        this.m_sptCurrentJewel.setVisible(false);
        ++this.m_iPosIdx;
        if (this.m_iPosIdx >= m_pos.length) {
            this.gameOver();
            return;
        }
        ColumnsJewel columnsJewel = new ColumnsJewel(this, this.m_imgJewels);
        columnsJewel.reset();
        columnsJewel.setColor(this.m_sptCurrentJewel.getColor());
        columnsJewel.setVisible(true);
        this.m_jewels.insertElementAt(columnsJewel, n + 1);
        int n2 = this.m_iPosIdx;
        for (int i = 0; i < this.m_jewels.size(); ++i) {
            ColumnsJewel columnsJewel2 = (ColumnsJewel)this.m_jewels.elementAt(i);
            columnsJewel2.m_bMoving = false;
            columnsJewel2.m_uiMovingTime = 1000;
            columnsJewel2.setPosition(this.m_relX + m_pos[n2][0], this.m_relY + m_pos[n2][1]);
            --n2;
        }
        if (this.enoughJewelToVanish(columnsJewel, n + 1)) {
            this.m_bVanishingJewels = true;
            this.makeVanishedJewels();
        } else {
            this.m_bReady = true;
            this.newPlayerJewel();
        }
    }

    void makeVanishedJewels() {
        for (int i = this.m_vanishIdxBegin; i <= this.m_vanishIdxEnd; ++i) {
            ColumnsJewel columnsJewel = (ColumnsJewel)this.m_jewels.elementAt(i);
            columnsJewel.m_bDead = true;
            columnsJewel.setVanished(true);
            ++this.m_iScore;
        }
    }

    void destroyVanishedJewels() {
        ColumnsJewel columnsJewel;
        int n = 0;
        ColumnsJewel columnsJewel2 = (ColumnsJewel)this.m_jewels.elementAt(this.m_vanishIdxBegin);
        if (!columnsJewel2.isVanishedCompleted()) {
            return;
        }
        int n2 = this.m_iPosIdx;
        for (n = 0; n < this.m_jewels.size(); ++n) {
            ColumnsJewel columnsJewel3 = (ColumnsJewel)this.m_jewels.elementAt(n);
            columnsJewel3.m_bMoving = false;
            columnsJewel3.m_uiMovingTime = 1000;
            columnsJewel3.setPosition(this.m_relX + m_pos[n2][0], this.m_relY + m_pos[n2][1]);
            --n2;
        }
        boolean bl = false;
        while (!bl) {
            for (n = 0; n < this.m_jewels.size(); ++n) {
                columnsJewel = (ColumnsJewel)this.m_jewels.elementAt(n);
                if (columnsJewel.m_bDead) {
                    this.m_jewels.removeElement(columnsJewel);
                    columnsJewel = null;
                    --this.m_iPosIdx;
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (this.m_jewels.size() > 0) continue;
            bl = true;
        }
        n2 = this.m_iPosIdx;
        for (n = 0; n < this.m_jewels.size(); ++n) {
            columnsJewel = (ColumnsJewel)this.m_jewels.elementAt(n);
            columnsJewel.setPosition(this.m_relX + m_pos[n2][0], this.m_relY + m_pos[n2][1]);
            --n2;
        }
        this.newPlayerJewel();
    }

    boolean enoughJewelToVanish(ColumnsJewel columnsJewel, int n) {
        ColumnsJewel columnsJewel2;
        int n2 = 1;
        this.m_vanishIdxBegin = n - 1;
        while (this.m_vanishIdxBegin >= 0 && (columnsJewel2 = (ColumnsJewel)this.m_jewels.elementAt(this.m_vanishIdxBegin)).getColor() == columnsJewel.getColor()) {
            --this.m_vanishIdxBegin;
            ++n2;
        }
        ++this.m_vanishIdxBegin;
        this.m_vanishIdxEnd = n + 1;
        while (this.m_vanishIdxEnd < this.m_jewels.size() && (columnsJewel2 = (ColumnsJewel)this.m_jewels.elementAt(this.m_vanishIdxEnd)).getColor() == columnsJewel.getColor()) {
            ++this.m_vanishIdxEnd;
            ++n2;
        }
        --this.m_vanishIdxEnd;
        return n2 >= 3;
    }

    boolean areAllStops() {
        for (int i = 0; i < this.m_jewels.size(); ++i) {
            ColumnsJewel columnsJewel = (ColumnsJewel)this.m_jewels.elementAt(i);
            if (!columnsJewel.isMoving()) continue;
            return false;
        }
        return true;
    }

    private void updateNewJewel() {
        int n;
        if (!this.areAllStops()) {
            return;
        }
        ColumnsJewel columnsJewel = null;
        ColumnsJewel columnsJewel2 = null;
        for (n = this.m_jewels.size() - 1; n > 0; --n) {
            columnsJewel = (ColumnsJewel)this.m_jewels.elementAt(n);
            columnsJewel2 = (ColumnsJewel)this.m_jewels.elementAt(n - 1);
            columnsJewel.moveTo(columnsJewel2.getX(), columnsJewel2.getY());
        }
        columnsJewel = (ColumnsJewel)this.m_jewels.elementAt(0);
        ++this.m_iPosIdx;
        if (this.m_iPosIdx >= m_pos.length) {
            this.gameOver();
        } else {
            columnsJewel.moveTo(this.m_relX + m_pos[this.m_iPosIdx][0], this.m_relY + m_pos[this.m_iPosIdx][1]);
        }
        if (this.m_iNumJewels < this.m_iMaxJewels) {
            if (this.m_iNumJewels > 8) {
                this.m_bReady = true;
                for (n = 0; n < this.m_jewels.size(); ++n) {
                    columnsJewel = (ColumnsJewel)this.m_jewels.elementAt(n);
                    columnsJewel.m_uiMovingTime = 1000;
                }
            }
            ColumnsJewel columnsJewel3 = new ColumnsJewel(this, this.m_imgJewels);
            columnsJewel3.setPosition(this.m_relX + m_pos[0][0], this.m_relY + m_pos[0][1]);
            columnsJewel3.reset();
            columnsJewel3.setVisible(true);
            if (!this.m_bReady) {
                columnsJewel3.m_uiMovingTime = 80;
            }
            this.m_jewels.addElement(columnsJewel3);
            ++this.m_iNumJewels;
        }
    }

    private void play() {
        this.m_iGameState = 7;
    }

    void newPlayerJewel() {
        this.m_sptCurrentJewel = null;
        this.m_sptCurrentJewel = new ColumnsJewel(this, this.m_imgJewels);
        this.m_sptCurrentJewel.setPosition(this.m_playerX + 20, this.m_relY + 180);
        this.m_sptCurrentJewel.reset();
        this.m_sptCurrentJewel.setVelocity(0, 0);
        this.m_sptCurrentJewel.setVisible(true);
        this.m_bShot = false;
        this.m_bVanishingJewels = false;
        int n = this.m_sptCurrentJewel.getColor();
        while (!this.isColorExist(n)) {
            n = this.getRand(this.m_sptCurrentJewel.getNumCellRows());
        }
        this.m_sptCurrentJewel.setColor(n);
    }

    boolean isColorExist(int n) {
        if (this.m_jewels.size() <= 0) {
            return true;
        }
        for (int i = 0; i < this.m_jewels.size(); ++i) {
            ColumnsJewel columnsJewel = (ColumnsJewel)this.m_jewels.elementAt(i);
            if (columnsJewel.getColor() != n) continue;
            return true;
        }
        return false;
    }

    void shoot() {
        if (this.m_bShot) {
            return;
        }
        this.m_sptCurrentJewel.setVelocity(0, 0);
        this.m_bShot = true;
    }

    public int getRand(int n) {
        int n2 = Math.abs(this.m_rnd.nextInt()) % n;
        return n2;
    }

    public void gameOver() {
        this.m_bCanGameResume = false;
        this.m_highScores.update(this.m_iScore);
        this.m_highScores.save();
        this.m_lGameOverTick = 0L;
        this.m_oldFrameTick = System.currentTimeMillis();
        this.m_iGameState = 8;
    }

    private void newCredits() {
        this.m_iCreditTextYPos = this.getHeight();
        this.m_iGameState = 11;
    }

    public void win() {
        this.m_bWin = true;
        this.m_highScores.update(this.m_iScore);
        this.m_highScores.save();
        this.m_lWinTick = 0L;
        this.m_oldFrameTick = System.currentTimeMillis();
        this.m_iGameState = 9;
    }

    public boolean isPlaying() {
        return this.m_iGameState == 7;
    }

    private void processInput() {
        if (this.m_iGameState == 4) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                this.m_display.setCurrent((Displayable)this.m_profile);
            }
        } else if (this.m_iGameState == 12) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                this.newMenu();
            }
        } else if (this.m_iGameState == 10) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                this.newMenu();
            }
        } else if (this.m_iGameState == 11) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                if (this.m_bWin && this.m_highScores.isTopSix() != -1) {
                    this.newHighscores();
                } else {
                    this.newMenu();
                }
            }
        } else if (this.m_iGameState == 5) {
            this.m_menu.ProcessInput(this);
        } else {
            if (this.m_pressedKeys[0]) {
                this.m_iResumeState = this.m_iGameState;
                this.newMenu();
            }
            if (this.m_pressedKeys[1]) {
                if (!this.m_bPauseDone) {
                    this.m_bPauseDone = true;
                    boolean bl = this.m_bPaused = !this.m_bPaused;
                    if (this.m_bPaused) {
                        this.m_lBlinkTick = 0L;
                        this.m_bBlinkShow = true;
                        this.m_music.stop();
                    } else if (this.m_bSoundOn) {
                        this.m_music.play(true);
                    }
                }
            } else {
                this.m_bPauseDone = false;
            }
            this.processGameInput();
        }
    }

    private void processGameInput() {
        if (this.m_iGameState != 7 || this.m_bPaused) {
            return;
        }
        if (this.m_pressedKeys[2]) {
            this.m_playerX -= 2;
            if (this.m_playerX < this.m_relX + 13) {
                this.m_playerX = this.m_relX + 13;
            }
            if (!this.m_bShot) {
                this.m_sptCurrentJewel.setPosition(this.m_playerX + 20, this.m_relY + 180);
            }
        }
        if (this.m_pressedKeys[3]) {
            this.m_playerX += 2;
            if (this.m_playerX > this.m_relX + this.m_imgBackground.getWidth() - this.m_imgBat.getWidth()) {
                this.m_playerX = this.m_relX + this.m_imgBackground.getWidth() - this.m_imgBat.getWidth();
            }
            if (!this.m_bShot) {
                this.m_sptCurrentJewel.setPosition(this.m_playerX + 20, this.m_relY + 180);
            }
        }
        if (this.m_pressedKeys[4]) {
            if (!this.m_bKeyPressedFlags[2]) {
                this.m_bKeyPressedFlags[2] = true;
            }
        } else {
            this.m_bKeyPressedFlags[2] = false;
        }
        if (this.m_pressedKeys[6]) {
            if (!this.m_bKeyPressedFlags[4]) {
                this.shoot();
                this.m_bKeyPressedFlags[4] = true;
            }
        } else {
            this.m_bKeyPressedFlags[4] = false;
        }
        if (this.m_pressedKeys[5]) {
            if (!this.m_bKeyPressedFlags[3]) {
                this.m_bKeyPressedFlags[3] = true;
            }
        } else {
            this.m_bKeyPressedFlags[3] = false;
        }
    }

    private void bCleanBorder(Graphics graphics) {
        if (this.getWidth() > 176 || this.getHeight() > 208) {
            int n = this.m_relX + 176;
            int n2 = this.m_relY + 208;
            graphics.setColor(0, 0, 0);
            graphics.fillRect(0, 0, this.m_relX, this.getHeight());
            graphics.fillRect(n, 0, this.getWidth(), this.getHeight());
            graphics.fillRect(this.m_relX, 0, n, this.m_relY);
            graphics.fillRect(this.m_relX, n2, n, this.getHeight());
        }
    }

    private synchronized void updateNDrawAll(Graphics graphics) {
        Object object;
        int n = 0;
        graphics.drawImage(this.m_imgBackground, this.m_relX + 0, this.m_relY + 0, 20);
        for (n = 0; n < this.m_jewels.size(); ++n) {
            object = (ColumnsJewel)this.m_jewels.elementAt(n);
            if (object == null || this.getGameState() != 7 || this.m_bPaused || this.m_sptCurrentJewel == null || !((NvSprite)object).isCollidedWith(this.m_sptCurrentJewel)) continue;
            this.onCollideJewel(n);
            break;
        }
        if (this.getGameState() == 7 && !this.m_bPaused) {
            if (this.m_bVanishingJewels) {
                this.destroyVanishedJewels();
            } else {
                this.updateNewJewel();
            }
        }
        for (n = 0; n < this.m_jewels.size(); ++n) {
            object = (ColumnsJewel)this.m_jewels.elementAt(n);
            if (object == null) continue;
            if (this.getGameState() == 7 && !this.m_bPaused) {
                ((ColumnsJewel)object).update(this.m_lFrameTickDiff);
            }
            ((NvGridSprite)object).render(graphics);
        }
        graphics.drawImage(this.m_imgPyramid, this.m_relX + 0, this.m_relY + 117, 20);
        graphics.drawImage(this.m_imgBat, this.m_playerX, this.m_relY + 184, 20);
        if (this.getGameState() == 7 && !this.m_bPaused) {
            this.m_sptCurrentJewel.update(this.m_lFrameTickDiff);
        }
        this.m_sptCurrentJewel.render(graphics);
        if (this.getGameState() == 7 && !this.m_bPaused && this.m_bShot) {
            this.onShot(graphics);
        }
        this.bCleanBorder(graphics);
        object = TextResources.getString(28) + ": " + this.m_iScore;
        this.renderCenteredYellowText(graphics, (String)object, this.m_fontTexts3, this.m_relX + 88, this.m_relY + 10);
        if (this.m_bPaused) {
            this.renderPauseMsg(graphics, TextResources.getString(24), this.m_fontTexts2);
        }
    }

    private void onShot(Graphics graphics) {
        this.m_sptCurrentJewel.setY(this.m_sptCurrentJewel.getY() - 6);
        if (this.m_sptCurrentJewel.getY() < this.m_relY - this.m_sptCurrentJewel.getWidth() && this.m_sptCurrentJewel.isVisible()) {
            this.newPlayerJewel();
        }
    }

    private boolean canGameResume() {
        return this.m_bCanGameResume;
    }

    public void newMenu() {
        this.m_menu.m_bEnabledFirstItem = this.canGameResume();
        this.m_menu.reset();
        this.m_releasedKeys[6] = false;
        this.m_iGameState = 5;
    }

    public void menuDone(int n) {
        switch (n) {
            case 0: {
                this.m_iGameState = this.m_iResumeState;
                break;
            }
            case 1: {
                this.newGame(1);
                break;
            }
            case 2: {
                boolean bl = this.m_bSoundOn = !this.m_bSoundOn;
                if (this.m_bSoundOn) {
                    this.m_strMenuTexts[2] = TextResources.getString(29);
                    this.m_music.play(true);
                    break;
                }
                this.m_strMenuTexts[2] = TextResources.getString(30);
                this.m_music.stop();
                break;
            }
            case 3: {
                this.newHighscores();
                break;
            }
            case 4: {
                this.newGameControls();
                break;
            }
            case 5: {
                NvHelp.showInstructions(this.m_display);
                break;
            }
            case 6: {
                this.newCredits();
                break;
            }
            case 7: {
                this.m_midlet.m_bNeedExit = true;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 2: {
                this.m_pressedKeys[2] = true;
                this.m_releasedKeys[2] = false;
                break;
            }
            case 5: {
                this.m_pressedKeys[3] = true;
                this.m_releasedKeys[3] = false;
                break;
            }
            case 8: {
                this.m_pressedKeys[6] = true;
                this.m_releasedKeys[6] = false;
                break;
            }
            case 1: {
                this.m_pressedKeys[4] = true;
                this.m_releasedKeys[4] = false;
                break;
            }
            case 6: {
                this.m_pressedKeys[5] = true;
                this.m_releasedKeys[5] = false;
                break;
            }
            case 0: {
                switch (n) {
                    case 52: {
                        this.m_pressedKeys[2] = true;
                        this.m_releasedKeys[2] = false;
                        break block0;
                    }
                    case 54: {
                        this.m_pressedKeys[3] = true;
                        this.m_releasedKeys[3] = false;
                        break block0;
                    }
                    case 53: {
                        this.m_pressedKeys[6] = true;
                        this.m_releasedKeys[6] = false;
                        break block0;
                    }
                    case 50: {
                        this.m_pressedKeys[4] = true;
                        this.m_releasedKeys[4] = false;
                        break block0;
                    }
                    case 56: {
                        this.m_pressedKeys[5] = true;
                        this.m_releasedKeys[5] = false;
                    }
                }
            }
        }
        if (n == 42) {
            this.m_pressedKeys[0] = true;
            this.m_releasedKeys[0] = false;
        } else if (n == 35) {
            this.m_pressedKeys[1] = true;
            this.m_releasedKeys[1] = false;
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 2: {
                this.m_pressedKeys[2] = false;
                this.m_releasedKeys[2] = true;
                break;
            }
            case 5: {
                this.m_pressedKeys[3] = false;
                this.m_releasedKeys[3] = true;
                break;
            }
            case 8: {
                this.m_pressedKeys[6] = false;
                this.m_releasedKeys[6] = true;
                break;
            }
            case 1: {
                this.m_pressedKeys[4] = false;
                this.m_releasedKeys[4] = true;
                break;
            }
            case 6: {
                this.m_pressedKeys[5] = false;
                this.m_releasedKeys[5] = true;
                break;
            }
            case 0: {
                switch (n) {
                    case 52: {
                        this.m_pressedKeys[2] = false;
                        this.m_releasedKeys[2] = true;
                        break block0;
                    }
                    case 54: {
                        this.m_pressedKeys[3] = false;
                        this.m_releasedKeys[3] = true;
                        break block0;
                    }
                    case 53: {
                        this.m_pressedKeys[6] = false;
                        this.m_releasedKeys[6] = true;
                        break block0;
                    }
                    case 50: {
                        this.m_pressedKeys[4] = false;
                        this.m_releasedKeys[4] = true;
                        break block0;
                    }
                    case 56: {
                        this.m_pressedKeys[5] = false;
                        this.m_releasedKeys[5] = true;
                    }
                }
            }
        }
        if (n == 42) {
            this.m_pressedKeys[0] = false;
            this.m_releasedKeys[0] = true;
        } else if (n == 35) {
            this.m_pressedKeys[1] = false;
            this.m_releasedKeys[1] = true;
        }
    }
}

