/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class JumpRms {
    protected static RecordStore m_rs = null;
    protected static final String RS_NAME = "JumpBallRMS";
    public String[] scores = new String[20];
    public int MusicOn;
    public int VibraOn = 1;

    JumpRms() {
        this.init();
        this.GetSettings();
        this.Shutdown();
    }

    public void init() {
        try {
            m_rs = RecordStore.openRecordStore((String)RS_NAME, (boolean)true);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            recordStoreNotFoundException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void Shutdown() {
        try {
            m_rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void Clear() {
        try {
            RecordStore.deleteRecordStore((String)RS_NAME);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void SaveSettings() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.MusicOn);
            dataOutputStream.writeInt(this.VibraOn);
            for (int i = 0; i < 20; ++i) {
                dataOutputStream.writeUTF(this.scores[i]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            int n = m_rs.addRecord(byArray, 0, byArray.length);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void GetSettings() {
        boolean bl = true;
        try {
            RecordEnumeration recordEnumeration = m_rs.enumerateRecords(null, null, true);
            while (recordEnumeration.hasNextElement()) {
                try {
                    int n = recordEnumeration.nextRecordId();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(m_rs.getRecord(n));
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    this.MusicOn = dataInputStream.readInt();
                    this.VibraOn = dataInputStream.readInt();
                    for (int i = 0; i < 20; ++i) {
                        this.scores[i] = dataInputStream.readUTF();
                    }
                    bl = false;
                }
                catch (RecordStoreException recordStoreException) {
                    recordStoreException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            recordStoreNotOpenException.printStackTrace();
        }
        if (bl) {
            this.MusicOn = 1;
            this.VibraOn = 1;
            for (int i = 0; i < 20; i += 2) {
                this.scores[i] = "<Empty>";
                this.scores[i + 1] = "0";
            }
            this.SaveSettings();
        }
    }
}

