/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BackgroundFigure {
    private int m_CurrentFrame;
    private Image[] m_Images;
    private boolean[] m_VisibleFlags;

    public BackgroundFigure() {
        LineOut lineout = (LineOut)Application.getCurrent();
        this.m_CurrentFrame = -1;
        this.m_Images = new Image[6];
        this.m_VisibleFlags = new boolean[6];
        int currentLevel = lineout.gameMode() == 1 ? lineout.savedLevel() : 1;
        for (int i = 0; i < currentLevel; i += 2) {
            this.nextFrame();
        }
    }

    public void nextFrame() {
        ++this.m_CurrentFrame;
        if (this.m_CurrentFrame % 6 == 0) {
            LineOut lineout = (LineOut)Application.getCurrent();
            int gameMode = lineout.gameMode();
            if ((gameMode == 0 || gameMode == 1) && this.m_CurrentFrame > 17) {
                this.m_CurrentFrame = 17;
            }
            if (gameMode == 5) {
                if (this.m_CurrentFrame == 0) {
                    this.m_CurrentFrame = (int)(System.currentTimeMillis() % 3L * 6L);
                } else {
                    this.m_CurrentFrame = this.m_CurrentFrame / 6 + (int)(System.currentTimeMillis() % 2L);
                    this.m_CurrentFrame = this.m_CurrentFrame % 3 * 6;
                }
            }
            if (gameMode >= 2 && gameMode <= 4) {
                int minFrame = (gameMode - 2) * 6;
                int maxFrame = minFrame + 5;
                if (this.m_CurrentFrame < minFrame) {
                    this.m_CurrentFrame = minFrame;
                }
                if (this.m_CurrentFrame > maxFrame) {
                    this.m_CurrentFrame = maxFrame;
                }
            }
        }
        try {
            int i;
            if (this.m_CurrentFrame % 6 == 0) {
                for (i = 0; i < 6; ++i) {
                    this.m_Images[i] = null;
                }
                System.gc();
                for (i = 0; i < 6; ++i) {
                    String name = "/figure";
                    name = name + String.valueOf(this.m_CurrentFrame / 6 + 1);
                    name = name + "_";
                    name = name + String.valueOf(i);
                    name = name + ".png";
                    this.m_Images[i] = Image.createImage((String)name);
                }
                System.gc();
            }
            for (i = 0; i < 6; ++i) {
                this.m_VisibleFlags[i] = i >= this.m_CurrentFrame % 6;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void paint(Graphics graphics, int x, int y) {
        for (int i = 5; i >= 0; --i) {
            if (!this.m_VisibleFlags[i]) continue;
            graphics.drawImage(this.m_Images[i], x, y, 20);
        }
    }
}

