/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Enemy {
    private static Image m_SharedImage;
    private static int[] m_NormalFrameSequence;
    private static int[] m_ExploFrameSequence;
    private int m_HighPrecisionXpos;
    private int m_HighPrecisionYpos;
    private byte m_Direction;
    private boolean m_Explosion;
    private boolean m_IsDead;
    private Random m_Random;
    private int[] m_CurrentSequence;
    private int m_SequencePosition;
    private int m_FrameSize;
    private boolean m_Visible;

    public Enemy(int x, int y) {
        try {
            if (m_SharedImage == null) {
                m_SharedImage = Image.createImage((String)"/enemy.png");
            }
            LineOut lineout = (LineOut)Application.getCurrent();
            Game game = (Game)Display.getDisplay((MIDlet)lineout).getCurrent();
            GameField gameField = game.getGameField();
            this.m_HighPrecisionXpos = x;
            this.m_HighPrecisionYpos = y;
            this.m_Direction = 0;
            this.m_Explosion = false;
            this.m_IsDead = false;
            this.m_Random = new Random();
            this.m_CurrentSequence = m_NormalFrameSequence;
            this.m_SequencePosition = 0;
            this.m_FrameSize = game.getGraphicsContext().getClipWidth() / gameField.getFieldWidth();
            this.m_Visible = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void update() {
        LineOut lineout = (LineOut)Application.getCurrent();
        Game game = (Game)Display.getDisplay((MIDlet)lineout).getCurrent();
        GameField gameField = game.getGameField();
        Player player = gameField.getPlayer();
        int xpos = this.m_HighPrecisionXpos >> 16;
        int ypos = this.m_HighPrecisionYpos >> 16;
        int mapElementSize = game.getGraphicsContext().getClipWidth() / gameField.getFieldWidth();
        int mapXpos = xpos / mapElementSize;
        int mapYpos = ypos / mapElementSize;
        int ways = gameField.getBlock(mapXpos, mapYpos);
        int speed = (mapElementSize << 19) / 128;
        if (ways == 0 && !this.m_Explosion) {
            this.m_Explosion = true;
            this.m_CurrentSequence = m_ExploFrameSequence;
            this.m_SequencePosition = 0;
            player.setScore(player.getScore() + 200);
        }
        if (!this.m_Explosion) {
            if (player.collidesWith(xpos, ypos, mapElementSize, mapElementSize)) {
                player.setEnergy(player.getEnergy() - 1, false);
            }
            if (xpos % mapElementSize == 0 && ypos % mapElementSize == 0) {
                byte random = (byte)(this.m_Random.nextInt() % 100);
                int distanceX = player.getHighPrecisionX() - this.m_HighPrecisionXpos;
                int distanceY = player.getHighPrecisionY() - this.m_HighPrecisionYpos;
                int absDistanceX = distanceX < 0 ? -distanceX : distanceX;
                int absDistanceY = distanceY < 0 ? -distanceY : distanceY;
                int blockLeft = gameField.getBlock(mapXpos - 1, mapYpos);
                int blockRight = gameField.getBlock(mapXpos + 1, mapYpos);
                int blockUp = gameField.getBlock(mapXpos, mapYpos - 1);
                int blockDown = gameField.getBlock(mapXpos, mapYpos + 1);
                if (ways == 17) {
                    ways = 0;
                    if ((blockLeft & 4) != 0) {
                        ways |= 8;
                    }
                    if ((blockRight & 8) != 0) {
                        ways |= 4;
                    }
                    if ((blockUp & 1) != 0) {
                        ways |= 2;
                    }
                    if ((blockDown & 2) != 0) {
                        ways |= 1;
                    }
                }
                if (mapXpos == 0 || blockLeft == 16) {
                    ways &= 0xFFFFFFF7;
                }
                if (mapXpos == 15 || blockRight == 16) {
                    ways &= 0xFFFFFFFB;
                }
                if (mapYpos == 0 || blockUp == 16) {
                    ways &= 0xFFFFFFFD;
                }
                if (mapYpos == 17 || blockDown == 16) {
                    ways &= 0xFFFFFFFE;
                }
                switch (this.m_Direction) {
                    case 8: {
                        if ((ways & 0xFFFFFFFB) == 0) break;
                        ways &= 0xFFFFFFFB;
                        break;
                    }
                    case 4: {
                        if ((ways & 0xFFFFFFF7) == 0) break;
                        ways &= 0xFFFFFFF7;
                        break;
                    }
                    case 2: {
                        if ((ways & 0xFFFFFFFE) == 0) break;
                        ways &= 0xFFFFFFFE;
                        break;
                    }
                    case 1: {
                        if ((ways & 0xFFFFFFFD) == 0) break;
                        ways &= 0xFFFFFFFD;
                    }
                }
                if (random == 0) {
                    absDistanceX = absDistanceY + 1;
                }
                if (random == 1) {
                    absDistanceY = absDistanceX + 1;
                }
                if (random == 2) {
                    distanceX = -distanceX;
                }
                if (random == 3) {
                    distanceY = -distanceY;
                }
                if (distanceX == 0) {
                    absDistanceX = absDistanceY + 1;
                }
                if (distanceY == 0) {
                    absDistanceY = absDistanceX + 1;
                }
                switch (ways & 0xC) {
                    case 0: {
                        if (absDistanceX >= absDistanceY) break;
                        absDistanceX = absDistanceY + 1;
                        break;
                    }
                    case 8: {
                        if (distanceX == 0) {
                            distanceX = -1;
                        }
                        if (distanceX <= 0) break;
                        distanceX = -distanceX;
                        break;
                    }
                    case 4: {
                        if (distanceX == 0) {
                            distanceX = 1;
                        }
                        if (distanceX >= 0) break;
                        distanceX = -distanceX;
                    }
                }
                switch (ways & 3) {
                    case 0: {
                        if (absDistanceX < absDistanceY) break;
                        absDistanceY = absDistanceX + 1;
                        break;
                    }
                    case 2: {
                        if (distanceY == 0) {
                            distanceY = -1;
                        }
                        if (distanceY <= 0) break;
                        distanceY = -distanceY;
                        break;
                    }
                    case 1: {
                        if (distanceY == 0) {
                            distanceY = 1;
                        }
                        if (distanceY >= 0) break;
                        distanceY = -distanceY;
                    }
                }
                this.m_Direction = absDistanceX < absDistanceY ? (distanceX < 0 ? (byte)8 : (byte)4) : (distanceY < 0 ? (byte)2 : (byte)1);
            }
            if (ways == 0) {
                speed = 0;
            }
            switch (this.m_Direction) {
                case 8: {
                    this.m_HighPrecisionXpos -= speed;
                    break;
                }
                case 4: {
                    this.m_HighPrecisionXpos += speed;
                    break;
                }
                case 2: {
                    this.m_HighPrecisionYpos -= speed;
                    break;
                }
                case 1: {
                    this.m_HighPrecisionYpos += speed;
                }
            }
            ++this.m_SequencePosition;
            if (this.m_SequencePosition >= this.m_CurrentSequence.length) {
                this.m_SequencePosition = 0;
            }
        } else if (this.m_SequencePosition == this.m_CurrentSequence.length - 1) {
            this.m_IsDead = true;
            this.m_Visible = false;
        } else {
            ++this.m_SequencePosition;
            if (this.m_SequencePosition >= this.m_CurrentSequence.length) {
                this.m_SequencePosition = 0;
            }
        }
    }

    public void paint(Graphics graphics, int x, int y) {
        if (this.m_Visible) {
            int xpos = (this.m_HighPrecisionXpos >> 16) + x;
            int ypos = (this.m_HighPrecisionYpos >> 16) + y;
            int frame = this.m_CurrentSequence[this.m_SequencePosition];
            int imageX = frame * this.m_FrameSize % m_SharedImage.getWidth();
            int imageY = frame * this.m_FrameSize / m_SharedImage.getWidth() * this.m_FrameSize;
            int oldClipX = graphics.getClipX();
            int oldClipY = graphics.getClipY();
            int oldClipWidth = graphics.getClipWidth();
            int oldClipHeight = graphics.getClipHeight();
            graphics.clipRect(xpos, ypos, this.m_FrameSize, this.m_FrameSize);
            graphics.drawImage(m_SharedImage, xpos - imageX, ypos - imageY, 20);
            graphics.setClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
        }
    }

    public boolean isDead() {
        return this.m_IsDead;
    }

    static {
        m_NormalFrameSequence = new int[]{0, 0, 1, 1, 2, 2, 3, 3};
        m_ExploFrameSequence = new int[]{4, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9};
    }
}

