/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public class Game
extends LineOutCanvas {
    private static final int STATE_LOADINGLEVEL = 0;
    private static final int STATE_LEVELREADY = 1;
    private static final int STATE_COUNTDOWN = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_CONTINUEYES = 4;
    private static final int STATE_CONTINUENO = 5;
    private static final int STATE_GAMEOVER = 6;
    private static final int STATE_SHOWPICTURE = 7;
    private static final int STATE_SHOWPICTURE_GAMEEND = 8;
    private static final int STATE_LEVELCOMPLETE = 9;
    private static final int STATE_GAMECOMPLETE = 10;
    private static final int STATE_DEMOCOMPLETE = 11;
    private static final int STATE_EXITGAMEYESNO_YES = 12;
    private static final int STATE_EXITGAMEYESNO_NO = 13;
    private static final int STATE_EXITGAMEYESNOSAVE_YES = 14;
    private static final int STATE_EXITGAMEYESNOSAVE_NO = 15;
    private static final int STATE_EXITGAMEYESNOSAVE_SAVE = 16;
    private BackgroundFigure m_BackgroundFigure;
    private GameField m_GameField;
    private ScoreBar m_ScoreBar;
    private byte m_State;
    private byte m_Level;
    private byte m_PlayedLevels;
    private byte m_CountDown;
    private int m_KeysOld;
    private Random m_Random;
    private boolean m_GameEndWithScore;
    private int m_BlendPos;
    private int m_BlendSpeed;
    private boolean m_DoExit;
    private Image m_FigureImage;
    private Image m_FigureFieldImage;
    private Graphics m_FigureGraphics;
    private Graphics m_FigureFieldGraphics;
    private javax.microedition.media.Player m_MidiSong;
    private VolumeControl m_MidiVolume;

    public void init() {
        super.init();
        try {
            LineOut lineout = (LineOut)Application.getCurrent();
            LineOutCanvas canvas = (LineOutCanvas)Display.getDisplay((MIDlet)lineout).getCurrent();
            this.m_BackgroundFigure = new BackgroundFigure();
            this.m_GameField = new GameField();
            this.m_ScoreBar = new ScoreBar();
            this.m_State = 0;
            this.m_KeysOld = this.getKeyStates();
            this.m_Random = new Random();
            this.m_GameEndWithScore = false;
            this.m_BlendPos = 0;
            this.m_BlendSpeed = 4;
            this.m_DoExit = false;
            int blockSize = canvas.getGraphicsContext().getClipWidth() / this.m_GameField.getFieldWidth();
            this.m_FigureImage = Image.createImage((int)(blockSize * this.m_GameField.getFieldWidth()), (int)(blockSize * this.m_GameField.getFieldHeight()));
            this.m_FigureFieldImage = Image.createImage((int)(blockSize * this.m_GameField.getFieldWidth()), (int)(blockSize * this.m_GameField.getFieldHeight()));
            this.m_FigureGraphics = this.m_FigureImage.getGraphics();
            this.m_FigureFieldGraphics = this.m_FigureFieldImage.getGraphics();
            switch (lineout.gameMode()) {
                case 0: {
                    this.m_Level = 1;
                    this.m_PlayedLevels = 0;
                    break;
                }
                case 1: {
                    this.m_Level = (byte)lineout.savedLevel();
                    this.m_PlayedLevels = (byte)(this.m_Level - 1);
                    this.m_GameField.getPlayer().setLives(lineout.savedLives());
                    break;
                }
                case 2: {
                    this.m_Level = 1;
                    this.m_PlayedLevels = 0;
                    break;
                }
                case 3: {
                    this.m_Level = (byte)13;
                    this.m_PlayedLevels = 0;
                    break;
                }
                case 4: {
                    this.m_Level = (byte)25;
                    this.m_PlayedLevels = 0;
                    break;
                }
                case 5: {
                    this.m_Level = (byte)(System.currentTimeMillis() % 36L + 1L);
                    this.m_PlayedLevels = 0;
                }
            }
            this.m_MidiSong = Manager.createPlayer((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/song_ingame.mid"), (String)"audio/midi");
            this.m_MidiSong.realize();
            this.m_MidiSong.setLoopCount(-1);
            this.m_MidiVolume = (VolumeControl)this.m_MidiSong.getControl("VolumeControl");
            this.m_MidiVolume.setLevel(0);
            this.m_MidiSong.start();
            if (lineout.soundMode() == 0) {
                this.m_MidiSong.stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean update() {
        if (this.m_BackgroundFigure == null || this.m_GameField == null || this.m_ScoreBar == null) {
            return true;
        }
        int keys = this.getKeyStates();
        this.m_KeysOld &= keys;
        int keysMask = this.m_KeysOld;
        this.m_KeysOld = keys;
        keys ^= keysMask;
        LineOut lineout = (LineOut)Application.getCurrent();
        Player player = this.m_GameField.getPlayer();
        Graphics graphics = this.getGraphicsContext();
        this.m_MidiVolume.setLevel(Math.min(this.m_BlendPos, lineout.soundMode() * 10));
        this.m_BlendPos += this.m_BlendSpeed;
        if (this.m_BlendPos > graphics.getClipHeight() + this.m_BlendSpeed) {
            this.m_BlendPos = graphics.getClipHeight() + this.m_BlendSpeed;
        } else if (this.m_BlendPos > 0) {
            keys = 0;
        } else {
            try {
                this.m_MidiSong.close();
                this.m_MidiSong = null;
                this.m_MidiVolume = null;
                this.m_BackgroundFigure = null;
                this.m_GameField = null;
                this.m_ScoreBar = null;
                this.m_Random = null;
                this.m_FigureImage = null;
                this.m_FigureFieldImage = null;
                this.m_FigureGraphics = null;
                this.m_FigureFieldGraphics = null;
                Menu menu = new Menu();
                menu.flushGraphics();
                Display.getDisplay((MIDlet)lineout).setCurrent((Displayable)menu);
                System.gc();
                if (this.m_GameEndWithScore) {
                    menu.init(player.getScore());
                } else {
                    menu.init();
                }
                lineout.resetFrameTimer();
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        switch (this.m_State) {
            case 0: {
                this.m_GameField.loadLevel(this.m_Level);
                this.m_State = 1;
                this.m_BackgroundFigure.paint(this.m_FigureGraphics, 0, 0);
                this.m_GameField.paintField(this.m_FigureFieldGraphics, this.m_FigureImage);
                lineout.resetFrameTimer();
                break;
            }
            case 1: {
                if ((keys & 0x10) == 0) break;
                this.m_State = (byte)2;
                this.m_CountDown = (byte)(3 * lineout.getFrameRate());
                break;
            }
            case 2: {
                if (this.m_BlendPos < graphics.getClipHeight()) {
                    return true;
                }
                this.m_CountDown = (byte)(this.m_CountDown - 1);
                if (this.m_CountDown > 0 && keys != 16 && keys != 1 && keys != 2 && keys != 4 && keys != 8) break;
                this.m_State = (byte)3;
                if (keys == 1) {
                    player.setNextDirection(8);
                }
                if (keys == 2) {
                    player.setNextDirection(4);
                }
                if (keys == 4) {
                    player.setNextDirection(2);
                }
                if (keys != 8) break;
                player.setNextDirection(1);
                break;
            }
            case 4: {
                if ((keys & 0x10) != 0) {
                    this.m_State = 0;
                }
                if ((keys & 3) == 0) break;
                this.m_State = (byte)5;
                break;
            }
            case 5: {
                if (keys == 16) {
                    this.m_BlendSpeed = -this.m_BlendSpeed;
                }
                if ((keys & 3) == 0) break;
                this.m_State = (byte)4;
                break;
            }
            case 6: {
                if (keys != 16) break;
                this.m_BlendSpeed = -this.m_BlendSpeed;
                if (lineout.gameMode() != 0 && lineout.gameMode() != 1) break;
                this.m_GameEndWithScore = true;
                break;
            }
            case 7: {
                if (keys != 16) break;
                this.m_State = 0;
                if (this.m_PlayedLevels % 2 == 0) {
                    this.m_BackgroundFigure.nextFrame();
                }
                lineout.resetFrameTimer();
                if (this.m_PlayedLevels != 6) break;
                this.m_State = (byte)11;
                break;
            }
            case 8: {
                if ((keys & 0x10) == 0) break;
                this.m_BlendSpeed = -this.m_BlendSpeed;
                break;
            }
            case 9: {
                this.m_CountDown = (byte)(this.m_CountDown + 1);
                if (this.m_CountDown > lineout.getFrameRate() * 2) {
                    this.m_CountDown = 0;
                }
                if (keys != 16) break;
                this.m_State = (byte)7;
                break;
            }
            case 10: {
                this.m_CountDown = (byte)(this.m_CountDown + 1);
                if (this.m_CountDown > lineout.getFrameRate() * 2) {
                    this.m_CountDown = 0;
                }
                if ((keys & 0x10) == 0) break;
                this.m_State = (byte)8;
                if (lineout.gameMode() != 0 && lineout.gameMode() != 1) break;
                this.m_GameEndWithScore = true;
                break;
            }
            case 11: {
                if ((keys & 0x10) == 0) break;
                this.m_BlendSpeed = -this.m_BlendSpeed;
                break;
            }
            case 12: {
                if ((keys & 0x10) != 0) {
                    this.m_BlendSpeed = -this.m_BlendSpeed;
                }
                if ((keys & 3) == 0) break;
                this.m_State = (byte)13;
                break;
            }
            case 13: {
                if ((keys & 0x10) != 0) {
                    this.m_State = (byte)3;
                }
                if ((keys & 3) == 0) break;
                this.m_State = (byte)12;
                break;
            }
            case 14: {
                if ((keys & 0x10) != 0) {
                    this.m_BlendSpeed = -this.m_BlendSpeed;
                }
                if ((keys & 1) != 0) {
                    this.m_State = (byte)16;
                }
                if ((keys & 2) == 0) break;
                this.m_State = (byte)15;
                break;
            }
            case 15: {
                if ((keys & 0x10) != 0) {
                    this.m_State = (byte)3;
                }
                if ((keys & 1) != 0) {
                    this.m_State = (byte)14;
                }
                if ((keys & 2) == 0) break;
                this.m_State = (byte)16;
                break;
            }
            case 16: {
                if ((keys & 0x10) != 0) {
                    this.m_State = (byte)13;
                    lineout.setSavedLevel(this.m_Level);
                    lineout.setSavedLives(player.getLives());
                    lineout.saveToStore();
                    lineout.resetFrameTimer();
                }
                if ((keys & 1) != 0) {
                    this.m_State = (byte)15;
                }
                if ((keys & 2) == 0) break;
                this.m_State = (byte)14;
                break;
            }
            case 3: {
                this.m_GameField.update();
                if ((keys & 0x18000) != 0 || this.m_DoExit) {
                    this.m_DoExit = false;
                    this.m_State = !(this.m_Level == (byte)lineout.savedLevel() && player.getLives() == (byte)lineout.savedLives() || lineout.gameMode() != 0 && lineout.gameMode() != 1) ? (byte)16 : (byte)13;
                }
                if ((keys & 1) != 0) {
                    player.setNextDirection(8);
                }
                if ((keys & 2) != 0) {
                    player.setNextDirection(4);
                }
                if ((keys & 4) != 0) {
                    player.setNextDirection(2);
                }
                if ((keys & 8) != 0) {
                    player.setNextDirection(1);
                }
                if (player.isDead()) {
                    player.setLives(player.getLives() - 1);
                    this.m_State = player.getLives() > 0 ? (byte)4 : (byte)6;
                }
                if (this.m_GameField.getPercents() <= 0) {
                    this.m_State = (byte)9;
                    this.m_CountDown = 0;
                    this.m_PlayedLevels = (byte)(this.m_PlayedLevels + 1);
                    switch (lineout.gameMode()) {
                        case 0: 
                        case 1: {
                            if (this.m_PlayedLevels >= 12) {
                                lineout.setActiveModes(3);
                            }
                            if (this.m_PlayedLevels >= 24) {
                                lineout.setActiveModes(4);
                            }
                            if (this.m_PlayedLevels >= 36) {
                                this.m_State = (byte)10;
                                lineout.setActiveModes(5);
                            } else {
                                this.m_Level = (byte)(this.m_Level + 1);
                            }
                            lineout.saveToStore();
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            if (this.m_PlayedLevels >= 12) {
                                this.m_State = (byte)10;
                                break;
                            }
                            this.m_Level = (byte)(this.m_Level + 1);
                            break;
                        }
                        case 5: {
                            this.m_Level = (byte)(System.currentTimeMillis() % 36L + 1L);
                        }
                    }
                }
                int random = this.m_Random.nextInt() % 200;
                int randomX = this.m_Random.nextInt() % 16;
                int randomY = this.m_Random.nextInt() % 18;
                int blockType = this.m_GameField.getBlock(randomX, randomY);
                int blockSize = graphics.getClipWidth() / this.m_GameField.getFieldWidth();
                int playerMapX = (player.getHighPrecisionX() >> 16) / (graphics.getClipWidth() / this.m_GameField.getFieldWidth());
                int playerMapY = (player.getHighPrecisionY() >> 16) / (graphics.getClipWidth() / this.m_GameField.getFieldWidth());
                if (blockType == 0 || blockType >= 16) break;
                int itemType = 0;
                if (random > 0 && random < 10) {
                    itemType = 5;
                }
                if (random > 10 && random < 20) {
                    itemType = 6;
                }
                if (random > 20 && random < 30) {
                    itemType = 7;
                }
                if (random > 30 && random < 40) {
                    itemType = 11;
                }
                if (random > 50 && random < 60) {
                    itemType = 10;
                }
                if (random > 60 && random < 65) {
                    itemType = 4;
                }
                if (random > 70 && random < 73) {
                    itemType = 8;
                }
                if (random > 80 && random < 82) {
                    itemType = 9;
                }
                if (!(itemType != 11 && itemType != 10 || Math.abs(randomX - playerMapX) >= 3 && Math.abs(randomY - playerMapY) >= 3)) {
                    itemType = 0;
                }
                if (randomX == playerMapX && randomY == playerMapY) {
                    itemType = 0;
                }
                if (itemType == 0) break;
                this.m_GameField.addItem(itemType, randomX * blockSize << 16, randomY * blockSize << 16);
                System.gc();
            }
        }
        return true;
    }

    public void hideNotify() {
        try {
            if (this.m_MidiSong != null) {
                this.m_MidiSong.stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.m_State == 12 || this.m_State == 13 || this.m_State == 14 || this.m_State == 15 || this.m_State == 16) {
            return;
        }
        this.m_DoExit = true;
    }

    public void showNotify() {
        try {
            if (this.m_MidiSong != null) {
                this.m_MidiSong.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void render() {
        if (this.m_FigureImage == null || this.m_FigureFieldImage == null || this.m_GameField == null || this.m_ScoreBar == null) {
            return;
        }
        LineOut lineout = (LineOut)Application.getCurrent();
        Graphics graphics = this.getGraphicsContext();
        int mapElementSize = graphics.getClipWidth() / this.m_GameField.getFieldWidth();
        boolean gameField = true;
        boolean hideField = false;
        boolean textField = true;
        String text1 = "";
        String text2 = "";
        String text3 = "";
        switch (this.m_State) {
            case 0: {
                hideField = true;
                text1 = "LOADING LEVEL";
                text2 = "PLEASE WAIT";
                break;
            }
            case 1: {
                hideField = true;
                text1 = "LEVEL READY";
                text2 = "PRESS BUTTON";
                break;
            }
            case 2: {
                text1 = "GET READY";
                if (this.m_CountDown <= lineout.getFrameRate() * 3) {
                    text2 = "3";
                }
                if (this.m_CountDown <= lineout.getFrameRate() * 2) {
                    text2 = "2";
                }
                if (this.m_CountDown > lineout.getFrameRate() * 1) break;
                text2 = "1";
                break;
            }
            case 4: {
                text1 = "CONTINUE GAME";
                text2 = "    NO";
                text3 = "YES   ";
                break;
            }
            case 5: {
                text1 = "CONTINUE GAME";
                text2 = "YES   ";
                text3 = "    NO";
                break;
            }
            case 6: {
                text1 = "GAME OVER";
                text2 = "PRESS BUTTON";
                break;
            }
            case 9: {
                text1 = "LEVEL COMPLETE";
                text2 = this.m_CountDown % (lineout.getFrameRate() * 2) < lineout.getFrameRate() || this.m_PlayedLevels % 12 != 0 || lineout.gameMode() >= 2 ? "PRESS BUTTON" : "AND SEE OPTIONS";
                break;
            }
            case 10: {
                text1 = "GAME COMPLETE";
                text2 = this.m_CountDown < lineout.getFrameRate() || lineout.gameMode() >= 2 ? "PRESS BUTTON" : "AND SEE OPTIONS";
                break;
            }
            case 11: {
                hideField = true;
                text1 = "DEMO COMPLETE";
                text2 = "PRESS BUTTON";
                text3 = "";
                break;
            }
            case 12: {
                hideField = true;
                text1 = "EXIT GAME";
                text2 = "    NO";
                text3 = "YES   ";
                break;
            }
            case 7: 
            case 8: {
                gameField = false;
                textField = false;
                break;
            }
            case 3: {
                textField = false;
                break;
            }
            case 13: {
                hideField = true;
                textField = false;
                text1 = "EXIT GAME";
                text2 = "YES   ";
                text3 = "    NO";
                break;
            }
            case 14: {
                hideField = true;
                textField = false;
                text1 = "EXIT GAME";
                text2 = "    NO SAVE";
                text3 = "YES        ";
                break;
            }
            case 15: {
                hideField = true;
                textField = false;
                text1 = "EXIT GAME";
                text2 = "YES    SAVE";
                text3 = "    NO     ";
                break;
            }
            case 16: {
                hideField = true;
                textField = false;
                text1 = "EXIT GAME";
                text2 = "YES NO     ";
                text3 = "       SAVE";
            }
        }
        int tx = this.translateX();
        int ty = this.translateY();
        if (!gameField) {
            graphics.drawImage(this.m_FigureImage, tx, ty, 20);
        } else {
            this.m_GameField.paintField(this.m_FigureFieldGraphics, this.m_FigureImage);
            graphics.drawImage(this.m_FigureFieldImage, tx, ty, 20);
            this.m_GameField.paintObstacles(graphics, tx, ty);
        }
        if (hideField) {
            this.m_GameField.paintHideBlocks(graphics, tx, ty, 0, 0, this.m_GameField.getFieldWidth(), this.m_GameField.getFieldHeight());
        }
        if (textField) {
            this.m_GameField.paintHideBlocks(graphics, tx, ty, (this.m_GameField.getFieldWidth() - 14) / 2, (this.m_GameField.getFieldHeight() - 4) / 2, 14, 4);
        }
        this.drawString(graphics, lineout.bitmapFontA(), text1, graphics.getClipWidth() / 2 + tx, this.m_GameField.getFieldHeight() * mapElementSize / 2 - mapElementSize / 6 + ty, 33);
        this.drawString(graphics, lineout.bitmapFontA(), text2, graphics.getClipWidth() / 2 + tx, this.m_GameField.getFieldHeight() * mapElementSize / 2 + mapElementSize / 6 + ty, 17);
        this.drawString(graphics, lineout.bitmapFontB(), text3, graphics.getClipWidth() / 2 + tx, this.m_GameField.getFieldHeight() * mapElementSize / 2 + mapElementSize / 6 + ty, 17);
        this.m_ScoreBar.paint(graphics, tx, ty);
        this.drawBlendEffect(graphics, this.m_BlendPos, this.m_BlendSpeed);
        this.flushGraphics();
    }

    public GameField getGameField() {
        return this.m_GameField;
    }
}

