/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GameField {
    public static final int OBJECT_PLAYER_LEFT = 0;
    public static final int OBJECT_PLAYER_RIGHT = 1;
    public static final int OBJECT_PLAYER_UP = 2;
    public static final int OBJECT_PLAYER_DOWN = 3;
    public static final int OBJECT_SHIELD = 4;
    public static final int OBJECT_BONUS10 = 5;
    public static final int OBJECT_BONUS30 = 6;
    public static final int OBJECT_BONUS50 = 7;
    public static final int OBJECT_ENERGY = 8;
    public static final int OBJECT_EXTRALIVE = 9;
    public static final int OBJECT_INVERSEENERGY = 10;
    public static final int OBJECT_SPEEDINCREASE = 11;
    public static final int OBJECT_ENEMY = 12;
    public static final int BLOCK_NORMAL_EMPTY = 0;
    public static final int BLOCK_NORMAL_DOWN = 1;
    public static final int BLOCK_NORMAL_UP = 2;
    public static final int BLOCK_NORMAL_UPDOWN = 3;
    public static final int BLOCK_NORMAL_RIGHT = 4;
    public static final int BLOCK_NORMAL_RIGHTDOWN = 5;
    public static final int BLOCK_NORMAL_RIGHTUP = 6;
    public static final int BLOCK_NORMAL_RIGHTUPDOWN = 7;
    public static final int BLOCK_NORMAL_LEFT = 8;
    public static final int BLOCK_NORMAL_LEFTDOWN = 9;
    public static final int BLOCK_NORMAL_LEFTUP = 10;
    public static final int BLOCK_NORMAL_LEFTUPDOWN = 11;
    public static final int BLOCK_NORMAL_LEFTRIGHT = 12;
    public static final int BLOCK_NORMAL_LEFTRIGHTDOWN = 13;
    public static final int BLOCK_NORMAL_LEFTRIGHTUP = 14;
    public static final int BLOCK_NORMAL_LEFTRIGHTUPDOWN = 15;
    public static final int BLOCK_SPECIAL_FIRST = 16;
    public static final int BLOCK_SPECIAL_WALL = 16;
    public static final int BLOCK_SPECIAL_STOP = 17;
    public static final int BLOCK_SPECIAL_HIDE = 18;
    private byte m_Level;
    private byte m_Percents;
    private int m_UnsolvedLines;
    private Player m_Player;
    private Enemy[] m_Enemies;
    private Item[] m_Items;
    private byte[][] m_Field;
    private byte[][] m_FieldOld;
    private Image m_BlocksImage;
    private int m_BlockSize;

    public GameField() {
        try {
            LineOut lineout = (LineOut)Application.getCurrent();
            LineOutCanvas canvas = (LineOutCanvas)Display.getDisplay((MIDlet)lineout).getCurrent();
            this.m_Level = 0;
            this.m_Percents = 0;
            this.m_UnsolvedLines = 0;
            this.m_Player = new Player(0, 0, 0);
            this.m_Field = new byte[16][18];
            this.m_FieldOld = new byte[16][18];
            this.m_BlockSize = canvas.getGraphicsContext().getClipWidth() / 16;
            this.m_BlocksImage = Image.createImage((String)"/blocks.png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadLevel(int level) {
        try {
            int i;
            this.m_Level = (byte)level;
            InputStream stream = this.getClass().getResourceAsStream("/level" + level + ".lev");
            this.m_Percents = (byte)stream.read();
            byte numMaxEnemies = (byte)stream.read();
            byte numMaxItems = (byte)stream.read();
            int numObjects = stream.read();
            Player oldPlayer = this.m_Player;
            this.m_Player = null;
            this.m_Enemies = null;
            this.m_Items = null;
            System.gc();
            this.m_Enemies = new Enemy[numMaxEnemies];
            this.m_Items = new Item[numMaxItems];
            this.m_UnsolvedLines = 0;
            block10: for (i = 0; i < numObjects; ++i) {
                byte typeObject = (byte)stream.read();
                int xposObject = (byte)stream.read() * this.m_BlockSize << 16;
                int yposObject = (byte)stream.read() * this.m_BlockSize << 16;
                switch (typeObject) {
                    case 0: {
                        this.m_Player = new Player(8, xposObject, yposObject);
                        continue block10;
                    }
                    case 1: {
                        this.m_Player = new Player(4, xposObject, yposObject);
                        continue block10;
                    }
                    case 2: {
                        this.m_Player = new Player(2, xposObject, yposObject);
                        continue block10;
                    }
                    case 3: {
                        this.m_Player = new Player(1, xposObject, yposObject);
                        continue block10;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.addItem(typeObject, xposObject, yposObject);
                        continue block10;
                    }
                    case 12: {
                        this.addEnemy(xposObject, yposObject);
                    }
                }
            }
            if (oldPlayer != null) {
                this.m_Player.setLives(oldPlayer.getLives());
                this.m_Player.setScore(oldPlayer.getScore());
            }
            for (i = 0; i < this.getFieldHeight(); ++i) {
                for (int j = 0; j < this.getFieldWidth(); ++j) {
                    this.m_Field[j][i] = (byte)stream.read();
                    this.m_FieldOld[j][i] = -1;
                    if (this.m_Field[j][i] >= 16) {
                        this.m_UnsolvedLines += 4;
                        continue;
                    }
                    for (int k = 0; k < 4; ++k) {
                        if ((this.m_Field[j][i] & 1 << k) == 0) continue;
                        ++this.m_UnsolvedLines;
                    }
                }
            }
            stream.close();
            stream = null;
            oldPlayer = null;
            System.gc();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getFieldWidth() {
        return this.m_Field.length;
    }

    public int getFieldHeight() {
        return this.m_Field[0].length;
    }

    public int getBlock(int x, int y) {
        if (x < 0 || x >= this.getFieldWidth() || y < 0 || y >= this.getFieldHeight()) {
            return 0;
        }
        return this.m_Field[x][y];
    }

    public int getLevel() {
        return this.m_Level;
    }

    public int getPercents() {
        int unsolvedPercents = this.m_UnsolvedLines * 100 / (this.getFieldWidth() * this.getFieldHeight() * 4);
        if (unsolvedPercents < this.m_Percents) {
            return 0;
        }
        return unsolvedPercents - this.m_Percents;
    }

    public Player getPlayer() {
        return this.m_Player;
    }

    public void deleteBlock(int x, int y, int type) {
        int blockTypeOld;
        if (x < 0 || x >= this.getFieldWidth() || y < 0 || y >= this.getFieldHeight()) {
            return;
        }
        int blockTypeNew = blockTypeOld = this.m_Field[x][y];
        if (type < 16) {
            blockTypeNew = blockTypeOld & ~type;
        } else if (type == blockTypeOld) {
            blockTypeNew = 0;
        }
        if (blockTypeNew != blockTypeOld) {
            this.computeScoreAndPercentsForBlocks(blockTypeOld, blockTypeNew, 0);
            this.m_Field[x][y] = (byte)blockTypeNew;
        }
    }

    public void updateBlock(int x, int y, int ignoreX, int ignoreY, int depth) {
        int blockTypeNew;
        if (x < 0 || x >= this.getFieldWidth() || y < 0 || y >= this.getFieldHeight()) {
            return;
        }
        if (x == ignoreX && y == ignoreY) {
            return;
        }
        int blockTypeOld = this.getBlock(x, y);
        if (blockTypeOld == 0) {
            return;
        }
        if (blockTypeOld == 17) {
            blockTypeOld = 15;
        }
        if (blockTypeOld < 16) {
            int blockMask = 0;
            int blockTypeLeft = this.getBlock(x - 1, y);
            int blockTypeRight = this.getBlock(x + 1, y);
            int blockTypeUp = this.getBlock(x, y - 1);
            int blockTypeDown = this.getBlock(x, y + 1);
            if (blockTypeLeft >= 16 || (blockTypeLeft & 4) != 0) {
                blockMask |= 8;
            }
            if (blockTypeRight >= 16 || (blockTypeRight & 8) != 0) {
                blockMask |= 4;
            }
            if (blockTypeUp >= 16 || (blockTypeUp & 1) != 0) {
                blockMask |= 2;
            }
            if (blockTypeDown >= 16 || (blockTypeDown & 2) != 0) {
                blockMask |= 1;
            }
            if ((blockTypeNew = blockTypeOld & blockMask) == 8 || blockTypeNew == 4 || blockTypeNew == 2 || blockTypeNew == 1 || blockTypeNew == 0) {
                blockTypeNew = 0;
            } else {
                if (x == 0) {
                    blockTypeNew |= blockTypeOld & 8;
                }
                if (x == this.getFieldWidth() - 1) {
                    blockTypeNew |= blockTypeOld & 4;
                }
                if (y == 0) {
                    blockTypeNew |= blockTypeOld & 2;
                }
                if (y == this.getFieldHeight() - 1) {
                    blockTypeNew |= blockTypeOld & 1;
                }
            }
        } else {
            blockTypeOld = 15;
            blockTypeNew = 0;
        }
        if (blockTypeOld != blockTypeNew) {
            this.computeScoreAndPercentsForBlocks(blockTypeOld, blockTypeNew, depth);
            this.m_Field[x][y] = (byte)blockTypeNew;
            int blockTypeDel = blockTypeOld ^ blockTypeNew;
            if ((blockTypeDel & 8) != 0) {
                this.updateBlock(x - 1, y, ignoreX, ignoreY, depth + 1);
            }
            if ((blockTypeDel & 4) != 0) {
                this.updateBlock(x + 1, y, ignoreX, ignoreY, depth + 1);
            }
            if ((blockTypeDel & 2) != 0) {
                this.updateBlock(x, y - 1, ignoreX, ignoreY, depth + 1);
            }
            if ((blockTypeDel & 1) != 0) {
                this.updateBlock(x, y + 1, ignoreX, ignoreY, depth + 1);
            }
        }
    }

    public void computeScoreAndPercentsForBlocks(int blockTypeOld, int blockTypeNew, int depth) {
        int blockMask = blockTypeOld ^ blockTypeNew;
        for (int i = 0; i < 4; ++i) {
            if ((blockMask & 1 << i) == 0) continue;
            if (depth > 0) {
                this.m_Player.setScore(this.m_Player.getScore() + 5);
            } else {
                this.m_Player.setScore(this.m_Player.getScore() + 1);
            }
            --this.m_UnsolvedLines;
        }
    }

    public void addItem(int type, int x, int y) {
        if (this.m_Items != null) {
            for (int i = 0; i < this.m_Items.length; ++i) {
                if (this.m_Items[i] != null && !this.m_Items[i].isDead()) continue;
                this.m_Items[i] = new Item(type, x, y);
                break;
            }
        }
    }

    public void addEnemy(int x, int y) {
        if (this.m_Enemies != null) {
            for (int i = 0; i < this.m_Enemies.length; ++i) {
                if (this.m_Enemies[i] != null && !this.m_Enemies[i].isDead()) continue;
                this.m_Enemies[i] = new Enemy(x, y);
                break;
            }
        }
    }

    public boolean update() {
        int i;
        this.m_Player.update();
        if (this.m_Enemies != null) {
            for (i = 0; i < this.m_Enemies.length; ++i) {
                if (this.m_Enemies[i] == null) continue;
                this.m_Enemies[i].update();
            }
        }
        if (this.m_Items != null) {
            for (i = 0; i < this.m_Items.length; ++i) {
                if (this.m_Items[i] == null) continue;
                this.m_Items[i].update();
            }
        }
        return true;
    }

    public void paintField(Graphics graphics, Image backImage) {
        int blockNumsX = this.m_BlocksImage.getWidth() / this.m_BlockSize;
        int oldClipX = graphics.getClipX();
        int oldClipY = graphics.getClipY();
        int oldClipWidth = graphics.getClipWidth();
        int oldClipHeight = graphics.getClipHeight();
        for (int fy = 0; fy < this.getFieldHeight(); ++fy) {
            for (int fx = 0; fx < this.getFieldWidth(); ++fx) {
                byte blockType = this.m_Field[fx][fy];
                if (this.m_FieldOld[fx][fy] == blockType) continue;
                this.m_FieldOld[fx][fy] = blockType;
                int blockXpos = blockType % blockNumsX * this.m_BlockSize;
                int blockYpos = blockType / blockNumsX * this.m_BlockSize;
                int destXpos = fx * this.m_BlockSize;
                int destYpos = fy * this.m_BlockSize;
                graphics.setClip(destXpos, destYpos, this.m_BlockSize, this.m_BlockSize);
                graphics.drawImage(backImage, 0, 0, 20);
                graphics.drawImage(this.m_BlocksImage, destXpos - blockXpos, destYpos - blockYpos, 20);
            }
        }
        graphics.setClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
    }

    public void paintObstacles(Graphics graphics, int x, int y) {
        int i;
        if (this.m_Player != null) {
            this.m_Player.paint(graphics, x, y);
        }
        if (this.m_Enemies != null) {
            for (i = 0; i < this.m_Enemies.length; ++i) {
                if (this.m_Enemies[i] == null) continue;
                this.m_Enemies[i].paint(graphics, x, y);
            }
        }
        if (this.m_Items != null) {
            for (i = 0; i < this.m_Items.length; ++i) {
                if (this.m_Items[i] == null) continue;
                this.m_Items[i].paint(graphics, x, y);
            }
        }
    }

    public void paintHideBlocks(Graphics graphics, int px, int py, int x, int y, int width, int height) {
        int blockNumsX = this.m_BlocksImage.getWidth() / this.m_BlockSize;
        int blockType = 18;
        int blockXpos = blockType % blockNumsX * this.m_BlockSize;
        int blockYpos = blockType / blockNumsX * this.m_BlockSize;
        int oldClipX = graphics.getClipX();
        int oldClipY = graphics.getClipY();
        int oldClipWidth = graphics.getClipWidth();
        int oldClipHeight = graphics.getClipHeight();
        for (int fy = y; fy < y + height; ++fy) {
            for (int fx = x; fx < x + width; ++fx) {
                int destXpos = px + fx * this.m_BlockSize;
                int destYpos = py + fy * this.m_BlockSize;
                graphics.setClip(destXpos, destYpos, this.m_BlockSize, this.m_BlockSize);
                graphics.drawImage(this.m_BlocksImage, destXpos - blockXpos, destYpos - blockYpos, 20);
            }
        }
        graphics.setClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
    }
}

