/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class ScoreBar {
    private Image m_ScoreBar;
    private Image m_EnergyLine;
    private StringBuffer m_Score;
    private StringBuffer m_Lives;
    private StringBuffer m_Percents;
    private StringBuffer m_Level;

    public ScoreBar() {
        try {
            this.m_ScoreBar = Image.createImage((String)"/scorebar.png");
            this.m_EnergyLine = Image.createImage((String)"/energyline.png");
            this.m_Score = new StringBuffer("000000");
            this.m_Lives = new StringBuffer("0");
            this.m_Percents = new StringBuffer("00");
            this.m_Level = new StringBuffer("00");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void paint(Graphics graphics, int x, int y) {
        LineOut lineout = (LineOut)Application.getCurrent();
        Game game = (Game)Display.getDisplay((MIDlet)lineout).getCurrent();
        GameField gamefield = game.getGameField();
        Player player = gamefield.getPlayer();
        if (player == null) {
            return;
        }
        int factorW = (graphics.getClipWidth() << 16) / 128;
        int factorH = (this.m_ScoreBar.getHeight() << 16) / 16;
        int barX = x;
        int barY = y + graphics.getClipHeight() - this.m_ScoreBar.getHeight();
        int liveX = (94 * factorW >> 16) + barX;
        int liveY = (7 * factorH >> 16) + barY;
        int scoreX = (44 * factorW >> 16) + barX;
        int scoreY = (7 * factorH >> 16) + barY;
        int levelX = (9 * factorW >> 16) + barX;
        int levelY = (7 * factorH >> 16) + barY;
        int percentX = (107 * factorW >> 16) + barX;
        int percentY = (7 * factorH >> 16) + barY;
        int energylineX = (15 * factorW >> 16) + barX;
        int energylineY = (2 * factorH >> 16) + barY;
        int energySize = this.m_EnergyLine.getWidth() * player.getEnergy() / 100;
        int lives = player.getLives();
        int score = player.getScore();
        int percents = gamefield.getPercents();
        int level = gamefield.getLevel();
        this.m_Lives.setCharAt(0, (char)(lives % 10 + 48));
        this.m_Score.setCharAt(5, (char)(score % 10 + 48));
        this.m_Score.setCharAt(4, (char)((score /= 10) % 10 + 48));
        this.m_Score.setCharAt(3, (char)((score /= 10) % 10 + 48));
        this.m_Score.setCharAt(2, (char)((score /= 10) % 10 + 48));
        this.m_Score.setCharAt(1, (char)((score /= 10) % 10 + 48));
        this.m_Score.setCharAt(0, (char)((score /= 10) % 10 + 48));
        this.m_Percents.setCharAt(1, (char)(percents % 10 + 48));
        this.m_Percents.setCharAt(0, (char)((percents /= 10) % 10 + 48));
        this.m_Level.setCharAt(1, (char)(level % 10 + 48));
        this.m_Level.setCharAt(0, (char)((level /= 10) % 10 + 48));
        graphics.drawImage(this.m_ScoreBar, barX, barY, 20);
        game.drawString(graphics, lineout.bitmapFontA(), this.m_Lives, liveX, liveY, 20);
        game.drawString(graphics, lineout.bitmapFontB(), this.m_Score, scoreX, scoreY, 20);
        game.drawString(graphics, lineout.bitmapFontA(), this.m_Level, levelX, levelY, 20);
        game.drawString(graphics, lineout.bitmapFontB(), this.m_Percents, percentX, percentY, 20);
        if (energySize > 0) {
            int oldClipX = graphics.getClipX();
            int oldClipY = graphics.getClipY();
            int oldClipWidth = graphics.getClipWidth();
            int oldClipHeight = graphics.getClipHeight();
            graphics.setClip(energylineX, energylineY, energySize, this.m_EnergyLine.getHeight());
            graphics.drawImage(this.m_EnergyLine, energylineX, energylineY, 0x10 | 4);
            graphics.setClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
        }
    }
}

