/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite {
    private Image image;
    private int x;
    private int y;
    private boolean visible;
    private int frame;
    private int num_frames;
    public int width;
    public int height;
    public int slide = 0;

    public Sprite(Image image, int numframes) {
        this.InitImage(image, numframes);
    }

    public void InitImage(Image image, int numframes) {
        this.image = image;
        this.frame = 0;
        this.num_frames = numframes;
        this.visible = true;
        if (image != null) {
            this.width = this.image.getWidth() / numframes;
            this.height = this.image.getHeight();
        }
    }

    public void Destroy() {
        this.DeActivate();
    }

    public void Draw(Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.x > IceHockey.canvasWidth || this.x + this.width < 0 || this.y > IceHockey.canvasHeight || this.y + this.height < 0) {
            return;
        }
        g.setClip(this.x, this.y, this.width, this.height);
        g.drawImage(this.image, this.x - this.frame * this.width, this.y, 20);
    }

    public void DrawFlipped(Graphics g) {
        if (!this.visible) {
            return;
        }
        for (int xx = 0; xx < this.width; ++xx) {
            g.setClip(this.x + (this.width - xx), this.y + this.slide, 1, this.height - this.slide);
            g.drawImage(this.image, this.x - this.frame * this.width + (this.width - xx * 2), this.y + this.slide, 20);
        }
    }

    public void DrawAndSlide(Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.x > IceHockey.canvasWidth || this.x + this.width < 0 || this.y > IceHockey.canvasHeight || this.y + this.height < 0) {
            return;
        }
        g.setClip(this.x, this.y + this.slide, this.width, this.height - this.slide);
        g.drawImage(this.image, this.x - this.frame * this.width, this.y + this.slide, 20);
    }

    public void DrawFromImage(Image im, Graphics g, int str_wid) {
        int clphgt;
        int wid = im.getWidth() / str_wid;
        int hgt = im.getHeight();
        if (!this.visible) {
            return;
        }
        if (this.x > IceHockey.canvasWidth || this.x + wid < 0 || this.y > IceHockey.canvasHeight || this.y + hgt < 0) {
            return;
        }
        int clpwid = wid;
        if (this.x + clpwid > IceHockey.canvasWidth) {
            clpwid = IceHockey.canvasWidth - this.x;
        }
        if (this.y + (clphgt = hgt) > IceHockey.canvasHeight) {
            clphgt = IceHockey.canvasHeight - this.y;
        }
        g.setClip(this.x, this.y, clpwid, clphgt);
        g.drawImage(im, this.x - this.frame * wid, this.y, 20);
    }

    public void DrawFromImage(Image im, Graphics g, int xoff, int yoff, int width, int height) {
        int wid = im.getWidth() / width;
        int hgt = im.getHeight() / height;
        if (!this.visible) {
            return;
        }
        if (this.x > IceHockey.canvasWidth || this.x + wid < 0 || this.y > IceHockey.canvasHeight || this.y + hgt < 0) {
            return;
        }
        g.setClip(this.x, this.y, wid, hgt);
        g.drawImage(im, this.x - (this.frame + xoff) * wid, this.y - yoff * hgt, 20);
    }

    public void DrawSingle(Image im, Graphics g, boolean isFlip) {
        int wid = im.getWidth();
        int hgt = im.getHeight();
        if (!this.visible) {
            return;
        }
        if (this.x > IceHockey.canvasWidth || this.x + wid < 0 || this.y > IceHockey.canvasHeight || this.y + hgt < 0) {
            return;
        }
        if (isFlip) {
            DirectUtils.getDirectGraphics((Graphics)g).drawImage(im, this.x, this.y, 20, 180);
        } else {
            g.drawImage(im, this.x, this.y, 20);
        }
    }

    public void Activate() {
        this.visible = true;
    }

    public void DeActivate() {
        this.visible = false;
    }

    public boolean IsActive() {
        return this.visible;
    }

    public Image GetImage() {
        return this.image;
    }

    public int GetX() {
        return this.x;
    }

    public void SetX(int x) {
        this.x = x;
    }

    public int GetY() {
        return this.y;
    }

    public void SetY(int y) {
        this.y = y;
    }

    public void SetXY(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void SetFrame(int fr) {
        this.frame = fr;
    }

    public int GetFrame() {
        return this.frame;
    }
}

