/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class DeviceAPI {
    public boolean vibrateEnabled = true;
    public int currentVolume = 3;
    private Core core;
    private Player currentPlayer;
    private VolumeControl volumeControl;
    private int[] volumeLevels = new int[]{0, 33, 67, 100};

    public DeviceAPI(int NUM_SOUNDS, Core core) {
        this.core = core;
    }

    public void playSound(int soundNumber, boolean loop, boolean soundTypeSupported) {
        if (this.currentVolume > 0 && soundTypeSupported) {
            this.stopSound();
            this.loadSound(soundNumber);
            if (loop) {
                this.currentPlayer.setLoopCount(-1);
            } else {
                this.currentPlayer.setLoopCount(1);
            }
            this.resumeSound();
        }
    }

    public void stopSound() {
        try {
            this.currentPlayer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseSound() {
        try {
            this.currentPlayer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resumeSound() {
        try {
            this.currentPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean midiNotPlaying() {
        return this.currentPlayer != null && this.currentPlayer.getState() != 400;
    }

    public void vibrate() {
        if (this.vibrateEnabled) {
            try {
                this.core.display.vibrate(400);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void backLight() {
    }

    private void loadSound(int soundNumber) {
        try {
            this.currentPlayer = Manager.createPlayer((InputStream)new Object().getClass().getResourceAsStream("/" + soundNumber + ".mid"), (String)"audio/midi");
            this.currentPlayer.prefetch();
            this.volumeControl = (VolumeControl)this.currentPlayer.getControl("VolumeControl");
            if (this.volumeControl != null) {
                this.volumeControl.setLevel(this.volumeLevels[this.currentVolume]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fillRect(Graphics g, int x1, int y1, int x2, int y2, int color) {
        g.setColor(color);
        g.fillRect(x1, y1, x2 - x1, y2 - y1);
    }
}

