/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class DeviceCanvas
extends GameCanvas {
    public Core core;
    private Display display;
    private int frameCount;
    public Image preloadingImage;
    private Graphics graphics;

    public DeviceCanvas(Display display) {
        super(false);
        this.display = display;
        this.setFullScreenMode(true);
        try {
            this.preloadingImage = Image.createImage((String)"/01gyroxlogo.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.graphics = this.getGraphics();
    }

    public void update() {
        if (this.frameCount == 3) {
            int relativeFrame = 0;
            while (relativeFrame < 1) {
                this.updateCoreKeyStates();
                this.core.Core_update(this.graphics);
                ++relativeFrame;
            }
            this.flushGraphics();
        } else if (this.frameCount == 2) {
            this.core = new Core(this.display, this.preloadingImage);
            ++this.frameCount;
        } else {
            this.graphics.setColor(0);
            this.graphics.fillRect(0, 0, 176, 220);
            if (this.preloadingImage != null) {
                this.graphics.drawImage(this.preloadingImage, 88, 110, 3);
            }
            ++this.frameCount;
        }
    }

    public void hideNotify() {
        this.core.Core_pauseGame();
    }

    public void keyPressed(int key) {
        this.core.Key_event(key, true, true);
    }

    public void keyReleased(int key) {
        this.core.Key_event(key, false, true);
    }

    private void updateCoreKeyStates() {
        int keyStates = this.getKeyStates();
        if ((keyStates & 2) != 0) {
            this.core.Key_event(-1, true, false);
        } else {
            this.core.Key_event(-1, false, false);
        }
        if ((keyStates & 0x40) != 0) {
            this.core.Key_event(-2, true, false);
        } else {
            this.core.Key_event(-2, false, false);
        }
        if ((keyStates & 4) != 0) {
            this.core.Key_event(-3, true, false);
        } else {
            this.core.Key_event(-3, false, false);
        }
        if ((keyStates & 0x20) != 0) {
            this.core.Key_event(-4, true, false);
        } else {
            this.core.Key_event(-4, false, false);
        }
        if ((keyStates & 0x100) != 0) {
            this.core.Key_event(-5, true, false);
        } else {
            this.core.Key_event(-5, false, false);
        }
    }
}

