/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames.rocky;

import com.anthemgames.Runtime;
import com.anthemgames.rocky.Config;
import com.anthemgames.rocky.ui.Arena;
import com.anthemgames.rocky.ui.MainScreen;
import com.anthemgames.sound.S60SoundPlayer;
import com.anthemgames.ui.SplashScreen;
import com.anthemgames.ui.TextScreen;
import com.sprintpcs.media.Vibrator;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class RockyRuntime
extends Runtime {
    public static String[] CREDITS = new String[]{"Rocky", "(TM) & (c)", "1976-2006", "Metro-Goldwyn-Mayer", "Studios Inc", " ", "All rights ", "Reserved.", ""};
    public static Image SplashImg;
    public static boolean ignoreKeys;
    public static int showingLegal;
    public static final boolean AUDIO_ENABLED;
    public static final String AUDIO_EXTENSION = ".qcp";
    public static final String AUDIO_MIMETYPE = "audio/vnd.qcelp";
    public static final boolean SMALL_RUNTIME = false;
    private static MainScreen MyMainScreen;
    private static TextScreen MyTextScreen;
    private static Arena MyArena;
    private static SplashScreen MySplash;
    public static boolean incomingInSplash;
    public static String debugText;

    public static MainScreen getMainScreen() {
        if (MyMainScreen == null) {
            MyMainScreen = new MainScreen(0);
        }
        RockyRuntime.MyMainScreen.setDrawLoading = false;
        return MyMainScreen;
    }

    public static MainScreen getMainScreen(int type) {
        if (MyMainScreen == null) {
            MyMainScreen = new MainScreen(type);
        }
        RockyRuntime.MyMainScreen.setDrawLoading = false;
        return MyMainScreen;
    }

    public static TextScreen GetTextScreen(String[] text, Displayable nextscreen, boolean paragraphs) {
        MyTextScreen = null;
        MyTextScreen = new TextScreen(text, nextscreen, paragraphs);
        return MyTextScreen;
    }

    public static TextScreen GetTextScreen(String[] text, Displayable nextscreen, boolean paragraphs, boolean centered) {
        MyTextScreen = null;
        MyTextScreen = new TextScreen(text, nextscreen, paragraphs, centered);
        return MyTextScreen;
    }

    public static synchronized Arena GetArenaScreen(int venue, int npc) {
        RockyRuntime.FreememForGame();
        MyArena = new Arena(venue, npc);
        return MyArena;
    }

    public static synchronized Arena GetArenaScreen(int venue) {
        RockyRuntime.FreememForGame();
        MyArena = new Arena(venue);
        return MyArena;
    }

    public static void FreememForGame() {
        MyMainScreen = null;
        MyTextScreen = null;
        MyArena = null;
    }

    public static void showScreen() {
        Arena.Interupted = false;
        if (Runtime.currentScreen == null) {
            Vector<Image> images = new Vector<Image>();
            Vector<Integer> colors = new Vector<Integer>();
            Image logos = Runtime.loadImage("logos");
            colors.addElement(new Integer(-1));
            images.addElement(Runtime.extractImage(logos, 0, 0, 104, 100));
            colors.addElement(new Integer(-16777216));
            images.addElement(Runtime.extractImage(logos, 0, 164, 104, 70));
            logos = null;
            Font font = Font.getFont((int)64, (int)0, (int)8);
            Image background = SplashImg;
            if (background != null) {
                colors.addElement(new Integer(0));
                images.addElement(background);
            }
            MySplash = new SplashScreen(images, colors);
            MySplash.start((Displayable)RockyRuntime.getMainScreen());
            MySplash = null;
        } else {
            Arena.returnTime = System.currentTimeMillis();
            Runtime.showScreen();
        }
    }

    public static void pauseApp() {
        if (Runtime.currentScreen != null && Runtime.currentScreen instanceof Arena) {
            Arena.Interupted = true;
            ((Arena)Runtime.currentScreen).pause();
        }
    }

    public static void playSound(String filename, String mimetype) {
        Runtime.playSound(filename, mimetype);
    }

    public static void playBackgroundSound(String filename, String mimetype) {
        Runtime.playBackgroundSound(filename, mimetype);
    }

    public static void vibrate() {
        if (Config.vibrate()) {
            Vibrator.vibrate((int)100);
        }
    }

    static {
        Runtime.setSoundPlayer(new S60SoundPlayer());
        SplashImg = Runtime.loadImage("splash");
        ignoreKeys = false;
        showingLegal = 0;
        AUDIO_ENABLED = Runtime.soundPlayer != null;
        MyMainScreen = null;
        MyTextScreen = null;
        MyArena = null;
        MySplash = null;
        incomingInSplash = false;
        debugText = "";
    }
}

