/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames.rocky.ui;

import com.anthemgames.Runtime;
import com.anthemgames.rocky.Config;
import com.anthemgames.rocky.RockyRuntime;
import com.anthemgames.rocky.players.Boxer;
import com.anthemgames.rocky.ui.ComboTrainer;
import com.anthemgames.rocky.ui.Micky;
import com.anthemgames.ui.ImageScreen;
import com.nokia.mid.ui.FullCanvas;
import java.util.Random;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Arena
extends FullCanvas {
    private static final long ROUND_DURATION = 61000L;
    private static final int ROCKY_STARTING_X = 32;
    private static final int OPPONENT_STARTING_X = 96;
    private static final int BOXER_Y = 32;
    private static final int ROCKY_PRACTICING_X = 24;
    private static final int ROCKY_PRACTICING_Y = 64;
    private static final int MEATBAG_X = 48;
    private static final int MEATBAG_Y = 32;
    public static final int MEATLOCKER = 0;
    public static final int GYM = 1;
    public static final int MAINRING = 2;
    public static final int OK_BUTTON = -23;
    private Image offscreen;
    private Graphics primary = null;
    private static final String[] BACKGROUND_IMAGE_FILES = new String[]{"meatroom", "gym", "ring"};
    private static final String[] COUNTS = new String[]{"one", "two", "three"};
    private static int[][] MEATLOCKER_PATTERN = new int[][]{{0, 1, 2, 0, 0, 1, 2, 0, 0, 2, -1}, {3, 4, 5, 3, 3, 4, 5, 3, 3, 4, -1}, {6, 7, 7, 7, 8, 7, 7, 7, 7, 7, -1}, {9, 10, 10, 10, 10, 10, 10, 10, 10, 10, -1}, {11, 12, 12, 12, 12, 12, 12, 12, 12, 12, -1}, {13, 14, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 16, 15, 15, 15, 15, 16, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1}};
    private static int[][] GYM_PATTERN = new int[][]{{0, 1, 2, 2, 2, 2, 2, 2, 14, 15, -1}, {3, 4, 5, 5, 5, 5, 5, 5, 12, 13, -1}, {6, 7, 8, 9, 9, 9, 9, 10, 11, 6, -1}, {24, 25, 26, 27, 27, 27, 27, 34, 40, 39, -1}, {28, 29, 30, 30, 30, 30, 30, 30, 37, 38, -1}, {31, 30, 30, 30, 30, 30, 30, 30, 30, 36, -1}, {32, 32, 32, 32, 32, 32, 32, 32, 32, 32, -1}, {33, 33, 33, 33, 33, 33, 33, 33, 33, 33, -1}, {35, 35, 35, 35, 35, 35, 35, 35, 35, 35, -1}};
    private static int[] GYM_FOREGROUND = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static int[][] MAINRING_PATTERN = new int[][]{{0, 1, 2, 3, 3, 3, 3, 4, 5, 6, -1}, {23, 24, 25, 26, 26, 26, 26, 7, 8, 9, -1}, {10, 11, 12, 13, 13, 13, 13, 30, 31, 32, -1}, {33, 34, 35, 36, 36, 36, 36, 17, 18, 19, -1}, {20, 21, 22, 22, 22, 22, 22, 22, 39, 40, -1}, {37, 22, 22, 22, 22, 22, 22, 22, 22, 38, -1}, {14, 14, 14, 14, 14, 14, 14, 14, 14, 14, -1}, {29, 27, 29, 28, 15, 28, 29, 29, 15, 27, -1}};
    private static int[] MAINRING_FOREGROUND = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private StopThread thread = null;
    private Object semaphore = new Object();
    private int background_offset = 0;
    protected int venue;
    private Boxer rocky;
    protected Boxer opponent;
    private Image backgroundtiles;
    private Image background = null;
    private int foregroundyoffset = -1;
    private boolean boxing = false;
    private int healthbarlength;
    private Micky micky;
    private boolean match_finished = false;
    private long knockout_time = 0L;
    private long standup_checked = 0L;
    private boolean[] knockout_sounds = new boolean[]{false, false, false};
    private long round_started;
    private long round_ends;
    private Image healthbar = null;
    private Image score = null;
    private Image numbers = null;
    private Image ropes = null;
    private Image[] combo = null;
    private int rocky_ko = 0;
    private int opponent_ko = 0;
    private int round = 0;
    private boolean inround = false;
    private long combo_time = 0L;
    private long combo_train_time = 0L;
    private boolean combo_training = false;
    private long combo_frozen_time = -1L;
    private long combo_time_lag = 500L;
    private ComboTrainer comboTrainer = null;
    private boolean comboCompleted = false;
    private boolean comboFailed = false;
    private boolean frozen = false;
    private String[] menu = null;
    private int selection = -1;
    private Font textfont = Font.getFont((int)0, (int)1, (int)16);
    private long freezetime = 0L;
    private boolean freezetimer = false;
    private long time_remaining = 0L;
    private boolean comboSuccess = false;
    private Random random = new Random();
    private boolean rocky_punch_first = false;
    private boolean StopKeys = false;
    private boolean NoHideorShow = false;
    private boolean comboNull = false;
    public int FPS = 10;
    public int maxSleepTime = 1000 / this.FPS;
    public boolean paused = false;
    public static boolean Interupted = false;
    int cheat = 0;
    public static long returnTime = 0L;
    public static long leaveTime = 0L;
    public static long specialTime = 0L;
    public static long hideTime = 0L;
    private long currentTime = 0L;
    private long lastUpdateTime = System.currentTimeMillis();

    public Arena(int venue) {
        this(venue, 6);
    }

    public Arena(int venue, int npc) {
        this.init(venue, npc);
    }

    public void init(int venue, int npc) {
        Runtime.stopPlayingSound();
        this.venue = venue;
        this.opponent = new Boxer(npc, this);
        this.micky = new Micky(this, true);
        this.healthbarlength = this.getWidth() * 45 / 100;
        switch (venue) {
            case 0: {
                this.rocky = new Boxer(4, this);
                this.comboTrainer = new ComboTrainer(this, this.rocky);
                this.combo_time_lag = 1000L;
                break;
            }
            case 1: {
                this.rocky = new Boxer(3, this);
                break;
            }
            case 2: {
                this.rocky = new Boxer(5, this);
            }
        }
        switch (venue) {
            case 1: 
            case 2: {
                this.healthbar = Runtime.loadImage("bar");
                this.ropes = Runtime.loadImage("ropes");
            }
            case 0: {
                this.score = Runtime.loadImage("score");
                this.numbers = Runtime.loadImage("numbers");
                this.combo = new Image[3];
                this.combo[0] = Runtime.loadImage("great");
                this.combo[1] = Runtime.loadImage("wrong");
                this.combo[2] = Runtime.loadImage("combo");
            }
        }
        this.rocky.setOpponent(this.opponent);
        this.opponent.setOpponent(this.rocky);
        if (this.opponent.getHitPoints() < this.rocky.getHitPoints()) {
            this.opponent.addHitPointBonus(this.rocky.getHitPoints() - this.opponent.getHitPoints());
        }
    }

    public void pause() {
        leaveTime = System.currentTimeMillis();
        if (this.menu == null && this.micky == null && this.rocky != null) {
            Interupted = true;
            this.menu = new String[]{"Resume game", "Exit"};
            this.selection = 0;
            this.setFrozen(true);
            this.requestRepaint();
        }
    }

    private void handleMickyOk() {
        if (this.match_finished || this.comboSuccess) {
            Runtime.showScreen((Displayable)RockyRuntime.getMainScreen(1));
        } else {
            this.combo_train_time = System.currentTimeMillis();
            this.micky = null;
            this.boxing = true;
            this.startRound();
        }
    }

    public void keyRepeated(int keycode) {
        if (RockyRuntime.ignoreKeys) {
            return;
        }
        if (!this.frozen && !this.opponent.isDown() && this.rocky != null) {
            switch (keycode) {
                case 52: {
                    this.rocky.moveLeft();
                    break;
                }
                case 53: {
                    this.rocky.block();
                    break;
                }
                case 54: {
                    this.rocky.moveRight();
                }
            }
        }
    }

    public void keyPressed(int keycode) {
        try {
            boolean incoming;
            boolean repaint;
            block44: {
                block45: {
                    block43: {
                        RockyRuntime.debugText = String.valueOf(keycode);
                        if (RockyRuntime.ignoreKeys) {
                            return;
                        }
                        if (!(keycode != 35 && this.cheat == 0 || this.frozen)) {
                            this.cheat = keycode == 35 && this.cheat == 0 ? 1 : (keycode == 55 && this.cheat == 1 ? 2 : (keycode == 56 && this.cheat == 2 ? 3 : (keycode == 57 && this.cheat == 3 ? 4 : 0)));
                        }
                        if (this.cheat == 4) {
                            this.opponent.knockOut();
                            this.cheat = 0;
                        }
                        repaint = true;
                        incoming = false;
                        if (keycode == 42) {
                            try {
                                Config.toggleSound(!Config.playSound());
                            }
                            catch (Throwable error) {
                                Runtime.checkIfSavable();
                            }
                            return;
                        }
                        if (keycode == -6 || keycode == -7 || keycode == -6 || keycode == -7) {
                            keycode = -23;
                        }
                        if (this.micky == null || Interupted) break block43;
                        switch (this.getGameAction(keycode)) {
                            case 1: {
                                if (this.micky != null) {
                                    this.micky.scroll(false);
                                    break;
                                }
                                break block44;
                            }
                            case 6: {
                                if (this.micky != null) {
                                    this.micky.scroll(true);
                                    break;
                                }
                                break block44;
                            }
                            case 8: {
                                this.inActionFire();
                                break;
                            }
                            default: {
                                if (keycode == -23) {
                                    this.inActionFire();
                                    break;
                                }
                                repaint = false;
                                break;
                            }
                        }
                        break block44;
                    }
                    if (this.frozen || this.StopKeys) break block45;
                    switch (this.getGameAction(keycode)) {
                        case 2: {
                            this.rocky.moveLeft();
                            break;
                        }
                        case 5: {
                            this.rocky.moveRight();
                        }
                    }
                    switch (keycode) {
                        case 50: {
                            incoming = this.rocky.punch(1);
                            break;
                        }
                        case 49: {
                            incoming = this.rocky.punch(0);
                            break;
                        }
                        case 51: {
                            incoming = this.rocky.punch(2);
                            break;
                        }
                        case -3: 
                        case 52: {
                            this.rocky.moveLeft();
                            break;
                        }
                        case -4: 
                        case 54: {
                            this.rocky.moveRight();
                            break;
                        }
                        case 53: {
                            if (this.venue == 2) {
                                this.rocky.block();
                                break;
                            }
                            break block44;
                        }
                        case -23: {
                            this.pause();
                            break;
                        }
                        default: {
                            if (this.getGameAction(keycode) == 8) {
                                this.pause();
                                break;
                            }
                            break block44;
                        }
                    }
                    break block44;
                }
                if (this.menu != null) {
                    switch (this.getGameAction(keycode)) {
                        case 8: {
                            Interupted = false;
                            this.handleFrozenOk();
                            repaint = false;
                            break;
                        }
                        case 1: {
                            if (this.selection > 0) {
                                --this.selection;
                            }
                            this.repaint();
                            break;
                        }
                        case 6: {
                            if (this.selection < this.menu.length - 1) {
                                ++this.selection;
                            }
                            this.repaint();
                            break;
                        }
                        default: {
                            if (keycode == -23) {
                                this.handleFrozenOk();
                                repaint = false;
                                break;
                            }
                            repaint = false;
                        }
                    }
                }
            }
            if (incoming && this.comboTrainer == null) {
                this.opponent.seePunch(this.rocky.getPunchX());
            }
            if (repaint) {
                this.requestRepaint();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void inActionFire() {
        if (this.match_finished || this.comboSuccess) {
            Runtime.showScreen((Displayable)RockyRuntime.getMainScreen(1));
        } else {
            this.combo_train_time = System.currentTimeMillis();
            this.micky = null;
            this.boxing = true;
            this.startRound();
        }
    }

    private void handleFrozenOk() {
        switch (this.selection) {
            case 0: {
                this.setFrozen(false);
                this.menu = null;
                Interupted = false;
                break;
            }
            case 1: {
                if (this.comboSuccess) {
                    this.micky = new Micky(this);
                    this.requestRepaint();
                    break;
                }
                this.endThread();
                RockyRuntime.FreememForGame();
                Runtime.showScreen((Displayable)RockyRuntime.getMainScreen());
            }
        }
        this.showNotify();
    }

    public void freezeBoxers(boolean frozen) {
        this.frozen = frozen;
    }

    public void setFrozen(boolean frozen) {
        if (frozen && !this.frozen) {
            this.frozen = true;
            this.freezetimer = true;
            this.combo_frozen_time = System.currentTimeMillis() - this.combo_time;
            this.freezetime = System.currentTimeMillis();
            this.time_remaining = this.round_ends - this.freezetime;
        } else if (!frozen) {
            this.frozen = false;
            this.freezetimer = false;
            if (this.combo_training) {
                this.combo_train_time = System.currentTimeMillis();
            }
            if (this.combo_frozen_time != -1L) {
                this.combo_time = System.currentTimeMillis() - this.combo_frozen_time;
            }
            this.round_ends = System.currentTimeMillis() + this.time_remaining;
            this.round_started = this.round_ends - 61000L;
            this.freezetime = 0L;
            this.menu = null;
        }
    }

    public void paint(Graphics graphics) {
        if (this.rocky == null) {
            return;
        }
        if (this.frozen) {
            this.combo_time = System.currentTimeMillis();
        }
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int[][] pattern = null;
        switch (this.venue) {
            case 0: {
                pattern = MEATLOCKER_PATTERN;
                break;
            }
            case 1: {
                pattern = GYM_PATTERN;
                break;
            }
            case 2: {
                pattern = MAINRING_PATTERN;
            }
        }
        if (this.backgroundtiles == null) {
            this.backgroundtiles = Runtime.loadImage(BACKGROUND_IMAGE_FILES[this.venue]);
        }
        if (this.rocky.inMiddleOfPunch() || this.opponent.inMiddleOfPunch()) {
            Boxer boxer2;
            this.rocky_punch_first = Math.abs(this.random.nextInt()) % 3 > 1;
            Boxer boxer1 = this.rocky_punch_first ? this.rocky : this.opponent;
            Boxer boxer = boxer2 = this.rocky_punch_first ? this.opponent : this.rocky;
            if (boxer1.inMiddleOfPunch()) {
                boxer2.takeHit(boxer1.getPunchX());
            } else if (boxer2.inMiddleOfPunch()) {
                boxer1.takeHit(boxer2.getPunchX());
            }
        }
        int n = this.micky != null ? 0 : (this.background_offset = this.opponent.getX() + 32 > this.getWidth() ? this.opponent.getX() + 32 - this.getWidth() : 0);
        if (160 < this.getWidth()) {
            this.background_offset = (160 - this.getWidth()) / 2;
        }
        graphics.translate(0, 45);
        this.drawBackground(graphics, pattern, this.backgroundtiles);
        graphics.translate(0, -45);
        if (this.micky != null && !Interupted) {
            this.micky.paint(graphics);
        } else {
            graphics.translate(0, 45);
            this.paintBoxers(graphics);
            graphics.translate(0, -45);
            if (this.venue == 2 || this.venue == 1) {
                if (this.rocky == null) {
                    return;
                }
                this.drawHealthBar(graphics, 5, this.rocky, true);
                this.drawHealthBar(graphics, this.getWidth() - 5, this.opponent, false);
                this.paintTimer(graphics);
            }
        }
        if (System.currentTimeMillis() - this.combo_time < this.combo_time_lag && !this.frozen) {
            if (this.venue == 0) {
                this.StopKeys = true;
            }
            Image image = null;
            int imgwidth = 0;
            int imgheight = 0;
            int imgx = 0;
            int imgy = 0;
            if (this.comboCompleted) {
                image = this.combo[0];
                imgwidth = 55;
                imgheight = 21;
                imgx = 0;
                imgy = 0;
            } else if (this.comboFailed) {
                image = this.combo[1];
                imgwidth = 65;
                imgheight = 21;
                imgx = 0;
                imgy = 0;
            } else if (this.venue != 0) {
                image = this.combo[2];
                imgwidth = 65;
                imgheight = 21;
                imgx = 0;
                imgy = 0;
            }
            int xoffset = (this.getWidth() - imgwidth) / 2;
            int yoffset = (this.getHeight() - imgheight) / 2;
            if (image != null) {
                Runtime.drawClippedImage(graphics, image, xoffset, yoffset, imgwidth, imgheight, imgx, imgy);
            }
            image = null;
        } else if (this.comboTrainer != null && this.micky == null) {
            this.comboCompleted = false;
            this.comboFailed = false;
            if (this.comboTrainer.ready()) {
                try {
                    System.out.println("1 sec waiting time");
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.comboTrainer.start();
                this.StopKeys = false;
            } else if (this.comboTrainer.isPainting()) {
                this.comboTrainer.paint(graphics, this.getWidth(), this.getHeight());
            }
        }
        if (this.comboTrainer != null) {
            int number = this.comboTrainer.getComboCount();
            int xoffset = (this.getWidth() - 11) / 2;
            int yoffset = 5;
            graphics.setColor(0);
            graphics.fillRect(xoffset - 2, yoffset - 2, 16, 12);
            graphics.setColor(0xFFFF00);
            graphics.drawRect(xoffset - 2, yoffset - 2, 16, 12);
            int tens = number / 10;
            int ones = number % 10;
            this.drawNumber(graphics, tens, xoffset, yoffset);
            this.drawNumber(graphics, ones, xoffset + 7, yoffset);
        }
        if (this.menu != null) {
            int width = this.textfont.stringWidth(this.menu[0]);
            int height = this.textfont.getSize() * this.menu.length;
            int xpos = (this.getWidth() - width) / 2;
            int ypos = (this.getHeight() - height) / 2;
            graphics.setColor(0);
            graphics.fillRect(xpos - 2, ypos - 2, width + 4, height + 4);
            graphics.setColor(0xFF0000);
            graphics.drawRect(xpos - 2, ypos - 2, width + 4, height + 4);
            for (int index = 0; index < this.menu.length; ++index) {
                graphics.setColor(index == this.selection ? 0xFFFF00 : 0xFF0000);
                graphics.drawString(this.menu[index], this.getWidth() / 2, ypos, 17);
                ypos += this.textfont.getSize();
            }
            this.endThread();
            return;
        }
        RockyRuntime.ignoreKeys = false;
        graphics.setColor(255, 30, 30);
    }

    public void showNotify() {
        if (this.thread == null) {
            this.startThread();
        }
    }

    public void hideNotify() {
        this.pause();
        this.endThread();
    }

    public synchronized void startThread() {
        this.endThread();
        Thread.yield();
        this.thread = new StopThread();
        this.thread.start();
    }

    private void endThread() {
        if (this.thread != null) {
            this.thread.endthread = true;
        }
        this.thread = null;
    }

    void startRound() {
        this.inround = true;
        ++this.round;
        if (this.round > 1) {
            this.rocky.resetHitPoints();
            this.opponent.resetHitPoints();
        }
        long duration = 61000L;
        this.round_started = System.currentTimeMillis();
        this.round_ends = System.currentTimeMillis() + duration;
        this.positionBoxers(true);
        if (this.venue != 0 && RockyRuntime.AUDIO_ENABLED && Config.playSound()) {
            RockyRuntime.playSound("bell_ring", "");
        }
    }

    public void positionBoxers(boolean startingRound) {
        if (this.venue != 0) {
            if (!this.opponent.isKnockedOut() || startingRound) {
                this.opponent.setX(96);
                this.opponent.setY(32);
                this.opponent.setMinMaxX(31, 97);
            }
            if (!this.rocky.isKnockedOut() || startingRound) {
                this.rocky.setX(32);
                this.rocky.setY(32);
                this.rocky.setMinMaxX(31, 97);
            }
        } else {
            this.rocky.setX(24);
            this.rocky.setY(64);
            this.opponent.setX(48);
            this.opponent.setY(32);
        }
    }

    void endRound() {
        this.inround = false;
        Runtime.stopPlayingSound();
        boolean bl = this.match_finished = this.match_finished && (this.rocky.isCountedOut() || this.opponent.isCountedOut()) || this.round == 5;
        if (!this.match_finished) {
            this.rocky.resetHitPoints();
            this.opponent.resetHitPoints();
            this.micky = new Micky(this, false);
            this.requestRepaint();
        } else if (this.rocky.isCountedOut() || !this.opponent.isCountedOut()) {
            this.micky = new Micky(this);
            this.requestRepaint();
        } else {
            int time = (int)((System.currentTimeMillis() - this.round_started) / 1000L);
            int whichopponent = this.opponent.getWhich();
            try {
                if (this.round < Config.getRound(whichopponent) || this.round == Config.getRound(whichopponent) && time < Config.getTime(whichopponent)) {
                    Config.addScore(this.opponent.getWhich(), this.round, time);
                }
                Config.addScore(this.opponent.getWhich(), this.round, time);
            }
            catch (Throwable error) {
                Runtime.checkIfSavable();
            }
            this.releaseAll();
            Image image = null;
            image = Runtime.loadImage("rockyvic");
            Image winnerimage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            winnerimage.getGraphics().setColor(0);
            winnerimage.getGraphics().fillRect(0, 0, winnerimage.getWidth(), winnerimage.getHeight());
            if (image != null) {
                winnerimage.getGraphics().drawImage(image, 0, 0, 20);
                image = null;
            }
            image = Runtime.loadImage("winner");
            Runtime.drawClippedImage(winnerimage.getGraphics(), image, (winnerimage.getWidth() - 69) / 2, (winnerimage.getHeight() - 21) / 2, 69, 21, 0, 0);
            image = null;
            Runtime.showScreen((Displayable)new ImageScreen(0, winnerimage, (Displayable)RockyRuntime.getMainScreen()));
            if (RockyRuntime.AUDIO_ENABLED && Config.playSound()) {
                RockyRuntime.playSound("win1", "");
            }
        }
    }

    public void threwCombo() {
        this.combo_time = System.currentTimeMillis();
    }

    public void startComboTraining() {
        this.combo_training = true;
        this.combo_train_time = System.currentTimeMillis();
    }

    public void resetComboTrainTime() {
        this.combo_train_time = System.currentTimeMillis();
    }

    public void comboCompleted() {
        this.combo_training = false;
        this.combo_time = System.currentTimeMillis();
        if (RockyRuntime.AUDIO_ENABLED && Config.playSound()) {
            RockyRuntime.playSound("positive1", "");
        }
        this.comboCompleted = true;
    }

    public void comboSuccess() {
        this.combo_training = false;
        this.comboSuccess = true;
    }

    public void comboFailed() {
        this.combo_training = false;
        this.combo_time = System.currentTimeMillis();
        if (RockyRuntime.AUDIO_ENABLED && Config.playSound()) {
            RockyRuntime.playSound("negative1", "");
        }
        this.comboFailed = true;
    }

    public void combosDone(boolean screwedup) {
        this.comboTrainer = null;
        this.micky = new Micky(this);
        this.match_finished = true;
        if (RockyRuntime.AUDIO_ENABLED && Config.playSound()) {
            RockyRuntime.playSound((screwedup ? "negative" : "positive") + "1", "");
        }
        this.requestRepaint();
    }

    private void paintBoxers(Graphics graphics) {
        this.drawBoxer(graphics, this.rocky);
        this.drawBoxer(graphics, this.opponent);
        if (this.venue == 2 || this.venue == 1) {
            for (int index = 0; index < 10; ++index) {
                for (int rope = 0; rope < 3; ++rope) {
                    int tilex = index * 16;
                    int tiley = 48 + rope * 16;
                    graphics.drawImage(this.ropes, tilex - this.background_offset, tiley, 20);
                }
            }
        }
        if (this.frozen) {
            if (this.knockout_time != 0L) {
                this.knockout_time += System.currentTimeMillis() - this.standup_checked;
                this.standup_checked = System.currentTimeMillis();
            }
            return;
        }
        if (this.rocky.isDown() || this.opponent.isDown()) {
            Boxer boxer;
            Boxer boxer2 = boxer = this.rocky.isDown() ? this.rocky : this.opponent;
            if (this.knockout_time == 0L) {
                this.standup_checked = System.currentTimeMillis();
                this.knockout_sounds = new boolean[]{false, false, false};
                this.knockout_time = System.currentTimeMillis();
            } else {
                int downtime = (int)((System.currentTimeMillis() - this.knockout_time) / 1000L);
                if (!this.match_finished && downtime > 3) {
                    this.match_finished = true;
                    boxer.setCountedOut(true);
                    this.endRound();
                } else {
                    if (downtime > 0) {
                        if (downtime > 3) {
                            downtime = 3;
                        }
                        Runtime.drawClippedImage(graphics, this.numbers, (this.getWidth() - 24) / 2, (this.getHeight() - 24) / 2, 24, 24, (downtime - 1) * 24, 0);
                        if (!this.knockout_sounds[downtime - 1]) {
                            this.knockout_sounds[downtime - 1] = true;
                            if (RockyRuntime.AUDIO_ENABLED && Config.playSound()) {
                                RockyRuntime.playSound("count_midi", "");
                            }
                        }
                    }
                    if (downtime > 0 && downtime < 3 && System.currentTimeMillis() - this.standup_checked > (long)(250 * boxer.getKnockouts())) {
                        this.standup_checked = System.currentTimeMillis();
                        if (this.random.nextInt() % 12 > 3 * boxer.getKnockouts()) {
                            boxer.getUp();
                            boxer.opponent.getUp();
                            this.positionBoxers(false);
                        }
                    }
                }
            }
        } else {
            this.knockout_time = 0L;
        }
    }

    private void paintTimer(Graphics graphics) {
        int xoffset = 5;
        int yoffset = 5;
        graphics.setColor(0);
        graphics.fillRect(xoffset - 3, yoffset - 3, 39, 16);
        graphics.setColor(0xFFFF00);
        graphics.drawRect(xoffset - 3, yoffset - 3, 39, 16);
        Runtime.drawClippedImage(graphics, this.score, xoffset, yoffset, 5, 10, 55, 0);
        Runtime.drawClippedImage(graphics, this.score, xoffset + 7, yoffset, 5, 10, 60, 0);
        Runtime.drawClippedImage(graphics, this.score, xoffset + 14, yoffset, 5, 10, 50, 0);
        int r10 = this.round / 10;
        int r1s = this.round % 10;
        Runtime.drawClippedImage(graphics, this.score, xoffset + 21, yoffset, 5, 10, 5 * r10, 0);
        Runtime.drawClippedImage(graphics, this.score, xoffset + 28, yoffset, 5, 10, 5 * r1s, 0);
        int now = !this.freezetimer ? (int)(this.round_ends - System.currentTimeMillis()) / 1000 : (int)(this.time_remaining / 1000L);
        int minutes = now / 60;
        int tensseconds = now % 60 / 10;
        int onesseconds = now % 60 - tensseconds * 10;
        xoffset = (this.getWidth() - 24) / 2;
        yoffset = 5;
        graphics.setColor(0);
        graphics.fillRect(xoffset - 3, yoffset - 3, 31, 16);
        graphics.setColor(0xFFFF00);
        graphics.drawRect(xoffset - 3, yoffset - 3, 31, 16);
        this.drawNumber(graphics, minutes, xoffset, yoffset);
        this.drawNumber(graphics, 10, xoffset + 7, yoffset);
        this.drawNumber(graphics, tensseconds, xoffset + 14, yoffset);
        this.drawNumber(graphics, onesseconds, xoffset + 21, yoffset);
    }

    private void drawNumber(Graphics graphics, int number, int xpos, int ypos) {
        Runtime.drawClippedImage(graphics, this.score, xpos, ypos, 5, 10, number * 5, 0);
    }

    private void drawHealthBar(Graphics graphics, int xpos, Boxer boxer, boolean isRocky) {
        int yoffset = this.getHeight() - (this.healthbar.getHeight() + 2);
        int length = this.healthbarlength * boxer.getHitPoints() / boxer.getMaxHitPoints();
        graphics.setColor(boxer.getHitPoints() < boxer.getMaxHitPoints() / 2 ? 0xFF0000 : 65280);
        graphics.fillRect((isRocky ? xpos : xpos - this.healthbarlength) - 1, yoffset - 1, this.healthbarlength + 2, this.healthbar.getHeight() + 2);
        Runtime.drawClippedImage(graphics, this.healthbar, isRocky ? xpos : xpos - length, yoffset, length, this.healthbar.getHeight(), 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestRepaint() {
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notify();
        }
    }

    private void createBackgroundImage(int[][] pattern, Image tiles) {
        int yoffset = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        int tileWidth = 16;
        boolean opponentset = false;
        this.background = Image.createImage((int)((pattern[0].length - 1) * tileWidth), (int)(pattern.length * tileWidth));
        Graphics graphics = this.background.getGraphics();
        for (int row = 0; row < pattern.length; ++row) {
            int xpos = 0;
            int tile = 0;
            int rowheight = -1;
            int[] rowset = pattern[row];
            boolean finished = false;
            while (!finished) {
                finished = tile >= rowset.length;
                int which = rowset[tile];
                if (which != -1) {
                    graphics.setClip(xpos, yoffset, tileWidth, tileWidth);
                    graphics.drawImage(tiles, xpos - which * tileWidth, yoffset, 20);
                    xpos += tileWidth;
                    if (rowheight == -1) {
                        rowheight = tiles.getHeight();
                    }
                    ++tile;
                    continue;
                }
                finished = true;
            }
            yoffset += rowheight;
        }
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    private void drawBackground(Graphics g, int[][] pattern, Image tiles) {
        int yoffset = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        int tileWidth = tiles.getHeight();
        boolean opponentset = false;
        for (int row = 0; row < pattern.length; ++row) {
            int tile = 0;
            int rowheight = -1;
            int[] rowset = pattern[row];
            int xpos = (width - tileWidth * (rowset.length - 1)) / 2;
            boolean finished = false;
            while (!finished) {
                finished = tile >= rowset.length;
                int which = rowset[tile];
                if (which != -1) {
                    g.setClip(xpos, yoffset, tileWidth, tileWidth);
                    g.drawImage(tiles, xpos - which * tileWidth, yoffset, 20);
                    xpos += tileWidth;
                    if (rowheight == -1) {
                        rowheight = tiles.getHeight();
                    }
                    ++tile;
                    continue;
                }
                finished = true;
            }
            yoffset += rowheight;
        }
        g.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    private void releaseAll() {
        this.healthbar = null;
        this.score = null;
        this.numbers = null;
        this.ropes = null;
        this.background = null;
        this.backgroundtiles = null;
        this.opponent = null;
        this.micky = null;
        this.rocky = null;
    }

    private void drawBoxer(Graphics graphics, Boxer boxer) {
        boxer.getCurrentFrame(!this.frozen, graphics, this.background_offset);
    }

    private void knockedOut(Boxer boxer) {
        int kocount = 0;
        switch (boxer.getWhich()) {
            case 3: 
            case 4: 
            case 5: {
                ++this.rocky_ko;
                kocount = this.rocky_ko;
                if (this.opponent.getX() >= this.rocky.getX() + 56) break;
                this.opponent.setX(this.rocky.getX() + 56);
                break;
            }
            default: {
                ++this.opponent_ko;
                kocount = this.opponent_ko;
                if (this.opponent.getX() + 72 <= this.background.getWidth()) break;
                this.opponent.setX(this.background.getWidth() - 100);
            }
        }
    }

    class StopThread
    extends Thread {
        boolean endthread = false;

        StopThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.endthread) {
                long elapsed;
                long start = System.currentTimeMillis();
                Arena.this.repaint();
                Object object = Arena.this.semaphore;
                synchronized (object) {
                    try {
                        Arena.this.semaphore.wait(75L);
                    }
                    catch (InterruptedException error) {
                        // empty catch block
                    }
                }
                switch (Arena.this.venue) {
                    case 0: {
                        if (Arena.this.frozen || !Arena.this.combo_training || System.currentTimeMillis() - Arena.this.combo_train_time <= 4000L) break;
                        Arena.this.combo_training = false;
                        Arena.this.combosDone(true);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (Arena.this.frozen || !Arena.this.inround || System.currentTimeMillis() < Arena.this.round_ends || Arena.this.match_finished) break;
                        Arena.this.endRound();
                    }
                }
                if ((elapsed = System.currentTimeMillis() - start) >= (long)Arena.this.maxSleepTime) continue;
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {}
            }
        }
    }
}

