/*
 * Decompiled with CFR 0.152.
 */
package com.anthemgames.sound;

import com.anthemgames.sound.SoundPlayer;
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class S60SoundPlayer
implements SoundPlayer {
    private Player player = null;
    Sound sound;

    public static byte[] loadData(String name) {
        byte[] res = null;
        InputStream in = Thread.currentThread().getClass().getResourceAsStream("/" + name);
        if (in != null) {
            try {
                int i;
                byte[] buf = new byte[1024];
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((i = in.read(buf)) > 0) {
                    bout.write(buf, 0, i);
                }
                res = bout.toByteArray();
                bout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return res;
    }

    public void playSound(String filename, String mimetype) {
        if (filename.indexOf("punch") != -1) {
            this.stop();
            this.sound = new Sound(S60SoundPlayer.loadData("punch.ott"), 1);
            if (this.sound != null) {
                this.sound.play(1);
            }
            return;
        }
        if (filename.indexOf("bell") != -1) {
            filename = "count_midi.mid";
        } else if (filename.indexOf(".") == -1) {
            filename = filename + ".mid";
        } else if (filename.indexOf("ott") != -1) {
            filename = filename.substring(0, filename.indexOf(".ott")) + ".mid";
        }
        try {
            if (this.player != null) {
                this.player.close();
            }
            ByteArrayInputStream bs = new ByteArrayInputStream(S60SoundPlayer.loadData(filename));
            this.player = null;
            this.player = Manager.createPlayer((InputStream)bs, (String)"audio/midi");
            bs = null;
            if (filename.indexOf("title") != -1) {
                this.player.setLoopCount(5);
            } else {
                this.player.setLoopCount(1);
            }
            if (this.player != null) {
                this.player.start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void playBackgroundSound(String filename, String mimetype) {
        this.playSound(filename, mimetype);
    }

    public void stop() {
        try {
            if (this.player != null) {
                this.player.close();
                this.player = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (this.sound != null) {
                this.sound.stop();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

