/*
 * Decompiled with CFR 0.152.
 */
package com.tinyline.tiny2d;

import com.tinyline.tiny2d.Tiny2D;
import com.tinyline.tiny2d.TinyPoint;

public final class TinyRect {
    public int xmin;
    public int ymin;
    public int xmax;
    public int ymax;

    public TinyRect() {
        this.ymax = Integer.MIN_VALUE;
        this.xmax = Integer.MIN_VALUE;
        this.ymin = Integer.MIN_VALUE;
        this.xmin = Integer.MIN_VALUE;
    }

    public TinyRect(TinyRect tinyRect) {
        this.xmin = tinyRect.xmin;
        this.ymin = tinyRect.ymin;
        this.xmax = tinyRect.xmax;
        this.ymax = tinyRect.ymax;
    }

    public TinyRect(int n, int n2, int n3, int n4) {
        int n5;
        TinyRect tinyRect;
        int n6;
        TinyRect tinyRect2;
        if (n < n3) {
            this.xmin = n;
            tinyRect2 = this;
            n6 = n3;
        } else {
            this.xmin = n3;
            tinyRect2 = this;
            n6 = tinyRect2.xmax = n;
        }
        if (n2 < n4) {
            this.ymin = n2;
            tinyRect = this;
            n5 = n4;
        } else {
            this.ymin = n4;
            tinyRect = this;
            n5 = n2;
        }
        tinyRect.ymax = n5;
    }

    public final TinyRect grow(int n, int n2) {
        return new TinyRect(this.xmin - n, this.ymin - n2, this.xmax + n, this.ymax + n2);
    }

    public final void setEmpty() {
        this.ymax = Integer.MIN_VALUE;
        this.ymin = Integer.MIN_VALUE;
        this.xmax = Integer.MIN_VALUE;
        this.xmin = Integer.MIN_VALUE;
    }

    public final void union(TinyRect tinyRect) {
        if (tinyRect != null && !tinyRect.isEmpty()) {
            if (this.isEmpty()) {
                this.xmin = tinyRect.xmin;
                this.xmax = tinyRect.xmax;
                this.ymin = tinyRect.ymin;
                this.ymax = tinyRect.ymax;
                return;
            }
            this.xmin = Tiny2D.min(this.xmin, tinyRect.xmin);
            this.xmax = Tiny2D.max(this.xmax, tinyRect.xmax);
            this.ymin = Tiny2D.min(this.ymin, tinyRect.ymin);
            this.ymax = Tiny2D.max(this.ymax, tinyRect.ymax);
        }
    }

    public final TinyRect intersection(TinyRect tinyRect) {
        int n = Tiny2D.max(this.xmin, tinyRect.xmin);
        int n2 = Tiny2D.min(this.xmax, tinyRect.xmax);
        int n3 = Tiny2D.max(this.ymin, tinyRect.ymin);
        int n4 = Tiny2D.min(this.ymax, tinyRect.ymax);
        return new TinyRect(n, n3, n2, n4);
    }

    public final void add(TinyPoint tinyPoint) {
        if (this.isEmpty()) {
            this.xmin = this.xmax = tinyPoint.x;
            this.ymin = this.ymax = tinyPoint.y;
            return;
        }
        if (tinyPoint.x < this.xmin) {
            this.xmin = tinyPoint.x;
        } else if (tinyPoint.x > this.xmax) {
            this.xmax = tinyPoint.x;
        }
        if (tinyPoint.y < this.ymin) {
            this.ymin = tinyPoint.y;
            return;
        }
        if (tinyPoint.y > this.ymax) {
            this.ymax = tinyPoint.y;
        }
    }

    public final boolean isEmpty() {
        return this.xmin == Integer.MIN_VALUE;
    }

    public final boolean contains(TinyPoint tinyPoint) {
        return this.xmin <= tinyPoint.x && tinyPoint.x <= this.xmax && this.ymin <= tinyPoint.y && tinyPoint.y <= this.ymax;
    }

    public final boolean intersects(TinyRect tinyRect) {
        return this.xmin <= tinyRect.xmax && tinyRect.xmin <= this.xmax && this.ymin <= tinyRect.ymax && tinyRect.ymin <= this.ymax;
    }
}

