/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Angle;
import game.Entity;
import game.Goal;
import game.ImageBank;
import game.SoccerCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ball
extends Entity {
    private double speed = 2.5;
    private long launchFrame;
    private boolean active = true;
    private int addScore;
    private Image timerImage;

    public Ball(SoccerCanvas canvas) {
        super(canvas);
        this.height = this.width = ImageBank.getImage("/ball/0.0.png").getWidth();
        this.timerImage = ImageBank.getImage("/time_bar.jpg");
        this.newBall();
    }

    public void think() {
        if (this.canvas.getFrame() < this.launchFrame || !this.active) {
            return;
        }
        int spd = Math.max(8 - this.canvas.getLevel() / 4, 4);
        if (this.canvas.getFrame() % (long)spd == 0L) {
            --this.addScore;
            if (this.addScore < 1) {
                this.active = false;
                this.canvas.addTimeOut();
                return;
            }
        }
        this.angle.add(this.addAngle);
        this.x += Math.cos(this.angle.getAngle()) * this.speed;
        this.y += Math.sin(this.angle.getAngle()) * this.speed;
        int dx = Math.abs((int)((double)this.canvas.getFieldMidX() - this.x));
        int dy = Math.abs((int)((double)this.canvas.getFieldMidY() - this.y));
        int r = (int)Math.sqrt(dx * dx + dy * dy);
        if ((double)r > (double)this.canvas.getFieldSize() + 0.0 * (double)this.canvas.getGoal().getGoalSize()) {
            Goal goal = this.canvas.getGoal();
            int gs = goal.getGoalSize() / 2 - 5;
            dx = Math.abs((int)(goal.getX() - this.x));
            r = (int)Math.sqrt(dx * dx + (dy = Math.abs((int)(goal.getY() - this.y))) * dy);
            if (r <= gs) {
                this.active = false;
                this.canvas.addScore(this.addScore);
            } else if (r <= gs + 9) {
                this.canvas.addPostHit();
                this.angle = new Angle(goal.getAngle().getAngle() + 1.5707963267948966 + Math.PI * this.canvas.random());
                this.addAngle = 0.0;
            } else {
                this.active = false;
                this.canvas.addMiss();
            }
        }
    }

    public int getBonus() {
        return this.addScore;
    }

    public void newBall() {
        this.speed = (double)this.canvas.getFieldSize() * (1.0 + (double)this.canvas.getLevel() * 0.05) / 40.0;
        this.addScore = 100;
        this.x = this.canvas.getFieldMidX();
        this.y = this.canvas.getFieldMidY();
        this.active = true;
        Goal goal = this.canvas.getGoal();
        do {
            this.angle = new Angle(this.canvas.random() * Math.PI * 2.0);
        } while (Math.abs(goal.getAngle().diff(this.angle)) < 0.9424777960769379 || Math.abs(goal.getAngle().diff(this.angle)) > 2.356194490192345);
        this.addAngle = 0.0;
        this.launchFrame = Math.max(this.canvas.getFrame() + 45L, this.canvas.getLevelStartFrame() + 75L);
    }

    public void paint(Graphics gr) {
        if (this.canvas.getFrame() < this.launchFrame) {
            this.drawRotatedImage(gr, "arrow", 0, 0, (int)this.x, (int)this.y, new Angle(this.angle.getAngle() + Math.PI).getAngle());
        } else if (this.active) {
            int frame = (int)this.canvas.getFrame() % 6;
            this.drawRotatedImage(gr, "ball", 0, frame, (int)this.x, (int)this.y, this.angle.getAngle());
            int x = this.canvas.getFieldMidX() - this.timerImage.getWidth() / 2;
            gr.setClip(x, 0, (int)((float)this.getBonus() / 100.0f * (float)this.timerImage.getWidth() + 1.0f), this.canvas.getHeight());
            gr.drawImage(this.timerImage, x, this.canvas.getPosY() + ImageBank.getHeaderHeight(), 20);
            gr.setClip(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        }
    }

    public void kick(double angle, double addAngle) {
        this.angle = new Angle(angle);
        this.addAngle = addAngle;
    }
}

