/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Entity;
import game.ImageBank;
import game.SoccerCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Menu
extends Entity {
    private static long menuFrame = 0L;
    protected Image menuImage;
    protected Image markerImage;
    protected int maxSelections;
    protected int curSelection = 0;
    private int selectionSize;
    private static int delay = 0;
    private boolean fireJammed = true;

    public Menu(SoccerCanvas canvas, Image menuImage, int maxSelections) {
        super(canvas);
        this.menuImage = menuImage;
        this.maxSelections = maxSelections;
        this.markerImage = ImageBank.getImage("/menu_marker.png");
        if (menuImage != null) {
            this.selectionSize = menuImage.getHeight() / maxSelections;
        }
    }

    public void think() {
        this.canvas.pause(true);
        menuFrame = this.canvas.getFrame() + 20L;
        int state = this.canvas.getKeyStates();
        if (this.fireJammed) {
            if ((state & 0x100) == 0) {
                this.fireJammed = false;
            }
        } else if (delay < 1) {
            if ((state & 2) != 0) {
                --this.curSelection;
                delay = 3;
                if (this.curSelection < 0) {
                    this.curSelection = this.maxSelections - 1;
                }
            }
            if ((state & 0x40) != 0) {
                ++this.curSelection;
                delay = 3;
                if (this.curSelection >= this.maxSelections) {
                    this.curSelection = 0;
                }
            }
            if ((state & 0x100) != 0 || (state & 0x200) != 0) {
                delay = 0;
                this.makeSelection(this.curSelection);
            }
        }
        if (delay > 0) {
            --delay;
        }
    }

    public static long getMenuFrame() {
        return menuFrame;
    }

    public void paint(Graphics gr) {
        int x = this.canvas.getWidth() / 2 - this.menuImage.getWidth() / 2;
        int y = this.canvas.getHeight() / 2 - this.menuImage.getHeight() / 2;
        gr.drawImage(this.menuImage, x, y, 0);
        gr.drawImage(this.markerImage, x - this.markerImage.getWidth() - 4, y + this.selectionSize * this.curSelection, 0);
    }

    public abstract void makeSelection(int var1);
}

