/*
 * Decompiled with CFR 0.152.
 */
package res.smarts;

import bbs.framework.game.BBSSmartGame;
import bbs.framework.library.BBSSprite;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSSmartSprite;
import game.SpaceKidGame;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Energy
extends BBSSmartSprite {
    public boolean hasGun = false;
    public boolean hasCell = false;
    public boolean hasCard = false;
    public boolean hasGear = false;
    public boolean timerOff = false;
    public static int timer;
    private String msg;
    char[] Ktimer = new char[5];

    public Energy(BBSSprite[] sprite, int sType, int color, int oid) {
        super(sprite, sType, oid);
        this.energy = 100;
        this.zorder = 2;
        this.msg = "_";
    }

    public static BBSSmartSprite create(BBSGame game, int color, int sType, int oid, int sure) {
        timer = sure;
        return new Energy(new BBSSprite[]{new BBSSprite(game, "sprites/blank.sif", 0, 0, 0, 0, 0, 0)}, sType, color, oid);
    }

    public void doAnimation(BBSSmartGame game, int time) {
        if (!this.hasGun && game.stage > 1) {
            this.hasGun = true;
        }
        int minute = 0;
        int second = 0;
        if (this.onceInMs(time, 420) && !this.timerOff) {
            --timer;
        }
        if (timer < 0) {
            game.gameState = 9;
            ((SpaceKidGame)game).win = false;
        } else {
            minute = timer / 60;
            second = timer % 60;
        }
        this.Ktimer[0] = (char)(48 + minute / 10);
        this.Ktimer[1] = (char)(48 + minute % 10);
        this.Ktimer[2] = 58;
        this.Ktimer[3] = (char)(48 + second / 10);
        this.Ktimer[4] = (char)(48 + second % 10);
        if (this.animCounter > 0 && this.onceInMs(time, 120)) {
            this.energy = Math.max(0, this.energy - 1);
            --this.animCounter;
            if (this.energy == 0) {
                this.timerOff = true;
                game.gameState = 9;
                ((SpaceKidGame)game).win = false;
            }
            if (this.animCounter == 0) {
                game.playSound("ah");
            }
            if (game.vibration && this.animCounter == 0) {
                game.vibrate(200);
            }
        }
    }

    public void trigger(String command, int[] pars) {
        if (command.equals("hit") && this.animCounter == 0) {
            this.animCounter = 10;
        }
        if (command.equals("fall")) {
            this.energy = 0;
            this.animCounter = 1;
        }
        if (command.equals("takeCard")) {
            this.hasCard = true;
        }
        if (command.equals("takeGear")) {
            this.hasGear = true;
        }
        if (command.equals("takeGun")) {
            this.hasGun = true;
        }
        if (command.equals("takePower")) {
            this.hasCell = true;
        }
        if (command.equals("launch")) {
            if (!this.hasGun) {
                this.msg = "WITHOUT A GUN YOU CANNOT SURVIVE";
            } else if (!this.hasCell) {
                this.msg = "FIND POWERCELL TO OPERATE";
            } else {
                this.timerOff = true;
            }
        }
        if (command.equals("pass")) {
            if (!this.hasGear) {
                this.msg = "UNABLE TO OPEN DOOR WITHOUT GEAR";
            } else if (!this.hasCard) {
                this.msg = "FIND ACCESS CARD TO OPERATE";
            } else {
                this.timerOff = true;
            }
        }
        if (command.equals("timerStop")) {
            this.timerOff = true;
        }
    }

    public int interract(BBSSmartGame game, BBSSmartSprite sprite, int action) {
        return 0;
    }

    public boolean draw(BBSSmartGame game, Graphics g, int spriteNo) {
        Image tGun = game.loadImage("sprites/Marty_port.png");
        g.setColor(255, 0, 0);
        g.fillRect(25, 12, 52, 5);
        g.setColor(0, 0, 0);
        g.fillRect(26 + this.energy / 2, 13, 50 - this.energy / 2, 3);
        g.drawImage(tGun, 0, 0, 20);
        int ypos = 0;
        switch (game.stage) {
            case 1: {
                tGun = this.hasGun ? game.loadImage("sprites/gun.png") : game.loadImage("sprites/gun_empty.png");
                ypos = game.w - tGun.getWidth() - 5;
                g.drawImage(tGun, ypos, 0, 20);
                tGun = this.hasCell ? game.loadImage("sprites/powercell.png") : game.loadImage("sprites/powercell_empty.png");
                ypos = ypos - tGun.getWidth() - 5;
                g.drawImage(tGun, ypos, 0, 20);
                game.drawText(g, game.w - 30, 30, null, this.Ktimer, 4, 1);
                if (this.msg.equals("_")) break;
                game.drawText(g, game.w / 2, 50, this.msg, null, 4, 1);
                this.msg = "_";
                break;
            }
            case 2: {
                tGun = this.hasCard ? game.loadImage("sprites/card.png") : game.loadImage("sprites/card_empty.png");
                ypos = game.w - tGun.getWidth() - 5;
                g.drawImage(tGun, ypos, 0, 20);
                tGun = this.hasGear ? game.loadImage("sprites/gear.png") : game.loadImage("sprites/gear_empty.png");
                ypos = ypos - tGun.getWidth() - 5;
                g.drawImage(tGun, ypos, 0, 20);
                game.drawText(g, game.w - 30, 30, null, this.Ktimer, 4, 1);
                if (this.msg.equals("_")) break;
                game.drawText(g, game.w / 2, 50, this.msg, null, 4, 1);
                this.msg = "_";
                break;
            }
            case 3: {
                game.drawText(g, game.w - 30, 30, null, this.Ktimer, 4, 1);
                if (this.msg.equals("_")) break;
                game.drawText(g, game.w / 2, 50, this.msg, null, 4, 1);
                this.msg = "_";
            }
        }
        return true;
    }
}

