/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.screens;

import com.jarbull.basket.game.MainMidlet;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class ImageShowScreen
extends Canvas
implements Runnable {
    public static final int STATE__IDLE = 0;
    public static final int STATE__WAIT = 1;
    public static final int STATE__EXIT = 2;
    private MainMidlet midlet;
    private Displayable previousDisplay;
    private Thread thread;
    private int screenCenterX;
    private int screenCenterY;
    private int state = 0;
    private Image image;
    int threadCounter = 0;

    public ImageShowScreen(MainMidlet midlet, Image image) {
        this.initialize(midlet, image);
    }

    private void initialize(MainMidlet midlet, Image image) {
        this.midlet = midlet;
        this.image = image;
        this.setFullScreenMode(true);
        this.previousDisplay = Display.getDisplay((MIDlet)midlet).getCurrent();
        this.screenCenterX = this.getWidth() / 2;
        this.screenCenterY = this.getHeight() / 2;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setNextDisplay(Displayable nextDisplay) {
        this.previousDisplay = nextDisplay;
    }

    public void show() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void waitForClose() {
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.threadCounter == 2 && this.state != 1) {
            this.state = 2;
        }
    }

    protected void paint(Graphics g) {
        g.setColor(16580781);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.image, this.screenCenterX - this.image.getWidth() / 2, this.screenCenterY - this.image.getHeight() / 2, 0);
    }

    public void run() {
        while (this.state != 2) {
            if (this.threadCounter < 2) {
                ++this.threadCounter;
            }
            this.repaint();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.image = null;
        System.gc();
    }
}

