/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import com.jarbull.basket.inGame.Ball;

public class BallAnimationHandler
implements Runnable {
    private Thread t;
    private boolean isRunning = true;
    private boolean isPaused = false;
    private long threadDelay = 100L;
    Ball ball;

    public BallAnimationHandler(Ball ball) {
        this.ball = ball;
    }

    public void run() {
        while (this.isRunning) {
            if (!this.isPaused) {
                if (Math.abs(this.ball.velocityX) >= 6.0) {
                    this.threadDelay = 60L;
                } else if (Math.abs(this.ball.velocityX) < 6.0 && Math.abs(this.ball.velocityX) >= 2.0) {
                    this.threadDelay = 80L;
                } else if (Math.abs(this.ball.velocityX) < 2.0 && Math.abs(this.ball.velocityX) >= 1.0) {
                    this.threadDelay = 100L;
                } else if (Math.abs(this.ball.velocityX) < 1.0 && Math.abs(this.ball.velocityX) > 0.2) {
                    this.threadDelay = 140L;
                }
                if (this.ball.velocityX > 0.2) {
                    this.ball.nextFrame();
                } else if (this.ball.velocityX < -0.2) {
                    this.ball.prevFrame();
                }
            }
            try {
                Thread.sleep(this.threadDelay);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void kill() {
        this.isRunning = false;
        this.ball = null;
    }

    public void pause() {
        this.isPaused = true;
    }

    public void waitForClose() {
        try {
            this.t.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

