/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.models;

import bbs.framework.helper.BBSKeys;
import bbs.framework.interfaces.BBSILoader;
import bbs.framework.models.BBSGame;
import javax.microedition.lcdui.Graphics;

public abstract class BBSLoader
implements BBSILoader {
    public int maxValue;
    protected int percentage = 0;
    protected int loadEffect;
    protected String percStr = "0";

    public BBSLoader(BBSGame game, int effect) {
        this.loadEffect = effect;
        this.initialize(game);
    }

    public void setMaxValue(int value) {
        this.maxValue = value;
    }

    public void progress(BBSGame game) {
        ++this.percentage;
        game.dState = 1;
        this.percStr = String.valueOf(100 * this.percentage / Math.max(1, this.maxValue));
        if (this.percentage >= this.maxValue && game.gameState == 3) {
            game.gameState = 4;
            System.gc();
        }
    }

    protected void freeResources(BBSGame game) {
        for (int cnt = 0; cnt < game.fontNames.length; ++cnt) {
            game.removeCache(game.fontNames[cnt]);
        }
        System.gc();
        game.gameState = 5;
        this.loaderClosed(game);
        game.stageStart();
    }

    public abstract void initialize(BBSGame var1);

    public abstract void doAnimation(BBSGame var1, int var2);

    public abstract void drawScreen(BBSGame var1, Graphics var2, int var3);

    public abstract void keyPress(BBSGame var1, BBSKeys var2, int var3);

    public abstract void loaderClosed(BBSGame var1);
}

