/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.AIComputer;
import com.eternity.castlelords.Archer;
import com.eternity.castlelords.Boss;
import com.eternity.castlelords.CLCampaignMap;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.CLLocales;
import com.eternity.castlelords.Cannon;
import com.eternity.castlelords.CommandProcessor;
import com.eternity.castlelords.GameObject;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.HitAnim;
import com.eternity.castlelords.IngameMenu;
import com.eternity.castlelords.Knight;
import com.eternity.castlelords.LogoCanvas;
import com.eternity.castlelords.Messages;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.Piker;
import com.eternity.castlelords.Rain;
import com.eternity.castlelords.Resource;
import com.eternity.castlelords.Rider;
import com.eternity.castlelords.Shot;
import com.eternity.castlelords.Spell;
import com.eternity.castlelords.Walker;
import com.eternity.castlelords.Wall;
import com.eternity.castlelords.Warlord;
import com.eternity.castlelords.WarlordsCastles;
import com.impossible.util.BCFont;
import com.impossible.util.ByteStringBuffer;
import com.impossible.util.Im;
import com.impossible.util.ImLoader;
import com.impossible.util.XCanvas;
import com.impossible.util.XClass;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class CLGameCanvas
extends XClass {
    public static GameObjects gameObjects;
    private static WarlordsCastles main;
    private Display display;
    public static int viewport;
    private int viewportSpeed = 10;
    private CLImageTracker imageTracker;
    private static Player audioplayer;
    private AIComputer computer;
    private CommandProcessor commands;
    private StringBuffer message;
    private byte[][] message_bytes;
    private InputStreamReader isr;
    Hashtable dialogs;
    private int messageDelay;
    private int statisticsDelay = 0;
    private int menuLevel;
    private static int actualMission;
    private int gamePhase = 1;
    public static int playerGameEvent;
    private int aiGameEvent = 0;
    private static long lastCHK;
    private int bossHP = 100;
    private static boolean isAlive;
    private boolean isActiveKeyboard = true;
    private boolean isActiveHelp = false;
    private boolean isAIActive = false;
    private boolean isObjectsActive = false;
    private int timeDelay = 10;
    private int playTime = 0;
    private int automaticCycles = 0;
    private int actualFocus = 1;
    private int maxActualFocus = 1;
    private int actualPosition = 0;
    private int maxPosition = 0;
    private int previousCharacter = 0;
    private int currentCharacter = 0;
    private int nextCharacter = 0;
    static ImLoader blueStronghold;
    static ImLoader redStronghold;
    static int[] strongholdFrames;
    private Sprite background;
    private Sprite info;
    private int[] blueVictims = new int[7];
    private int[] redVictims = new int[7];
    public int resourceRightBorder = 480;
    public int resourceLeftBorder = 24;
    public boolean enabledResourceFalling;
    int score = 0;
    public int status = 0;
    private int[] supportV = new int[10];
    private String missionBGText = "";
    public int navigation;
    public static final Random random;
    public static final int NORMAL_TIME_DELAY = 15;
    public static final int SPELLS_TIME_DELAY = 1;
    public static final int STATUS_INFO = 0;
    public static final int STATUS_GAME = 1;
    public static final int STATUS_HELP = 2;
    public static final int STATUS_OBJ = 3;
    public static final int MODE_CAMPAIGN = 0;
    public static final int MODE_SKIRMISH = 1;
    public static final int MODE_LOADING = 2;
    public static final int MODE_RESULTS = 3;
    public static final int MODE_ENDING = 4;
    public static final int MODE_OBJECTIVES = 5;
    public static final int MODE_WAITING = 6;
    public static final int MODE_MP_ERROR = 7;
    public static final int MODE_ETHER_LORD_DEATH = 8;
    public static int gameMode;
    public static int nextMode;
    public static final int SCREEN_WIDTH = 176;
    public static final int SCREEN_HEIGHT = 220;
    public static final int SCENE_WIDTH = 528;
    public static final int SCENE_HEIGHT = 220;
    public static final int MINIMAP_SCALE = 12;
    public static final int PLAYER_BASE_X_POSITION = 12;
    public static final int PLAYER_BASE_Y_POSITION = 213;
    public static final int COMPUTER_BASE_X_POSITION = 516;
    public static final int COMPUTER_BASE_Y_POSITION = 213;
    public static final int MENU_OFFSET_Y = 45;
    public static final int FRENCH_FLAG = 0;
    public static final int ENGLISH_FLAG = 1;
    public static final int NORMAL = 0;
    public static final int HARDCORE = 1;
    public static final int RESULT_NONE = 0;
    public static final int RESULT_VICTORY = 1;
    public static final int RESULT_DEFEAT = 2;
    private static int result;
    public static final int STANDARD_PLAY_TIME = 8800;
    public static final int COUNTDOWN_TIME = 100;
    public static final int CASTLE_POWER_STATUSBAR_SCALE = 40;
    public static final int[] BACKGROUND_SEQ;
    public static long START_GAME_TIME;
    public static long ACTUAL_GAME_TIME;
    public boolean[] menuAccess = new boolean[]{true, true, true, true, true, true};
    int actualBackground = 0;
    private boolean objectivesAlreadyShown = false;
    private int objectivesContinueType = 1;
    private static final int CONTINUE_NONE = 1;
    private static final int CONTINUE_PLAY = 2;
    IngameMenu left_menu;
    IngameMenu right_menu;
    static int PROGRESS;
    public int[] objectives = new int[25];
    public static String[] objectives_l;
    Boss boss = null;
    Boss blueBoss = null;
    int loadBlueBoss = 0;
    int loadRedBoss = 0;
    static Vector params;
    static boolean isCampaign;
    static int MAKE_STEP_WHILE_IN_MENU;
    static int ticks_till_step;
    static final byte VS_SCROLLING = 0;
    static final byte VS_EXPLOADING = 1;
    static final byte VS_BURNING = 2;
    byte victory_state;
    static byte[][] TXT_ENDING;
    static byte[][] SUBTITLE_ENDING;
    byte[] txt_ending;
    byte[][] subtitle_ending;
    int scrollTo;
    byte castleToDestroy;
    byte castleToDestroyLevel;
    static final int[][] destroySteps;
    byte destroyPosition;
    short destroyClipY;
    ImLoader explosionAnimation;
    byte explosionAnimationFrameCount;
    byte[] explosionFrameIdxS;
    short[] explosionYs;
    short[] explosionXs;
    short[] explosionOrder;
    short explosion;
    short expl1Idx;
    short expl2Idx;
    short explosionX = (short)25;
    short[] encampExplosionXs;
    short blinkTime;
    boolean blink;
    byte[][] burnDisplayOrder;
    short[][] burnDisplayX;
    short[][] burnDisplayY;
    byte[] burnFrameIdx;
    Boss bossToKill;
    static final int[] PAL_VICTORY;
    static final int[] PAL_DEFEAT;
    int flame_idx;
    int timInd;
    int offs;
    int[] pal_blue_dark;
    int[] pal_blue_light;
    int[] pal_red_dark;
    int[] pal_red_light;
    int[] pal_red;
    int[] pal_blue;
    static final int[][] power_cols;
    static final int COL_SPLITTER = 13737334;
    public static int buildings_stats_time;
    static final int BUILD_STAT_TIME = 3000;
    ByteStringBuffer gold;
    ByteStringBuffer stone;
    ByteStringBuffer mana;
    ByteStringBuffer villages;
    ByteStringBuffer mines;
    static final int COL_VICTORY = 16692264;
    static final int COL_DEFEAT = 14101248;
    static final int COL_VICT_SCROLL = 12026397;
    static final int COL_DEF_SCROLL = 10627596;
    static final int COL_RES_STROKE = 11781578;
    static final int COL_RES_WRITE = 13359066;
    static final int COL_RES_WRITE2 = -2768506;
    static final int COL_RES_WRITE3 = -331056;
    int result_offset;
    int result_padding;
    int result_offset_min;
    private int openY;
    private boolean castleImmortal;
    private int rpgCharacter;
    public static int load_max;
    public static int load_pos;
    static final int[] LOAD_STROKE_COLORS;
    static final int[] LOAD_FILL_TOPS;
    static final int[] LOAD_FILL_LENGTHS;
    static byte[][] TIP_TEXT;
    static int blinkText;
    static final byte HIT_ANIM_BLOOD = 0;
    static final byte HIT_ANIM_STONE = 1;
    static final byte HIT_ANIM_BONE = 2;
    static final byte HIT_ANIM_WOOD = 3;
    static Vector hitAnims;
    public static final byte RAIN_STONE = 0;
    public static final byte RAIN_BLOOD = 1;
    public static final byte RAIN_FIRE = 2;
    public static int DROP_MAX_SPEED;
    public static int DROP_MIN_SPEED;
    public static Rain blueRain;
    public static Rain redRain;
    static int[] spike_start_x;
    static int spikes_width;
    static short[][] spike_x;
    static short[][] spike_y;
    static short[][] spike_height;
    static short[][] spike_time;
    static boolean[][] spike_dir_up;
    static final int spike_dx = 28;
    static final int spike_dy = 26;
    static final int spike_wait_time = 300;
    static int spike_speed;
    static int[] spike_runTime;
    static int armaggedonTime;
    static int disenchantTime;
    static int disenchantInd;
    static int rainTime;
    static int[] positions;
    static int curpos;
    static boolean dir;
    static boolean hand_type;
    static int blueHandTime;
    static int redHandTime;
    static int redHandType;
    static int blueHandType;
    static int quakeTime;
    static int lastQuakeX;
    static int quakeDifferenceX;
    static boolean quakeLeft;
    static int quakeSpeed;
    static final int MAX_QUAKE_MOVE_X = 20;
    static final int QUAKE_RADIUS_X = 1;
    static final int QUAKE_MIN_MOVE = 2;
    static final int QUAKE_MAX_MOVE = 13;
    static final int QUAKE_SPEED = 1;
    static int quakeAcc;
    static int quakeDecc;
    static int time34;
    static int qTime;
    int scriptIp;
    boolean scriptLoop;
    boolean nextInstruction;
    DyingAnim lastExplosion;
    int ethExplIndex;
    static final int[] exX;
    static final int[] exY;
    int sinkClip;
    int bossY;
    boolean redEffect;

    static {
        viewport = 0;
        actualMission = 0;
        playerGameEvent = 0;
        lastCHK = 0L;
        isAlive = true;
        strongholdFrames = new int[2];
        random = new Random();
        gameMode = 0;
        result = 0;
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        BACKGROUND_SEQ = nArray;
        objectives_l = new String[]{"Gather X gold", "Gather X stone", "Gather X mana", "Build X hamlets", "Build X mines", "Build X shrines", "Build castle defence", "7", "8", "9", "Defend for X seconds", "Defeat the enemy!", "Train level X Y1", "Train level X Y2", "Train level X Y3", "Train level X Y4", "Train level X Y5", "Recruit X Y1", "Recruit X Y2", "Recruit X Y3", "Recruit X Y4", "Recruit X Y5", "Weaken the enemy", "Survive all attacks"};
        MAKE_STEP_WHILE_IN_MENU = 5;
        TXT_ENDING = new byte[][]{GameObjects.convertToByteString("Victory", false), GameObjects.convertToByteString("Defeat", false)};
        SUBTITLE_ENDING = new byte[][]{GameObjects.convertToByteString("You have vanquished the enemy", false), GameObjects.convertToByteString("You were vanquished", false)};
        destroySteps = new int[][]{{84, 35, 76, 14}, {35, 30, 30, 30}, {25, 30, 30, 30, 30}};
        PAL_VICTORY = new int[]{0xFFFFFF, -84952, -347865, -544985, -939226, -1465051, -2122205, -3042271, -4159458, -5473765, -7116777, -8956909, -11257075, -13819897, -16777216};
        PAL_DEFEAT = new int[]{0xFFFFFF, -709888, -841216, -1037824, -1431296, -1890560, -2546176, -3464448, -4513536, -5759744, -7399168, -9235456, -11465216, -13891584, -16777216};
        power_cols = new int[][]{{2132735, 27876}, {16122368, 11341064}};
        buildings_stats_time = 0;
        LOAD_STROKE_COLORS = new int[]{7625778, 10585939, 15257718, 12686};
        LOAD_FILL_TOPS = new int[]{44, 110, 188};
        LOAD_FILL_LENGTHS = new int[]{-44, 96, 66};
        blueRain = null;
        redRain = null;
        spike_start_x = new int[2];
        spikes_width = 150;
        spike_runTime = new int[2];
        armaggedonTime = 0;
        disenchantTime = 0;
        disenchantInd = 0;
        rainTime = 0;
        positions = new int[]{1, 2, 3, 4, 5, 4, 3, 2, 1};
        curpos = 0;
        dir = true;
        hand_type = false;
        blueHandTime = 0;
        redHandTime = 0;
        redHandType = 0;
        blueHandType = 0;
        quakeTime = 0;
        lastQuakeX = 0;
        quakeDifferenceX = 0;
        quakeLeft = true;
        quakeSpeed = 1;
        qTime = 0;
        exX = new int[]{135, 85, 112, 90, 117, 86, 105, 127, 123, 101, 120, 140, 157, 100, 124, 150, 177};
        exY = new int[]{150, 137, 130, 122, 115, 104, 105, 104, 82, 70, 65, 62, 67, 40, 36, 42, 35};
    }

    public CLGameCanvas(XCanvas canvas, WarlordsCastles main, Display display, CLImageTracker tracker) {
        super(canvas);
        short[] sArray = new short[4];
        sArray[0] = 11;
        sArray[2] = -37;
        sArray[3] = -37;
        this.encampExplosionXs = sArray;
        byte[][] byArrayArray = new byte[3][];
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[1] = 2;
        byArray2[3] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[5];
        byArray3[1] = 2;
        byArray3[3] = 1;
        byArrayArray[2] = byArray3;
        this.burnDisplayOrder = byArrayArray;
        short[][] sArrayArray = new short[3][];
        short[] sArray2 = new short[3];
        sArray2[0] = 10;
        sArray2[2] = -5;
        sArrayArray[0] = sArray2;
        short[] sArray3 = new short[5];
        sArray3[0] = -10;
        sArray3[2] = -25;
        sArray3[4] = -30;
        sArrayArray[1] = sArray3;
        short[] sArray4 = new short[5];
        sArray4[1] = 2;
        sArray4[2] = -20;
        sArray4[4] = -25;
        sArrayArray[2] = sArray4;
        this.burnDisplayX = sArrayArray;
        short[][] sArrayArray2 = new short[3][];
        short[] sArray5 = new short[3];
        sArray5[0] = -20;
        sArray5[2] = -45;
        sArrayArray2[0] = sArray5;
        short[] sArray6 = new short[5];
        sArray6[0] = -18;
        sArray6[1] = -13;
        sArray6[2] = -13;
        sArray6[4] = -3;
        sArrayArray2[1] = sArray6;
        short[] sArray7 = new short[5];
        sArray7[0] = -27;
        sArray7[1] = -10;
        sArray7[2] = -15;
        sArray7[4] = -5;
        sArrayArray2[2] = sArray7;
        this.burnDisplayY = sArrayArray2;
        this.timInd = 0;
        this.offs = 0;
        this.pal_blue_dark = new int[]{0xFFFFFF, 262, 399979, 667029, 1334983, 2905780, 6582427, 2919385, 4625114, 6458834, 6988767, 5354728, 8042471, 7391470, 9098738, 11396343};
        this.pal_blue_light = new int[]{0xFFFFFF, 400727, 1728485, 2724087, 5102333, 9359868, 14674168, 9368830, 12515070, 14611966, 15006462, 0xCCFCFF, 15596798, 15269375, 0xF4FEFF, 0xFBFEFF};
        this.pal_red_dark = new int[]{0xFFFFFF, 720896, 5441025, 0x811000, 11738368, 11739648, 12601609, 12602123, 13131537, 13330967, 13726749, 13331224, 13993258, 13992490, 14457403, 15121500};
        this.pal_red_light = new int[]{0xFFFFFF, 6227458, 13507076, 15810560, 16541952, 16545280, 16630309, 16631077, 16636739, 16639062, 16706153, 16639321, 16708234, 16707978, 16709804, 16710872};
        this.pal_red = new int[]{0xFFFFFF, -51638, -711110, -52410, -119230, -1172946, -1243619, -2031338, -3276782, -4784115, -6488055, -8192000, -10092544, -12189696, -16771320, -1};
        this.pal_blue = new int[]{0xFFFFFF, -13658370, -13790474, -13857299, -14056225, -14255153, -14454595, -14653265, -14852964, -15118201, -15383952, -15715497, -16047044, -16379361, -16777216, -1};
        this.openY = 0;
        this.castleImmortal = false;
        this.rpgCharacter = 0;
        this.display = display;
        this.timeDelay = 15;
        CLGameCanvas.main = main;
        this.message = new StringBuffer();
        this.commands = new CommandProcessor();
        this.navigation = 0;
        gameObjects = new GameObjects();
        this.computer = new AIComputer(this, gameObjects);
        this.status = 0;
        try {
            this.imageTracker = tracker;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.gold = new ByteStringBuffer();
        this.stone = new ByteStringBuffer();
        this.mana = new ByteStringBuffer();
        this.villages = new ByteStringBuffer();
        this.mines = new ByteStringBuffer();
    }

    static int getMenuY() {
        int menu_y = CLImageTracker.small_icons.getHeight() + CLImageTracker.box[0].getHeight() - 4;
        Font f = Font.getFont((int)0, (int)0, (int)8);
        return menu_y += 6 + 2 * CLImageTracker.box[0].getHeight() - 8;
    }

    public void start() {
        isAlive = true;
        this.left_menu = new IngameMenu(gameObjects, this, -6);
        this.right_menu = new IngameMenu(gameObjects, this, -7);
        this.left_menu.active = false;
        this.right_menu.active = false;
        result = 0;
        hitAnims = new Vector();
        redRain = null;
        blueRain = null;
        CLGameCanvas.spike_runTime[0] = 0;
        CLGameCanvas.spike_runTime[1] = 0;
        buildings_stats_time = 0;
    }

    public static long checkoutTime() {
        ACTUAL_GAME_TIME = System.currentTimeMillis() / 1000L - START_GAME_TIME;
        return ACTUAL_GAME_TIME;
    }

    public void initGameStats() {
        this.score = 0;
        viewport = 0;
        int i = 0;
        while (i < this.blueVictims.length) {
            this.blueVictims[i] = 0;
            this.redVictims[i] = 0;
            ++i;
        }
        this.actualBackground = CLGameCanvas.random(3);
    }

    static int random(int size) {
        int temp = 0;
        if (size == 0) {
            return 0;
        }
        temp = (random.nextInt() & Integer.MAX_VALUE) % size;
        return temp;
    }

    public void initRandomGame(int raceLeft, int raceRight, int charisma, int intelligence, int morality, int wizardTypeBlue, int charismaRed, int intelligenceRed, int moralityRed, int wizardTypeRed, boolean playerIsBlue, boolean load) {
        PROGRESS = 0;
        params = new Vector();
        params.addElement(new Integer(raceLeft));
        params.addElement(new Integer(raceRight));
        params.addElement(new Integer(charisma));
        params.addElement(new Integer(intelligence));
        params.addElement(new Integer(morality));
        params.addElement(new Integer(wizardTypeBlue));
        params.addElement(new Integer(charismaRed));
        params.addElement(new Integer(intelligenceRed));
        params.addElement(new Integer(moralityRed));
        params.addElement(new Integer(wizardTypeRed));
        params.addElement(new Boolean(playerIsBlue));
        gameMode = 2;
        isCampaign = false;
        this.clearObjectives();
        this.addObjective("n");
        CLGameCanvas.initLoading(true);
        ++PROGRESS;
        gameObjects.getLiveObjects().removeAllElements();
        gameObjects.getSpells().removeAllElements();
        ++PROGRESS;
        gameObjects.initGameObjects(LogoCanvas.getSkirmishDifficulty(), false);
        CLGameCanvas.gameObjects.blueWarlord.race = raceLeft;
        CLGameCanvas.gameObjects.blueWarlord.initUnitsCharacteristics(raceLeft);
        CLGameCanvas.gameObjects.redWarlord.race = raceRight;
        ++PROGRESS;
        CLGameCanvas.gameObjects.redWarlord.initUnitsCharacteristics(raceRight);
        CLGameCanvas.gameObjects.blueWarlord.setWarlord(charisma, morality, intelligence, wizardTypeBlue);
        CLGameCanvas.gameObjects.blueWarlord.level = 20 - (LogoCanvas.getSkirmishDifficulty() + 1) * 4;
        ++PROGRESS;
        CLGameCanvas.gameObjects.redWarlord.setWarlord(charismaRed, moralityRed, intelligenceRed, wizardTypeRed);
        CLGameCanvas.gameObjects.redWarlord.generateWarlordCharacteristics(GameObjects.SKIRMISH_TOTAL_WPOINTS + LogoCanvas.getSkirmishDifficulty());
        CLGameCanvas.gameObjects.blueWarlord.level = (LogoCanvas.getSkirmishDifficulty() + 2) * 4;
        ++PROGRESS;
        CLGameCanvas.gameObjects.blueWarlord.lastWalkerXPosition = 12;
        CLGameCanvas.gameObjects.redWarlord.lastWalkerXPosition = 516;
        CLGameCanvas.gameObjects.flyingTexts.removeAllElements();
        ++PROGRESS;
        this.computer.setBattleNumber(0);
        actualMission = 0;
        ++PROGRESS;
        this.enabledResourceFalling = LogoCanvas.getDropsSetting() == 1;
        ++PROGRESS;
        this.computer.resetStrategies();
        ++PROGRESS;
        if (load) {
            this.imageTracker.resetMenu(false);
            ImLoader.initLoad();
            ImLoader.setLoadListener(this);
            ImLoader.LOAD_MODE = 0;
            this.imageTracker.loadGame(CLGameCanvas.gameObjects.blueWarlord.race, CLGameCanvas.gameObjects.redWarlord.race, 0, 0, -1, playerIsBlue);
            ImLoader.LOAD_MODE = 1;
            this.imageTracker.loadGame(CLGameCanvas.gameObjects.blueWarlord.race, CLGameCanvas.gameObjects.redWarlord.race, 0, 0, -1, playerIsBlue);
            ImLoader.LOAD_MODE = (byte)2;
        }
        ++PROGRESS;
        this.initGameStats();
        ++PROGRESS;
        this.menuLevel = 1;
        this.commands.clearBuffer();
        this.actualFocus = 1;
        result = 0;
        START_GAME_TIME = System.currentTimeMillis() / 1000L;
        ++PROGRESS;
        this.isAIActive = true;
        MAKE_STEP_WHILE_IN_MENU = 5;
        if (LogoCanvas.getSkirmishDifficulty() >= 0) {
            CLGameCanvas.gameObjects.redWarlord.createUnit(0, true);
        }
        if (LogoCanvas.getSkirmishDifficulty() >= 1) {
            CLGameCanvas.gameObjects.redWarlord.createUnit(1, true);
        }
        if (LogoCanvas.getSkirmishDifficulty() >= 2) {
            CLGameCanvas.gameObjects.redWarlord.createUnit(3, true);
        }
        CLGameCanvas.gameObjects.level = 5;
        blueStronghold = this.setupStronghold(CLGameCanvas.gameObjects.blueWarlord.castleLevel);
        redStronghold = this.setupStronghold(CLGameCanvas.gameObjects.redWarlord.castleLevel);
        this.statisticsDelay = 0;
        this.isActiveHelp = false;
        if (LogoCanvas.getSoundSetting() == 1) {
            this.playMusic();
        }
        this.resourceRightBorder = 480;
        this.boss = null;
        this.blueBoss = null;
        this.start();
        nextMode = 1;
        this.generalInit(playerIsBlue);
        this.isActiveKeyboard = true;
        this.isObjectsActive = true;
        this.isAIActive = true;
        IngameMenu.killFixedCommands();
    }

    public void generalInit(boolean playerIsBlue) {
        if (playerIsBlue) {
            CLGameCanvas.gameObjects.playerW = CLGameCanvas.gameObjects.blueWarlord;
            CLGameCanvas.gameObjects.enemyW = CLGameCanvas.gameObjects.redWarlord;
        } else {
            CLGameCanvas.gameObjects.playerW = CLGameCanvas.gameObjects.redWarlord;
            CLGameCanvas.gameObjects.enemyW = CLGameCanvas.gameObjects.blueWarlord;
            viewport = 528 - XCanvas.WIDTH;
        }
        CLLocales.updateSpellDescriptions(Math.min(CLGameCanvas.gameObjects.playerW.intelligence, 15));
    }

    void clearObjectives() {
        int i = 0;
        while (i < this.objectives.length) {
            this.objectives[i] = 0;
            ++i;
        }
    }

    void addObjective(String ss) {
        int p1 = ss.indexOf("<") + 1;
        int p2 = ss.indexOf(">");
        int p3 = ss.indexOf(",");
        switch (ss.charAt(0)) {
            case 'n': {
                this.objectives[11] = 1;
                System.out.println("Standard victory condition");
                break;
            }
            case 'w': {
                String s = ss.substring(p1, p3);
                int v = Integer.parseInt(ss.substring(p3 + 1, p2));
                if (s.compareTo("red") == 0) {
                    this.objectives[22] = v;
                }
                if (s.compareTo("blue") != 0) break;
                this.objectives[23] = v;
                break;
            }
            case 'g': {
                String s = ss.substring(p1, p3);
                int v = Integer.parseInt(ss.substring(p3 + 1, p2));
                if (s.compareTo("gold") == 0) {
                    this.objectives[0] = v;
                    break;
                }
                if (s.compareTo("stone") == 0) {
                    this.objectives[1] = v;
                    break;
                }
                if (s.compareTo("mana") != 0) break;
                this.objectives[2] = v;
                break;
            }
            case 'b': {
                String s = ss.substring(p1, p3);
                int v = Integer.parseInt(ss.substring(p3 + 1, p2));
                if (s.compareTo("hamlet") == 0) {
                    this.objectives[3] = v;
                    break;
                }
                if (s.compareTo("mine") == 0) {
                    this.objectives[4] = v;
                    break;
                }
                if (s.compareTo("shrines") == 0) {
                    this.objectives[5] = v;
                    break;
                }
                if (s.compareTo("castledef") != 0) break;
                this.objectives[6] = v;
                break;
            }
            case 'd': {
                this.objectives[10] = Integer.parseInt(ss.substring(p1, p2));
                break;
            }
            case 't': {
                String s = ss.substring(p1, p3);
                int v = Integer.parseInt(ss.substring(p3 + 1, p2));
                if (s.compareTo("u1") == 0) {
                    this.objectives[12] = v;
                    break;
                }
                if (s.compareTo("u2") == 0) {
                    this.objectives[13] = v;
                    break;
                }
                if (s.compareTo("u3") == 0) {
                    this.objectives[14] = v;
                    break;
                }
                if (s.compareTo("u4") == 0) {
                    this.objectives[15] = v;
                    break;
                }
                if (s.compareTo("u5") != 0) break;
                this.objectives[16] = v;
                break;
            }
            case 'r': {
                String s = ss.substring(p1, p3);
                int v = Integer.parseInt(ss.substring(p3 + 1, p2));
                if (s.compareTo("u1") == 0) {
                    this.objectives[17] = v;
                    break;
                }
                if (s.compareTo("u2") == 0) {
                    this.objectives[18] = v;
                    break;
                }
                if (s.compareTo("u3") == 0) {
                    this.objectives[19] = v;
                    break;
                }
                if (s.compareTo("u4") == 0) {
                    this.objectives[20] = v;
                    break;
                }
                if (s.compareTo("u5") != 0) break;
                this.objectives[21] = v;
            }
        }
    }

    public void restartCampaign() {
        int missionNumber = (Integer)params.elementAt(0);
        if (CLGameCanvas.main.cmap.activeMission >= 17) {
            missionNumber = CLGameCanvas.main.cmap.activeMission;
        }
        Warlord blueW = (Warlord)params.elementAt(1);
        String techtree = (String)params.elementAt(2);
        String objectives = (String)params.elementAt(3);
        String techtreeRed = (String)params.elementAt(4);
        int redSupremacy = (Integer)params.elementAt(5);
        this.initCampaign(missionNumber, blueW, techtree, objectives, techtreeRed, false, redSupremacy);
    }

    public void restartSkirmish() {
        int raceLeft = (Integer)params.elementAt(0);
        int raceRight = (Integer)params.elementAt(1);
        int charisma = (Integer)params.elementAt(2);
        int intelligence = (Integer)params.elementAt(3);
        int morality = (Integer)params.elementAt(4);
        int wizardTypeBlue = (Integer)params.elementAt(5);
        int charismaRed = (Integer)params.elementAt(6);
        int intelligenceRed = (Integer)params.elementAt(7);
        int moralityRed = (Integer)params.elementAt(8);
        int wizardTypeRed = (Integer)params.elementAt(9);
        boolean playerIsBlue = (Boolean)params.elementAt(10);
        this.initRandomGame(raceLeft, raceRight, charisma, intelligence, morality, wizardTypeBlue, charismaRed, intelligenceRed, moralityRed, wizardTypeRed, playerIsBlue, false);
    }

    public void initCampaign(int missionNumber, Warlord blueW, String techtree, String objectives, String techtreeRed, boolean load, int redSupremacy) {
        gameMode = 2;
        isCampaign = true;
        CLGameCanvas.initLoading(true);
        params = new Vector();
        params.addElement(new Integer(missionNumber));
        params.addElement(blueW);
        params.addElement(techtree);
        params.addElement(objectives);
        params.addElement(techtreeRed);
        params.addElement(new Integer(redSupremacy));
        int actual_mission = 0;
        if (missionNumber > 17) {
            actual_mission = missionNumber;
            missionNumber = 1;
        }
        gameObjects.getLiveObjects().removeAllElements();
        gameObjects.getSpells().removeAllElements();
        CLGameCanvas.gameObjects.blueWarlord = blueW;
        gameObjects.initGameObjects(missionNumber, true);
        this.missionBGText = "";
        System.out.println("Mission: " + missionNumber);
        CLGameCanvas.gameObjects.blueWarlord.race = GameObjects.MISSION_PLAYER_RACES[missionNumber - 1];
        CLGameCanvas.gameObjects.blueWarlord.initUnitsCharacteristics(CLGameCanvas.gameObjects.blueWarlord.race);
        CLGameCanvas.gameObjects.redWarlord.race = GameObjects.MISSION_AI_RACES[missionNumber - 1];
        CLGameCanvas.gameObjects.redWarlord.initUnitsCharacteristics(CLGameCanvas.gameObjects.redWarlord.race);
        CLGameCanvas.gameObjects.redWarlord.level = GameObjects.MISSION_LEVEL_PROGRESS[missionNumber - 1];
        CLGameCanvas.gameObjects.redWarlord.intelligence = GameObjects.MISSION_IQ_PROGRESS[missionNumber - 1];
        CLGameCanvas.gameObjects.redWarlord.charisma = GameObjects.MISSION_CHARISMA_PROGRESS[missionNumber - 1];
        CLGameCanvas.gameObjects.redWarlord.morality = GameObjects.MISSION_MORALE_PROGRESS[missionNumber - 1];
        CLGameCanvas.gameObjects.redWarlord.supremacy = redSupremacy;
        CLGameCanvas.gameObjects.blueWarlord.lastWalkerXPosition = 12;
        CLGameCanvas.gameObjects.redWarlord.lastWalkerXPosition = 516;
        String[] tt = new String[15];
        System.out.println(objectives);
        objectives = String.valueOf(objectives) + ";";
        int lastc = 0;
        int cnt = 0;
        this.clearObjectives();
        int i = 0;
        while (i < objectives.length()) {
            if (objectives.charAt(i) == ';') {
                tt[cnt] = objectives.substring(lastc, i);
                this.addObjective(tt[cnt]);
                ++cnt;
                lastc = i + 1;
            }
            ++i;
        }
        CLGameCanvas.gameObjects.flyingTexts.removeAllElements();
        this.computer.setBattleNumber(missionNumber);
        if (actual_mission == 0) {
            actualMission = missionNumber;
            ((Object)((Object)main)).getClass();
            CLCampaignMap.skippable = true;
        } else {
            actualMission = actual_mission;
            ((Object)((Object)main)).getClass();
            CLCampaignMap.skippable = false;
        }
        START_GAME_TIME = System.currentTimeMillis() / 1000L;
        i = 0;
        while (i < 5) {
            CLGameCanvas.gameObjects.redWarlord.tt_unit_max_levels[i] = Integer.parseInt(techtreeRed.substring(i, i + 1));
            CLGameCanvas.gameObjects.blueWarlord.tt_unit_max_levels[i] = Integer.parseInt(techtree.substring(i, i + 1));
            ++i;
        }
        i = 0;
        while (i < 7) {
            CLGameCanvas.gameObjects.redWarlord.tt_buildings[i] = Integer.parseInt(techtreeRed.substring(5 + i, 6 + i)) == 1;
            CLGameCanvas.gameObjects.blueWarlord.tt_buildings[i] = Integer.parseInt(techtree.substring(5 + i, 6 + i)) == 1;
            ++i;
        }
        i = 0;
        while (i < 4) {
            CLGameCanvas.gameObjects.redWarlord.tt_actions[i] = Integer.parseInt(techtreeRed.substring(12 + i, 13 + i)) == 1;
            CLGameCanvas.gameObjects.blueWarlord.tt_actions[i] = Integer.parseInt(techtree.substring(12 + i, 13 + i)) == 1;
            ++i;
        }
        this.enabledResourceFalling = CLCampaignMap.selMission[8].substring(1, 2).equals("1");
        if (this.enabledResourceFalling) {
            this.resourceRightBorder = 240;
        }
        this.computer.resetStrategies();
        if (load) {
            this.imageTracker.resetMenu(true);
        }
        int bg_idx = 0;
        this.loadBlueBoss = 0;
        this.loadRedBoss = 0;
        try {
            bg_idx = Integer.parseInt(CLCampaignMap.selMission[8].substring(0, 1));
            if (CLCampaignMap.selMission.length >= 10) {
                this.loadBlueBoss = Integer.parseInt(CLCampaignMap.selMission[9].substring(0, 1));
                this.loadRedBoss = Integer.parseInt(CLCampaignMap.selMission[9].substring(1, 2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (load) {
            ImLoader.initLoad();
            XCanvas.DONT_PROCESS_BUFFER = 1;
            ImLoader.setLoadListener(this);
            ImLoader.LOAD_MODE = 0;
            this.imageTracker.loadGame(CLGameCanvas.gameObjects.blueWarlord.race, CLGameCanvas.gameObjects.redWarlord.race, this.loadBlueBoss, this.loadRedBoss, bg_idx, true);
            ImLoader.LOAD_MODE = 1;
            this.imageTracker.loadGame(CLGameCanvas.gameObjects.blueWarlord.race, CLGameCanvas.gameObjects.redWarlord.race, this.loadBlueBoss, this.loadRedBoss, bg_idx, true);
            ImLoader.LOAD_MODE = (byte)2;
        }
        this.initGameStats();
        this.menuLevel = 1;
        this.commands.clearBuffer();
        this.actualFocus = 1;
        result = 0;
        START_GAME_TIME = System.currentTimeMillis() / 1000L;
        this.gamePhase = 1;
        this.isAIActive = true;
        MAKE_STEP_WHILE_IN_MENU = 5;
        isAlive = true;
        this.statisticsDelay = 0;
        this.isActiveHelp = false;
        this.isActiveKeyboard = true;
        this.isObjectsActive = true;
        ((Object)((Object)main)).getClass();
        CLCampaignMap.triggerNext = false;
        CLGameCanvas.gameObjects.level = 5;
        blueStronghold = this.setupStronghold(CLGameCanvas.gameObjects.blueWarlord.castleLevel);
        redStronghold = this.setupStronghold(CLGameCanvas.gameObjects.redWarlord.castleLevel);
        this.playTime = CLGameCanvas.gameObjects.questType == 1 ? 8800 : 0;
        this.blueBoss = null;
        this.boss = null;
        if (CLGameCanvas.gameObjects.questType == 4) {
            CLGameCanvas.gameObjects.isBossAlive[1] = true;
            this.boss = new Boss(this.loadRedBoss, false, gameObjects, this.imageTracker);
            gameObjects.addLiveObject(this.boss);
            redStronghold = null;
            if (this.loadBlueBoss != 0) {
                CLGameCanvas.gameObjects.isBossAlive[0] = true;
                this.blueBoss = new Boss(this.loadBlueBoss, true, gameObjects, this.imageTracker);
                gameObjects.addLiveObject(this.blueBoss);
                blueStronghold = null;
            }
        } else {
            this.boss = null;
        }
        if (LogoCanvas.getSoundSetting() == 1) {
            this.playMusic();
        }
        this.isObjectsActive = false;
        this.start();
        nextMode = 0;
        this.status = 0;
        ((Object)((Object)main)).getClass();
        ((Object)((Object)main)).getClass();
        CLCampaignMap.DIALOG_TYPE = (byte)2;
        this.objectivesAlreadyShown = false;
        this.openY = 0;
        CLGameCanvas.main.cmap.txtIndex = 0;
        CLGameCanvas.main.cmap.nextCh = -1;
        CLGameCanvas.main.cmap.updateText();
        this.generalInit(true);
    }

    public void tick() {
        if (gameMode == 0 || gameMode == 1) {
            if (result == 0 && (result = this.testQuestResult(CLGameCanvas.gameObjects.questType)) != 0) {
                this.startVictoryDefeatState();
            }
            if (gameMode != 4) {
                if (!this.left_menu.active && !this.right_menu.active) {
                    if (ticks_till_step == 0) {
                        ticks_till_step = 1;
                    }
                } else {
                    if (this.left_menu.active) {
                        this.left_menu.updateMenu();
                    }
                    if (ticks_till_step == 0) {
                        ticks_till_step = MAKE_STEP_WHILE_IN_MENU;
                    }
                }
                --ticks_till_step;
                this.right_menu.updateMenu();
                if (buildings_stats_time > 0) {
                    --buildings_stats_time;
                }
                if (ticks_till_step == 0 && this.navigation == 0 && this.menuLevel == 1) {
                    if (this.status == 1 && this.isAIActive) {
                        this.computer.doTurn();
                    }
                    if (!(gameMode != 1 && gameMode != 0 || !this.isObjectsActive && gameMode != 1)) {
                        this.doStepOverObjects();
                        this.tickGameObjects();
                        this.performSpells();
                        this.testObjectsForLife();
                        gameObjects.doTurn();
                        gameObjects.moveFlyingTexts();
                        if (this.enabledResourceFalling) {
                            this.addResource(1);
                        }
                        if (blueRain != null) {
                            blueRain.runRain();
                            if (blueRain.isOver()) {
                                blueRain = null;
                            }
                        }
                        if (redRain != null) {
                            redRain.runRain();
                            if (redRain.isOver()) {
                                redRain = null;
                            }
                        }
                        if (!CLGameCanvas.isSpikeOver(0)) {
                            CLGameCanvas.runSpikes();
                        } else if (!CLGameCanvas.isSpikeOver(1)) {
                            CLGameCanvas.runSpikes();
                        }
                        CLGameCanvas.runEarthQuake();
                    }
                }
            }
        } else if (gameMode == 4) {
            this.doStepOverObjects();
            this.tickGameObjects();
            this.testObjectsForLife();
            gameObjects.moveFlyingTexts();
            this.runVictoryDefeat();
        }
        if (gameMode == 2 && load_pos == load_max && ++blinkText == 8) {
            blinkText = 0;
        }
    }

    void tickGameObjects() {
        int i = 0;
        while (i < gameObjects.getLiveObjects().size()) {
            GameObject temp = (GameObject)((Object)gameObjects.getLiveObjects().elementAt(i));
            if (ticks_till_step == 0 && !(temp instanceof Archer) && temp.moved) {
                temp.nextFrame();
            }
            ++i;
        }
    }

    public void tickAfter() {
        if (gameMode == 1 || gameMode == 0 || gameMode == 4) {
            int i = 0;
            while (i < CLGameCanvas.gameObjects.dyingAnims.size()) {
                DyingAnim temp = (DyingAnim)CLGameCanvas.gameObjects.dyingAnims.elementAt(i);
                if (ticks_till_step == 0) {
                    --temp.showTime;
                    temp.nextFrame();
                    if (temp.showTime < 1) {
                        CLGameCanvas.gameObjects.dyingAnims.removeElementAt(i);
                    }
                }
                ++i;
            }
            CLGameCanvas.runHitAnims();
        }
    }

    void checkObjectives() {
        boolean allClear = true;
        if (this.objectives[0] > 0) {
            if (CLGameCanvas.gameObjects.blueWarlord.money < this.objectives[0]) {
                allClear = false;
            } else {
                this.objectives[0] = -this.objectives[0];
                gameMode = 5;
            }
        }
        if (this.objectives[1] > 0) {
            if (CLGameCanvas.gameObjects.blueWarlord.stones < this.objectives[1]) {
                allClear = false;
            } else {
                this.objectives[1] = -this.objectives[1];
                gameMode = 5;
            }
        }
        if (this.objectives[2] > 0) {
            if (CLGameCanvas.gameObjects.blueWarlord.mana < this.objectives[2]) {
                allClear = false;
            } else {
                this.objectives[2] = -this.objectives[2];
                gameMode = 5;
            }
        }
        if (this.objectives[3] > 0) {
            if (CLGameCanvas.gameObjects.blueWarlord.villages < this.objectives[3] + 1) {
                allClear = false;
            } else {
                this.objectives[3] = -this.objectives[3];
                gameMode = 5;
            }
        }
        if (this.objectives[4] > 0) {
            if (CLGameCanvas.gameObjects.blueWarlord.mines < this.objectives[4]) {
                allClear = false;
            } else {
                this.objectives[4] = -this.objectives[4];
                gameMode = 5;
            }
        }
        if (this.objectives[5] > 0) {
            if (CLGameCanvas.gameObjects.blueWarlord.shrines < this.objectives[5]) {
                allClear = false;
            } else {
                this.objectives[5] = -this.objectives[5];
                gameMode = 5;
            }
        }
        if (this.objectives[6] > 0) {
            if (CLGameCanvas.gameObjects.blueWarlord.wall_state == this.objectives[6]) {
                allClear = false;
            } else {
                this.objectives[6] = -this.objectives[6];
                gameMode = 5;
            }
        }
        if (this.objectives[11] > 0) {
            allClear = false;
        }
        int i = 0;
        while (i < 5) {
            if (this.objectives[12 + i] > 0) {
                if (CLGameCanvas.gameObjects.blueWarlord.unitsLevel[i] < this.objectives[12 + i]) {
                    allClear = false;
                } else {
                    this.objectives[12 + i] = -this.objectives[12 + i];
                    gameMode = 5;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 5) {
            if (this.objectives[17 + i] > 0) {
                if (CLGameCanvas.gameObjects.blueWarlord.unitsCounts[i] < this.objectives[17 + i]) {
                    allClear = false;
                } else {
                    this.objectives[17 + i] = -this.objectives[17 + i];
                    gameMode = 5;
                }
            }
            ++i;
        }
        if (this.objectives[22] > 0) {
            if (CLGameCanvas.gameObjects.redWarlord.castlePower > this.objectives[22]) {
                allClear = false;
            } else {
                this.objectives[22] = -this.objectives[22];
                gameMode = 5;
            }
        }
        if (this.objectives[23] > 0) {
            if (CLGameCanvas.gameObjects.blueWarlord.castlePower > this.objectives[23]) {
                allClear = false;
            } else {
                this.objectives[23] = -this.objectives[23];
                gameMode = 5;
            }
        }
        if (allClear) {
            CLGameCanvas.gameObjects.redWarlord.castlePower = 0;
            CLGameCanvas.gameObjects.isBossAlive[1] = false;
        }
    }

    public void paint() {
        switch (gameMode) {
            case 1: 
            case 4: 
            case 7: 
            case 8: {
                this.redrawScene(XClass.g);
                break;
            }
            case 5: {
                this.redrawScene(XClass.g);
                this.status = 1;
                this.redrawObjectives();
                break;
            }
            case 0: {
                this.progressTextEvent();
                this.redrawScene(XClass.g);
                if (this.status == 3) break;
                this.checkObjectives();
                switch (actualMission) {
                    case 1: {
                        this.redrawSceneMission1(XClass.g);
                        break;
                    }
                    case 2: {
                        this.redrawSceneMission2(XClass.g);
                        break;
                    }
                    case 3: {
                        this.redrawSceneMission(XClass.g, 3);
                        break;
                    }
                    case 4: {
                        this.redrawSceneMission(XClass.g, 4);
                        break;
                    }
                    case 5: {
                        this.redrawSceneMission(XClass.g, 5);
                        break;
                    }
                    case 6: {
                        this.redrawSceneMission(XClass.g, 6);
                        break;
                    }
                    case 7: {
                        this.redrawSceneMission(XClass.g, 7);
                        break;
                    }
                    case 8: {
                        this.redrawSceneMission(XClass.g, 8);
                        break;
                    }
                    case 9: {
                        this.redrawSceneMission9(XClass.g);
                        break;
                    }
                    case 10: {
                        this.redrawSceneMission(XClass.g, 10);
                        break;
                    }
                    case 11: {
                        this.redrawSceneMission(XClass.g, 11);
                        break;
                    }
                    case 12: {
                        this.redrawSceneMission(XClass.g, 12);
                        break;
                    }
                    case 13: {
                        this.redrawSceneMission(XClass.g, 13);
                        break;
                    }
                    case 14: {
                        this.redrawSceneMission(XClass.g, 14);
                        break;
                    }
                    case 15: {
                        this.redrawSceneMission(XClass.g, 15);
                        break;
                    }
                    case 16: {
                        this.redrawSceneMission(XClass.g, 16);
                        break;
                    }
                    case 17: {
                        this.redrawSceneMission17(XClass.g);
                        break;
                    }
                    case 18: {
                        this.redrawSceneMission18(XClass.g);
                        break;
                    }
                    case 19: {
                        this.redrawSceneMission19(XClass.g);
                        break;
                    }
                    case 20: {
                        this.redrawSceneMission20(XClass.g);
                    }
                }
                break;
            }
            case 2: {
                CLGameCanvas.drawLoading(XClass.g, true);
                break;
            }
            case 3: {
                this.drawResults();
            }
        }
    }

    protected void draw2String(String text, int posX, int posY, int align, Graphics g) {
        g.setColor(70, 90, 100);
        g.drawString(text, posX + 1, posY + 1, align);
        g.setColor(200, 190, 140);
        g.drawString(text, posX, posY, align);
    }

    protected void drawInfoString(String text, int posX, int posY, int align, Graphics g) {
        g.setColor(0, 0, 0);
        g.drawString(text, posX + 1, posY + 1, align);
        g.setColor(255, 255, 0);
        g.drawString(text, posX, posY, align);
    }

    private void redrawMissionBG_text() {
        XClass.g.setColor(0);
        XClass.g.drawString(this.missionBGText, 1 + XCanvas.WIDTH / 2, 41, 1 + 16);
        XClass.g.setColor(0xFFFFFF);
        XClass.g.drawString(this.missionBGText, XCanvas.WIDTH / 2, 40, 1 + 16);
    }

    public void drawMenuFocus(Graphics g) {
        g.setColor(255, 255, 0);
        switch (this.actualFocus) {
            case 1: {
                g.drawRect(50, 44, 25, 25);
                break;
            }
            case 2: {
                g.drawRect(75, 44, 25, 25);
                break;
            }
            case 3: {
                g.drawRect(100, 44, 25, 25);
                break;
            }
            case 4: {
                g.drawRect(50, 69, 25, 25);
                break;
            }
            case 5: {
                g.drawRect(75, 69, 25, 25);
                break;
            }
            case 6: {
                g.drawRect(100, 69, 25, 25);
                break;
            }
            case 0: {
                g.drawRect(75, 94, 25, 25);
            }
        }
    }

    public void drawQuickHelpBox(Graphics g) {
        g.setColor(40, 30, 25);
        g.fillRect(0, 0, 176, 29);
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        g.setColor(142, 133, 79);
        g.drawRect(0, 1, 176, 27);
        g.setColor(73, 91, 101);
        g.drawRect(1, 0, 174, 29);
    }

    public void initMenuAcces(boolean value) {
        int i = 0;
        while (i < this.menuAccess.length) {
            this.menuAccess[i] = value;
            ++i;
        }
    }

    public void drawActualMenu(Graphics g) {
        if (this.left_menu.active) {
            this.left_menu.menu_y = CLGameCanvas.getMenuY();
            this.left_menu.drawMenu(g, 0, true);
            this.drawProducts(false);
        } else if (this.right_menu.active) {
            this.right_menu.menu_y = CLGameCanvas.getMenuY();
            this.right_menu.drawMenu(g, XCanvas.WIDTH, false);
            this.drawProducts(true);
        } else {
            this.drawProducts(false);
        }
    }

    public void drawEnchants() {
        int num_enchants = CLGameCanvas.gameObjects.playerW.getNumberOfActiveEnchantments();
        if (num_enchants > 0) {
            int koz = CLImageTracker.spell_icons.getWidth() >> 2;
            int x = XCanvas.WIDTH - num_enchants * (CLImageTracker.spell_icons.getWidth() + koz) - koz >> 1;
            int y = CLGameCanvas.getMenuY() + 2;
            Spell[] enchants = new Spell[num_enchants];
            enchants[0] = CLGameCanvas.gameObjects.playerW.enchantment1;
            if (num_enchants > 1) {
                enchants[1] = CLGameCanvas.gameObjects.playerW.enchantment2;
            }
            int i = 0;
            while (i < num_enchants) {
                int idx = Spell.getIconIdx(enchants[i].type);
                CLImageTracker.spell_icons.drawSubImage(XClass.g, x, y, idx / 11, idx % 11);
                int lenght = CLImageTracker.spell_icons.getWidth() * enchants[i].duration / Spell.getDurationByType(enchants[i].type, CLGameCanvas.gameObjects.playerW.intelligence - 1);
                XClass.g.setColor(16122368);
                XClass.g.fillRect(x, y + CLImageTracker.spell_icons.getHeight(), lenght, 4);
                XClass.g.setColor(9767430);
                XClass.g.drawRect(x, y + CLImageTracker.spell_icons.getHeight(), CLImageTracker.spell_icons.getWidth(), 4);
                if ((i + 1) % 2 == 0) {
                    y += CLImageTracker.spell_icons.getHeight() + koz;
                    x = XCanvas.WIDTH - num_enchants * (CLImageTracker.spell_icons.getWidth() + koz) - koz >> 1;
                }
                ++i;
                x += CLImageTracker.spell_icons.getWidth() + koz;
            }
        }
    }

    ImLoader setupStronghold(int level) {
        ImLoader strongHImage = this.imageTracker.getImageForStronghold(level);
        return strongHImage;
    }

    void startVictoryDefeatState() {
        gameMode = 4;
        this.victory_state = 0;
        this.bossToKill = null;
        this.right_menu.active = false;
        this.left_menu.active = false;
        if (result == 1) {
            this.txt_ending = TXT_ENDING[0];
            this.subtitle_ending = CLImageTracker.font_small.splitText(SUBTITLE_ENDING[0], XCanvas.WIDTH);
            this.castleToDestroy = CLGameCanvas.gameObjects.redWarlord == CLGameCanvas.gameObjects.enemyW ? (byte)1 : 0;
            this.castleToDestroyLevel = (byte)CLGameCanvas.gameObjects.enemyW.castleLevel;
            if (this.boss != null) {
                this.bossToKill = this.boss;
                this.castleToDestroyLevel = 0;
                if (this.bossToKill.bossType == 2) {
                    this.startScriptEtherLordDeath();
                }
            }
        } else {
            this.txt_ending = TXT_ENDING[1];
            this.subtitle_ending = CLImageTracker.font_small.splitText(SUBTITLE_ENDING[1], XCanvas.WIDTH);
            this.castleToDestroy = CLGameCanvas.gameObjects.redWarlord == CLGameCanvas.gameObjects.playerW ? (byte)1 : 0;
            this.castleToDestroyLevel = (byte)CLGameCanvas.gameObjects.playerW.castleLevel;
            if (this.blueBoss != null) {
                this.bossToKill = this.blueBoss;
                this.castleToDestroyLevel = 0;
            }
        }
        short[][] widths = new short[][]{GameObjects.DYING_WIDTHS[1]};
        short[][] offsets = new short[][]{GameObjects.DYING_OFFSETS[1]};
        this.explosionAnimation = this.imageTracker.getImageForDying(5);
        this.explosionAnimationFrameCount = (byte)widths[0].length;
        this.explosionFrameIdxS = new byte[2];
        this.explosionYs = new short[2];
    }

    void drawAdditionalVictoryStuff() {
        CLImageTracker.font_anouncements.palette = result == 1 ? PAL_VICTORY : PAL_DEFEAT;
        int y = XCanvas.HEIGHT / 3;
        CLImageTracker.font_anouncements.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y, this.txt_ending);
        if (this.victory_state == 2) {
            y += CLImageTracker.font_anouncements.char_height;
            CLImageTracker.font_small.palette[1] = -16777216 + (result == 1 ? 16692264 : 14101248);
            CLImageTracker.font_small.palette[2] = -16777216;
            int i = 0;
            while (i < this.subtitle_ending.length) {
                CLImageTracker.font_small.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y, this.subtitle_ending[i]);
                ++i;
                y += CLImageTracker.font_small.char_height;
            }
            if (this.blink) {
                CLImageTracker.font_small.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y, CLLocales.getByteString("Press 5"));
            }
        }
    }

    void runVictoryDefeat() {
        switch (this.victory_state) {
            case 0: {
                boolean done = false;
                if (this.castleToDestroy == 0) {
                    if (viewport > 0) {
                        viewport -= this.viewportSpeed;
                    }
                    if (viewport <= 0) {
                        done = true;
                        viewport = 0;
                    }
                } else {
                    if (viewport < 528 - XCanvas.WIDTH) {
                        viewport += this.viewportSpeed;
                    }
                    if (viewport >= 528 - XCanvas.WIDTH) {
                        done = true;
                        viewport = 528 - XCanvas.WIDTH;
                    }
                }
                if (!done) break;
                this.victory_state = 1;
                this.explosionX = this.castleToDestroy == 1 ? (short)(XCanvas.WIDTH - 10 - (GameObjects.DYING_SIZE[0][5] >> 1)) : (short)(25 - (GameObjects.DYING_SIZE[0][5] >> 1));
                boolean archerOwnedByBlue = this.castleToDestroy == 0;
                int i = 0;
                while (i < gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)gameObjects.getLiveObjects().elementAt(i));
                    if (temp instanceof Archer && temp.isOwnedByBlue() == archerOwnedByBlue) {
                        ((Archer)temp).setHitPoints(0);
                        ((Archer)temp).magicHitPoints = 0;
                    }
                    ++i;
                }
                this.destroyPosition = 0;
                this.explosionYs[0] = this.bossToKill == null ? (short)(this.castleToDestroy == 0 ? blueStronghold.getHeight() : redStronghold.getHeight()) : (short)this.bossToKill.positionY;
                if (this.castleToDestroyLevel == 2) {
                    this.explosionYs[0] = (short)(this.explosionYs[0] + CLImageTracker.tower_top.getHeight());
                }
                this.explosionYs[0] = (short)(213 - this.explosionYs[0]);
                this.destroyClipY = this.explosionYs[0];
                if (this.castleToDestroyLevel > 0) {
                    this.explosionYs[0] = (short)(this.explosionYs[0] + destroySteps[this.castleToDestroyLevel][this.destroyPosition]);
                } else {
                    this.explosionFrameIdxS[0] = 0;
                }
                this.explosionYs[1] = -100;
                if (this.bossToKill != null && this.bossToKill.bossType != 2) {
                    gameObjects.getLiveObjects().removeElement((Object)this.bossToKill);
                }
                if (this.bossToKill == null || this.bossToKill.bossType != 2) break;
                short[] ex = new short[]{18, 44, 30, 18, 44, 30, 18, 44, 30, 18, 44};
                short[] ey = new short[]{27, 27, 46, 62, 62, 80, 97, 97, 115, 132, 132};
                short[] sArray = new short[11];
                sArray[0] = 6;
                sArray[1] = 1;
                sArray[2] = 3;
                sArray[3] = 7;
                sArray[5] = 9;
                sArray[6] = 2;
                sArray[7] = 10;
                sArray[8] = 4;
                sArray[9] = 8;
                sArray[10] = 5;
                short[] order = sArray;
                i = 0;
                while (i < ex.length) {
                    int n = i;
                    ex[n] = (short)(ex[n] + (this.bossToKill.positionX - 50));
                    int n2 = i++;
                    ey[n2] = (short)(ey[n2] + (213 - this.bossToKill.frames.getHeight(0, 0) - (this.explosionAnimation.getHeight() >> 1)));
                }
                this.explosionXs = ex;
                this.explosionYs = ey;
                this.explosionOrder = order;
                this.explosion = 0;
                this.expl1Idx = 0;
                this.expl2Idx = (short)-1;
                break;
            }
            case 1: {
                if (this.bossToKill != null && this.bossToKill.bossType == 2) {
                    this.boss.runRedEffect();
                    this.expl1Idx = (short)(this.expl1Idx + 1);
                    if (this.expl2Idx >= 0) {
                        this.expl2Idx = (short)(this.expl2Idx + 1);
                    }
                    if (this.expl2Idx == this.explosionAnimationFrameCount) {
                        this.expl2Idx = (short)-1;
                    }
                    if (this.expl1Idx == 3) {
                        this.boss.setRedEffect();
                    }
                    if (this.expl1Idx == 8) {
                        this.explosion = (short)(this.explosion + 1);
                        if (this.explosion < this.explosionOrder.length) {
                            this.expl2Idx = this.expl1Idx;
                            this.expl1Idx = 0;
                        } else {
                            this.explosion = (short)(this.explosion - 1);
                        }
                    }
                    if (this.expl1Idx != this.explosionAnimationFrameCount || this.explosion != this.explosionOrder.length - 1) break;
                    this.victory_state = (byte)2;
                    System.out.println("Explosions over !!!");
                    this.blink = false;
                    this.blinkTime = (short)400;
                    break;
                }
                int i = 0;
                while (i < 2) {
                    if (this.explosionYs[i] != -100) {
                        int n = i;
                        this.explosionFrameIdxS[n] = (byte)(this.explosionFrameIdxS[n] + 1);
                        if (this.explosionFrameIdxS[n] >= this.explosionAnimationFrameCount) {
                            int idx = i;
                            if (i < 1) {
                                idx = i + 1;
                                this.explosionYs[i] = this.explosionYs[idx];
                                this.explosionFrameIdxS[i] = this.explosionFrameIdxS[idx];
                            }
                            this.explosionYs[idx] = -100;
                            this.explosionFrameIdxS[idx] = 0;
                        }
                    }
                    ++i;
                }
                if (this.explosionFrameIdxS[0] != 6) break;
                this.destroyPosition = (byte)(this.destroyPosition + 1);
                if (this.destroyPosition < destroySteps[this.castleToDestroyLevel].length && this.castleToDestroyLevel > 0) {
                    this.explosionYs[1] = (short)(this.explosionYs[0] + destroySteps[this.castleToDestroyLevel][this.destroyPosition]);
                    if (this.castleToDestroyLevel <= 0) break;
                    if (this.destroyPosition == 1) {
                        this.destroyClipY = (short)(this.destroyClipY + destroySteps[this.castleToDestroyLevel][0]);
                    }
                    this.destroyClipY = (short)(this.destroyClipY + destroySteps[this.castleToDestroyLevel][this.destroyPosition]);
                    break;
                }
                this.victory_state = (byte)2;
                this.blink = false;
                this.blinkTime = (short)400;
                int index = 0;
                this.burnFrameIdx = new byte[this.burnDisplayOrder[this.castleToDestroyLevel].length];
                i = 0;
                while (i < this.burnFrameIdx.length) {
                    if (this.burnDisplayOrder[this.castleToDestroyLevel][i] == 0) {
                        int n = index;
                        index = (byte)(n + 1);
                        this.burnFrameIdx[i] = (byte)(n & 3);
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                this.blinkTime = (short)(this.blinkTime - XCanvas.DT);
                if (this.blinkTime <= 0) {
                    this.blink = !this.blink;
                    this.blinkTime = (short)400;
                }
                if (this.bossToKill != null && this.bossToKill.bossType == 2) break;
                if (this.explosionYs[0] != -100 && (this.explosionFrameIdxS[0] = (byte)(this.explosionFrameIdxS[0] + 1)) >= this.explosionAnimationFrameCount) {
                    this.explosionYs[0] = -100;
                    this.explosionFrameIdxS[0] = 0;
                }
                int i = 0;
                while (i < this.burnFrameIdx.length) {
                    if (this.burnDisplayOrder[this.castleToDestroyLevel][i] == 0) {
                        int n = i;
                        this.burnFrameIdx[n] = (byte)(this.burnFrameIdx[n] + 1);
                        int n3 = i;
                        this.burnFrameIdx[n3] = (byte)(this.burnFrameIdx[n3] & 3);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    public static void nextStrongHoldFrame(int blueOrRed) {
        int n = blueOrRed;
        strongholdFrames[n] = strongholdFrames[n] + 1;
        if (strongholdFrames[n] >= 4) {
            CLGameCanvas.strongholdFrames[blueOrRed] = 0;
        }
    }

    public void drawStrongholds(Graphics g) {
        block27: {
            if (gameMode != 4 || this.victory_state != 2) {
                if (blueStronghold != null) {
                    if (gameMode == 4 && this.victory_state == 1) {
                        g.setClip(0, (int)this.destroyClipY, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
                        ImLoader.setMasterClip(0, this.destroyClipY, XCanvas.WIDTH, XCanvas.HEIGHT);
                    }
                    CLGameCanvas.blueStronghold.transform = 0;
                    blueStronghold.drawSubImage(g, -1 * viewport, 213 - blueStronghold.getHeight(), 0, strongholdFrames[0]);
                    if (CLGameCanvas.gameObjects.blueWarlord.castleLevel == 2) {
                        CLImageTracker.tower_top.draw(g, -1 * viewport, 213 - blueStronghold.getHeight() - CLImageTracker.tower_top.getHeight(), 20);
                    }
                    if (CLGameCanvas.gameObjects.blueWarlord.castlePower < GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.blueWarlord.castleLevel] >> 2) {
                        CLImageTracker.flames.drawSubImage(g, -1 * viewport - CLImageTracker.flame_offset, 213 - CLImageTracker.flames.getHeight(), 0, (this.flame_idx & 7) >> 1);
                    }
                    if (strongholdFrames[0] != 0 && ticks_till_step == 0) {
                        CLGameCanvas.nextStrongHoldFrame(0);
                    }
                }
                if (redStronghold != null) {
                    if (gameMode == 4 && this.victory_state == 1) {
                        g.setClip(0, (int)this.destroyClipY, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
                        ImLoader.setMasterClip(0, this.destroyClipY, XCanvas.WIDTH, XCanvas.HEIGHT);
                    }
                    CLGameCanvas.redStronghold.transform = 2;
                    redStronghold.drawSubImage(g, 528 - viewport - redStronghold.getWidth(), 213 - redStronghold.getHeight(), 0, strongholdFrames[1]);
                    if (CLGameCanvas.gameObjects.redWarlord.castleLevel == 2) {
                        CLImageTracker.tower_top.drawRegion(g, 0, 0, CLImageTracker.tower_top.getWidth(), CLImageTracker.tower_top.getHeight(), 2, 528 - viewport - CLImageTracker.tower_top.getWidth(), 213 - redStronghold.getHeight() - CLImageTracker.tower_top.getHeight(), 20);
                    }
                    if (CLGameCanvas.gameObjects.redWarlord.castlePower < GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.redWarlord.castleLevel] >> 2) {
                        CLImageTracker.flames.drawSubImage(g, 528 - viewport - CLImageTracker.flames.getWidth() + CLImageTracker.flame_offset, 213 - CLImageTracker.flames.getHeight(), 0, (this.flame_idx & 7) >> 1);
                    }
                    if (strongholdFrames[1] != 0 && ticks_till_step == 0) {
                        CLGameCanvas.nextStrongHoldFrame(1);
                    }
                }
                ++this.flame_idx;
            }
            ImLoader.setMasterClip(0, 0, XCanvas.WIDTH, XCanvas.HEIGHT);
            if (gameMode != 4) break block27;
            if (this.victory_state == 2 && this.bossToKill == null) {
                int y = CLImageTracker.castleDestroyed[this.castleToDestroyLevel][0].getHeight();
                y = 213 - y;
                g.setClip(0, 0, (int)XCanvas.WIDTH, 213);
                int i = 0;
                while (i < this.burnDisplayOrder[this.castleToDestroyLevel].length) {
                    int x;
                    byte type = this.burnDisplayOrder[this.castleToDestroyLevel][i];
                    if (this.castleToDestroy == 1) {
                        x = XCanvas.WIDTH - this.burnDisplayX[this.castleToDestroyLevel][i];
                        x = type == 0 ? (x -= CLImageTracker.flames.getWidth()) : (x -= CLImageTracker.castleDestroyed[this.castleToDestroyLevel][type - 1].getWidth());
                        if (type == 0) {
                            CLImageTracker.flames.drawSubImage(g, x, y + this.burnDisplayY[this.castleToDestroyLevel][i], 0, this.burnFrameIdx[i]);
                        } else {
                            Im ruinImage = CLImageTracker.castleDestroyed[this.castleToDestroyLevel][type - 1];
                            ruinImage.drawRegion(g, 0, 0, ruinImage.getWidth(), ruinImage.getHeight(), 2, x, y + this.burnDisplayY[this.castleToDestroyLevel][i], 20);
                        }
                    } else {
                        x = this.burnDisplayX[this.castleToDestroyLevel][i];
                        if (type == 0) {
                            CLImageTracker.flames.drawSubImage(g, x, y + this.burnDisplayY[this.castleToDestroyLevel][i], 0, this.burnFrameIdx[i]);
                        } else {
                            CLImageTracker.castleDestroyed[this.castleToDestroyLevel][type - 1].draw(g, x, y + this.burnDisplayY[this.castleToDestroyLevel][i], 20);
                        }
                    }
                    ++i;
                }
                g.setClip(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
            }
            if (!(this.bossToKill != null && this.bossToKill.bossType == 2 || this.victory_state != 1 && this.victory_state != 2)) {
                int i;
                g.setClip(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
                if (this.castleToDestroyLevel > 0) {
                    i = 0;
                    while (i < 2) {
                        if (this.explosionYs[i] != -100) {
                            this.explosionAnimation.drawSubImage(g, this.explosionX, this.explosionYs[i] - (this.explosionAnimation.getHeight(0, this.explosionFrameIdxS[i]) >> 1), 0, this.explosionFrameIdxS[i]);
                        }
                        ++i;
                    }
                } else if (this.explosionYs[0] != -100) {
                    i = 0;
                    while (i < this.encampExplosionXs.length) {
                        this.explosionX = result == 1 ? (short)(XCanvas.WIDTH - this.encampExplosionXs[i] - 88) : this.encampExplosionXs[i];
                        int frame_idx = this.explosionFrameIdxS[0] + i;
                        if (frame_idx >= 0 && frame_idx < this.explosionAnimationFrameCount) {
                            this.explosionAnimation.drawSubImage(g, this.explosionX, this.explosionYs[0] + destroySteps[0][i] - (this.explosionAnimation.getHeight() >> 1), 0, frame_idx);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void drawBackgrounds(Graphics g) {
        g.setFont(Font.getFont((int)64, (int)0, (int)8));
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
        if (CLImageTracker.background != null) {
            if (viewport <= 176) {
                CLImageTracker.background.draw(g, 0 - viewport, 0, 20);
                CLImageTracker.background.drawRegion(g, 0, 0, CLImageTracker.background.getWidth(), CLImageTracker.background.getHeight(), 2, XCanvas.WIDTH - viewport, 0, 20);
            }
            if (viewport > 176) {
                CLImageTracker.background.drawRegion(g, 0, 0, CLImageTracker.background.getWidth(), CLImageTracker.background.getHeight(), 2, XCanvas.WIDTH - viewport, 0, 20);
                CLImageTracker.background.draw(g, 2 * XCanvas.WIDTH - viewport, 0, 20);
            }
        }
    }

    public void drawRaceInfo(Graphics g) {
        switch (CLGameCanvas.gameObjects.blueWarlord.race) {
            case 0: {
                this.draw2String(CLLocales.getString("BARBARIANS"), 2, 54, 20, g);
                break;
            }
            case 2: {
                this.draw2String(CLLocales.getString("UNDEAD"), 2, 54, 20, g);
                break;
            }
            case 3: {
                this.draw2String(CLLocales.getString("DEMONS"), 2, 54, 20, g);
                break;
            }
            case 1: {
                this.draw2String(CLLocales.getString("ORCS"), 2, 54, 20, g);
            }
        }
        this.draw2String("[" + CLGameCanvas.gameObjects.blueWarlord.wizardry + "/" + CLGameCanvas.gameObjects.blueWarlord.ability + "]", 2, 40, 20, g);
        switch (CLGameCanvas.gameObjects.redWarlord.race) {
            case 0: {
                this.draw2String(CLLocales.getString("BARBARIANS"), 174, 54, 24, g);
                break;
            }
            case 2: {
                this.draw2String(CLLocales.getString("UNDEAD"), 174, 54, 24, g);
                break;
            }
            case 3: {
                this.draw2String(CLLocales.getString("DEMONS"), 174, 54, 24, g);
                break;
            }
            case 1: {
                this.draw2String(CLLocales.getString("ORCS"), 174, 54, 24, g);
            }
        }
        this.draw2String("[" + CLGameCanvas.gameObjects.redWarlord.wizardry + "/" + CLGameCanvas.gameObjects.redWarlord.ability + "]", 174, 40, 24, g);
        this.draw2String("[" + this.computer.actualUnitsStrategy + "," + this.computer.actualBuildStrategy + "," + this.computer.actualMagicStrategy + "]", 174, 75, 24, g);
    }

    private void drawAbilityFrame(int x, int y) {
        ++this.timInd;
        if (this.timInd > 500) {
            this.timInd = 0;
        }
        if (this.timInd % 10 == 0) {
            this.offs += 2;
            this.offs %= 4;
        }
        XClass.g.setColor(0xC0FF00);
        int i = 1;
        while (i < 16) {
            if ((i + this.offs) % 4 == 0) {
                XClass.g.drawRect(x + i, y, 1, 1);
                XClass.g.drawRect(x + i, y + 15, 1, 1);
            }
            if ((i + this.offs) % 4 == 2) {
                XClass.g.drawRect(x, y + i, 1, 1);
                XClass.g.drawRect(x + 15, y + i, 1, 1);
            }
            ++i;
        }
    }

    public void drawAbilityIcons(Graphics g, Person w) {
        if (w == null) {
            return;
        }
        int size = CLImageTracker.abilities.getWidth() * 5 / 4;
        int y = CLGameCanvas.getMenuY() + 2;
        int p = 0;
        if (w.ownedByBlue) {
            int i = 0;
            while (i < 25) {
                if (w.abil(i)) {
                    if (p <= 2) {
                        CLImageTracker.abilities.drawSubImage(g, 4 + p * size, y, 0, i);
                        if (w.isMagicAbility(i)) {
                            this.drawAbilityFrame(4 + p * size, y);
                        }
                    } else {
                        CLImageTracker.abilities.drawSubImage(g, (p - 3) * size, y + size, 0, i);
                        if (w.isMagicAbility(i)) {
                            this.drawAbilityFrame((p - 3) * size, y + size);
                        }
                    }
                    ++p;
                }
                ++i;
            }
        } else {
            p = 0;
            int i = 0;
            while (i < 25) {
                if (w.abil(i)) {
                    if (p <= 2) {
                        CLImageTracker.abilities.drawSubImage(g, 176 - (p + 1) * size, y, 0, i);
                        if (w.isMagicAbility(i)) {
                            this.drawAbilityFrame(176 - (p + 1) * size, y);
                        }
                    } else {
                        CLImageTracker.abilities.drawSubImage(g, 176 - (p - 2) * size, y + size, 0, i);
                        if (w.isMagicAbility(i)) {
                            this.drawAbilityFrame(176 - (p - 2) * size, y + size);
                        }
                    }
                    ++p;
                }
                ++i;
            }
        }
    }

    public void drawAllVisibleObjects(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 216, 176, 4);
        if (CLGameCanvas.gameObjects.blueWarlord.personOnSpike != null) {
            this.drawAbilityIcons(g, CLGameCanvas.gameObjects.blueWarlord.personOnSpike);
        } else {
            this.drawAbilityIcons(g, CLGameCanvas.gameObjects.blueWarlord.archer);
        }
        if (CLGameCanvas.gameObjects.redWarlord.personOnSpike != null) {
            this.drawAbilityIcons(g, CLGameCanvas.gameObjects.redWarlord.personOnSpike);
        } else {
            this.drawAbilityIcons(g, CLGameCanvas.gameObjects.redWarlord.archer);
        }
        int greenLength = 0;
        int yellowLength = 0;
        boolean redLength = false;
        int maxUnitHP = 0;
        Im upgradeStars = CLImageTracker.upgradeStars;
        int upgradeWidth = upgradeStars.getWidth() + 1;
        int upgradeHeight = upgradeStars.getHeight() + 1;
        int starWidth = upgradeWidth / 5;
        int hpLenght = upgradeWidth - 3;
        int posIdx = 0;
        int i = 0;
        while (i < gameObjects.getLiveObjects().size()) {
            GameObject temp = (GameObject)((Object)gameObjects.getLiveObjects().elementAt(i));
            posIdx = temp.positionX / 12;
            if (temp instanceof Person) {
                if (temp.ownedByBlue) {
                    g.setColor(32, 138, 255);
                } else {
                    g.setColor(245, 1, 0);
                }
                g.fillRect(posIdx * 4, 216, 4, 4);
            }
            if (temp.getPositionX() + temp.width() / 2 > viewport && temp.getPositionX() - temp.width() / 2 < viewport + 176) {
                temp.setRefPixelPosition(temp.positionX - viewport, temp.positionY);
                temp.paintSprite(g, false);
                int hpValue = 0;
                if (temp instanceof Person) {
                    int y;
                    int x;
                    hpValue = temp.ownedByBlue ? CLGameCanvas.gameObjects.blueWarlord.getUnitHP(((Person)temp).type) : CLGameCanvas.gameObjects.redWarlord.getUnitHP(((Person)temp).type);
                    if (temp instanceof Boss) {
                        this.bossHP = hpValue = Boss.HP[((Boss)temp).bossType];
                    }
                    if (((Person)temp).diseasetime > 0) {
                        g.setColor(255, 0, 0);
                    }
                    if (((Person)temp).bloodtime > 0) {
                        g.setColor(0, 255, 0);
                    }
                    maxUnitHP = ((Person)temp).maxHitPoints + ((Person)temp).maxMagicHitPoints;
                    greenLength = ((Person)temp).hitPoints * hpLenght / maxUnitHP;
                    yellowLength = ((Person)temp).magicHitPoints * hpLenght / maxUnitHP;
                    if (greenLength > hpLenght) {
                        greenLength = hpLenght;
                    }
                    g.setColor(0, 0, 0);
                    int blackLength = upgradeWidth;
                    if (temp instanceof Archer) {
                        x = ((Archer)temp).healthX - blackLength / 2 - viewport;
                        y = ((Archer)temp).healthY;
                    } else {
                        x = temp.positionX - blackLength / 2 - viewport;
                        y = temp.positionY - 3;
                    }
                    g.fillRect(x - 1, y - 1, blackLength, 4);
                    if (!temp.ownedByBlue) {
                        g.setColor(245, 1, 0);
                        g.drawLine(x, y, x + greenLength, y);
                        g.setColor(174, 12, 10);
                        g.drawLine(x, y + 1, x + greenLength, y + 1);
                    } else {
                        g.setColor(32, 138, 255);
                        g.drawLine(x, y, x + greenLength, y);
                        g.setColor(0, 108, 227);
                        g.drawLine(x, y + 1, x + greenLength, y + 1);
                    }
                    if (yellowLength > 0) {
                        g.setColor(200, 200, 0);
                        g.drawLine(x + greenLength, y, x + greenLength + yellowLength, y);
                        g.setColor(65, 65, 0);
                        g.drawLine(x + greenLength, y + 1, x + greenLength + yellowLength, y + 1);
                    }
                    if (!(temp instanceof Wall) && !(temp instanceof Boss)) {
                        g.setColor(1979191);
                        g.fillRect(--x, y += 2, upgradeWidth, upgradeHeight);
                        g.setColor(0);
                        g.drawRect(x, y, upgradeWidth - 1, upgradeHeight - 1);
                        g.setClip(++x, y, starWidth * temp.level, upgradeHeight);
                        upgradeStars.draw(g, x, y, 20);
                        g.setClip(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
                    }
                    Person pers = (Person)temp;
                    if (pers.upgradeFrameIdx >= 0) {
                        if (temp instanceof Archer) {
                            x = ((Archer)temp).healthX - viewport;
                            y = ((Archer)temp).healthY;
                        } else {
                            x = pers.positionX - viewport;
                            y = pers.positionY + pers.height();
                        }
                        CLImageTracker.upgradeAnim.drawSubImage(g, x - CLImageTracker.upgradeAnim.getWidth() / 2, y - CLImageTracker.upgradeAnim.getHeight(), 0, pers.upgradeFrameIdx);
                    }
                }
            } else if (ticks_till_step == 0 && !(temp instanceof Archer) && temp.moved) {
                temp.nextFrame();
            }
            ++i;
        }
        CLGameCanvas.runHandOf();
        CLGameCanvas.runDisenchant();
        CLGameCanvas.runArmaggedon();
    }

    public static void removeAllLiveObjects() {
        CLGameCanvas.gameObjects.blueWarlord.personOnSpike = null;
        CLGameCanvas.gameObjects.redWarlord.personOnSpike = null;
        int i = 0;
        while (i < gameObjects.getLiveObjects().size()) {
            gameObjects.getLiveObjects().removeElementAt(i);
            ++i;
        }
    }

    public void testObjectsForLife() {
        CLGameCanvas.gameObjects.blueWarlord.personOnSpike = null;
        CLGameCanvas.gameObjects.redWarlord.personOnSpike = null;
        CLGameCanvas.gameObjects.blueWarlord.lastWalkerXPosition = 516;
        CLGameCanvas.gameObjects.redWarlord.lastWalkerXPosition = 12;
        int i = 0;
        while (i < gameObjects.getLiveObjects().size()) {
            GameObject temp = (GameObject)((Object)gameObjects.getLiveObjects().elementAt(i));
            if (temp instanceof Person) {
                if (((Person)temp).getHitPoints() < 1) {
                    if (temp.ownedByBlue) {
                        ++CLGameCanvas.gameObjects.redWarlord.kills;
                        CLGameCanvas.gameObjects.blueWarlord.kills = 0;
                        switch (CLGameCanvas.gameObjects.redWarlord.kills) {
                            case 2: {
                                gameObjects.addCenterText(CLLocales.getString("DOUBLE"), 10, 4);
                                break;
                            }
                            case 3: {
                                gameObjects.addCenterText(CLLocales.getString("TRIPLE"), 10, 4);
                                break;
                            }
                            case 4: {
                                gameObjects.addCenterText(CLLocales.getString("BLOODBATH"), 10, 4);
                                break;
                            }
                            case 5: {
                                gameObjects.addCenterText(CLLocales.getString("RAMPAGE"), 10, 4);
                                break;
                            }
                            case 6: {
                                gameObjects.addCenterText(CLLocales.getString("HEROIC"), 10, 4);
                                break;
                            }
                            case 7: {
                                gameObjects.addCenterText(CLLocales.getString("IMMORTAL"), 10, 4);
                                break;
                            }
                            case 8: {
                                gameObjects.addCenterText(CLLocales.getString("TITANIC"), 10, 4);
                                break;
                            }
                            case 9: {
                                gameObjects.addCenterText(CLLocales.getString("GODLIKE"), 10, 4);
                                break;
                            }
                            case 10: {
                                gameObjects.addCenterText(CLLocales.getString("GODMAN"), 10, 4);
                            }
                        }
                        if (temp instanceof Boss) {
                            CLGameCanvas.gameObjects.isBossAlive[0] = false;
                        } else {
                            int n = ((Person)temp).type;
                            this.blueVictims[n] = this.blueVictims[n] + 1;
                        }
                    } else {
                        CLGameCanvas.gameObjects.redWarlord.kills = 0;
                        ++CLGameCanvas.gameObjects.blueWarlord.kills;
                        switch (CLGameCanvas.gameObjects.blueWarlord.kills) {
                            case 2: {
                                gameObjects.addCenterText(CLLocales.getString("DOUBLE"), 10, 3);
                                break;
                            }
                            case 3: {
                                gameObjects.addCenterText(CLLocales.getString("TRIPLE"), 10, 3);
                                break;
                            }
                            case 4: {
                                gameObjects.addCenterText(CLLocales.getString("BLOODBATH"), 10, 3);
                                break;
                            }
                            case 5: {
                                gameObjects.addCenterText(CLLocales.getString("RAMPAGE"), 10, 3);
                                break;
                            }
                            case 6: {
                                gameObjects.addCenterText(CLLocales.getString("HEROIC"), 10, 3);
                                break;
                            }
                            case 7: {
                                gameObjects.addCenterText(CLLocales.getString("IMMORTAL"), 10, 3);
                                break;
                            }
                            case 8: {
                                gameObjects.addCenterText(CLLocales.getString("TITANIC"), 10, 3);
                                break;
                            }
                            case 9: {
                                gameObjects.addCenterText(CLLocales.getString("GODLIKE"), 10, 3);
                                break;
                            }
                            case 10: {
                                gameObjects.addCenterText(CLLocales.getString("GODMAN"), 10, 3);
                            }
                        }
                        if (temp instanceof Boss) {
                            CLGameCanvas.gameObjects.isBossAlive[1] = false;
                        } else {
                            int n = ((Person)temp).type;
                            this.redVictims[n] = this.redVictims[n] + 1;
                        }
                    }
                    if (temp instanceof Wall) {
                        if (temp.ownedByBlue) {
                            CLGameCanvas.gameObjects.blueWarlord.wall_state = 0;
                        } else {
                            CLGameCanvas.gameObjects.redWarlord.wall_state = 0;
                        }
                    }
                    if (temp instanceof Archer) {
                        if (temp.isOwnedByBlue()) {
                            CLGameCanvas.gameObjects.blueWarlord.has_archer = false;
                            CLGameCanvas.gameObjects.blueWarlord.archer = null;
                        } else {
                            CLGameCanvas.gameObjects.redWarlord.has_archer = false;
                            CLGameCanvas.gameObjects.redWarlord.archer = null;
                        }
                    }
                    if (temp instanceof Cannon) {
                        if (temp.isOwnedByBlue()) {
                            CLGameCanvas.gameObjects.blueWarlord.has_cannon = false;
                            System.out.println("HASCANNON false (blue)...........");
                        } else {
                            CLGameCanvas.gameObjects.redWarlord.has_cannon = false;
                            System.out.println("HASCANNON false (red)...........");
                        }
                    }
                    if (!(temp instanceof Boss)) {
                        int y;
                        int x;
                        gameObjects.getLiveObjects().removeElementAt(i);
                        if (temp instanceof Archer) {
                            x = ((Archer)temp).healthX;
                            y = ((Archer)temp).healthY;
                        } else {
                            x = ((Person)temp).positionX;
                            y = 213;
                        }
                        CLGameCanvas.gameObjects.dyingAnims.addElement(new DyingAnim(this.imageTracker.getImageForDying(((Person)temp).type), x, y - GameObjects.DYING_SIZE[1][((Person)temp).type], ((Person)temp).type));
                    }
                } else if (!(temp instanceof Archer) && !(temp instanceof Wall)) {
                    if (temp.ownedByBlue) {
                        if (CLGameCanvas.gameObjects.blueWarlord.personOnSpike == null) {
                            CLGameCanvas.gameObjects.blueWarlord.personOnSpike = (Person)temp;
                        } else if (temp.positionX > CLGameCanvas.gameObjects.blueWarlord.personOnSpike.positionX) {
                            CLGameCanvas.gameObjects.blueWarlord.personOnSpike = (Person)temp;
                        }
                        if (temp.positionX < CLGameCanvas.gameObjects.blueWarlord.lastWalkerXPosition) {
                            CLGameCanvas.gameObjects.blueWarlord.lastWalkerXPosition = temp.positionX;
                        }
                    } else {
                        if (CLGameCanvas.gameObjects.redWarlord.personOnSpike == null) {
                            CLGameCanvas.gameObjects.redWarlord.personOnSpike = (Person)temp;
                        } else if (temp.positionX < CLGameCanvas.gameObjects.redWarlord.personOnSpike.positionX) {
                            CLGameCanvas.gameObjects.redWarlord.personOnSpike = (Person)temp;
                        }
                        if (temp.positionX > CLGameCanvas.gameObjects.redWarlord.lastWalkerXPosition) {
                            CLGameCanvas.gameObjects.redWarlord.lastWalkerXPosition = temp.positionX;
                        }
                    }
                }
            } else if (temp instanceof Shot) {
                if (((Shot)temp).isAttackOver()) {
                    gameObjects.getLiveObjects().removeElementAt(i);
                }
            } else if (temp instanceof Resource && ((Resource)temp).hitPoints < 1) {
                gameObjects.getLiveObjects().removeElementAt(i);
            }
            ++i;
        }
        if (CLGameCanvas.gameObjects.blueWarlord.lastWalkerXPosition > 12) {
            CLGameCanvas.gameObjects.blueWarlord.lastWalkerXPosition = 12;
        }
        if (CLGameCanvas.gameObjects.redWarlord.lastWalkerXPosition < 516) {
            CLGameCanvas.gameObjects.redWarlord.lastWalkerXPosition = 516;
        }
    }

    public void performSpells() {
        int i = 0;
        while (i < gameObjects.getSpells().size()) {
            Spell temp = (Spell)((Object)gameObjects.getSpells().elementAt(i));
            if (!temp.isAttackOver()) {
                temp.createSpell();
                temp.setAttackOver(true);
            }
            if (temp.duration > 0) {
                temp.doStep();
            } else {
                temp.finalizeSpell();
                gameObjects.getSpells().removeElementAt(i);
            }
            ++i;
        }
    }

    public void doStepOverObjects() {
        int i = 0;
        while (i < gameObjects.getLiveObjects().size()) {
            GameObject temp = (GameObject)((Object)gameObjects.getLiveObjects().elementAt(i));
            if (gameMode != 4 || temp instanceof Shot || temp instanceof Resource) {
                temp.doStep();
            }
            ++i;
        }
    }

    public void drawDyingAnimations(Graphics g) {
        int i = 0;
        while (i < CLGameCanvas.gameObjects.dyingAnims.size()) {
            DyingAnim temp = (DyingAnim)CLGameCanvas.gameObjects.dyingAnims.elementAt(i);
            temp.paint(g, temp.x - viewport, temp.y);
            ++i;
        }
        if (gameMode == 4 && this.victory_state == 1 && this.bossToKill != null && this.bossToKill.bossType == 2) {
            short expl_idx = this.explosionOrder[this.explosion];
            this.explosionAnimation.drawSubImage(g, this.explosionXs[expl_idx] - viewport, this.explosionYs[expl_idx], 0, this.expl1Idx);
            if (this.expl2Idx >= 0) {
                expl_idx = this.explosionOrder[this.explosion - 1];
                this.explosionAnimation.drawSubImage(g, this.explosionXs[expl_idx] - viewport, this.explosionYs[expl_idx], 0, this.expl2Idx);
            }
        }
    }

    public void drawFlyingAndCenterTexts(Graphics g) {
        int base_r = 0;
        int base_g = 0;
        int base_b = 0;
        int i = 0;
        while (i < CLGameCanvas.gameObjects.flyingTexts.size()) {
            GameObjects.FlyingText text = (GameObjects.FlyingText)CLGameCanvas.gameObjects.flyingTexts.elementAt(i);
            switch (text.type) {
                case 0: {
                    base_g = 200;
                    base_b = 200;
                    base_r = 200;
                    break;
                }
                case 1: {
                    base_g = 10;
                    base_b = 10;
                    base_r = 200;
                    g.setColor(14754304);
                    break;
                }
                case 2: {
                    base_r = 50;
                    base_g = 150;
                    base_b = 200;
                    g.setColor(base_r + text.showTime * 5, base_g + text.showTime * 5, base_b + text.showTime * 5);
                    break;
                }
                case 5: {
                    base_b = 10;
                    base_r = 10;
                    base_g = 200;
                    g.setColor(52224);
                }
            }
            CLImageTracker.font_numbers.palette[1] = -16777216 + g.getColor();
            CLImageTracker.font_small.palette[1] = -16777216 + g.getColor();
            if (text.type == 1 || text.type == 5) {
                CLImageTracker.font_numbers.textOutCenter(g, text.x - viewport, text.y, text.byte_text);
            } else {
                CLImageTracker.font_small.textOutCenter(g, text.x - viewport, text.y, text.byte_text);
            }
            ++i;
        }
        if (CLGameCanvas.gameObjects.centerTexts.size() > 0 && gameMode != 4) {
            GameObjects.CenterText text = (GameObjects.CenterText)CLGameCanvas.gameObjects.centerTexts.elementAt(0);
            switch (text.type) {
                case 0: {
                    base_g = 200;
                    base_b = 200;
                    base_r = 200;
                    break;
                }
                case 4: {
                    base_g = 10;
                    base_b = 10;
                    base_r = 200;
                    CLImageTracker.font_anouncements.palette = this.pal_red;
                    break;
                }
                case 6: {
                    base_g = 200;
                    base_b = 200;
                    base_r = 200;
                    break;
                }
                case 3: {
                    base_b = 10;
                    base_r = 10;
                    base_g = 200;
                    CLImageTracker.font_anouncements.palette = this.pal_blue;
                }
            }
            g.setColor(base_r + text.showTime * 5, base_g + text.showTime * 5, base_b + text.showTime * 5);
            int i2 = 0;
            int y = text.y;
            while (i2 < text.byte_text.length) {
                CLImageTracker.font_anouncements.textOutCenter(g, text.x, y, text.byte_text[i2]);
                ++i2;
                y += CLImageTracker.font_anouncements.char_height;
            }
            if (--text.showTime < 0) {
                CLGameCanvas.gameObjects.centerTexts.removeElementAt(0);
            }
        }
    }

    public void drawActualGameStats(Graphics g) {
        BCFont fSmall = CLImageTracker.font_small;
        int boxH = Math.max(fSmall.char_height, CLImageTracker.small_icons.getHeight());
        int y = boxH + CLImageTracker.box[0].getHeight() - 4;
        int max_width = 5 * XCanvas.WIDTH >> 4;
        int x = 0;
        IngameMenu.drawBox(g, x, y, max_width, 6);
        int yy = y + CLImageTracker.box[0].getHeight() - 4;
        g.setColor(13737334);
        g.fillRect((x += CLImageTracker.box[0].getWidth()) - 4, yy, max_width + 8, 1);
        int power_length = this.blueBoss == null ? CLGameCanvas.gameObjects.blueWarlord.castlePower * max_width / GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.blueWarlord.castleLevel] : this.blueBoss.getHitPoints() * max_width / Boss.HP[this.blueBoss.bossType];
        int i = 0;
        while (i < 2) {
            g.setColor(power_cols[0][i]);
            g.fillRect(x, yy + 3 + i, power_length, 1);
            ++i;
        }
        g.setColor(13418646);
        x += max_width / 2;
        x = XCanvas.WIDTH - max_width - CLImageTracker.box[0].getWidth() * 2;
        IngameMenu.drawBox(g, x, y, max_width, 6);
        g.setColor(13737334);
        g.fillRect((x += CLImageTracker.box[0].getWidth()) - 4, yy, max_width + 8, 1);
        power_length = this.boss == null ? CLGameCanvas.gameObjects.redWarlord.castlePower * max_width / GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.redWarlord.castleLevel] : this.boss.getHitPointsNoMagic() * max_width / Boss.HP[this.boss.bossType];
        i = 0;
        while (i < 2) {
            g.setColor(power_cols[1][i]);
            g.fillRect(x, yy + 3 + i, power_length, 1);
            ++i;
        }
        x += max_width / 2;
        g.setColor(13418646);
        int w = XCanvas.WIDTH - CLImageTracker.box[0].getWidth() * 2;
        x = CLImageTracker.box[0].getWidth();
        y = CLImageTracker.box[0].getHeight() - 4;
        fSmall.palette[1] = -1;
        fSmall.palette[2] = 0;
        IngameMenu.drawBox(g, 0, 0, w, boxH);
        g.setColor(0xFFFFFF);
        yy = y + CLImageTracker.small_icons.getHeight() - fSmall.char_height;
        if (buildings_stats_time == 0) {
            CLImageTracker.small_icons.drawSubImage(g, x, y, 0, 0);
            this.gold.delete(0, this.gold.length());
            this.gold.appendNum(CLGameCanvas.gameObjects.playerW.money);
            fSmall.textOut(g, x + CLImageTracker.small_icons.getWidth() + 2, yy, this.gold);
            CLImageTracker.small_icons.drawSubImage(g, x += w / 3, y, 0, 1);
            this.stone.delete(0, this.stone.length());
            this.stone.appendNum(CLGameCanvas.gameObjects.playerW.stones);
            fSmall.textOut(g, x + CLImageTracker.small_icons.getWidth() + 2, yy, this.stone);
            this.mana.delete(0, this.mana.length());
            this.mana.appendNum(CLGameCanvas.gameObjects.playerW.mana);
            CLImageTracker.small_icons.drawSubImage(g, x += w / 3, y, 0, 2);
            fSmall.textOut(g, x + CLImageTracker.small_icons.getWidth() + 2, yy, this.mana);
        } else {
            CLImageTracker.small_icons.drawSubImage(g, x, y, 0, 7);
            this.villages.delete(0, this.villages.length());
            this.villages.appendNum(CLGameCanvas.gameObjects.playerW.villages).append((byte)71);
            this.villages.appendNum(CLGameCanvas.gameObjects.playerW.max_villages);
            fSmall.textOut(g, x + CLImageTracker.small_icons.getWidth() + 2, y, this.villages);
            CLImageTracker.small_icons.drawSubImage(g, x += w >> 1, y, 0, 8);
            this.mines.delete(0, this.mines.length());
            this.mines.appendNum(CLGameCanvas.gameObjects.playerW.mines).append((byte)71);
            this.mines.appendNum(CLGameCanvas.gameObjects.playerW.max_mines);
            fSmall.textOut(g, x + CLImageTracker.small_icons.getWidth() + 2, yy, this.mines);
        }
    }

    protected int redrawInfo(Graphics g, int currCharacter, int txtIndex) {
        if (this.status == 0) {
            this.isActiveKeyboard = false;
            this.isObjectsActive = false;
            CLGameCanvas.main.cmap.paint();
        }
        return 0;
    }

    public void testViewport() {
        if (viewport < 0) {
            viewport = 0;
        } else if (viewport > 352) {
            viewport = 352;
        }
    }

    public boolean moveViewport(int posX, int step) {
        if (viewport != posX) {
            if (viewport < posX) {
                if (viewport + step > posX) {
                    viewport = posX;
                    this.testViewport();
                    return true;
                }
                viewport += step;
                return false;
            }
            if (viewport - step < posX) {
                viewport = posX;
                this.testViewport();
                return true;
            }
            viewport -= step;
            return false;
        }
        this.testViewport();
        return true;
    }

    public int testQuestResult(int questType) {
        int result = 0;
        switch (questType) {
            case 0: {
                if (CLGameCanvas.gameObjects.enemyW.castlePower < 1) {
                    result = 1;
                }
                if (CLGameCanvas.gameObjects.playerW.castlePower >= 1) break;
                result = 2;
                break;
            }
            case 2: {
                if (CLGameCanvas.gameObjects.enemyW.castlePower < 1 && this.playTime > 0) {
                    result = 1;
                }
                if (CLGameCanvas.gameObjects.playerW.castlePower >= 1 && this.playTime >= 1) break;
                result = 2;
                break;
            }
            case 1: {
                if (CLGameCanvas.gameObjects.enemyW.castlePower < 1 || this.playTime < 1) {
                    result = 1;
                }
                if (CLGameCanvas.gameObjects.playerW.castlePower >= 1) break;
                result = 2;
                break;
            }
            case 3: {
                if (CLGameCanvas.gameObjects.redWarlord.money > CLGameCanvas.gameObjects.requiredGold && CLGameCanvas.gameObjects.redWarlord.stones > CLGameCanvas.gameObjects.requiredStones && CLGameCanvas.gameObjects.redWarlord.mana > CLGameCanvas.gameObjects.requiredMana) {
                    result = 1;
                }
                if (CLGameCanvas.gameObjects.blueWarlord.castlePower >= 1 && CLGameCanvas.gameObjects.redWarlord.castlePower >= 1) break;
                result = 2;
                break;
            }
            case 4: {
                if (!CLGameCanvas.gameObjects.isBossAlive[1]) {
                    result = 1;
                }
                if (CLGameCanvas.gameObjects.blueWarlord.castlePower >= 1 && CLGameCanvas.gameObjects.isBossAlive[0]) break;
                result = 2;
            }
        }
        return result;
    }

    protected void redrawScene(Graphics g) {
        this.drawBackgrounds(g);
        this.drawStrongholds(g);
        if (!CLGameCanvas.isSpikeOver(0) && gameMode != 4) {
            CLGameCanvas.drawSpikes(false, 0);
        }
        if (!CLGameCanvas.isSpikeOver(1) && gameMode != 4) {
            CLGameCanvas.drawSpikes(false, 1);
        }
        this.drawAllVisibleObjects(g);
        this.drawDyingAnimations(g);
        CLGameCanvas.drawHitAnims();
        if (gameMode != 4) {
            if (this.boss != null && this.boss.isLightningEnabled()) {
                Boss.paintLightning(g);
            }
            if (!CLGameCanvas.isSpikeOver(0)) {
                CLGameCanvas.drawSpikes(true, 0);
            }
            if (!CLGameCanvas.isSpikeOver(1)) {
                CLGameCanvas.drawSpikes(true, 1);
            }
            if (blueRain != null) {
                blueRain.drawRain(g);
            }
            if (redRain != null) {
                redRain.drawRain(g);
            }
        }
        this.redrawMissionBG_text();
        this.drawFlyingAndCenterTexts(g);
        if (this.messageDelay > 0) {
            BCFont fSmall = CLImageTracker.font_small;
            fSmall.palette[1] = -1907998;
            fSmall.palette[2] = -16777216;
            int h = this.message_bytes.length * fSmall.char_height + 3;
            int y = XCanvas.HEIGHT - h - 5;
            g.setColor(2702919);
            g.fillRect(0, y, (int)XCanvas.WIDTH, h);
            g.setColor(0);
            g.drawRect(0, y, XCanvas.WIDTH - 1, h - 1);
            y += 2;
            int i = 0;
            while (i < this.message_bytes.length) {
                fSmall.textOutCenter(g, XCanvas.WIDTH >> 1, y, this.message_bytes[i]);
                ++i;
                y += fSmall.char_height;
            }
            --this.messageDelay;
        }
        this.drawActualGameStats(g);
        if (gameMode != 4) {
            this.drawEnchants();
            this.drawActualMenu(g);
        }
        if (gameMode == 4) {
            this.drawAdditionalVictoryStuff();
        }
        if (gameMode == 8) {
            this.scriptEatherLordDeath();
        }
    }

    void initResults() {
        this.imageTracker.loadResultImages(CLGameCanvas.gameObjects.enemyW.race);
        this.result_offset = 0;
        this.result_padding = 5;
    }

    void drawResults() {
        byte[] resultTitle;
        int col_scroll;
        int col;
        int y = 16;
        XClass.g.setColor(0);
        XClass.g.fillRect(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
        CLImageTracker.resultBG.draw(XClass.g, 0, 0, 20);
        if (result == 1) {
            col = 16692264;
            col_scroll = 12026397;
            CLImageTracker.font_anouncements.palette = PAL_VICTORY;
            resultTitle = CLLocales.getByteString("VICTORY");
        } else {
            col = 14101248;
            col_scroll = 10627596;
            CLImageTracker.font_anouncements.palette = PAL_DEFEAT;
            resultTitle = CLLocales.getByteString("DEFEAT");
        }
        CLImageTracker.font_anouncements.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y, resultTitle);
        CLImageTracker.font_small.palette[1] = -2768506;
        CLImageTracker.font_small.palette[2] = 0;
        CLImageTracker.font_small.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y += CLImageTracker.font_anouncements.char_height, CLLocales.getByteString("BATTLE_CASSUALTIES"));
        int h = 177 - (y += CLImageTracker.font_small.char_height + (CLImageTracker.font_small.char_height >> 1));
        h = Math.min(h, CLImageTracker.scrollBg.getHeight() + 2 * CLImageTracker.resultArrows.getHeight() + 2);
        XClass.g.setColor(col);
        int x = 15;
        int w = XCanvas.WIDTH - 2 * x;
        XClass.g.setColor(8614987);
        XClass.g.drawRect(x - 1, y - 1, w, h);
        XClass.g.setColor(16765564);
        XClass.g.drawRect(x - 2, y - 2, w + 2, h + 2);
        CLImageTracker.resultArrows.drawSubImage(XClass.g, x + (w -= 2) - CLImageTracker.resultArrows.getWidth(), y + 1, 0, 0);
        CLImageTracker.resultArrows.drawSubImage(XClass.g, x + w - CLImageTracker.resultArrows.getWidth(), y + h - 1 - CLImageTracker.resultArrows.getHeight(), 1, 0);
        int h_bg = h - CLImageTracker.resultArrows.getHeight() * 2 - 2;
        int yy = y + 1 + CLImageTracker.resultArrows.getHeight();
        int x_bg = x + w - (CLImageTracker.resultArrows.getWidth() >> 1) - 1;
        Im scrollBg = CLImageTracker.scrollBg;
        if (h_bg < scrollBg.getHeight()) {
            XClass.g.setClip(0, yy, (int)XCanvas.WIDTH, h_bg);
            scrollBg.draw(XClass.g, x_bg, yy, 1 | 0x10);
            XClass.g.setClip(0, yy + h_bg - 5, (int)XCanvas.WIDTH, 5);
            scrollBg.draw(XClass.g, x_bg, yy + h_bg, 1 | 0x20);
            XClass.g.setClip(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
        } else {
            scrollBg.draw(XClass.g, x_bg, yy, 1 | 0x10);
        }
        int koz = CLImageTracker.portraits.getHeight() / 3;
        int result_height = 5 * CLImageTracker.portraits.getHeight() + 4 * koz + 4;
        int scroll_height = (h - 2 * CLImageTracker.resultArrows.getHeight()) * (h - 2 * this.result_padding) / result_height;
        int scroll_y = y + CLImageTracker.resultArrows.getHeight() + (h - 2 * CLImageTracker.resultArrows.getHeight()) * -this.result_offset / result_height;
        int hh = scroll_height;
        yy = scroll_y;
        ImLoader scrollBar = CLImageTracker.scrollBar;
        scrollBar.drawSubImage(XClass.g, x + w - CLImageTracker.resultArrows.getWidth(), yy, 0, 0);
        yy += scrollBar.getHeight();
        hh -= scrollBar.getHeight();
        while (hh > scrollBar.getHeight()) {
            scrollBar.drawSubImage(XClass.g, x + w - CLImageTracker.resultArrows.getWidth(), yy, 1, 0);
            yy += scrollBar.getHeight();
            hh -= scrollBar.getHeight();
        }
        yy = scroll_y + scroll_height - scrollBar.getHeight();
        scrollBar.drawSubImage(XClass.g, x + w - CLImageTracker.resultArrows.getWidth(), yy, 2, 0);
        this.result_offset_min = (h -= 2 * this.result_padding) - result_height;
        XClass.g.setClip(x, y += this.result_padding, w += 2, h);
        ImLoader.setMasterClip(x, y, w, h);
        y += 2;
        y += this.result_offset;
        int xx = (x += this.result_padding) + (w - this.result_padding - CLImageTracker.resultArrows.getWidth() >> 1);
        int i = 0;
        while (i < this.blueVictims.length - 1) {
            CLImageTracker.portraits.drawSubImage(XClass.g, x, y, 0, i);
            CLImageTracker.portrait_enemy.drawSubImage(XClass.g, xx, y, 0, i);
            XClass.g.setColor(-2768506);
            XClass.g.drawRect(x - 2, y - 2, CLImageTracker.portraits.getWidth() + 3, CLImageTracker.portraits.getHeight() + 3);
            XClass.g.drawRect(xx - 2, y - 2, CLImageTracker.portraits.getWidth() + 3, CLImageTracker.portraits.getHeight() + 3);
            CLImageTracker.font_small.palette[1] = -331056;
            CLImageTracker.font_small.textOut(XClass.g, x + CLImageTracker.portraits.getWidth() + 4, y + (CLImageTracker.portraits.getHeight() - CLImageTracker.font_small.char_height >> 1), GameObjects.convertToByteString("" + this.blueVictims[i], false));
            CLImageTracker.font_small.textOut(XClass.g, xx + CLImageTracker.portraits.getWidth() + 4, y + (CLImageTracker.portraits.getHeight() - CLImageTracker.font_small.char_height >> 1), GameObjects.convertToByteString("" + this.redVictims[i], false));
            ++i;
            y += CLImageTracker.portraits.getHeight() + koz;
        }
        XClass.g.setClip(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
        ImLoader.setMasterClip(0, 0, XCanvas.WIDTH, XCanvas.HEIGHT);
        y = 180;
        LogoCanvas.drawSmallButton(XClass.g, XCanvas.WIDTH >> 1, y, 1, CLLocales.getByteString("CONTINUE"));
    }

    protected void progressTextEvent() {
        if (playerGameEvent == 22) {
            int next = CLGameCanvas.main.cmap.progress_INGAME_dialog();
            switch (next) {
                case 1: {
                    this.status = 1;
                    ++this.gamePhase;
                    System.out.println("Game phase: " + this.gamePhase);
                    this.isActiveKeyboard = false;
                    this.isObjectsActive = false;
                    this.isAIActive = false;
                    CLGameCanvas.main.cmap.progress_INGAME_dialog();
                    break;
                }
                case 2: {
                    if (!this.objectivesAlreadyShown) {
                        this.status = 3;
                        gameMode = 5;
                        this.isActiveKeyboard = false;
                        this.isObjectsActive = false;
                        this.isAIActive = false;
                        this.objectivesAlreadyShown = true;
                        this.objectivesContinueType = 2;
                        break;
                    }
                    this.status = 1;
                    this.gamePhase = -1;
                    this.isActiveKeyboard = true;
                    this.isObjectsActive = true;
                    this.isAIActive = true;
                    System.out.println("Play nicely kids! (game active)");
                    break;
                }
                case 3: {
                    this.status = 3;
                    gameMode = 5;
                    this.isActiveKeyboard = false;
                    this.isObjectsActive = false;
                    this.isAIActive = false;
                    this.objectivesAlreadyShown = true;
                    this.objectivesContinueType = 1;
                    System.out.println("Showing objectives " + this.status);
                    break;
                }
                case 0: {
                    this.status = 0;
                    this.isActiveKeyboard = false;
                    this.isObjectsActive = false;
                    this.isAIActive = false;
                }
            }
            playerGameEvent = 0;
        }
        if (playerGameEvent == 23) {
            System.out.println("Dialog skipped, game activated: Play nicely kids! (game active)");
            if (!this.objectivesAlreadyShown) {
                this.status = 3;
                gameMode = 5;
                this.isActiveKeyboard = false;
                this.isObjectsActive = false;
                this.isAIActive = false;
                this.objectivesAlreadyShown = true;
                this.objectivesContinueType = 2;
            } else {
                this.status = 1;
                this.gamePhase = -1;
                this.isActiveKeyboard = true;
                this.isObjectsActive = true;
                this.isAIActive = true;
            }
            playerGameEvent = 0;
        }
    }

    void redrawObjectives() {
        this.openY += 15;
        if (this.openY > XCanvas.WIDTH - 30) {
            this.openY = XCanvas.WIDTH - 30;
        }
        CLGameCanvas.main.cmap.drawScroll(0, 50, XCanvas.WIDTH, this.openY);
        int y = 70;
        CLImageTracker.font_small.palette[1] = -5636096;
        String s = "";
        if (this.openY > y + CLImageTracker.font_small.char_height) {
            CLImageTracker.font_small.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y, CLLocales.getByteString("Mission Objectives"));
        }
        y += CLImageTracker.font_small.char_height + 20;
        CLImageTracker.font_small.palette[1] = -16777216;
        int i = 0;
        while (i < this.objectives.length) {
            if (Math.abs(this.objectives[i]) > 0) {
                int p1 = objectives_l[i].indexOf(88);
                int p2 = objectives_l[i].indexOf(89);
                if (p1 > 0) {
                    s = objectives_l[i].substring(0, p1);
                    s = String.valueOf(s) + Math.abs(this.objectives[i]);
                    if (p2 > 0) {
                        switch (objectives_l[i].charAt(p2 + 1)) {
                            case '1': {
                                s = String.valueOf(s) + Messages.PIKER[CLGameCanvas.gameObjects.blueWarlord.race];
                                break;
                            }
                            case '2': {
                                s = String.valueOf(s) + Messages.KNIGHT[CLGameCanvas.gameObjects.blueWarlord.race];
                                break;
                            }
                            case '3': {
                                s = String.valueOf(s) + Messages.ARCHER[CLGameCanvas.gameObjects.blueWarlord.race];
                                break;
                            }
                            case '4': {
                                s = String.valueOf(s) + Messages.RIDER[CLGameCanvas.gameObjects.blueWarlord.race];
                                break;
                            }
                            case '5': {
                                s = String.valueOf(s) + Messages.CANNON[CLGameCanvas.gameObjects.blueWarlord.race];
                            }
                        }
                    } else {
                        s = String.valueOf(s) + objectives_l[i].substring(p1 + 1);
                    }
                } else {
                    s = objectives_l[i];
                }
                if (this.openY > y + CLImageTracker.font_small.char_height) {
                    CLImageTracker.font_small.palette[1] = this.objectives[i] > 0 ? -16777216 : -16729344;
                    CLImageTracker.font_small.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y, CLLocales.getByteString("- " + s));
                    y += CLImageTracker.font_small.char_height;
                }
            }
            ++i;
        }
    }

    protected void redrawSceneMission1(Graphics g) {
        if (this.gamePhase == 1) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            this.automaticCycles = 30;
        }
        if (this.gamePhase == 2) {
            g.setColor(255, 255, 0);
            g.drawRect(3, 3, 171, 16);
            --this.automaticCycles;
            if (this.automaticCycles < 1) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 3) {
            this.status = 0;
            this.nextCharacter = this.redrawInfo(g, this.currentCharacter, 0);
            this.automaticCycles = 200;
        }
        if (this.gamePhase == 4) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            --this.automaticCycles;
            if (this.automaticCycles < 1) {
                this.gamePhase = 3;
                CLGameCanvas.main.cmap.txtIndex -= 3;
                CLGameCanvas.main.cmap.finalIndex = 0;
                CLGameCanvas.main.cmap.progress_INGAME_dialog();
            }
            if (playerGameEvent == 160) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 5) {
            this.status = 0;
            this.nextCharacter = this.redrawInfo(g, this.currentCharacter, 0);
            this.automaticCycles = 200;
        }
        if (this.gamePhase == 6) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            --this.automaticCycles;
            if (this.automaticCycles < 1) {
                this.gamePhase = 5;
                CLGameCanvas.main.cmap.txtIndex -= 3;
                CLGameCanvas.main.cmap.finalIndex = 0;
                CLGameCanvas.main.cmap.progress_INGAME_dialog();
            }
            if (playerGameEvent == 162) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 7) {
            this.status = 0;
            this.nextCharacter = this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 8) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            CLGameCanvas.gameObjects.redWarlord.castlePower = GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.redWarlord.castleLevel];
            if (playerGameEvent == 16) {
                ++this.gamePhase;
                this.automaticCycles = 80;
            }
        }
        if (this.gamePhase == 9) {
            this.isActiveKeyboard = false;
            this.isObjectsActive = true;
            --this.automaticCycles;
            if (this.automaticCycles < 1) {
                ++this.gamePhase;
                this.isActiveKeyboard = false;
                this.isObjectsActive = false;
            }
        }
        if (this.gamePhase == 10) {
            this.isActiveKeyboard = false;
            this.isObjectsActive = false;
            this.status = 0;
            this.nextCharacter = this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 11) {
            ++this.gamePhase;
            CLGameCanvas.gameObjects.redWarlord.castlePower = GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.redWarlord.castleLevel] / 2;
            CLGameCanvas.gameObjects.blueWarlord.personOnSpike.powerPoints = 50;
        }
        if (this.gamePhase == 12) {
            this.isActiveKeyboard = false;
            this.isObjectsActive = true;
            if (CLGameCanvas.gameObjects.blueWarlord.personOnSpike != null) {
                this.moveViewport(CLGameCanvas.gameObjects.blueWarlord.personOnSpike.positionX - 88, 3);
            }
            this.testViewport();
            if (CLGameCanvas.gameObjects.redWarlord.castlePower < GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.redWarlord.castleLevel] >> 2) {
                ++this.gamePhase;
                this.isActiveKeyboard = false;
                this.isObjectsActive = false;
                CLGameCanvas.gameObjects.redWarlord.castlePower = 1;
                CLGameCanvas.gameObjects.blueWarlord.personOnSpike.isMortal = false;
            }
        }
        if (this.gamePhase == 13) {
            this.status = 0;
            this.nextCharacter = this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 14) {
            this.status = 0;
            this.nextCharacter = this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 15) {
            this.moveViewport(0, 15);
            this.testViewport();
            this.isObjectsActive = true;
            this.isActiveKeyboard = false;
            CLGameCanvas.gameObjects.redWarlord.castlePower = GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.redWarlord.castleLevel] / 2;
            if (viewport < 5) {
                ++this.gamePhase;
                gameObjects.getLiveObjects().removeAllElements();
            }
        }
        if (this.gamePhase == 16) {
            this.status = 0;
            this.nextCharacter = this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 17) {
            Piker piker = new Piker(12 - Piker.WIDTH[CLGameCanvas.gameObjects.blueWarlord.race] / 2, 213 - Piker.HEIGHT[CLGameCanvas.gameObjects.blueWarlord.race], 10, 0, true, gameObjects, this.imageTracker);
            gameObjects.addLiveObject(piker);
            Knight piker2 = new Knight(12 - Piker.WIDTH[CLGameCanvas.gameObjects.redWarlord.race] / 2, 213 - Piker.HEIGHT[CLGameCanvas.gameObjects.redWarlord.race], 10, 0, false, gameObjects, this.imageTracker);
            gameObjects.addLiveObject(piker2);
            this.isObjectsActive = true;
            this.isActiveKeyboard = false;
            ++this.gamePhase;
        }
        if (this.gamePhase == 18 && CLGameCanvas.gameObjects.blueWarlord.personOnSpike != null && CLGameCanvas.gameObjects.redWarlord.personOnSpike != null) {
            CLGameCanvas.gameObjects.blueWarlord.personOnSpike.positionX = (516 - 12) / 2 - 50;
            CLGameCanvas.gameObjects.redWarlord.personOnSpike.positionX = (516 - 12) / 2 + 50;
            CLGameCanvas.gameObjects.blueWarlord.personOnSpike.isMortal = false;
            CLGameCanvas.gameObjects.redWarlord.personOnSpike.isMortal = false;
            ++this.gamePhase;
            this.automaticCycles = 80;
        }
        if (this.gamePhase == 19) {
            this.isObjectsActive = true;
            this.isActiveKeyboard = false;
            if (CLGameCanvas.gameObjects.blueWarlord.personOnSpike != null && CLGameCanvas.gameObjects.redWarlord.personOnSpike != null) {
                CLGameCanvas.gameObjects.blueWarlord.personOnSpike.isMortal = true;
                CLGameCanvas.gameObjects.redWarlord.personOnSpike.isMortal = true;
                CLGameCanvas.gameObjects.blueWarlord.personOnSpike.hitPoints = 4;
                CLGameCanvas.gameObjects.redWarlord.personOnSpike.hitPoints = 15;
                CLGameCanvas.gameObjects.blueWarlord.personOnSpike.setLastDamage(CLGameCanvas.random(5));
                CLGameCanvas.gameObjects.redWarlord.personOnSpike.setLastDamage(CLGameCanvas.random(7));
                this.moveViewport(528 / 2 - 176 / 2 - 10, 10);
                this.testViewport();
            }
            --this.automaticCycles;
            if (this.automaticCycles < 1) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 20) {
            this.status = 0;
            this.nextCharacter = this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 21) {
            this.status = 0;
            this.nextCharacter = this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 22) {
            CLGameCanvas.gameObjects.redWarlord.personOnSpike.hitPoints = -1;
            this.isObjectsActive = true;
            ++this.gamePhase;
        }
        if (this.gamePhase == 23) {
            this.isObjectsActive = true;
            this.moveViewport(0, 4);
            this.testViewport();
            if (viewport < 5) {
                ++this.gamePhase;
                gameObjects.getLiveObjects().removeElement((Object)CLGameCanvas.gameObjects.blueWarlord.personOnSpike);
            }
        }
        if (this.gamePhase == 24) {
            this.status = 0;
            this.nextCharacter = this.redrawInfo(g, this.currentCharacter, 0);
            CLGameCanvas.gameObjects.redWarlord.castlePower = GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.redWarlord.castleLevel] / 2;
            this.automaticCycles = 200;
        }
        if (this.gamePhase == 25) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            CLGameCanvas.gameObjects.redWarlord.castlePower = GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.redWarlord.castleLevel] / 2;
            --this.automaticCycles;
            if (this.automaticCycles < 1) {
                this.gamePhase = 24;
                CLGameCanvas.main.cmap.txtIndex -= 3;
                CLGameCanvas.main.cmap.finalIndex = 0;
                CLGameCanvas.main.cmap.progress_INGAME_dialog();
            }
            if (playerGameEvent == 21) {
                ++this.gamePhase;
                this.automaticCycles = 80;
                CLGameCanvas.gameObjects.blueWarlord.unitsLevel[0] = 5;
                CLGameCanvas.gameObjects.blueWarlord.upgradeLevel[0] = 5;
            }
        }
        if (this.gamePhase == 26) {
            this.status = 0;
            this.nextCharacter = this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 27) {
            this.isAIActive = true;
        }
        if (this.gamePhase == 300) {
            CLGameCanvas.gameObjects.flyingTexts.removeAllElements();
            this.imageTracker.getIntroImage().draw(g, 0, 0, 20);
            g.setColor(255, 255, 0);
            g.setFont(Font.getFont((int)64, (int)1, (int)0));
            g.drawString(CLLocales.getString("VICTORY"), 88, 80, 17);
            g.setFont(Font.getFont((int)64, (int)0, (int)8));
            g.setColor(255, 255, 0);
            isAlive = false;
            result = 1;
            g.setColor(115, 135, 155);
            g.fillRoundRect(38, 203, 100, 15, 5, 5);
            g.setColor(255, 255, 0);
            this.draw2String(CLLocales.getString("CONTINUE"), 88, 205, 17, g);
        }
    }

    protected void redrawSceneMission2(Graphics g) {
        if (this.gamePhase == 1) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            this.automaticCycles = 200;
        }
        if (this.gamePhase == 2) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            --this.automaticCycles;
            if (this.automaticCycles < 1) {
                this.gamePhase = 1;
                CLGameCanvas.main.cmap.txtIndex -= 3;
                CLGameCanvas.main.cmap.finalIndex = 0;
                CLGameCanvas.main.cmap.progress_INGAME_dialog();
            }
            if (playerGameEvent == 163) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 3) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 4) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            CLGameCanvas.gameObjects.redWarlord.castlePower = GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.redWarlord.castleLevel];
            if (playerGameEvent == 170) {
                ++this.gamePhase;
                System.out.println("Doneid");
                CLGameCanvas.gameObjects.blueWarlord.tt_unit_max_levels[2] = 5;
            }
        }
        if (this.gamePhase == 5) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void redrawSceneMission9(Graphics g) {
        if (this.gamePhase == 1) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            this.automaticCycles = 300;
        }
        if (this.gamePhase == 2) {
            int ii = 0;
            while (ii < 4) {
                Piker piker2 = new Piker(516 - (10 - ii * 2) * 30, 213 - Piker.HEIGHT[CLGameCanvas.gameObjects.redWarlord.race], 10, 2, false, gameObjects, this.imageTracker);
                gameObjects.addLiveObject(piker2);
                Knight piker3 = new Knight(516 - (10 - ii * 2 + 1) * 30, 213 - Piker.HEIGHT[CLGameCanvas.gameObjects.redWarlord.race], 10, 6, false, gameObjects, this.imageTracker);
                gameObjects.addLiveObject(piker3);
                ++ii;
            }
            ++this.gamePhase;
            this.automaticCycles = 120;
        }
        if (this.gamePhase == 3) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            this.isAIActive = true;
            if (System.currentTimeMillis() - lastCHK > 1000L) {
                lastCHK = System.currentTimeMillis();
                --this.automaticCycles;
            }
            CLGameCanvas.gameObjects.redWarlord.castlePower = GameObjects.CASTLE_LEVEL_HP[CLGameCanvas.gameObjects.redWarlord.castleLevel];
            this.missionBGText = "Time remaining \n " + this.automaticCycles / 60 + ":" + this.automaticCycles % 60;
            if (this.automaticCycles < 1) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 4) {
            this.missionBGText = "";
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            this.isAIActive = true;
            ++this.gamePhase;
        }
        if (this.gamePhase == 5) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 6) {
            this.isObjectsActive = true;
            if (CLGameCanvas.gameObjects.blueWarlord.personOnSpike != null) {
                CLGameCanvas.gameObjects.blueWarlord.personOnSpike.isMortal = true;
                CLGameCanvas.gameObjects.blueWarlord.personOnSpike.hitPoints = -1;
            } else {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 7) {
            Rider piker3 = new Rider(17, 213 - Rider.HEIGHT[CLGameCanvas.gameObjects.redWarlord.race], 30, 2, true, gameObjects, this.imageTracker);
            gameObjects.addLiveObject(piker3);
            ++this.gamePhase;
            this.automaticCycles = 300;
        }
        if (this.gamePhase == 8) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            this.isAIActive = true;
            --this.automaticCycles;
            if (CLGameCanvas.gameObjects.blueWarlord.personOnSpike != null) {
                CLGameCanvas.gameObjects.blueWarlord.personOnSpike.isMortal = false;
                if (this.automaticCycles % 10 == 0 && CLGameCanvas.gameObjects.blueWarlord.personOnSpike.hitPoints > 2) {
                    --CLGameCanvas.gameObjects.blueWarlord.personOnSpike.hitPoints;
                }
            }
            if (CLGameCanvas.gameObjects.redWarlord.personOnSpike != null && this.automaticCycles % 10 == 0) {
                CLGameCanvas.gameObjects.redWarlord.personOnSpike.hitPoints -= XCanvas.next_random(2);
                CLGameCanvas.gameObjects.redWarlord.personOnSpike.powerPoints = 0;
            }
            if (this.automaticCycles < 1) {
                ++this.gamePhase;
                this.automaticCycles = 0;
            }
        }
        if (this.gamePhase == 9) {
            this.isActiveKeyboard = false;
            this.isObjectsActive = false;
            this.isAIActive = false;
            ++this.automaticCycles;
            if (this.automaticCycles > 90) {
                ++this.gamePhase;
            } else {
                g.setColor(0);
                int i = 0;
                while (i < XCanvas.HEIGHT + 40) {
                    int j = 0;
                    while (j < XCanvas.WIDTH + 40) {
                        if (i % 20 == 0 && j % 20 == 0) {
                            int s = this.automaticCycles / 3;
                            g.fillRect(j - s, i - s, s * 2, s * 2);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if (this.gamePhase == 10) {
            CLGameCanvas.removeAllLiveObjects();
            main.stopGame(1);
        }
    }

    protected void redrawSceneMission17(Graphics g) {
        if (this.gamePhase == 1) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 2 && this.bossHP < 200) {
            ++this.gamePhase;
        }
        if (this.gamePhase == 3) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 4 && this.bossHP < 20) {
            ++this.gamePhase;
        }
        if (this.gamePhase == 5) {
            CLGameCanvas.removeAllLiveObjects();
            main.stopGame(1);
        }
    }

    protected void redrawSceneMission18(Graphics g) {
        if (this.gamePhase == 1) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            byte[] byArray = new byte[3];
            byArray[1] = 1;
            IngameMenu.fixedCommands(byArray);
        }
        if (this.gamePhase == 2) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            if (playerGameEvent == 21) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 3) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            byte[] byArray = new byte[3];
            byArray[1] = 1;
            byArray[2] = 1;
            IngameMenu.fixedCommands(byArray);
        }
        if (this.gamePhase == 4) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            if (playerGameEvent == 110) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 5) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            byte[] byArray = new byte[3];
            byArray[1] = 1;
            byArray[2] = 5;
            IngameMenu.fixedCommands(byArray);
        }
        if (this.gamePhase == 6) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            this.isAIActive = true;
            if (playerGameEvent == 111) {
                ++this.gamePhase;
                Knight piker3 = new Knight(252, 213 - Piker.HEIGHT[CLGameCanvas.gameObjects.redWarlord.race], 10, 6, false, gameObjects, this.imageTracker);
                gameObjects.addLiveObject(piker3);
                this.automaticCycles = 50;
            }
        }
        if (this.gamePhase == 7) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 8) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            this.isAIActive = true;
            --this.automaticCycles;
            if (this.automaticCycles < 1) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 9) {
            this.status = 0;
            this.isAIActive = false;
            this.redrawInfo(g, this.currentCharacter, 0);
            this.automaticCycles = 560;
        }
        if (this.gamePhase == 10) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            this.isAIActive = true;
            --this.automaticCycles;
            if (this.automaticCycles < 1) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 11) {
            this.isAIActive = false;
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            this.automaticCycles = 160;
        }
        if (this.gamePhase == 12) {
            CLGameCanvas.gameObjects.redWarlord.castlePower = 0;
            CLGameCanvas.gameObjects.isBossAlive[1] = false;
        }
    }

    protected void redrawSceneMission19(Graphics g) {
        if (this.gamePhase == 1) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            byte[] byArray = new byte[3];
            byArray[1] = 2;
            IngameMenu.fixedCommands(byArray);
        }
        if (this.gamePhase == 2) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            if (playerGameEvent == 170) {
                ++this.gamePhase;
                this.castleImmortal = true;
            }
        }
        if (this.gamePhase == 3) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 4) {
            ++this.gamePhase;
        }
        if (this.gamePhase == 5) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            byte[] byArray = new byte[3];
            byArray[1] = 2;
            byArray[2] = 1;
            IngameMenu.fixedCommands(byArray);
        }
        if (this.gamePhase == 6) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            if (playerGameEvent == 171) {
                ++this.gamePhase;
            }
            this.automaticCycles = 0;
        }
        if (this.gamePhase == 7) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            byte[] byArray = new byte[4];
            byArray[2] = 1;
            byArray[3] = 3;
            IngameMenu.fixedCommands(byArray);
        }
        if (this.gamePhase == 8) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            if (playerGameEvent == 17) {
                System.out.println("Built rider " + CLGameCanvas.gameObjects.blueWarlord.unitsCounts[1]);
                this.automaticCycles += CLGameCanvas.gameObjects.blueWarlord.unitsCounts[1];
                if (this.automaticCycles >= 3) {
                    ++this.gamePhase;
                }
                playerGameEvent = 0;
            }
        }
        if (this.gamePhase == 9) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
        }
        if (this.gamePhase == 10) {
            ++this.gamePhase;
        }
        if (this.gamePhase == 11) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            byte[] byArray = new byte[3];
            byArray[1] = 2;
            byArray[2] = 1;
            IngameMenu.fixedCommands(byArray);
        }
        if (this.gamePhase == 12) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            if (playerGameEvent == 171) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 13) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            byte[] byArray = new byte[3];
            byArray[1] = 2;
            byArray[2] = 1;
            IngameMenu.fixedCommands(byArray);
        }
        if (this.gamePhase == 14) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            if (playerGameEvent == 171) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 15) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            byte[] byArray = new byte[3];
            byArray[1] = 2;
            byArray[2] = 1;
            IngameMenu.fixedCommands(byArray);
        }
        if (this.gamePhase == 16) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            if (playerGameEvent == 171) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 17) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            byte[] byArray = new byte[3];
            byArray[1] = 2;
            byArray[2] = 1;
            IngameMenu.fixedCommands(byArray);
        }
        if (this.gamePhase == 18) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            if (playerGameEvent == 171) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 19) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            this.castleImmortal = false;
        }
        if (this.castleImmortal) {
            CLGameCanvas.gameObjects.redWarlord.castlePower = 500;
        }
    }

    protected void redrawSceneMission20(Graphics g) {
        Knight piker3;
        if (this.castleImmortal) {
            CLGameCanvas.gameObjects.redWarlord.castlePower = 500;
        }
        if (this.gamePhase == 1) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            byte[] byArray = new byte[2];
            byArray[0] = 1;
            IngameMenu.fixedCommands(byArray);
        }
        if (this.gamePhase == 2) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            if (CLGameCanvas.gameObjects.blueWarlord.unitsCounts[1] < 5) {
                piker3 = new Knight(12 - Piker.WIDTH[CLGameCanvas.gameObjects.redWarlord.race], 213 - Piker.HEIGHT[CLGameCanvas.gameObjects.redWarlord.race], 10, 6, true, gameObjects, this.imageTracker);
                gameObjects.addLiveObject(piker3);
                CLGameCanvas.gameObjects.blueWarlord.spells = new int[]{23};
                CLGameCanvas.gameObjects.blueWarlord.mana = 1500;
                CLGameCanvas.gameObjects.blueWarlord.intelligence = 2;
                this.castleImmortal = true;
            }
            if (playerGameEvent == 120) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 3) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            this.automaticCycles = 40;
        }
        if (this.gamePhase == 4) {
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
            --this.automaticCycles;
            if (this.automaticCycles < 1) {
                int i = 0;
                while (i < 5) {
                    CLGameCanvas.gameObjects.blueWarlord.getClass();
                    ++i;
                }
            }
            if (CLGameCanvas.gameObjects.redWarlord.unitsCounts[1] < 5) {
                piker3 = new Knight(12 - Piker.WIDTH[CLGameCanvas.gameObjects.redWarlord.race], 213 - Piker.HEIGHT[CLGameCanvas.gameObjects.redWarlord.race], 10, 6, true, gameObjects, this.imageTracker);
                gameObjects.addLiveObject(piker3);
                piker3 = new Knight(516 + Piker.WIDTH[CLGameCanvas.gameObjects.redWarlord.race], 213 - Piker.HEIGHT[CLGameCanvas.gameObjects.redWarlord.race], 10, 6, false, gameObjects, this.imageTracker);
                gameObjects.addLiveObject(piker3);
                this.castleImmortal = true;
            }
            CLGameCanvas.gameObjects.blueWarlord.spells = new int[]{13};
            CLGameCanvas.gameObjects.blueWarlord.mana = 1500;
            this.right_menu.fillMenu((byte)1);
            if (playerGameEvent == 120) {
                ++this.gamePhase;
            }
        }
        if (this.gamePhase == 5) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            this.automaticCycles = 100;
        }
        if (this.gamePhase == 6) {
            --this.automaticCycles;
            if (this.automaticCycles < 1) {
                ++this.gamePhase;
            }
            this.isActiveKeyboard = true;
            this.isObjectsActive = true;
        }
        if (this.gamePhase == 7) {
            this.castleImmortal = false;
            CLGameCanvas.gameObjects.redWarlord.castlePower = 0;
        }
    }

    protected void redrawSceneMission(Graphics g, int mission) {
        if (this.gamePhase == 1) {
            this.status = 0;
            this.redrawInfo(g, this.currentCharacter, 0);
            this.automaticCycles = 300;
        }
    }

    public void setAlive(boolean flag) {
        isAlive = flag;
    }

    public int getTimeDelay() {
        return this.timeDelay;
    }

    public void setTimeDelay(int timeDelay) {
        this.timeDelay = timeDelay;
    }

    public boolean castleDefence(boolean ownedByPlayer) {
        if (ownedByPlayer) {
            if (CLGameCanvas.gameObjects.playerW.stones < GameObjects.BUILDINGS_PRICES[1][4]) {
                this.addMessage(CLLocales.getString("MESSAGE_NO_RESOURCES"));
                return false;
            }
            CLGameCanvas.gameObjects.playerW.stones -= GameObjects.BUILDINGS_PRICES[1][4];
            gameObjects.addSpell(new Spell(1, CLGameCanvas.gameObjects.playerW == CLGameCanvas.gameObjects.blueWarlord, CLGameCanvas.gameObjects.playerW.intelligence - 1, gameObjects, WarlordsCastles.imageTracker));
            playerGameEvent = 36;
        }
        return true;
    }

    public boolean addUnit(int command, boolean ownedByPlayer, int num) {
        if (ownedByPlayer) {
            boolean success = false;
            switch (command) {
                case 11: {
                    success = CLGameCanvas.gameObjects.playerW.addProduct((byte)0, (byte)0, num);
                    break;
                }
                case 12: {
                    success = CLGameCanvas.gameObjects.playerW.addProduct((byte)0, (byte)1, num);
                    break;
                }
                case 13: {
                    success = CLGameCanvas.gameObjects.playerW.addProduct((byte)0, (byte)2, 1);
                    break;
                }
                case 15: {
                    success = CLGameCanvas.gameObjects.playerW.addProduct((byte)0, (byte)3, num);
                }
            }
            if (!success) {
                this.addMessage(CLLocales.getString("MESSAGE_NO_RESOURCES"));
            } else {
                playerGameEvent = command;
            }
            return success;
        }
        return false;
    }

    public boolean addResource(int chance) {
        int x = CLGameCanvas.random(this.resourceRightBorder - this.resourceLeftBorder) + this.resourceLeftBorder;
        int y = 73;
        if (GameObject.getChance(chance)) {
            gameObjects.addLiveObject(new Resource(x, y, gameObjects, this.imageTracker));
            return true;
        }
        return false;
    }

    public boolean addCannon(boolean ownedByPlayer) {
        if (ownedByPlayer) {
            boolean success = CLGameCanvas.gameObjects.playerW.addProduct((byte)0, (byte)4, 1);
            if (!success) {
                this.addMessage(CLLocales.getString("MESSAGE_NO_RESOURCES"));
            } else {
                playerGameEvent = 14;
                CLGameCanvas.gameObjects.playerW.unitsCounts[4] = CLGameCanvas.gameObjects.playerW.unitsCounts[4] + 1;
            }
            return success;
        }
        return false;
    }

    public boolean addSpell(int type, boolean ownedByPlayer) {
        int actualDamage = 0;
        if (ownedByPlayer && CLGameCanvas.gameObjects.playerW.intelligence < 1) {
            return false;
        }
        if (!ownedByPlayer && CLGameCanvas.gameObjects.enemyW.intelligence < 1) {
            return false;
        }
        Warlord actualWarlord = ownedByPlayer ? CLGameCanvas.gameObjects.playerW : CLGameCanvas.gameObjects.enemyW;
        int price = actualWarlord.getSpellPriceByType(type);
        if (ownedByPlayer) {
            if (CLGameCanvas.gameObjects.enemyW.hasEnchantmentType(10) && type != 1) {
                this.addMessage(CLLocales.getString("MESSAGE_NO_SPELL"));
                return false;
            }
            if (CLGameCanvas.gameObjects.playerW.mana >= price) {
                if (CLGameCanvas.gameObjects.playerW.hasAbility(32) && type != 1) {
                    if (GameObject.getChance(Warlord.getPowermageChance(CLGameCanvas.gameObjects.playerW.level - 1))) {
                        int armDamage = GameObjects.ALL_SPELLS_CHAR[(CLGameCanvas.gameObjects.playerW.intelligence - 1) * 24 + 2][GameObjects.TARGETS_POINTER];
                        int powermageArmDamage = armDamage * Warlord.POWERMAGE_ARM_PERCENTAGE / 100;
                        gameObjects.addSpell(new Spell(type, CLGameCanvas.gameObjects.playerW == CLGameCanvas.gameObjects.blueWarlord, CLGameCanvas.gameObjects.playerW.intelligence - 1, gameObjects, this.imageTracker));
                        CLGameCanvas.gameObjects.enemyW.castlePower -= 5 * powermageArmDamage;
                        gameObjects.addFlyingText("-" + 5 * powermageArmDamage, 10, 516, 113, 1);
                        int i = 0;
                        while (i < gameObjects.getLiveObjects().size()) {
                            GameObject temp = (GameObject)((Object)gameObjects.getLiveObjects().elementAt(i));
                            if (temp instanceof Person && temp.isOwnedByBlue() != (CLGameCanvas.gameObjects.playerW == CLGameCanvas.gameObjects.blueWarlord)) {
                                actualDamage = temp.type == 5 ? 5 * powermageArmDamage : powermageArmDamage;
                                ((Person)temp).subHitPoints(actualDamage);
                                gameObjects.addFlyingText("-" + actualDamage, 10, ((Person)temp).getPositionX(), ((Person)temp).getPositionY() - 5, 1);
                            }
                            ++i;
                        }
                    } else {
                        this.addMessage(CLLocales.getString("MESSAGE_SPELL_FAILED"));
                    }
                } else {
                    gameObjects.addSpell(new Spell(type, CLGameCanvas.gameObjects.playerW == CLGameCanvas.gameObjects.blueWarlord, CLGameCanvas.gameObjects.playerW.intelligence - 1, gameObjects, this.imageTracker));
                }
                CLGameCanvas.gameObjects.playerW.mana -= price;
                if (CLGameCanvas.gameObjects.playerW.hasAbility(8)) {
                    CLGameCanvas.gameObjects.playerW.addStone(price / 6);
                    CLGameCanvas.gameObjects.playerW.addGold(price / 6);
                }
                if (CLGameCanvas.gameObjects.playerW.hasAbility(16)) {
                    CLGameCanvas.gameObjects.playerW.createUnit(0, true);
                }
                playerGameEvent = 120 + type;
                return true;
            }
            this.addMessage(CLLocales.getString("MESSAGE_NO_MANA"));
            return false;
        }
        if (CLGameCanvas.gameObjects.playerW.hasEnchantmentType(10) && type != 1) {
            return false;
        }
        if (CLGameCanvas.gameObjects.enemyW.mana >= price) {
            if (CLGameCanvas.gameObjects.enemyW.hasAbility(32) && type != 1) {
                if (GameObject.getChance(Warlord.getPowermageChance(CLGameCanvas.gameObjects.enemyW.level - 1))) {
                    int armDamage = GameObjects.ALL_SPELLS_CHAR[(CLGameCanvas.gameObjects.enemyW.intelligence - 1) * 24 + 2][GameObjects.TARGETS_POINTER];
                    int powermageArmDamage = armDamage * Warlord.POWERMAGE_ARM_PERCENTAGE / 100;
                    gameObjects.addSpell(new Spell(type, CLGameCanvas.gameObjects.enemyW == CLGameCanvas.gameObjects.blueWarlord, CLGameCanvas.gameObjects.enemyW.intelligence - 1, gameObjects, this.imageTracker));
                    CLGameCanvas.gameObjects.playerW.castlePower -= 5 * powermageArmDamage;
                    gameObjects.addFlyingText("-" + 5 * powermageArmDamage, 10, 12, 113, 1);
                    int i = 0;
                    while (i < gameObjects.getLiveObjects().size()) {
                        GameObject temp = (GameObject)((Object)gameObjects.getLiveObjects().elementAt(i));
                        if (temp instanceof Person && temp.isOwnedByBlue() == (CLGameCanvas.gameObjects.playerW == CLGameCanvas.gameObjects.blueWarlord)) {
                            actualDamage = temp.type == 5 ? 5 * powermageArmDamage : powermageArmDamage;
                            ((Person)temp).subHitPoints(actualDamage);
                            gameObjects.addFlyingText("-" + actualDamage, 10, ((Person)temp).getPositionX(), ((Person)temp).getPositionY() - 5, 1);
                        }
                        ++i;
                    }
                }
            } else {
                gameObjects.addSpell(new Spell(type, CLGameCanvas.gameObjects.enemyW == CLGameCanvas.gameObjects.blueWarlord, CLGameCanvas.gameObjects.enemyW.intelligence - 1, gameObjects, this.imageTracker));
            }
            CLGameCanvas.gameObjects.enemyW.mana -= price;
            if (CLGameCanvas.gameObjects.enemyW.hasAbility(8)) {
                CLGameCanvas.gameObjects.enemyW.addStone(price / 6);
                CLGameCanvas.gameObjects.enemyW.addGold(price / 6);
            }
            if (CLGameCanvas.gameObjects.enemyW.hasAbility(16)) {
                CLGameCanvas.gameObjects.enemyW.createUnit(0, true);
            }
            return true;
        }
        return false;
    }

    public boolean addBuilding(int type, boolean ownedByPlayer) {
        if (ownedByPlayer) {
            boolean success = true;
            if (type == 5 && (CLGameCanvas.gameObjects.playerW.unitsCounts[5] > 0 || CLGameCanvas.gameObjects.playerW.isInProduction((byte)2, (byte)3) || !CLGameCanvas.gameObjects.playerW.canBuildWall || CLGameCanvas.gameObjects.enemyW.besiegers > 0)) {
                success = false;
            }
            if (success) {
                success = CLGameCanvas.gameObjects.playerW.addProduct((byte)2, (byte)type, 1);
            }
            if (!success) {
                this.addMessage(CLLocales.getString("MESSAGE_NO_RESOURCES"));
            } else if (type == 5) {
                playerGameEvent = 34;
            }
            return success;
        }
        return false;
    }

    public boolean upgradeCastle(boolean ownedByPlayer) {
        if (ownedByPlayer) {
            if (CLGameCanvas.gameObjects.blueWarlord.castleLevel < 2) {
                if (CLGameCanvas.gameObjects.blueWarlord.money < GameObjects.BUILDINGS_PRICES[0][6] || CLGameCanvas.gameObjects.blueWarlord.stones < GameObjects.BUILDINGS_PRICES[1][6]) {
                    this.addMessage(CLLocales.getString("MESSAGE_NO_RESOURCES"));
                    return false;
                }
                ++CLGameCanvas.gameObjects.blueWarlord.castleLevel;
                CLGameCanvas.gameObjects.blueWarlord.castlePower += CLGameCanvas.gameObjects.blueWarlord.castleLevel * 500;
                CLGameCanvas.gameObjects.blueWarlord.money -= GameObjects.BUILDINGS_PRICES[0][6];
                CLGameCanvas.gameObjects.blueWarlord.stones -= GameObjects.BUILDINGS_PRICES[1][6];
                blueStronghold = this.setupStronghold(CLGameCanvas.gameObjects.blueWarlord.castleLevel);
                this.addMessage(String.valueOf(CLLocales.getString("PROTECTOR")) + ": " + CLLocales.getString("MESSAGE_CASTLE_UPGRADED"));
                playerGameEvent = 5;
                return true;
            }
            this.addMessage(String.valueOf(CLLocales.getString("PROTECTOR")) + ": " + CLLocales.getString("MESSAGE_CASTLE_DONE"));
            return true;
        }
        if (CLGameCanvas.gameObjects.redWarlord.money >= GameObjects.BUILDINGS_PRICES[0][6] && CLGameCanvas.gameObjects.redWarlord.stones >= GameObjects.BUILDINGS_PRICES[1][6] && CLGameCanvas.gameObjects.redWarlord.castleLevel < 2) {
            ++CLGameCanvas.gameObjects.redWarlord.castleLevel;
            CLGameCanvas.gameObjects.redWarlord.castlePower += CLGameCanvas.gameObjects.redWarlord.castleLevel * 500;
            CLGameCanvas.gameObjects.redWarlord.money -= GameObjects.BUILDINGS_PRICES[0][6];
            CLGameCanvas.gameObjects.redWarlord.stones -= GameObjects.BUILDINGS_PRICES[1][6];
            redStronghold = this.setupStronghold(CLGameCanvas.gameObjects.redWarlord.castleLevel);
            return true;
        }
        return false;
    }

    public boolean upgradeUnit(int type, boolean ownedByPlayer) {
        if (ownedByPlayer) {
            boolean success = CLGameCanvas.gameObjects.playerW.addProduct((byte)1, (byte)type, 1);
            if (success) {
                switch (type) {
                    case 1: {
                        playerGameEvent = 41;
                        break;
                    }
                    case 2: {
                        playerGameEvent = 42;
                        break;
                    }
                    case 3: {
                        playerGameEvent = 43;
                        break;
                    }
                    case 4: {
                        playerGameEvent = 45;
                        break;
                    }
                    case 5: {
                        playerGameEvent = 44;
                    }
                }
            } else {
                this.addMessage(CLLocales.getString("MESSAGE_NO_RESOURCES"));
            }
            return success;
        }
        return CLGameCanvas.gameObjects.redWarlord.upgradeUnit(type);
    }

    public boolean razeWall(boolean ownedByBlue) {
        int i = 0;
        while (i < gameObjects.getLiveObjects().size()) {
            GameObject temp = (GameObject)((Object)gameObjects.getLiveObjects().elementAt(i));
            if (temp instanceof Wall && temp.isOwnedByBlue() == ownedByBlue) {
                ((Wall)temp).setHitPoints(0);
            }
            ++i;
        }
        return true;
    }

    public void addMessage(String news) {
        int size = this.message.capacity();
        if (size > 0) {
            this.message.delete(0, this.message.capacity() - 1);
        }
        this.message.append(news);
        this.message_bytes = CLImageTracker.font_small.splitText(GameObjects.convertToByteString(news, false), XCanvas.WIDTH);
        this.messageDelay = 20;
    }

    public GameObjects getGameObjects() {
        return gameObjects;
    }

    public boolean makeCommand(int command, int param) {
        switch (command) {
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                this.addUnit(command, true, param);
                break;
            }
            case 14: {
                if (CLGameCanvas.gameObjects.level > 4) {
                    this.addCannon(true);
                }
                this.menuLevel = 1;
                break;
            }
            case 41: {
                this.upgradeUnit(0, true);
                this.menuLevel = 1;
                break;
            }
            case 42: {
                if (CLGameCanvas.gameObjects.level > 1) {
                    this.upgradeUnit(1, true);
                }
                this.menuLevel = 1;
                break;
            }
            case 43: {
                if (CLGameCanvas.gameObjects.level > 2) {
                    this.upgradeUnit(2, true);
                }
                this.menuLevel = 1;
                break;
            }
            case 45: {
                if (CLGameCanvas.gameObjects.level > 3) {
                    this.upgradeUnit(3, true);
                }
                this.menuLevel = 1;
                break;
            }
            case 44: {
                if (CLGameCanvas.gameObjects.level > 4) {
                    this.upgradeUnit(4, true);
                }
                this.menuLevel = 1;
                break;
            }
            case 31: {
                this.addBuilding(0, true);
                this.menuLevel = 1;
                break;
            }
            case 32: {
                this.addBuilding(1, true);
                this.menuLevel = 1;
                break;
            }
            case 33: {
                this.addBuilding(2, true);
                this.menuLevel = 1;
                break;
            }
            case 35: {
                this.addBuilding(3, true);
                this.menuLevel = 1;
                break;
            }
            case 34: {
                this.addBuilding(5, true);
                this.menuLevel = 1;
                break;
            }
            case 37: {
                this.razeWall(CLGameCanvas.gameObjects.blueWarlord == CLGameCanvas.gameObjects.playerW);
                break;
            }
            case 5: {
                this.upgradeCastle(true);
                this.menuLevel = 1;
                break;
            }
            case 36: {
                this.castleDefence(true);
                this.menuLevel = 1;
                break;
            }
            case 120: {
                return this.addSpell(param, true);
            }
            case 105: {
                gameMode = 5;
                this.openY = 0;
                break;
            }
            case 104: {
                if (gameMode == 0) {
                    this.restartCampaign();
                    System.out.println("Restarting...");
                    break;
                }
                this.restartSkirmish();
                break;
            }
            default: {
                this.menuLevel = 1;
                playerGameEvent = 100;
            }
        }
        this.actualFocus = 1;
        return true;
    }

    public void playMusic() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/music/ingame.mid");
            audioplayer = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            audioplayer.prefetch();
            audioplayer.setLoopCount(-1);
            audioplayer.start();
        }
        catch (Exception ex) {
            main.exitGame();
        }
    }

    public static void stopMusic() {
        audioplayer.close();
    }

    public boolean loadDialogFile(String filename) {
        InputStream is = null;
        filename = String.valueOf(filename) + ".dat";
        if (this.dialogs != null) {
            this.dialogs.clear();
        }
        is = this.getClass().getResourceAsStream(filename);
        this.dialogs = CLCampaignMap.parseDialog(is);
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    protected void keyPressed(int key, int ga) {
        block44: {
            block43: {
                if (this.status != 0 || !isAlive || gameMode == 2) break block43;
                if (ga == 8) {
                    this.status = 1;
                    this.actualPosition = 0;
                    playerGameEvent = 22;
                }
                if (ga == 1) {
                    --this.actualPosition;
                    playerGameEvent = 24;
                }
                if (ga == 6) {
                    ++this.actualPosition;
                    playerGameEvent = 22;
                }
                if (key == -7) {
                    ((Object)((Object)main)).getClass();
                    if (CLCampaignMap.skippable) {
                        ++this.actualPosition;
                        playerGameEvent = 23;
                    }
                }
                break block44;
            }
            if (this.status != 1 || !isAlive) break block44;
            block0 : switch (gameMode) {
                case 0: 
                case 1: {
                    if (this.left_menu.active) {
                        if (key == -7) {
                            this.left_menu.active = false;
                            this.right_menu.activate((byte)1);
                            break;
                        }
                        this.left_menu.handleKeyPress(key, ga);
                        break;
                    }
                    if (this.right_menu.active) {
                        if (key == -6) {
                            this.right_menu.active = false;
                            this.left_menu.activate((byte)0);
                            break;
                        }
                        this.right_menu.handleKeyPress(key, ga);
                        break;
                    }
                    if (key == -6) {
                        playerGameEvent = 160;
                        this.left_menu.activate((byte)0);
                        ticks_till_step = MAKE_STEP_WHILE_IN_MENU;
                    } else if (key == -7) {
                        this.right_menu.activate((byte)1);
                        ticks_till_step = MAKE_STEP_WHILE_IN_MENU;
                    }
                    if (ga == 2 && (viewport -= this.viewportSpeed) < 0) {
                        viewport = 0;
                    }
                    if (ga == 5 && (viewport += this.viewportSpeed) > 352) {
                        viewport = 352;
                    }
                    if (key == 48) {
                        CLGameCanvas.gameObjects.redWarlord.castlePower = 0;
                        CLGameCanvas.gameObjects.isBossAlive[1] = false;
                    }
                    if (key == 51) {
                        CLGameCanvas.gameObjects.redWarlord.castlePower -= 25;
                        System.out.println(CLGameCanvas.gameObjects.redWarlord.castlePower);
                    }
                    if (key == 42) {
                        if (CLGameCanvas.gameObjects.redWarlord.supremacy == Warlord.EASYMACY) {
                            CLGameCanvas.gameObjects.redWarlord.supremacy = Warlord.NORMALMACY;
                        } else if (CLGameCanvas.gameObjects.redWarlord.supremacy == Warlord.NORMALMACY) {
                            CLGameCanvas.gameObjects.redWarlord.supremacy = Warlord.HARDMACY;
                        } else if (CLGameCanvas.gameObjects.redWarlord.supremacy == Warlord.HARDMACY) {
                            CLGameCanvas.gameObjects.redWarlord.supremacy = Warlord.EASYMACY;
                        }
                        this.addMessage("Diff changed to " + CLGameCanvas.gameObjects.redWarlord.supremacy + "pct.");
                    }
                    if (key != 35) break;
                    if (buildings_stats_time == 0) {
                        buildings_stats_time = 3000 / XCanvas.DT;
                        break;
                    }
                    buildings_stats_time = 0;
                    break;
                }
                case 5: {
                    System.out.println(ga);
                    if (ga != 8) break;
                    if (isCampaign) {
                        gameMode = 0;
                        switch (this.objectivesContinueType) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                this.status = 1;
                                this.gamePhase = -1;
                                this.openY = 0;
                                this.isActiveKeyboard = true;
                                this.isObjectsActive = true;
                                this.isAIActive = true;
                            }
                        }
                        break;
                    }
                    gameMode = 1;
                    break;
                }
                case 4: {
                    if (this.victory_state == 2 && ga == 8) {
                        this.initResults();
                        gameMode = 3;
                    }
                    if (key != 48) break;
                    this.startVictoryDefeatState();
                    break;
                }
                case 3: {
                    switch (ga) {
                        case 6: {
                            this.result_offset -= CLImageTracker.portraits.getHeight() / 3;
                            if (this.result_offset < this.result_offset_min) {
                                this.result_offset = this.result_offset_min;
                                break block0;
                            }
                            break block44;
                        }
                        case 1: {
                            this.result_offset += CLImageTracker.portraits.getHeight() / 3;
                            if (this.result_offset > 0) {
                                this.result_offset = 0;
                                break block0;
                            }
                            break block44;
                        }
                        case 8: {
                            this.imageTracker.resetResultImages();
                            CLGameCanvas.exitToMenu();
                        }
                    }
                }
            }
        }
        if (gameMode == 2 && ga == 8) {
            gameMode = nextMode;
        }
    }

    public static void exitToMenu() {
        isAlive = false;
        if (LogoCanvas.getSoundSetting() == 1) {
            CLGameCanvas.stopMusic();
        }
        CLGameCanvas.removeAllLiveObjects();
        try {
            if (actualMission > 17) {
                main.stopGame(-1);
            } else {
                main.stopGame(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void keyReleased(int key, int ga) {
        if (this.isActiveKeyboard && this.status == 1 && isAlive) {
            switch (key) {
                case 55: {
                    this.viewportSpeed = 10;
                    break;
                }
                case 56: {
                    break;
                }
                case 57: {
                    this.viewportSpeed = 10;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyRepeated(int ga) {
        block16: {
            if (!this.isActiveKeyboard) return;
            switch (gameMode) {
                case 0: 
                case 1: {
                    if (this.status != 1 || !isAlive || this.left_menu.active || this.right_menu.active) return;
                    switch (ga) {
                        case 2: {
                            if ((viewport -= this.viewportSpeed) < 0) {
                                viewport = 0;
                            }
                            if (this.viewportSpeed >= 30) break;
                            ++this.viewportSpeed;
                            return;
                        }
                        case 5: {
                            if ((viewport += this.viewportSpeed) > 352) {
                                viewport = 352;
                            }
                            if (this.viewportSpeed >= 30) break;
                            ++this.viewportSpeed;
                        }
                    }
                    return;
                }
                case 3: {
                    switch (ga) {
                        case 6: {
                            this.result_offset -= CLImageTracker.portraits.getHeight() / 3;
                            if (this.result_offset >= this.result_offset_min) return;
                            this.result_offset = this.result_offset_min;
                            break block16;
                        }
                        case 1: {
                            this.result_offset += CLImageTracker.portraits.getHeight() / 3;
                            if (this.result_offset <= 0) return;
                            this.result_offset = 0;
                        }
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final int drawInstructions(int ptx, int ty, StringBuffer dialog, int width, int height, int startChar, CLImageTracker tracker, Graphics gd, int rpgCharacter, StringBuffer dialog_sub) {
        mainFont = Font.getFont((int)0, (int)0, (int)8);
        gd.setClip(0, 0, 528, 220);
        topY = ty + 4;
        tx = ptx;
        lx = dialog.length() - 1;
        nextword = new char[32];
        realword = new char[32];
        count = i = startChar;
        done = false;
        refreshPortrait = true;
        ** GOTO lbl70
        {
            ++i;
            do {
                if (i < lx && dialog.charAt(i) != ' ' && dialog.charAt(i) != ';' && dialog.charAt(i) != '%') continue block0;
                if (dialog.charAt(i) != ';' && dialog.charAt(i) != '%' && i <= lx) {
                    ++i;
                }
                dialog.getChars(count, i, nextword, 0);
                pp = 0;
                while (pp < 32) {
                    realword[pp] = 32;
                    ++pp;
                }
                findex = dialog_sub.length();
                if (count < findex) {
                    if (findex < i) {
                        dialog.getChars(count, findex, realword, 0);
                    } else {
                        dialog.getChars(count, i, realword, 0);
                    }
                }
                if (nextword[0] == '#') {
                    t_str = "";
                    k1 = 1;
                    while (k1 < i - count - 1) {
                        t_str = String.valueOf(t_str) + nextword[k1];
                        ++k1;
                    }
                    CLCampaignMap.rpgCharacter = (byte)Integer.parseInt(t_str);
                    if (rpgCharacter % 12 != CLCampaignMap.rpgCharacter) {
                        rpgCharacter = CLCampaignMap.rpgCharacter;
                        refreshPortrait = true;
                    }
                } else {
                    if (refreshPortrait && rpgCharacter >= 0) {
                        imgIndex = rpgCharacter;
                        if (rpgCharacter == 0 || rpgCharacter % 12 == 0) {
                            CLImageTracker.Im_portraits.drawSubImage(gd, ptx, ty - 4 - 54, imgIndex / 12, imgIndex % 12);
                        } else {
                            CLImageTracker.Im_portraits.drawSubImage(gd, ptx + 90, ty - 4 - 54, imgIndex / 12, imgIndex % 12);
                        }
                        refreshPortrait = false;
                    }
                    if (tx + mainFont.charsWidth(nextword, 0, i - count) > ptx + width) {
                        ty += mainFont.getHeight();
                        tx = ptx;
                    }
                    if (ty + mainFont.getHeight() <= topY + height) {
                        gd.setFont(mainFont);
                        gd.drawChars(realword, 0, i - count, tx, ty, 20);
                        tx += mainFont.charsWidth(nextword, 0, i - count);
                    } else {
                        i = count - 1;
                        done = true;
                    }
                }
                if (i < lx && dialog.charAt(i) == ';') {
                    tx = ptx;
                    ty += mainFont.getHeight();
                    if (i < lx) {
                        ++i;
                    }
                }
                if (i < lx && dialog.charAt(i) == '%') {
                    if (i < lx) {
                        ++i;
                    }
                    done = true;
                }
                if (ty + mainFont.getHeight() > topY + height || i >= lx) {
                    done = true;
                }
                count = i;
lbl70:
                // 2 sources

            } while (!done);
        }
        if (i >= lx) {
            return -1;
        }
        return i;
    }

    /*
     * Unable to fully structure code
     */
    public static final int getNextWordIndex(StringBuffer dialog, int width, int height, int startChar) {
        mainFont = Font.getFont((int)0, (int)0, (int)8);
        ptx = 1;
        ty = 1;
        topY = ty + 4;
        tx = ptx;
        lx = dialog.length() - 1;
        nextword = new char[32];
        count = i = startChar;
        done = false;
        ** GOTO lbl38
        {
            ++i;
            do {
                if (i < lx && dialog.charAt(i) != ' ' && dialog.charAt(i) != ';' && dialog.charAt(i) != '%') continue block0;
                if (dialog.charAt(i) != ';' && dialog.charAt(i) != '%' && i <= lx) {
                    ++i;
                }
                dialog.getChars(count, i, nextword, 0);
                if (nextword[0] != '#') {
                    if (tx + mainFont.charsWidth(nextword, 0, i - count) > ptx + width) {
                        ty += mainFont.getHeight();
                        tx = ptx;
                    }
                    if (ty + mainFont.getHeight() <= topY + height) {
                        tx += mainFont.charsWidth(nextword, 0, i - count);
                    } else {
                        i = count - 1;
                        done = true;
                    }
                }
                if (i < lx && dialog.charAt(i) == ';') {
                    tx = ptx;
                    ty += mainFont.getHeight();
                    if (i < lx) {
                        ++i;
                    }
                }
                if (i < lx && dialog.charAt(i) == '%') {
                    if (i < lx) {
                        ++i;
                    }
                    done = true;
                }
                if (ty + mainFont.getHeight() > topY + height || i >= lx) {
                    done = true;
                }
                count = i;
lbl38:
                // 2 sources

            } while (!done);
        }
        if (i >= lx) {
            return -1;
        }
        return i;
    }

    public void drawProducts(boolean left_side) {
        int y = CLGameCanvas.getMenuY();
        int abilitySize = CLImageTracker.abilities.getWidth() * 5 / 4;
        y += abilitySize;
        Vector products = CLGameCanvas.gameObjects.playerW.products;
        int i = 0;
        while (i < products.size()) {
            Warlord.Product p = (Warlord.Product)products.elementAt(i);
            y = p.drawProduct(XClass.g, y, left_side);
            ++i;
        }
    }

    public void loadProgress(int max, int pos) {
        load_max = max;
        load_pos = pos;
        XClass.canvas.repaint();
        XClass.canvas.serviceRepaints();
    }

    public static void initLoading(boolean showTips) {
        if (showTips) {
            TIP_TEXT = CLImageTracker.font_small.splitText(CLLocales.TIPS[XCanvas.next_random(CLLocales.TIPS.length)], XCanvas.WIDTH - 30);
            blinkText = 0;
        } else {
            TIP_TEXT = null;
        }
    }

    public static void drawLoading(Graphics g, boolean fillBg) {
        int i;
        int y;
        int h;
        if (fillBg) {
            g.setColor(0);
            g.fillRect(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
        }
        BCFont fBig = CLImageTracker.font_anouncements;
        BCFont fSmall = CLImageTracker.font_small;
        if (TIP_TEXT != null) {
            h = fBig.char_height + TIP_TEXT.length * fSmall.char_height;
            y = fBig.char_height;
            Im box = CLImageTracker.resultBG;
            g.setClip(0, y, (int)XCanvas.WIDTH, 14 + h);
            box.draw(g, 0, y, 20);
            g.setClip(0, y += 14 + h, (int)XCanvas.WIDTH, 14);
            box.draw(g, 0, y - box.getHeight() + 14, 20);
            g.setClip(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
            y = fBig.char_height + 14;
            fBig.palette = PAL_VICTORY;
            fBig.textOutCenter(g, XCanvas.WIDTH >> 1, y, CLLocales.getByteString("Tip"));
            y += fBig.char_height;
            fSmall.palette[1] = -3355444;
            i = 0;
            while (i < TIP_TEXT.length) {
                fSmall.textOut(g, 15, y, TIP_TEXT[i]);
                ++i;
                y += fSmall.char_height;
            }
        }
        int x = 0;
        int w = XCanvas.WIDTH - 1;
        h = 20;
        fSmall.palette[1] = -84953;
        y = XCanvas.HEIGHT - h - 2 - fSmall.char_height - 2;
        if (load_pos < load_max) {
            fSmall.textOutCenter(g, XCanvas.WIDTH >> 1, y, CLLocales.getByteString("Loading..."));
        } else if (TIP_TEXT != null && blinkText < 4) {
            fSmall.textOutCenter(g, XCanvas.WIDTH >> 1, y, CLLocales.getByteString("Press 5"));
        }
        y = XCanvas.HEIGHT - h - 2;
        i = 0;
        while (i < LOAD_STROKE_COLORS.length) {
            g.setColor(LOAD_STROKE_COLORS[i]);
            switch (i) {
                case 1: {
                    g.fillRect(x, y, w + 1, h + 1);
                    break;
                }
                case 2: {
                    g.fillRect(x - 1, y - 1, w + 3, 1);
                    g.fillRect(x - 1, y + h, w + 3, 1);
                    break;
                }
                default: {
                    g.drawRect(x, y, w, h);
                }
            }
            ++i;
            ++x;
            ++y;
            w -= 2;
            h -= 2;
        }
        int length = ++w * load_pos / load_max;
        i = 0;
        while (i <= h) {
            g.setColor(LOAD_FILL_TOPS[0] + LOAD_FILL_LENGTHS[0] * i / h, LOAD_FILL_TOPS[1] + LOAD_FILL_LENGTHS[1] * i / h, LOAD_FILL_TOPS[2] + LOAD_FILL_LENGTHS[2] * i / h);
            g.fillRect(x, y, length, 1);
            g.setColor(0);
            g.fillRect(x + length, y, w - length, 1);
            ++i;
            ++y;
        }
    }

    static void addHitAnim(Walker w, Person p, boolean blueHits) {
        int x = blueHits ? p.positionX + (p.width >> 1) - CLImageTracker.hitOffsets[p.race][p.type] : p.positionX - (p.width >> 1) + CLImageTracker.hitOffsets[p.race][p.type];
        byte type = p instanceof Wall ? (byte)1 : (p instanceof Cannon ? (byte)3 : (p.race == 2 ? (byte)2 : 0));
        CLGameCanvas.addHitAnim(x, 213 - CLImageTracker.hitHeights[w.race][w.type], type);
    }

    static void addHitAnim(int x, int y, byte type) {
        HitAnim ha = new HitAnim();
        ha.x = x;
        ha.y = y;
        ha.frame_idx = 0;
        ha.type = type;
        hitAnims.addElement(ha);
    }

    static void runHitAnims() {
        int i = hitAnims.size() - 1;
        while (i >= 0) {
            HitAnim hitanim = (HitAnim)hitAnims.elementAt(i);
            if (ticks_till_step == 0) {
                hitanim.frame_idx = (byte)(hitanim.frame_idx + 1);
            }
            byte max_frame_idx = 0;
            switch (hitanim.type) {
                case 0: {
                    max_frame_idx = 4;
                    break;
                }
                default: {
                    max_frame_idx = 2;
                }
            }
            if (hitanim.frame_idx > max_frame_idx) {
                hitAnims.removeElementAt(i);
            }
            --i;
        }
    }

    static void drawHitAnims() {
        int i = 0;
        while (i < hitAnims.size()) {
            HitAnim hitanim = (HitAnim)hitAnims.elementAt(i);
            ImLoader animLoader = null;
            switch (hitanim.type) {
                case 0: {
                    animLoader = CLImageTracker.hitAnimBlood;
                    break;
                }
                case 1: {
                    animLoader = CLImageTracker.hitAnimStone;
                    break;
                }
                case 2: {
                    animLoader = CLImageTracker.hitAnimBone;
                    break;
                }
                case 3: {
                    animLoader = CLImageTracker.hitAnimWood;
                }
            }
            if (animLoader != null) {
                animLoader.drawSubImage(XClass.g, hitanim.x - (animLoader.getWidth() >> 1) - viewport, hitanim.y - (animLoader.getHeight() >> 1), 0, hitanim.frame_idx);
            }
            ++i;
        }
    }

    public static void initSpikes(boolean playerSide, int time) {
        System.out.println("INITSPIKES !!!");
        if (playerSide) {
            CLGameCanvas.spike_runTime[0] = time;
        } else {
            CLGameCanvas.spike_runTime[1] = time;
        }
        CLGameCanvas.spike_start_x[1] = 528 - WarlordsCastles.imageTracker.getImageForStronghold(2).getWidth() - spikes_width;
        CLGameCanvas.spike_start_x[0] = WarlordsCastles.imageTracker.getImageForStronghold(2).getWidth();
        int spikes_height = CLImageTracker.spike.getHeight() * 3;
        int spike_lines = 6;
        int spikes_per_line = spikes_width / (CLImageTracker.spike.getWidth() << 2);
        spike_x = new short[spike_lines][spikes_per_line];
        spike_y = new short[spike_lines][spikes_per_line];
        spike_height = new short[spike_lines][spikes_per_line];
        spike_time = new short[spike_lines][spikes_per_line];
        spike_dir_up = new boolean[spike_lines][spikes_per_line];
        int start_x = 0;
        spike_speed = (CLImageTracker.spike.getHeight() * XCanvas.DT << 8) / 500;
        int i = 0;
        int y = 213;
        while (i < spike_lines) {
            int j = 0;
            int x = start_x;
            while (j < spikes_per_line) {
                CLGameCanvas.spike_x[i][j] = (short)x;
                CLGameCanvas.spike_y[i][j] = (short)y;
                CLGameCanvas.spike_height[i][j] = (short)(XCanvas.next_random(CLImageTracker.spike.getHeight()) << 8);
                CLGameCanvas.spike_dir_up[i][j] = XCanvas.next_random(2) == 0;
                CLGameCanvas.spike_time[i][j] = 300;
                ++j;
                x += CLImageTracker.spike.getWidth() << 2;
            }
            ++i;
            start_x = (213 - (y -= CLImageTracker.spike.getHeight() >> 1)) * 28 / 26;
        }
    }

    public static void runSpikes() {
        if (spike_runTime[0] > 0) {
            spike_runTime[0] = spike_runTime[0] - XCanvas.DT;
        }
        if (spike_runTime[1] > 0) {
            spike_runTime[1] = spike_runTime[1] - XCanvas.DT;
        }
        if (spike_runTime[0] > 0 || spike_runTime[1] > 0) {
            int i = 0;
            while (i < spike_x.length) {
                int j = 0;
                while (j < spike_x[i].length) {
                    if (spike_height[i][j] == 0 || spike_height[i][j] >> 8 == CLImageTracker.spike.getHeight()) {
                        short[] sArray = spike_time[i];
                        int n = j;
                        sArray[n] = (short)(sArray[n] - XCanvas.DT);
                        if (spike_time[i][j] <= 0) {
                            CLGameCanvas.spike_time[i][j] = 300;
                            CLGameCanvas.spike_dir_up[i][j] = spike_height[i][j] == 0;
                            CLGameCanvas.spike_height[i][j] = spike_height[i][j] == 0 ? (short)1 : (short)((CLImageTracker.spike.getHeight() << 8) - 1);
                        }
                    } else {
                        if (spike_dir_up[i][j]) {
                            short[] sArray = spike_height[i];
                            int n = j;
                            sArray[n] = (short)(sArray[n] + (short)spike_speed);
                        } else {
                            short[] sArray = spike_height[i];
                            int n = j;
                            sArray[n] = (short)(sArray[n] - (short)spike_speed);
                        }
                        if (spike_height[i][j] < 0) {
                            CLGameCanvas.spike_height[i][j] = 0;
                        } else if (spike_height[i][j] > CLImageTracker.spike.getHeight() << 8) {
                            CLGameCanvas.spike_height[i][j] = (short)(CLImageTracker.spike.getHeight() << 8);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static boolean isSpikeOver(int side) {
        return spike_runTime[side] <= 0;
    }

    public static void drawSpikes(boolean first_half, int side) {
        int start_i = first_half ? 0 : spike_x.length >> 1;
        int len = spike_x.length >> 1;
        int i = start_i;
        while (i < start_i + len) {
            int j = 0;
            while (j < spike_x[i].length) {
                int h = spike_height[i][j] >> 8;
                int y = spike_y[i][j] - h;
                int x = spike_start_x[side] + spike_x[i][j] - viewport;
                XClass.g.setClip(x, y, CLImageTracker.spike.getWidth(), h);
                CLImageTracker.spike.draw(XClass.g, x, y, 20);
                ++j;
            }
            ++i;
        }
        XClass.g.setClip(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
    }

    static void startArmaggedon() {
        armaggedonTime = 40;
        Boss.initLightning();
    }

    static void runArmaggedon() {
        if (armaggedonTime > 0) {
            --armaggedonTime;
            if ((--Boss.lightning_time & 1) == 0) {
                Boss.generateNewLightning(528, 80);
            }
            Boss.paintLightning(XClass.g);
        }
    }

    static void startDisenchant() {
        disenchantTime = 20;
        disenchantInd = 0;
    }

    static boolean isBetween(int subj, int min, int max) {
        boolean b = false;
        if (subj >= min && subj <= max) {
            b = true;
        }
        return b;
    }

    static void runDisenchant() {
        if (disenchantTime > 0) {
            if (--disenchantTime % 2 == 0) {
                ++disenchantInd;
            }
            if (CLGameCanvas.isBetween(disenchantTime, 18, 20)) {
                CLGameCanvas.isBetween(disenchantTime % 4, 0, 1);
            }
            if (CLGameCanvas.isBetween(disenchantTime, 5, 15)) {
                CLGameCanvas.isBetween(disenchantTime % 2, 0, 1);
            }
            if (CLGameCanvas.isBetween(disenchantTime, 0, 5)) {
                CLGameCanvas.isBetween(disenchantTime % 2, 0, 0);
            }
            int i = 0;
            while (i < 13) {
                CLImageTracker.dying[0].drawSubImage(XClass.g, -viewport + i * 45, 120 - disenchantInd * 12, 0, disenchantInd % 11);
                ++i;
            }
        }
    }

    static void startHandOfFire(int time, boolean isIce) {
        rainTime = time;
        hand_type = isIce;
    }

    static void runHandOfFire() {
        if (CLGameCanvas.gameObjects.blueWarlord.personOnSpike != null && rainTime > 0) {
            if (--rainTime % 5 == 0) {
                curpos = dir ? ++curpos : --curpos;
                if (curpos > 2) {
                    curpos = 2;
                    dir = false;
                }
                if (curpos < 0) {
                    curpos = 0;
                    dir = true;
                }
            }
            if (!hand_type) {
                CLImageTracker.handOfFire.drawSubImage(XClass.g, CLGameCanvas.gameObjects.blueWarlord.personOnSpike.positionX - 15 - viewport, CLGameCanvas.gameObjects.blueWarlord.personOnSpike.positionY - 60, 0, curpos);
            } else {
                CLImageTracker.handOfIce.drawSubImage(XClass.g, CLGameCanvas.gameObjects.blueWarlord.personOnSpike.positionX - 15 - viewport, CLGameCanvas.gameObjects.blueWarlord.personOnSpike.positionY - 60, 0, curpos);
            }
        }
    }

    static void startHandOf(int time, int type, boolean ownedByBlue) {
        if (ownedByBlue) {
            blueHandTime = time;
            blueHandType = type;
        } else {
            redHandTime = time;
            redHandType = type;
        }
    }

    static void runHandOf() {
        int blueRadius = 30 - blueHandTime * 3;
        int redRadius = 30 - redHandTime * 3;
        if (blueHandTime + redHandTime > 0) {
            int i = 0;
            while (i < gameObjects.getLiveObjects().size()) {
                GameObject temp = (GameObject)((Object)gameObjects.getLiveObjects().elementAt(i));
                if (temp instanceof Person) {
                    int j;
                    if (blueHandTime > 0 && !temp.isOwnedByBlue()) {
                        j = 0;
                        while (j < 15) {
                            if (blueHandType == 1) {
                                XClass.g.setColor(255 - blueHandTime * j, 150 - blueHandTime * j, 0);
                            } else {
                                XClass.g.setColor(0, 200 - blueHandTime * j, 255 - blueHandTime * j);
                            }
                            XClass.g.drawRoundRect(temp.positionX - (blueRadius + j) / 2 - viewport, temp.positionY - (blueRadius + j) / 2 + temp.height / 2, blueRadius + j, blueRadius + j, blueRadius + j, blueRadius + j);
                            ++j;
                        }
                    }
                    if (redHandTime > 0 && temp.isOwnedByBlue()) {
                        j = 0;
                        while (j < 15) {
                            if (redHandType == 1) {
                                XClass.g.setColor(255 - redHandTime * j, 150 - redHandTime * j, 0);
                            } else {
                                XClass.g.setColor(0, 200 - redHandTime * j, 255 - redHandTime * j);
                            }
                            XClass.g.drawRoundRect(temp.positionX - (redRadius + j) / 2 - viewport, temp.positionY - (redRadius + j) / 2 + temp.height / 2, redRadius + j, redRadius + j, redRadius + j, redRadius + j);
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (blueHandTime > 0) {
                --blueHandTime;
            }
            if (redHandTime > 0) {
                --redHandTime;
            }
        }
    }

    static void startEarthQuake(int time) {
        int new_viewport;
        quakeTime = time;
        qTime = 0;
        time34 = time * 3 >> 2;
        quakeAcc = (11 * XCanvas.DT << 8) / time34;
        quakeDecc = -(11 * XCanvas.DT << 8) / (time - time34);
        System.out.println("QAcc " + quakeAcc);
        System.out.println("QDecc " + quakeDecc);
        lastQuakeX = 512;
        quakeDifferenceX = 0;
        if (viewport < 13) {
            new_viewport = 13;
            quakeDifferenceX = new_viewport - viewport;
            viewport = new_viewport;
        }
        if (viewport + XCanvas.WIDTH + 13 > 528) {
            new_viewport = 528 - XCanvas.WIDTH - 13;
            quakeDifferenceX = new_viewport - viewport;
            viewport = new_viewport;
        }
        quakeLeft = true;
    }

    static void runEarthQuake() {
        if (qTime < quakeTime) {
            lastQuakeX = (qTime += XCanvas.DT) <= time34 ? (lastQuakeX += quakeAcc) : (lastQuakeX += quakeDecc);
            if (quakeLeft) {
                quakeDifferenceX -= lastQuakeX >> 8;
                viewport -= lastQuakeX >> 8;
            } else {
                quakeDifferenceX += lastQuakeX >> 8;
                viewport += lastQuakeX >> 8;
            }
            quakeLeft = !quakeLeft;
            quakeSpeed = 1;
            if (qTime >= quakeTime) {
                viewport -= quakeDifferenceX;
            }
            if (viewport < 0) {
                viewport = 0;
            }
            if (viewport >= 348) {
                viewport = 348;
            }
            System.out.println(viewport);
        }
    }

    public void nextInstruction() {
        ++this.scriptIp;
        this.scriptLoop = false;
    }

    public void startScriptEtherLordDeath() {
        this.scriptIp = 0;
        this.scriptLoop = false;
        gameMode = 8;
        this.boss.positionY = 213 - Boss.HEIGHT[this.boss.bossType];
        this.boss.actualSequence = Person.NORMAL;
        this.boss.setFrameSequence(this.boss.sequence[0]);
        this.boss.setRed(0);
    }

    public void scriptEatherLordDeath() {
        Im sink = CLImageTracker.bossSink;
        if (this.redEffect) {
            if (this.boss.redTime <= 0) {
                this.boss.setRedEffect();
            }
            this.boss.runRedEffect();
        }
        XClass.g.setClip(0, 0, (int)XCanvas.WIDTH, XCanvas.HEIGHT - 4);
        this.boss.paintSprite(XClass.g, false);
        switch (this.scriptIp) {
            case 0: {
                if (!this.scriptLoop) {
                    this.redEffect = false;
                    this.boss.setRed(0);
                    this.viewportSpeed = 30;
                    gameObjects.getLiveObjects().removeElement((Object)this.boss);
                    break;
                }
                if ((viewport += this.viewportSpeed) < 528 - XCanvas.WIDTH - 13 - 1) break;
                viewport = 528 - XCanvas.WIDTH - 13 - 1;
                this.viewportSpeed = 0;
                this.nextInstruction = true;
                break;
            }
            case 1: {
                if (!this.scriptLoop) {
                    if (this.boss.actualSequence == Person.BATTLE) break;
                    this.nextInstruction = true;
                    break;
                }
                this.boss.nextFrame();
                if (this.boss.turnDelay == 1) {
                    this.nextInstruction = true;
                }
                this.boss.doStep();
                break;
            }
            case 2: {
                if (!this.scriptLoop) {
                    this.boss.actualSequence = Person.BATTLE;
                    this.boss.setFrameSequence(this.boss.sequence[Person.BATTLE]);
                    break;
                }
                this.boss.nextFrame();
                if (this.boss.sequence[this.boss.actualSequence][this.boss.getFrameIdx()] != 4) break;
                this.nextInstruction = true;
                break;
            }
            case 3: {
                if (!this.scriptLoop) {
                    this.nextInstruction = true;
                    break;
                }
                if ((this.lastExplosion == null || this.lastExplosion.frame == 3) && ++this.ethExplIndex < exX.length) {
                    this.lastExplosion = new DyingAnim(this.imageTracker.getImageForDying(5), this.boss.positionX - Boss.WIDTH[this.boss.bossType] / 2 + exX[this.ethExplIndex], exY[this.ethExplIndex] - GameObjects.DYING_SIZE[1][5] / 2 + this.boss.positionY, 5);
                    CLGameCanvas.gameObjects.dyingAnims.addElement(this.lastExplosion);
                }
                if (CLGameCanvas.gameObjects.dyingAnims.size() != 0) break;
                this.nextInstruction = true;
                break;
            }
            case 4: {
                if (!this.scriptLoop) {
                    this.sinkClip = 0;
                    CLGameCanvas.startEarthQuake(4600);
                    this.lastExplosion = null;
                    this.ethExplIndex = 0;
                    this.redEffect = true;
                    break;
                }
                int sinkSpeed = (sink.getWidth() * XCanvas.DT << 8) / 1000;
                this.sinkClip += sinkSpeed;
                XClass.g.setClip(XCanvas.WIDTH - sink.getWidth(), 0, this.sinkClip >> 8, XCanvas.HEIGHT - 4);
                sink.draw(XClass.g, 528 - viewport, XCanvas.HEIGHT, 8 | 0x20);
                if (this.sinkClip >> 8 < sink.getWidth()) break;
                this.nextInstruction = true;
                break;
            }
            case 5: {
                int sinkSpeed;
                if (!this.scriptLoop) {
                    this.bossY = this.boss.positionY << 8;
                } else {
                    sinkSpeed = (Boss.HEIGHT[this.boss.bossType] * XCanvas.DT << 8) / 2500;
                    this.bossY += sinkSpeed;
                    this.boss.positionY = this.bossY >> 8;
                    if (this.boss.positionY >= XCanvas.HEIGHT - 4) {
                        this.nextInstruction = true;
                    }
                }
                sink.draw(XClass.g, 528 - viewport, XCanvas.HEIGHT, 8 | 0x20);
                break;
            }
            case 6: {
                int sinkSpeed;
                if (!this.scriptLoop) {
                    this.sinkClip = 0;
                } else {
                    sinkSpeed = (sink.getWidth() * XCanvas.DT << 8) / 1000;
                    this.sinkClip += sinkSpeed;
                    if (this.sinkClip >> 8 >= sink.getWidth()) {
                        this.nextInstruction = true;
                    }
                }
                XClass.g.setClip(XCanvas.WIDTH - sink.getWidth() + (this.sinkClip >> 8), 0, sink.getWidth() - (this.sinkClip >> 8), XCanvas.HEIGHT - 4);
                sink.draw(XClass.g, 528 - viewport, XCanvas.HEIGHT, 8 | 0x20);
                break;
            }
            case 7: {
                if (this.scriptLoop) break;
                gameMode = 4;
                this.victory_state = (byte)2;
            }
        }
        if (this.redEffect) {
            if (this.lastExplosion != null) {
                System.out.println("Last explosion frame: " + this.lastExplosion.frame);
            }
            if ((this.lastExplosion == null || this.lastExplosion.frame == 3) && ++this.ethExplIndex < exX.length) {
                this.lastExplosion = new DyingAnim(this.imageTracker.getImageForDying(5), this.boss.positionX - Boss.WIDTH[this.boss.bossType] / 2 + exX[this.ethExplIndex], exY[this.ethExplIndex] - GameObjects.DYING_SIZE[1][5] / 2 + this.boss.positionY, 5);
                CLGameCanvas.gameObjects.dyingAnims.addElement(this.lastExplosion);
            }
            this.drawDyingAnimations(XClass.g);
            int i = 0;
            while (i < CLGameCanvas.gameObjects.dyingAnims.size()) {
                DyingAnim temp = (DyingAnim)CLGameCanvas.gameObjects.dyingAnims.elementAt(i);
                if (ticks_till_step == 0) {
                    --temp.showTime;
                    temp.nextFrame();
                    if (temp.showTime < 1) {
                        CLGameCanvas.gameObjects.dyingAnims.removeElementAt(i);
                    }
                }
                ++i;
            }
        }
        XClass.g.setClip(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
        CLGameCanvas.runEarthQuake();
        if (!this.scriptLoop) {
            this.scriptLoop = true;
        }
        if (this.nextInstruction) {
            this.nextInstruction();
            this.nextInstruction = false;
        }
    }

    class DyingAnim {
        final int[] TYPE_PERSON;
        public int showTime;
        public int numFrames;
        public int x;
        public int y;
        ImLoader animation;
        public int type;
        int frame;
        int x_offs;

        public DyingAnim(ImLoader animation, int x, int y, int type) {
            int[] nArray = new int[7];
            nArray[1] = 1;
            nArray[3] = 1;
            nArray[4] = 2;
            nArray[5] = 2;
            nArray[6] = 2;
            this.TYPE_PERSON = nArray;
            this.frame = 0;
            type = this.type = this.TYPE_PERSON[type];
            this.showTime = type == 0 ? 10 : 11;
            this.x = x;
            this.y = y;
            this.animation = animation;
            switch (this.type) {
                case 0: {
                    this.numFrames = 10;
                    break;
                }
                case 1: 
                case 2: {
                    short[][] widths = new short[][]{GameObjects.DYING_WIDTHS[type - 1]};
                    short[][] offsets = new short[][]{GameObjects.DYING_OFFSETS[type - 1]};
                    this.numFrames = widths[0].length;
                    break;
                }
                default: {
                    System.out.println("WARNING: no animation -----" + type);
                }
            }
            int xSize = GameObjects.DYING_SIZE[0][type];
            int ySize = GameObjects.DYING_SIZE[1][type];
            this.x_offs = xSize >> 1;
        }

        public void nextFrame() {
            if (++this.frame >= this.numFrames) {
                this.frame = 0;
            }
        }

        public void paint(Graphics g, int x, int y) {
            this.animation.drawSubImage(g, x - this.x_offs, y, 0, this.frame);
        }
    }
}

