/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.Archer;
import com.eternity.castlelords.Boss;
import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.CLLocales;
import com.eternity.castlelords.Cannon;
import com.eternity.castlelords.GameObject;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Knight;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.Piker;
import com.eternity.castlelords.Resource;
import com.eternity.castlelords.Rider;
import com.eternity.castlelords.Spell;
import com.eternity.castlelords.Walker;
import com.eternity.castlelords.Wall;
import com.eternity.castlelords.WarlordsCastles;
import com.impossible.util.XCanvas;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Warlord {
    public static final int NO_ABILITY = 0;
    public static final int PROTECTOR_ABILITY = 1;
    public static final int BERSERK_ABILITY = 2;
    public static final int VAQUISH_ABILITY = 4;
    public static final int ELEMENTAL_ABILITY = 8;
    public static final int SPELLSWORD_ABILITY = 16;
    public static final int POWERMAGE_ABILITY = 32;
    public static int[] PROTECTOR_CHANCES = new int[]{20, 40, 60, 62, 64, 66, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81};
    public static int[] BERSERK_CHANCES = new int[]{20, 40, 60, 62, 64, 66, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81};
    public static int[] POWERMAGE_CHANCES = new int[]{50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50};
    public static final int ELEMENTAL_STONES = 100;
    public static final int ELEMENTAL_GOLD = 100;
    public static final int ELEMENTAL_RATE = 6;
    public static int POWERMAGE_ARM_PERCENTAGE = 50;
    public static int MSPAMMERDD1 = 1;
    public static int MSPAMMERDD2 = 2;
    public static int ENGINEER = 4;
    public static int ENCHANTER = 8;
    public static int ENCHANTER2 = 16;
    public static int MIXED1 = 32;
    public static int MIXED2 = 64;
    public static int MIXED3 = 128;
    public static int CHIEFTAIN = 256;
    public static int ARMORER = 512;
    public static int BERSERK = 1024;
    public static int BALANCED = 2048;
    public static int SPAMMER1 = 1;
    public static int SPAMMER2 = 2;
    public static int SPAMMER3 = 4;
    public static int SPAMMER4 = 8;
    public static int MEGASPAMMER1 = 16;
    public static int TITAN1 = 32;
    public static int TITAN2 = 64;
    public static int TITAN3 = 128;
    public static int DI1 = 256;
    public static int DI2 = 512;
    public static int VALIANT1 = 1024;
    public static int VALIANT2 = 2048;
    public static int VALIANT3 = 4096;
    public static int DEFENDER = 8192;
    public static int AVERAGEJOE = 16384;
    public int level;
    public int experience;
    public int wizardry;
    public int race;
    public int morality;
    public int charisma;
    public int intelligence;
    public int wizardType;
    public int charIdx = 0;
    public String name = "";
    public static int NORMALMACY = 0;
    public static int EASYMACY = -50;
    public static int HARDMACY = 25;
    public int supremacy = NORMALMACY;
    public int remainingSkillPoints;
    public int ability = 0;
    public int magicPerson;
    public int battlePerson;
    public int castlePower;
    public int castleLevel;
    public int mana;
    public int stones;
    public int money;
    public int villages;
    public int max_villages = 8;
    public int planned_villages = 0;
    public int mines;
    public int max_mines = 8;
    public int planned_mines = 0;
    public int shrines;
    public int kills;
    public Person personOnSpike = null;
    public Spell enchantment1 = null;
    public Spell enchantment2 = null;
    public boolean isPowerMage = false;
    public boolean underSiege = false;
    public boolean canBuildWall = false;
    public int besiegers = 0;
    public int lastWalkerXPosition = 0;
    public static final byte WS_NOT_BUILT = 0;
    public static final byte WS_BUILDING = 1;
    public static final byte WS_BUILT = 2;
    public byte wall_state;
    public boolean has_archer;
    public boolean has_cannon;
    public Archer archer;
    public int[] unitsHP = new int[7];
    public int[] unitsPP = new int[6];
    public int[] shotsPP = new int[5];
    public int[] shotTurnDelay = new int[2];
    public int[] unitsCounts = new int[7];
    public int[] unitsLevel;
    public int[] upgradeLevel;
    GameObjects gameObjects;
    public static boolean UPGRADE_HEAL = false;
    int charismaIncreaseGLD;
    int charismaIncreaseSTN;
    public Vector products;
    Vector finished_products;
    static final int DT_BATCH = 200;
    static final byte PT_UNIT = 0;
    static final byte PT_UPGRADE = 1;
    static final byte PT_BUILDING = 2;
    static final byte PR_GOLD = 0;
    static final byte PR_STONES = 1;
    static final byte PR_MANA = 2;
    static final int COL_RECT = 0x887868;
    static final int COL_GREEN1 = 6661632;
    static final int COL_GREEN2 = 9101824;
    boolean campaign;
    int[] spells;
    int[] spells_to_learn;
    int[] tt_unit_max_levels;
    boolean[] tt_buildings;
    boolean[] tt_actions;
    int max_castle_level;

    public Warlord(GameObjects go, boolean campaign) {
        int[] nArray = new int[6];
        nArray[0] = 1;
        this.unitsLevel = nArray;
        int[] nArray2 = new int[6];
        nArray2[0] = 1;
        this.upgradeLevel = nArray2;
        this.products = new Vector();
        this.campaign = false;
        this.spells = new int[0];
        this.spells_to_learn = new int[0];
        this.tt_unit_max_levels = new int[]{5, 5, 5, 5, 5};
        this.tt_buildings = new boolean[]{true, true, true, true, true, true, true};
        this.tt_actions = new boolean[]{true, true, true, true};
        this.max_castle_level = 2;
        this.gameObjects = go;
        this.campaign = campaign;
    }

    public void resetBattleSettings(int battleType) {
        switch (battleType) {
            case 0: {
                int[] nArray = new int[6];
                nArray[0] = 1;
                this.unitsLevel = nArray;
                int[] nArray2 = new int[6];
                nArray2[0] = 1;
                this.upgradeLevel = nArray2;
                break;
            }
            case 1: {
                int[] nArray = new int[6];
                nArray[0] = 1;
                nArray[1] = 1;
                this.unitsLevel = nArray;
                int[] nArray3 = new int[6];
                nArray3[0] = 1;
                nArray3[1] = 1;
                this.upgradeLevel = nArray3;
                break;
            }
            case 2: {
                int[] nArray = new int[6];
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[3] = 1;
                this.unitsLevel = nArray;
                int[] nArray4 = new int[6];
                nArray4[0] = 1;
                nArray4[1] = 1;
                nArray4[3] = 1;
                this.upgradeLevel = nArray4;
                break;
            }
            default: {
                int[] nArray = new int[6];
                nArray[0] = 1;
                this.unitsLevel = nArray;
                int[] nArray5 = new int[6];
                nArray5[0] = 1;
                this.upgradeLevel = nArray5;
            }
        }
        this.kills = 0;
        this.personOnSpike = null;
        this.castleLevel = 0;
        this.castlePower = 0;
        this.money = 0;
        this.stones = 0;
        this.mana = 0;
        this.charismaIncreaseSTN = 0;
        this.charismaIncreaseGLD = 0;
        this.shrines = 0;
        this.mines = 0;
        this.villages = 0;
        this.resetEnchantments();
        this.resetUnitCounters();
        this.products = new Vector();
        this.wall_state = 0;
        this.has_archer = false;
        this.has_cannon = false;
        this.planned_villages = 0;
        this.planned_mines = 0;
    }

    public void initUnitsCharacteristics(int race) {
        int i = 0;
        while (i < GameObjects.unitsHP[race].length) {
            this.unitsHP[i] = GameObjects.unitsHP[race][i];
            ++i;
        }
        i = 0;
        while (i < GameObjects.unitsPP[race].length) {
            this.unitsPP[i] = GameObjects.unitsPP[race][i];
            ++i;
        }
        i = 0;
        while (i < GameObjects.shotTurnDelay[race].length) {
            this.shotTurnDelay[i] = GameObjects.shotTurnDelay[race][i];
            ++i;
        }
    }

    public void unitsCharsToString() {
        System.out.print("Units Level: [");
        int i = 0;
        while (i < this.unitsLevel.length) {
            System.out.print("," + this.unitsLevel[i]);
            ++i;
        }
        System.out.println("]");
        System.out.print("Upgrade Level: [");
        i = 0;
        while (i < this.upgradeLevel.length) {
            System.out.print("," + this.upgradeLevel[i]);
            ++i;
        }
        System.out.println("]");
        System.out.print("Units HP: [");
        i = 0;
        while (i < this.unitsHP.length) {
            System.out.print("," + this.unitsHP[i]);
            ++i;
        }
        System.out.println("]");
        System.out.print("Units PP: [");
        i = 0;
        while (i < this.unitsPP.length) {
            System.out.print("," + this.unitsPP[i]);
            ++i;
        }
        System.out.println("]");
    }

    public boolean hasDoubleCharacteristics() {
        return this.hasAbility(4);
    }

    public int characteristicsCoeficient() {
        return this.hasAbility(4) ? 150 : 100;
    }

    public boolean mayUpgradeUnit(int type) {
        return this.money >= GameObjects.upgradeUnitsPriceGLD[this.unitsLevel[type]][type] * this.characteristicsCoeficient() / 100 && this.unitsLevel[type] < 5;
    }

    public boolean upgradeUnit(int type) {
        if (this.unitsLevel[type] != 0) {
            int n = type;
            this.unitsHP[n] = this.unitsHP[n] + GameObjects.upgradeUnitsHP[this.race][type];
            int n2 = type;
            this.unitsPP[n2] = this.unitsPP[n2] + GameObjects.upgradeUnitsPP[this.race][type];
            switch (type) {
                case 2: {
                    this.shotTurnDelay[0] = this.shotTurnDelay[0] - GameObjects.upgradeShotTurnDelay[this.race][0];
                    break;
                }
                case 4: {
                    this.shotTurnDelay[1] = this.shotTurnDelay[1] - GameObjects.upgradeShotTurnDelay[this.race][1];
                    System.out.println("Shot turn delay: " + this.shotTurnDelay[1]);
                }
            }
        }
        int n = type;
        this.unitsLevel[n] = this.unitsLevel[n] + 1;
        this.upgradeAllUnitsOnField(type);
        return true;
    }

    void upgradeAllUnitsOnField(int type) {
        boolean isBlue = this == this.gameObjects.blueWarlord;
        int i = 0;
        while (i < this.gameObjects.getLiveObjects().size()) {
            GameObject go = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
            if (go instanceof Person && go.isOwnedByBlue() == isBlue && go.type == type) {
                Person p = (Person)go;
                if (!(go instanceof Boss)) {
                    p.upgrade(this);
                } else {
                    System.out.println("Bosses do not upgrade!");
                }
            }
            ++i;
        }
    }

    public Person createUnit(int unitType, boolean applyAbilities) {
        GameObject unit = null;
        switch (unitType) {
            case 0: {
                if (this == this.gameObjects.blueWarlord) {
                    unit = this.gameObjects.addLiveObject(new Piker(this.gameObjects.blueWarlord.lastWalkerXPosition - Piker.WIDTH[this.gameObjects.blueWarlord.race] / 2, 213 - Piker.HEIGHT[this.gameObjects.blueWarlord.race], this.gameObjects.blueWarlord.generateUnitHP(0, applyAbilities), this.gameObjects.blueWarlord.generateUnitPP(0, applyAbilities), true, this.gameObjects, WarlordsCastles.imageTracker));
                    this.gameObjects.blueWarlord.lastWalkerXPosition -= Piker.WIDTH[this.gameObjects.blueWarlord.race] / 2;
                    break;
                }
                unit = this.gameObjects.addLiveObject(new Piker(this.gameObjects.redWarlord.lastWalkerXPosition + Piker.WIDTH[this.gameObjects.redWarlord.race] / 2, 213 - Piker.HEIGHT[this.gameObjects.redWarlord.race], this.gameObjects.redWarlord.generateUnitHP(0, applyAbilities), this.gameObjects.redWarlord.generateUnitPP(0, applyAbilities), false, this.gameObjects, WarlordsCastles.imageTracker));
                this.gameObjects.redWarlord.lastWalkerXPosition += Piker.WIDTH[this.gameObjects.redWarlord.race] / 2;
                break;
            }
            case 1: {
                if (this == this.gameObjects.blueWarlord) {
                    unit = this.gameObjects.addLiveObject(new Knight(this.gameObjects.blueWarlord.lastWalkerXPosition - Knight.WIDTH[this.gameObjects.blueWarlord.race] / 2, 213 - Knight.HEIGHT[this.gameObjects.blueWarlord.race], this.gameObjects.blueWarlord.generateUnitHP(1, applyAbilities), this.gameObjects.blueWarlord.generateUnitPP(1, applyAbilities), true, this.gameObjects, WarlordsCastles.imageTracker));
                    this.gameObjects.blueWarlord.lastWalkerXPosition -= Knight.WIDTH[this.gameObjects.blueWarlord.race] / 2;
                    break;
                }
                unit = this.gameObjects.addLiveObject(new Knight(this.gameObjects.redWarlord.lastWalkerXPosition + Knight.WIDTH[this.gameObjects.redWarlord.race] / 2, 213 - Knight.HEIGHT[this.gameObjects.redWarlord.race], this.gameObjects.redWarlord.generateUnitHP(1, applyAbilities), this.gameObjects.redWarlord.generateUnitPP(1, applyAbilities), false, this.gameObjects, WarlordsCastles.imageTracker));
                this.gameObjects.redWarlord.lastWalkerXPosition += Knight.WIDTH[this.gameObjects.redWarlord.race] / 2;
                break;
            }
            case 3: {
                if (this == this.gameObjects.blueWarlord) {
                    unit = this.gameObjects.addLiveObject(new Rider(this.gameObjects.blueWarlord.lastWalkerXPosition - Rider.WIDTH[this.gameObjects.blueWarlord.race] / 2, 213 - Rider.HEIGHT[this.gameObjects.blueWarlord.race], this.gameObjects.blueWarlord.generateUnitHP(3, applyAbilities), this.gameObjects.blueWarlord.generateUnitPP(3, applyAbilities), true, this.gameObjects, WarlordsCastles.imageTracker));
                    this.gameObjects.blueWarlord.lastWalkerXPosition -= Rider.WIDTH[this.gameObjects.blueWarlord.race] / 2;
                    break;
                }
                unit = this.gameObjects.addLiveObject(new Rider(this.gameObjects.redWarlord.lastWalkerXPosition + Rider.WIDTH[this.gameObjects.redWarlord.race] / 2, 213 - Rider.HEIGHT[this.gameObjects.redWarlord.race], this.gameObjects.redWarlord.generateUnitHP(3, applyAbilities), this.gameObjects.redWarlord.generateUnitPP(3, applyAbilities), false, this.gameObjects, WarlordsCastles.imageTracker));
                this.gameObjects.redWarlord.lastWalkerXPosition += Rider.WIDTH[this.gameObjects.redWarlord.race] / 2;
                break;
            }
            case 4: {
                if (this == this.gameObjects.blueWarlord) {
                    unit = this.gameObjects.addLiveObject(new Cannon(this.gameObjects.blueWarlord.lastWalkerXPosition - 45, 113, this.generateUnitHP(4, applyAbilities), this.generateUnitPP(4, applyAbilities), true, this.gameObjects, WarlordsCastles.imageTracker));
                    this.gameObjects.blueWarlord.lastWalkerXPosition -= 45;
                    break;
                }
                unit = this.gameObjects.addLiveObject(new Cannon(this.gameObjects.redWarlord.lastWalkerXPosition + 45, 113, this.generateUnitHP(4, applyAbilities), this.generateUnitPP(4, applyAbilities), false, this.gameObjects, WarlordsCastles.imageTracker));
                this.gameObjects.redWarlord.lastWalkerXPosition += 90;
                break;
            }
            case 2: {
                if (this == this.gameObjects.blueWarlord) {
                    if (this.gameObjects.blueWarlord.unitsCounts[2] > 0) {
                        int i = 0;
                        while (i < this.gameObjects.getLiveObjects().size()) {
                            GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                            if (temp.isOwnedByBlue() && temp instanceof Archer) {
                                ((Archer)temp).refreshLifeTime();
                            }
                            ++i;
                        }
                        break;
                    }
                    unit = this.gameObjects.addLiveObject(new Archer(0, 213 - WarlordsCastles.imageTracker.getImageForStronghold(2).getHeight(), this.generateUnitHP(2, applyAbilities), this.generateUnitPP(2, applyAbilities), true, this.gameObjects, WarlordsCastles.imageTracker));
                    break;
                }
                if (this.gameObjects.redWarlord.unitsCounts[2] > 0) {
                    int i = 0;
                    while (i < this.gameObjects.getLiveObjects().size()) {
                        GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                        if (!temp.isOwnedByBlue() && temp instanceof Archer) {
                            ((Archer)temp).refreshLifeTime();
                        }
                        ++i;
                    }
                    break;
                }
                unit = this.gameObjects.addLiveObject(new Archer(528, 213 - WarlordsCastles.imageTracker.getImageForStronghold(2).getHeight(), this.gameObjects.redWarlord.generateUnitHP(2, applyAbilities), this.gameObjects.redWarlord.generateUnitPP(2, applyAbilities), false, this.gameObjects, WarlordsCastles.imageTracker));
            }
        }
        return (Person)unit;
    }

    public int getUnitHP(int type) {
        return this.unitsHP[type] * this.characteristicsCoeficient() / 100;
    }

    public int getUpgradeUnitHP(int type) {
        return GameObjects.upgradeUnitsHP[this.race][type] * this.characteristicsCoeficient() / 100;
    }

    public int getUnitPP(int type) {
        return this.unitsPP[type] * this.characteristicsCoeficient() / 100;
    }

    public int getUpgradeUnitPP(int type) {
        return GameObjects.upgradeUnitsPP[this.race][type] * this.characteristicsCoeficient() / 100;
    }

    public int generateUnitHP(int type, boolean applyAbilities) {
        int hp = this.unitsHP[type] == 0 ? GameObjects.unitsHP[this.race][type] : this.unitsHP[type];
        hp += hp * this.supremacy / 100;
        int old_hp = hp;
        if (applyAbilities) {
            hp = hp * this.characteristicsCoeficient() / 100;
        }
        if (this.hasEnchantmentType(14)) {
            hp *= 100 - GameObjects.ALL_SPELLS_CHAR[14][GameObjects.PERCENTAGE_POINTER];
        }
        if (hp == 0) {
            System.out.println("Generated HP is 0 !!! " + old_hp + " " + (this.gameObjects.blueWarlord == this) + " " + this.unitsHP[0]);
        }
        return hp;
    }

    public int generateUnitPP(int type, boolean applyAbilities) {
        int pp = this.unitsPP[type] == 0 ? GameObjects.unitsPP[this.race][type] : this.unitsPP[type];
        pp += pp * this.supremacy / 100;
        if (applyAbilities) {
            pp = pp * this.characteristicsCoeficient() / 100;
            pp += pp * CLGameCanvas.random(this.morality * GameObjects.CHARACTERISTIC_PROPERTIES[0] + 1);
        }
        return pp;
    }

    public void increaseResources() {
        this.charismaIncreaseGLD += (this.villages * this.charisma * GameObjects.CHARACTERISTIC_PROPERTIES[1] << 10) / 100;
        this.money += this.villages + (this.charismaIncreaseGLD >> 10);
        this.charismaIncreaseGLD &= 0x3FF;
        if (this.money > GameObjects.RESOURCE_CAPS[0]) {
            this.money = GameObjects.RESOURCE_CAPS[0];
        }
        this.charismaIncreaseSTN += (this.mines * this.charisma * GameObjects.CHARACTERISTIC_PROPERTIES[1] << 10) / 100;
        this.stones += this.mines + (this.charismaIncreaseSTN >> 10);
        this.charismaIncreaseSTN &= 0x3FF;
        if (this.stones > GameObjects.RESOURCE_CAPS[1]) {
            this.stones = GameObjects.RESOURCE_CAPS[1];
        }
        this.mana += this.intelligence;
        if (this.mana > GameObjects.RESOURCE_CAPS[2]) {
            this.mana = GameObjects.RESOURCE_CAPS[2];
        }
    }

    public void addGold(int amount) {
        this.money += amount;
        if (this.money > GameObjects.RESOURCE_CAPS[0]) {
            this.money = GameObjects.RESOURCE_CAPS[0];
        }
    }

    public void addStone(int amount) {
        this.stones += amount;
        if (this.stones > GameObjects.RESOURCE_CAPS[1]) {
            this.stones = GameObjects.RESOURCE_CAPS[1];
        }
    }

    public void addMana(int amount) {
        this.mana += amount;
        if (this.mana > GameObjects.RESOURCE_CAPS[2]) {
            this.mana = GameObjects.RESOURCE_CAPS[2];
        }
    }

    public void resetUnitCounters() {
        int i = 0;
        while (i < this.unitsCounts.length) {
            this.unitsCounts[i] = 0;
            ++i;
        }
        this.besiegers = 0;
        this.underSiege = false;
    }

    public void setWarlordByType(int type) {
        switch (type) {
            case 0: {
                this.charisma = 1;
                this.morality = 1;
                this.intelligence = 2;
                this.wizardry = 0;
                break;
            }
            case 1: {
                this.charisma = 1;
                this.morality = 1;
                this.intelligence = 2;
                this.wizardry = 1;
                break;
            }
            default: {
                this.charisma = 1;
                this.morality = 1;
                this.intelligence = 2;
                this.wizardry = 0;
            }
        }
        this.resetEnchantments();
    }

    public void setWarlord(int charisma, int morality, int intelligence, int wizardType) {
        this.charisma = charisma;
        this.morality = morality;
        this.intelligence = intelligence;
        this.wizardType = wizardType;
        switch (wizardType) {
            case 0: {
                this.wizardry = 0;
                this.ability = 0;
                this.addBattlePerson(SPAMMER1);
                this.addBattlePerson(VALIANT1);
                this.addMagicPerson(ENCHANTER);
                this.addMagicPerson(MIXED1);
                break;
            }
            case 1: {
                this.wizardry = 0;
                this.ability = 8;
                this.addBattlePerson(SPAMMER2);
                this.addBattlePerson(TITAN2);
                this.addMagicPerson(ARMORER);
                this.addMagicPerson(MIXED2);
                break;
            }
            case 2: {
                this.wizardry = 0;
                this.ability = 16;
                this.addBattlePerson(TITAN1);
                this.addBattlePerson(VALIANT3);
                this.addMagicPerson(MSPAMMERDD2);
                this.addMagicPerson(MIXED2);
                break;
            }
            case 3: {
                this.wizardry = 0;
                this.ability = 32;
                this.addBattlePerson(TITAN2);
                this.addBattlePerson(DEFENDER);
                this.addMagicPerson(MSPAMMERDD1);
                this.addMagicPerson(MIXED1);
                break;
            }
            case 4: {
                this.wizardry = 1;
                this.ability = 0;
                this.addBattlePerson(AVERAGEJOE);
                this.addBattlePerson(DEFENDER);
                this.addMagicPerson(BALANCED);
                this.addMagicPerson(MIXED2);
                break;
            }
            case 5: {
                this.wizardry = 1;
                this.ability = 1;
                this.addBattlePerson(VALIANT2);
                this.addBattlePerson(TITAN3);
                this.addMagicPerson(CHIEFTAIN);
                this.addMagicPerson(BALANCED);
                break;
            }
            case 6: {
                this.wizardry = 1;
                this.ability = 2;
                this.addBattlePerson(SPAMMER3);
                this.addBattlePerson(VALIANT3);
                this.addMagicPerson(BERSERK);
                this.addMagicPerson(CHIEFTAIN);
                break;
            }
            case 7: {
                this.wizardry = 1;
                this.ability = 4;
                this.addBattlePerson(TITAN3);
                this.addBattlePerson(DEFENDER);
                this.addMagicPerson(BALANCED);
                this.addMagicPerson(ARMORER);
                break;
            }
            default: {
                this.wizardry = 0;
                this.ability = 0;
                this.addBattlePerson(SPAMMER1);
                this.addBattlePerson(VALIANT1);
                this.addMagicPerson(ENCHANTER);
                this.addMagicPerson(MIXED1);
            }
        }
    }

    public void generateWarlordCharacteristics(int totalAvailablePoints) {
        int availablePoints = totalAvailablePoints;
        this.intelligence = CLGameCanvas.random(availablePoints) + 2;
        availablePoints -= this.intelligence;
        this.charisma = CLGameCanvas.random(availablePoints += 2) + 1;
        availablePoints -= this.charisma;
        this.morality = ++availablePoints + 1;
        this.level = availablePoints;
    }

    public void generateWarlord(boolean hasAbility) {
        int availablePoints = GameObjects.SKIRMISH_TOTAL_WPOINTS;
        this.intelligence = CLGameCanvas.random(availablePoints) + 2;
        availablePoints -= this.intelligence;
        this.charisma = CLGameCanvas.random(availablePoints += 2) + 1;
        availablePoints -= this.charisma;
        this.morality = ++availablePoints + 1;
        int wizardType = CLGameCanvas.random(7);
        switch (wizardType) {
            case 0: {
                this.wizardry = 0;
                this.ability = 0;
                this.addBattlePerson(SPAMMER1);
                this.addBattlePerson(VALIANT1);
                this.addMagicPerson(ENCHANTER);
                this.addMagicPerson(MIXED1);
                break;
            }
            case 1: {
                this.wizardry = 0;
                this.ability = 8;
                this.addBattlePerson(SPAMMER2);
                this.addBattlePerson(TITAN2);
                this.addMagicPerson(ARMORER);
                this.addMagicPerson(MIXED2);
                break;
            }
            case 2: {
                this.wizardry = 0;
                this.ability = 16;
                this.addBattlePerson(TITAN1);
                this.addBattlePerson(VALIANT3);
                this.addMagicPerson(MSPAMMERDD2);
                this.addMagicPerson(MIXED2);
                break;
            }
            case 3: {
                this.wizardry = 0;
                this.ability = 32;
                this.addBattlePerson(TITAN2);
                this.addBattlePerson(DEFENDER);
                this.addMagicPerson(MSPAMMERDD1);
                this.addMagicPerson(MIXED1);
                break;
            }
            case 4: {
                this.wizardry = 1;
                this.ability = 0;
                this.addBattlePerson(AVERAGEJOE);
                this.addBattlePerson(DEFENDER);
                this.addMagicPerson(BALANCED);
                this.addMagicPerson(MIXED2);
                break;
            }
            case 5: {
                this.wizardry = 1;
                this.ability = 1;
                this.addBattlePerson(VALIANT2);
                this.addBattlePerson(TITAN3);
                this.addMagicPerson(CHIEFTAIN);
                this.addMagicPerson(BALANCED);
                break;
            }
            case 6: {
                this.wizardry = 1;
                this.ability = 2;
                this.addBattlePerson(SPAMMER3);
                this.addBattlePerson(VALIANT3);
                this.addMagicPerson(BERSERK);
                this.addMagicPerson(CHIEFTAIN);
                break;
            }
            case 7: {
                this.wizardry = 1;
                this.ability = 4;
                this.addBattlePerson(TITAN3);
                this.addBattlePerson(DEFENDER);
                this.addMagicPerson(BALANCED);
                this.addMagicPerson(ARMORER);
                break;
            }
            default: {
                this.wizardry = 0;
                this.ability = 0;
                this.addBattlePerson(SPAMMER1);
                this.addBattlePerson(VALIANT1);
                this.addMagicPerson(ENCHANTER);
                this.addMagicPerson(MIXED1);
            }
        }
        if (!hasAbility) {
            this.ability = 0;
        }
    }

    public void setPersonOnSpike(Person person) {
        this.personOnSpike = person;
    }

    public void countdown() {
    }

    public boolean hasAbility(int ability) {
        return (this.ability & ability) == ability;
    }

    public void performActiveEnchantments(Person unit) {
        if (this.hasEnchantmentType(22)) {
            unit.addMagicLevel(CLGameCanvas.random(6));
        }
        if (this.hasEnchantmentType(23)) {
            unit.addMagicHitPoints(CLGameCanvas.random(15) - 2);
        }
        if (this.hasEnchantmentType(21)) {
            unit.addMagicPowerPoints(CLGameCanvas.random(5));
        }
        if (this.hasEnchantmentType(19)) {
            unit.addMagicAbility(65536);
        }
        if (this.hasEnchantmentType(20) && unit.type == 2) {
            unit.addMagicLevel(CLGameCanvas.random(5));
        }
        if (this.hasEnchantmentType(12)) {
            unit.addMagicAbility(2048);
        }
        if (this.hasEnchantmentType(17)) {
            unit.addMagicAbility(32768);
        }
        if (this.hasEnchantmentType(6)) {
            unit.addMagicAbility(1024);
        }
        if (this.hasEnchantmentType(21)) {
            unit.addMagicPowerPoints(CLGameCanvas.random(6));
        }
        if (this.hasEnchantmentType(23)) {
            unit.addMagicPowerPoints(CLGameCanvas.random(15) - 2);
        }
        if (this.hasEnchantmentType(22)) {
            unit.addMagicLevel(CLGameCanvas.random(5));
        }
        if (this.hasEnchantmentType(20) && unit.type == 2) {
            unit.addMagicLevel(CLGameCanvas.random(5));
        }
        int i = 0;
        while (i < this.gameObjects.getLiveObjects().size()) {
            GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
            if ((temp instanceof Walker || temp instanceof Boss) && temp.ownedByBlue != unit.isOwnedByBlue() && ((Person)temp).hasStackBonus(8) && GameObject.getChance(GameObjects.FEAR_CHANCES[((Person)temp).level - 1]) && !unit.hasStackAbility(16)) {
                unit.addStackAbility(16);
                unit.powerPoints -= GameObjects.FEAR_COMBAT_POINTS[((Person)temp).level - 1];
                unit.hitPoints -= GameObjects.FEAR_HP_POINTS[((Person)temp).level - 1];
                if (unit.powerPoints < 1) {
                    unit.powerPoints = 1;
                }
                if (unit.hitPoints < 1) {
                    unit.hitPoints = 1;
                }
            }
            ++i;
        }
    }

    public void addEnchantment(Spell enchantment) {
        boolean added = false;
        if (this.enchantment1 == null) {
            this.enchantment1 = enchantment;
            added = true;
        } else if (this.enchantment2 == null) {
            this.enchantment2 = enchantment;
        } else {
            this.enchantment1.duration = 0;
            this.enchantment1 = this.enchantment2;
            this.enchantment2 = enchantment;
        }
    }

    public void resetEnchantments() {
        if (this.enchantment1 != null) {
            this.enchantment1.duration = 0;
            this.enchantment1 = null;
        }
        if (this.enchantment2 != null) {
            this.enchantment2.duration = 0;
            this.enchantment2 = null;
        }
    }

    public boolean hasEnchantment(Spell enchantment) {
        return this.enchantment1 == enchantment || this.enchantment2 == enchantment;
    }

    public boolean hasEnchantmentType(int spellType) {
        return this.getEnchantment1Type() == spellType || this.getEnchantment2Type() == spellType;
    }

    public int getEnchantment1Type() {
        if (this.enchantment1 == null) {
            return 0;
        }
        return this.enchantment1.type;
    }

    public int getEnchantment2Type() {
        if (this.enchantment2 == null) {
            return 0;
        }
        return this.enchantment2.type;
    }

    public int getNumberOfActiveEnchantments() {
        int result = 0;
        if (this.enchantment1 != null) {
            ++result;
        }
        if (this.enchantment2 != null) {
            ++result;
        }
        return result;
    }

    public boolean removeEnchantment(Spell enchantment) {
        if (this.enchantment1 == enchantment) {
            if (this.enchantment2 != null) {
                this.enchantment1 = this.enchantment2;
                this.enchantment2 = null;
                return true;
            }
            this.enchantment1 = null;
            return true;
        }
        if (this.enchantment2 == enchantment) {
            this.enchantment2 = null;
            return true;
        }
        return false;
    }

    public boolean removeEnchantmentType(int spellType) {
        if (this.enchantment1.type == spellType) {
            this.enchantment1.duration = 0;
            if (this.enchantment2 != null) {
                this.enchantment1 = this.enchantment2;
                this.enchantment2 = null;
                return true;
            }
            this.enchantment1 = null;
            return true;
        }
        if (this.enchantment2.type == spellType) {
            this.enchantment2.duration = 0;
            this.enchantment2 = null;
            return true;
        }
        return false;
    }

    public void addMagicPerson(int person) {
        this.magicPerson |= person;
    }

    public void removeMagicPerson(int person) {
        this.magicPerson ^= person;
    }

    public boolean hasMagicPerson(int person) {
        return (this.magicPerson & person) == person;
    }

    public void addBattlePerson(int person) {
        this.battlePerson |= person;
    }

    public void removeBattlePerson(int person) {
        this.battlePerson ^= person;
    }

    public boolean hasBattlePerson(int person) {
        return (this.battlePerson & person) == person;
    }

    public int getBuildTime(byte type, byte sub_type) {
        int result = 0;
        switch (type) {
            case 2: {
                result = GameObjects.buildingsBuildTime[sub_type];
                break;
            }
            case 1: {
                int level = this.upgradeLevel[sub_type];
                result = GameObjects.upgradeBuildTime[this.race * 5 + level][sub_type];
                break;
            }
            case 0: {
                result = this.hasEnchantmentType(9) ? GameObjects.unitsBuildTime[sub_type] * (100 - GameObjects.ALL_SPELLS_CHAR[9][GameObjects.BUILDTIME_POINTER]) / 100 : GameObjects.unitsBuildTime[sub_type];
                result = this.hasEnchantmentType(14) ? GameObjects.unitsBuildTime[sub_type] * (100 - GameObjects.ALL_SPELLS_CHAR[14][GameObjects.BUILDTIME_POINTER]) / 100 : GameObjects.unitsBuildTime[sub_type];
            }
        }
        return result;
    }

    public int getUnitPrice(byte res_type, byte sub_type) {
        int result = 0;
        result = this.hasEnchantmentType(9) ? GameObjects.unitsPrice[res_type + this.race * 3][sub_type] * (100 + GameObjects.ALL_SPELLS_CHAR[9][GameObjects.PERCENTAGE_POINTER]) / 100 : GameObjects.unitsPrice[res_type + this.race * 3][sub_type];
        return result * this.characteristicsCoeficient() / 100;
    }

    public int getUpgradePrice(int res_type, int sub_type) {
        int level = this.upgradeLevel[sub_type];
        switch (res_type) {
            case 0: {
                return GameObjects.upgradeUnitsPriceGLD[level + this.race * 5][sub_type] * this.characteristicsCoeficient() / 100;
            }
            case 1: {
                return GameObjects.upgradeUnitsPriceSTN[level + this.race * 5][sub_type] * this.characteristicsCoeficient() / 100;
            }
            case 2: {
                return GameObjects.upgradeUnitsPriceMNA[level + this.race * 5][sub_type] * this.characteristicsCoeficient() / 100;
            }
        }
        return 0;
    }

    public int getSpellPriceByType(int type) {
        int totalPrice = GameObjects.SPELLS_PRICES[type];
        if (this.hasEnchantmentType(5)) {
            totalPrice *= (100 + GameObjects.ALL_SPELLS_CHAR[5][GameObjects.PERCENTAGE_POINTER]) / 100;
        }
        if (type == 15 || type == 16) {
            totalPrice = totalPrice * this.characteristicsCoeficient() / 100;
        }
        return totalPrice;
    }

    public int getSpellPrice(Spell spell) {
        int totalPrice = GameObjects.SPELLS_PRICES[spell.type];
        if (this.hasEnchantmentType(5)) {
            totalPrice *= (100 + GameObjects.ALL_SPELLS_CHAR[5][GameObjects.PERCENTAGE_POINTER]) / 100;
        }
        if (spell.type == 15 || spell.type == 16) {
            totalPrice = totalPrice * this.characteristicsCoeficient() / 100;
        }
        return totalPrice;
    }

    public int getBuildingPrice(byte res_type, byte sub_type) {
        return GameObjects.BUILDINGS_PRICES[res_type][sub_type];
    }

    public boolean productConformsWithTechTree(byte type, byte sub_type) {
        switch (type) {
            case 1: {
                return this.upgradeLevel[sub_type] < this.tt_unit_max_levels[sub_type];
            }
            case 2: {
                return this.tt_buildings[sub_type];
            }
        }
        return true;
    }

    public boolean addProduct(byte type, byte sub_type, int batch) {
        if (this.productConformsWithTechTree(type, sub_type)) {
            Product prod = new Product(type, sub_type, batch);
            if (!prod.productApproved()) {
                return false;
            }
            boolean found = false;
            int i = 0;
            while (i < this.products.size() && !found) {
                Product p = (Product)this.products.elementAt(i);
                found = p.type == prod.type;
                ++i;
            }
            if (!found) {
                prod.startProducing();
            }
            this.products.addElement(prod);
        }
        return true;
    }

    public void produce() {
        this.finished_products = new Vector();
        int i = 0;
        while (i < this.products.size()) {
            Product prod = (Product)this.products.elementAt(i);
            prod.produce();
            ++i;
        }
        i = 0;
        while (i < this.finished_products.size()) {
            this.products.removeElement(this.finished_products.elementAt(i));
            ++i;
        }
    }

    public boolean isInProduction(byte type, byte sub_type) {
        boolean found = false;
        int i = 0;
        while (i < this.products.size()) {
            Product prod = (Product)this.products.elementAt(i);
            if (prod.type == type && prod.sub_type == sub_type) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    void productDone(Product prod) {
        boolean found = false;
        int i = 0;
        while (i < this.products.size() && !found) {
            Product p = (Product)this.products.elementAt(i);
            boolean bl = found = p != prod && p.type == prod.type;
            if (found) {
                p.startProducing();
            }
            ++i;
        }
        this.finished_products.addElement(prod);
    }

    public Product createProduct(byte type, byte sub_type, int batch) {
        return new Product(type, sub_type, batch);
    }

    public static int getProtectorChance(int level) {
        int retv = 0;
        if (level > 0 && level < PROTECTOR_CHANCES.length) {
            retv = PROTECTOR_CHANCES[level - 1];
        } else {
            System.out.println(level);
        }
        return retv;
    }

    public static int getBerserkChance(int level) {
        int retv = 0;
        if (level > 0 && level < BERSERK_CHANCES.length) {
            retv = BERSERK_CHANCES[level - 1];
        } else {
            System.out.println(level);
        }
        return retv;
    }

    public static int getPowermageChance(int level) {
        int retv = 0;
        if (level > 0 && level < POWERMAGE_CHANCES.length) {
            retv = POWERMAGE_CHANCES[level];
        } else {
            System.out.println(level);
        }
        return retv;
    }

    public int[] getAvailableSpellTypes() {
        if (this.campaign) {
            return this.spells;
        }
        if (this.wizardry == 0) {
            int[] spells = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
            return spells;
        }
        int[] spells = new int[]{14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        return spells;
    }

    public void setTechTree(int[] unitLevels, boolean[] available_buildings, boolean[] available_actions, int castle_level_limit) {
        this.tt_unit_max_levels = unitLevels;
        this.tt_buildings = available_buildings;
        this.tt_actions = available_actions;
        this.max_castle_level = castle_level_limit;
    }

    public void SaveWarlord(DataOutputStream dout) throws IOException {
        System.out.println("Saving warlord stats");
        dout.writeInt(this.wizardry);
        dout.writeInt(this.ability);
        dout.writeInt(this.morality);
        dout.writeInt(this.intelligence);
        dout.writeInt(this.charisma);
        dout.writeInt(this.level);
        dout.writeInt(this.remainingSkillPoints);
        dout.writeInt(this.spells.length);
        int i = 0;
        while (i < this.spells.length) {
            dout.writeInt(this.spells[i]);
            ++i;
        }
        dout.writeInt(this.spells_to_learn.length);
        i = 0;
        while (i < this.spells_to_learn.length) {
            dout.writeInt(this.spells_to_learn[i]);
            ++i;
        }
    }

    public void LoadWarlord(DataInputStream din) throws IOException {
        System.out.println("Loading warlord stats");
        this.wizardry = din.readInt();
        this.ability = din.readInt();
        this.morality = din.readInt();
        this.intelligence = din.readInt();
        this.charisma = din.readInt();
        this.level = din.readInt();
        this.remainingSkillPoints = din.readInt();
        this.spells = new int[din.readInt()];
        int i = 0;
        while (i < this.spells.length) {
            this.spells[i] = din.readInt();
            ++i;
        }
        this.spells_to_learn = new int[din.readInt()];
        i = 0;
        while (i < this.spells_to_learn.length) {
            this.spells_to_learn[i] = din.readInt();
            ++i;
        }
    }

    public class Product {
        byte type;
        byte sub_type;
        int build_time;
        int time = 0;
        int price_gold;
        int price_stone;
        int price_mana;
        int batch;
        final int batch_num;
        boolean started = false;
        boolean done = false;

        public Product(byte type, byte sub_type, int batch) {
            this.type = type;
            this.sub_type = sub_type;
            this.batch = this.batch_num = batch;
            switch (type) {
                case 0: {
                    this.price_gold = Warlord.this.getUnitPrice((byte)0, sub_type);
                    this.price_stone = Warlord.this.getUnitPrice((byte)1, sub_type);
                    this.price_mana = Warlord.this.getUnitPrice((byte)2, sub_type);
                    this.build_time = Warlord.this.getBuildTime(type, sub_type);
                    break;
                }
                case 1: {
                    this.price_gold = Warlord.this.getUpgradePrice(0, sub_type);
                    this.price_stone = Warlord.this.getUpgradePrice(1, sub_type);
                    this.price_mana = Warlord.this.getUpgradePrice(2, sub_type);
                    this.build_time = Warlord.this.getBuildTime(type, sub_type);
                    break;
                }
                case 2: {
                    this.price_gold = Warlord.this.getBuildingPrice((byte)0, sub_type);
                    this.price_stone = Warlord.this.getBuildingPrice((byte)1, sub_type);
                    this.price_mana = Warlord.this.getBuildingPrice((byte)2, sub_type);
                    this.build_time = Warlord.this.getBuildTime(type, sub_type);
                }
            }
        }

        public boolean productApproved() {
            if (Warlord.this.money >= this.price_gold * this.batch && Warlord.this.mana >= this.price_mana * this.batch && Warlord.this.stones >= this.price_stone * this.batch) {
                switch (this.type) {
                    case 0: {
                        switch (this.sub_type) {
                            case 2: {
                                Warlord.this.has_archer = true;
                                break;
                            }
                            case 4: {
                                if (Warlord.this.has_cannon) {
                                    return false;
                                }
                                Warlord.this.has_cannon = true;
                                System.out.println(".............HASCANNON true...........");
                            }
                        }
                        break;
                    }
                    case 1: {
                        byte by = this.sub_type;
                        Warlord.this.upgradeLevel[by] = Warlord.this.upgradeLevel[by] + 1;
                        break;
                    }
                    case 2: {
                        if (this.sub_type == 5) {
                            Warlord.this.wall_state = 1;
                        }
                        if (this.sub_type == 0) {
                            Warlord.this.planned_villages = Warlord.this.planned_villages == 0 ? Warlord.this.villages + 1 : ++Warlord.this.planned_villages;
                            if (Warlord.this.planned_villages == Warlord.this.max_villages) {
                                Warlord.this.tt_buildings[0] = false;
                            }
                        }
                        if (this.sub_type != 1) break;
                        Warlord.this.planned_mines = Warlord.this.planned_mines == 0 ? Warlord.this.mines + 1 : ++Warlord.this.planned_mines;
                        if (Warlord.this.planned_mines != Warlord.this.max_mines) break;
                        Warlord.this.tt_buildings[1] = false;
                    }
                }
                Warlord.this.money -= this.price_gold * this.batch;
                Warlord.this.mana -= this.price_mana * this.batch;
                Warlord.this.stones -= this.price_stone * this.batch;
                return true;
            }
            return false;
        }

        public void startProducing() {
            this.started = true;
        }

        public void produce() {
            if (this.started) {
                this.time += XCanvas.DT;
                if (!this.done && this.time >= this.build_time) {
                    this.done = true;
                }
                if (this.done) {
                    int i = 0;
                    while (i < this.batch) {
                        this.productComplete();
                        ++i;
                    }
                    Warlord.this.productDone(this);
                }
            }
        }

        public void productComplete() {
            block26: {
                block0 : switch (this.type) {
                    case 0: {
                        Person unit = null;
                        unit = Warlord.this.createUnit(this.sub_type, true);
                        if (unit != null && this.sub_type == 2) {
                            Warlord.this.archer = (Archer)unit;
                        }
                        if (unit != null) {
                            if (unit instanceof Walker) {
                                Warlord.this.gameObjects.performStackBonuses((Walker)unit);
                            }
                            Warlord.this.performActiveEnchantments(unit);
                            break;
                        }
                        System.out.println("ALERT: unit is null !!!!, subtype= " + this.sub_type);
                        break;
                    }
                    case 1: {
                        Warlord.this.upgradeUnit(this.sub_type);
                        switch (this.sub_type) {
                            case 0: {
                                CLGameCanvas.playerGameEvent = 170;
                                break;
                            }
                            case 1: {
                                CLGameCanvas.playerGameEvent = 171;
                                System.out.println("TRAIN COMPLETE " + CLGameCanvas.playerGameEvent);
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (this.sub_type) {
                            case 0: {
                                ++Warlord.this.villages;
                                CLGameCanvas.playerGameEvent = 21;
                                break block0;
                            }
                            case 1: {
                                ++Warlord.this.mines;
                                CLGameCanvas.playerGameEvent = 110;
                                break block0;
                            }
                            case 2: {
                                ++Warlord.this.shrines;
                                break block0;
                            }
                            case 3: {
                                Warlord.this.castlePower += GameObjects.CASTLE_LEVEL_HP[Warlord.this.castleLevel] * GameObjects.CASTLE_LEVEL_REPAIR[Warlord.this.castleLevel] / 100;
                                if (Warlord.this.castlePower > GameObjects.CASTLE_LEVEL_HP[Warlord.this.castleLevel]) {
                                    Warlord.this.castlePower = GameObjects.CASTLE_LEVEL_HP[Warlord.this.castleLevel];
                                    break block0;
                                }
                                break block26;
                            }
                            case 4: {
                                Warlord.this.gameObjects.addSpell(new Spell(1, Warlord.this == Warlord.this.gameObjects.blueWarlord, Warlord.this == Warlord.this.gameObjects.blueWarlord ? Warlord.this.gameObjects.blueWarlord.intelligence - 1 : Warlord.this.gameObjects.redWarlord.intelligence - 1, Warlord.this.gameObjects, WarlordsCastles.imageTracker));
                                Warlord.this.gameObjects.addCenterText(CLLocales.getString("DEFENCE"), 10, Warlord.this == Warlord.this.gameObjects.blueWarlord ? 3 : 4);
                                break block0;
                            }
                            case 5: {
                                int wPosY;
                                int wPosX2;
                                int wPosX1;
                                GameObject wall = null;
                                if (Warlord.this == Warlord.this.gameObjects.blueWarlord) {
                                    wPosX1 = 140;
                                    wPosX2 = 102;
                                    wPosY = 213;
                                    wall = Warlord.this.gameObjects.addLiveObject(new Wall(140, 112, Warlord.this.getUnitHP(5), Warlord.this.getUnitPP(5), true, Warlord.this.gameObjects, WarlordsCastles.imageTracker));
                                } else {
                                    wPosX1 = -116;
                                    wPosX2 = -78;
                                    wPosY = 213;
                                    wall = Warlord.this.gameObjects.addLiveObject(new Wall(388, 112, Warlord.this.gameObjects.redWarlord.getUnitHP(5), Warlord.this.gameObjects.redWarlord.getUnitPP(5), false, Warlord.this.gameObjects, WarlordsCastles.imageTracker));
                                }
                                CLGameCanvas.addHitAnim(wPosX1, wPosY, (byte)1);
                                CLGameCanvas.addHitAnim(wPosX2, wPosY, (byte)1);
                                int i = 0;
                                while (i < Warlord.this.gameObjects.getLiveObjects().size()) {
                                    GameObject temp = (GameObject)((Object)Warlord.this.gameObjects.getLiveObjects().elementAt(i));
                                    if (temp instanceof Walker && temp.collideWith(wall)) {
                                        ((Walker)temp).hitPoints = 0;
                                        ((Walker)temp).magicHitPoints = 0;
                                    }
                                    if (temp instanceof Resource && temp.collideWith(wall)) {
                                        ((Resource)temp).hitPoints = 0;
                                    }
                                    ++i;
                                }
                                Warlord.this.wall_state = (byte)2;
                                CLGameCanvas.playerGameEvent = 111;
                            }
                        }
                    }
                }
            }
        }

        public int drawProduct(Graphics g, int y, boolean left_side) {
            int x = 0;
            int h = 0;
            switch (this.type) {
                case 0: 
                case 1: {
                    if (!left_side) {
                        x = XCanvas.WIDTH - CLImageTracker.portraits.getWidth() - 4;
                    }
                    h = CLImageTracker.portraits.getHeight();
                    CLImageTracker.portraits.drawSubImage(g, x, y, 0, this.sub_type);
                    g.setColor(0x887868);
                    g.drawRect(x, y, CLImageTracker.portraits.getWidth() - 1, h - 1);
                    if (this.type == 0) {
                        CLImageTracker.numbers.drawSubImage(g, x + 1, y + h - CLImageTracker.numbers.getHeight(), 0, this.batch_num - 1);
                    } else if (this.type == 1) {
                        CLImageTracker.small_icons.drawSubImage(g, x + 1, y + h - CLImageTracker.small_icons.getHeight(), 0, 6);
                    }
                    x += CLImageTracker.portraits.getWidth();
                    break;
                }
                case 2: {
                    h = CLImageTracker.buildings.getHeight();
                    if (!left_side) {
                        x = XCanvas.WIDTH - CLImageTracker.buildings.getWidth() - 4;
                    }
                    CLImageTracker.buildings.drawSubImage(g, x, y, 0, this.sub_type);
                    g.setColor(0x887868);
                    g.drawRect(x, y, CLImageTracker.buildings.getWidth() - 1, h - 1);
                    x += CLImageTracker.buildings.getWidth();
                }
            }
            g.setColor(0x887868);
            g.drawRect(x, y, 3, h - 1);
            int size = (h -= 2) * this.time / this.build_time;
            g.setColor(6661632);
            g.fillRect(++x, ++y + h - size, 1, size);
            g.setColor(9101824);
            g.fillRect(x + 1, y + h - size, 1, size);
            return y + h + 2;
        }
    }
}

