/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.game;

import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.GameTemplate;
import com.tqm.fantasydefense.game.Enemy;
import com.tqm.fantasydefense.game.UnitPipeline;
import com.tqm.fantasydefense.game.Wave;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class EnemyWaves {
    public static Vector enemies = new Vector();
    private static Vector waves = new Vector();
    private Enemy enemy;
    private Wave wave;
    public static int _currentWave;
    public static int _waveCount;
    private static int _enemiesAdded;
    private boolean forcedWin = false;

    public final void clear() {
        enemies.removeAllElements();
        waves.removeAllElements();
        _currentWave = 0;
        _enemiesAdded = 0;
        _waveCount = 0;
        this.forcedWin = false;
    }

    public final void addWave(int n, int n2, int n3, int n4, int n5, int n6) {
        waves.addElement(new Wave(n, n2, n3, n4, n5, n6));
        if (waves.size() <= 1) {
            this.wave = (Wave)waves.lastElement();
            this.wave.setStart(0);
        } else {
            n = ((Wave)EnemyWaves.waves.elementAt((int)(EnemyWaves.waves.size() - 2)))._start;
            this.wave = (Wave)waves.lastElement();
            this.wave.setStart(n);
        }
        ++_waveCount;
    }

    public static int getWaveType(int wave) {
        if (wave >= waves.size() || wave < 0) {
            return 0;
        }
        return ((Wave)EnemyWaves.waves.elementAt((int)wave))._type;
    }

    public static int getWaveTime(int wave) {
        if (wave >= waves.size() || wave < 0) {
            return 0;
        }
        return ((Wave)EnemyWaves.waves.elementAt((int)wave))._enemyCount * ((Wave)EnemyWaves.waves.elementAt((int)wave))._enemyInterval;
    }

    private static Wave getCurrentWave() {
        return (Wave)waves.elementAt(_currentWave);
    }

    public static boolean hasAllEnemiesSpawnedInCurrWave() {
        if (_currentWave < waves.size()) {
            return EnemyWaves.getCurrentWave()._enemiesSpawned == EnemyWaves.getCurrentWave()._enemyCount;
        }
        return false;
    }

    public final void think() {
        Enumeration enumeration = waves.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            boolean bl;
            Wave wave = this.wave = (Wave)enumeration.nextElement();
            if (GameTemplate.getIter() > wave._start && GameTemplate.getIter() <= wave._start + wave._enemyInterval * wave._enemyCount) {
                if (GameTemplate.getIter() >= wave._start + wave._enemyInterval * wave._enemiesSpawned && wave._enemiesSpawned < wave._enemyCount) {
                    int n2 = wave._healthIncrease;
                    int n3 = wave._type;
                    int n4 = wave._road;
                    enemies.addElement(new Enemy(n4, n3, n2));
                    ++_enemiesAdded;
                    ++wave._enemiesSpawned;
                }
                bl = true;
            } else {
                bl = false;
            }
            if (bl && _currentWave < n) {
                _currentWave = n;
            }
            ++n;
        }
        n = 0;
        enumeration = enemies.elements();
        while (enumeration.hasMoreElements()) {
            this.enemy = (Enemy)enumeration.nextElement();
            if (!this.enemy.think()) {
                GameTemplate._money += this.enemy.getReward();
                if (GameTemplate.getGameMode() != 1) {
                    ++GameLogic.achivementStats.killedEnemies;
                    switch (this.enemy._type) {
                        case 0: {
                            ++GameLogic.achivementStats.killedOrks;
                            break;
                        }
                        case 1: {
                            ++GameLogic.achivementStats.killedSkeletons;
                            break;
                        }
                        case 3: {
                            ++GameLogic.achivementStats.killedElementals;
                            break;
                        }
                        case 2: {
                            ++GameLogic.achivementStats.killedElementals;
                            break;
                        }
                        case 4: {
                            ++GameLogic.achivementStats.killedWiches;
                            break;
                        }
                        case 5: {
                            ++GameLogic.achivementStats.killedGhosts;
                            break;
                        }
                        case 6: {
                            ++GameLogic.achivementStats.killedDrakes;
                        }
                    }
                }
                enemies.removeElementAt(n);
                ++GameTemplate.enemiesKilled;
                --n;
            }
            ++n;
        }
    }

    public final void drawLandUnits() {
        Enumeration enumeration = enemies.elements();
        GameTemplate.resetMarkers();
        while (enumeration.hasMoreElements()) {
            this.enemy = (Enemy)enumeration.nextElement();
            this.enemy.addToMarker();
            if (!this.enemy.visible() || this.enemy.isAir()) continue;
            UnitPipeline.addUnit(this.enemy);
        }
    }

    public final void drawAirUnits() {
        Enumeration enumeration = enemies.elements();
        while (enumeration.hasMoreElements()) {
            this.enemy = (Enemy)enumeration.nextElement();
            if (!this.enemy.visible() || !this.enemy.isAir()) continue;
            UnitPipeline.addUnit(this.enemy);
        }
    }

    public final void drawShadows(Graphics g) {
        Enumeration e = enemies.elements();
        while (e.hasMoreElements()) {
            this.enemy = (Enemy)e.nextElement();
            if (!this.enemy.shadowVisible()) continue;
            this.enemy.drawShadow(g);
        }
    }

    public final void forceWin() {
        this.clear();
        this.forcedWin = true;
    }

    public final boolean playerWon() {
        if (this.forcedWin) {
            return true;
        }
        if (_waveCount - _currentWave - 1 == 0) {
            if (((Wave)EnemyWaves.waves.lastElement())._enemiesSpawned < ((Wave)EnemyWaves.waves.lastElement())._enemyCount) {
                return false;
            }
            int livingEnemies = 0;
            Enumeration e = enemies.elements();
            while (e.hasMoreElements()) {
                this.enemy = (Enemy)e.nextElement();
                if (this.enemy._health <= 0) continue;
                ++livingEnemies;
            }
            if (livingEnemies == 0 && GameTemplate.myCastle._castleHp > 0) {
                return true;
            }
        }
        return false;
    }
}

