/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.menu;

import com.tqm.agave.MainLogic;
import com.tqm.agave.menu.Container;
import com.tqm.agave.menu.Row;
import com.tqm.agave.menu.TextLabel;
import com.tqm.fantasydefense.FramedPaper;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.Tutorial;
import com.tqm.fantasydefense.shop.ShopManager;
import com.tqm.fantasydefense.shop.secret.SecretCampaign;
import com.tqm.fantasydefense.shop.secret.SecretItemsManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public final class WorldMap {
    private Sprite world2and3Sprite;
    private Sprite campaign1Sprite;
    private Sprite arrowSprite;
    private Sprite shopSprite;
    private Sprite shieldSprite;
    private Sprite padlockSprite;
    private Sprite castleSprite;
    private int fontWrapperVMargin;
    private int fontWrapperY;
    private int lineY;
    private GameLogic gameLogic;
    private Tutorial tutorial;
    private boolean[] rmsCastlesLocks;
    private int[] rmsCastlesDifficultyLevels;
    private int nextCastleToUnlock;
    private int currMapIndex;
    private int currMapCastleIndex;
    private boolean shopSelected;
    private SecretCampaign[] campaigns;
    private boolean stage1Achieved;
    private long goToShopAnimStartTime;
    private boolean goToShopAnim;
    private FramedPaper framedPaper;
    private boolean unlockingMapQuestion;
    private boolean unlockingMapQuestionNotEnoughGems;
    private boolean lockedCastleInfo;
    private int lockedCastleInfoLine1Y;
    private int lockedCastleInfoCastleStringY;
    private int lockedCastleInfoLine2Y;
    private String lockedCastleInfoCastleString;
    private Sprite worldMapIconsSprite;
    private Sprite crystalIconSprite;
    private Sprite moneyWindowSprite;
    private int questionLine1Y;
    private int questionStringY;
    private int questionLine2Y;
    private String worldMapPrice;
    private Container mapInfoContainer;

    public WorldMap(GameLogic gameLogic, Tutorial tutorial) {
        this.gameLogic = gameLogic;
        this.tutorial = tutorial;
        this.currMapIndex = 0;
        this.currMapCastleIndex = 0;
        this.shopSelected = false;
        this.rmsCastlesLocks = new boolean[21];
        this.rmsCastlesDifficultyLevels = new int[21];
        this.campaigns = SecretItemsManager.getInstance().getCampaigns();
        this.framedPaper = new FramedPaper();
        this.mapInfoContainer = new Container(MainLogic.width, MainLogic.height, 129);
        FramedPaper.setContainerParams(this.mapInfoContainer);
    }

    public final void initSprites() {
        WorldMap worldMap;
        WorldMap worldMap2 = worldMap = this;
        if (worldMap.tutorial.isWorldMapTutorial()) {
            worldMap2.tutorial.initWorldMapTutorial();
        }
        if (worldMap2.unlockingMapQuestion) {
            worldMap2.initUnlockingMapQuestionParams();
        }
        worldMap.framedPaper.loadSprites();
        worldMap.framedPaper.setMenuFramePosition();
        worldMap.world2and3Sprite = GameLogic.loadSprite(3);
        worldMap.campaign1Sprite = GameLogic.loadSprite(34);
        worldMap.shopSprite = GameLogic.loadSprite(25);
        worldMap.arrowSprite = GameLogic.loadSprite(127);
        worldMap.shieldSprite = GameLogic.loadSprite(87);
        worldMap.padlockSprite = GameLogic.loadSprite(122);
        int n = worldMap.framedPaper.getPaperY() + worldMap.shopSprite.getHeight();
        worldMap.world2and3Sprite.setPosition((MainLogic.width - worldMap.world2and3Sprite.getWidth()) / 2, n - worldMap.world2and3Sprite.getHeight());
        worldMap.campaign1Sprite.setPosition((MainLogic.width - worldMap.campaign1Sprite.getWidth()) / 2, n - worldMap.campaign1Sprite.getHeight());
        worldMap.shopSprite.setPosition((MainLogic.width - worldMap.shopSprite.getWidth()) / 2, n - worldMap.shopSprite.getHeight());
        worldMap.fontWrapperVMargin = worldMap.gameLogic.getFontWrapper().getHeight() / 8;
        worldMap.fontWrapperY = worldMap.shopSprite.getY() + worldMap.shopSprite.getHeight() + worldMap.fontWrapperVMargin;
        worldMap.lineY = worldMap.fontWrapperY + worldMap.gameLogic.getFontWrapper().getHeight() + worldMap.fontWrapperVMargin;
        worldMap.reloadMap();
    }

    public final void deinitSprites() {
        WorldMap worldMap = this;
        if (MainLogic.getGameNextSubState() == 207 || MainLogic.getGameNextSubState() == 217) {
            worldMap.disposeSprites();
        }
        worldMap.gameLogic.getMenu().setRowSpace(GameLogic.getStdMenuRowSpace(worldMap.gameLogic.getFontWrapper()));
        worldMap.gameLogic.getMenu().setPosition(worldMap.gameLogic.getMenu().getX(), GameLogic.getStdMenuY());
        worldMap.gameLogic.getMenu().setSize(GameLogic.getStdMenuWidth(), GameLogic.getStdMenuHeight());
    }

    public final void disposeSprites() {
        WorldMap worldMap = this;
        worldMap.framedPaper.disposeSprites();
        MainLogic.disposeImage(3);
        MainLogic.disposeImage(34);
        MainLogic.disposeImage(127);
        MainLogic.disposeImage(25);
        MainLogic.disposeImage(87);
        MainLogic.disposeImage(122);
        worldMap.world2and3Sprite = null;
        worldMap.campaign1Sprite = null;
        worldMap.arrowSprite = null;
        worldMap.shopSprite = null;
        worldMap.shieldSprite = null;
        worldMap.padlockSprite = null;
    }

    public final void draw(Graphics object) {
        Object object2;
        Graphics graphics;
        Graphics graphics2 = object;
        object = this;
        ((WorldMap)object).gameLogic.getMenu().setTextColors(-7388160, -7388160);
        ((WorldMap)object).gameLogic.drawMenuSpritesWithoutTitle(graphics2);
        ((WorldMap)object).framedPaper.drawMenuFramedPaper(graphics2);
        switch (((WorldMap)object).currMapIndex) {
            case 0: {
                ((WorldMap)object).campaign1Sprite.paint(graphics2);
                super.drawPadlock(graphics2, ((WorldMap)object).campaign1Sprite);
                break;
            }
            case 1: {
                ((WorldMap)object).world2and3Sprite.setFrame(1);
                ((WorldMap)object).world2and3Sprite.paint(graphics2);
                super.drawPadlock(graphics2, ((WorldMap)object).world2and3Sprite);
                break;
            }
            case 2: {
                ((WorldMap)object).world2and3Sprite.setFrame(3);
                ((WorldMap)object).world2and3Sprite.paint(graphics2);
                super.drawPadlock(graphics2, ((WorldMap)object).world2and3Sprite);
                break;
            }
            case 3: {
                ((WorldMap)object).shopSprite.paint(graphics2);
            }
        }
        int n = ((WorldMap)object).shopSprite.getY() + (((WorldMap)object).shopSprite.getHeight() - ((WorldMap)object).arrowSprite.getHeight()) / 2;
        ((WorldMap)object).arrowSprite.setTransform(2);
        ((WorldMap)object).arrowSprite.setPosition(FramedPaper.menuLineX1, n);
        ((WorldMap)object).arrowSprite.paint(graphics2);
        ((WorldMap)object).arrowSprite.setTransform(0);
        ((WorldMap)object).arrowSprite.setPosition(FramedPaper.menuLineX2 - ((WorldMap)object).arrowSprite.getWidth(), n);
        ((WorldMap)object).arrowSprite.paint(graphics2);
        ((WorldMap)object).gameLogic.getFontWrapper().drawString(graphics2, ((WorldMap)object).gameLogic.getMenuTitle(), MainLogic.width / 2, ((WorldMap)object).fontWrapperY, 17);
        graphics2.setColor(-3621766);
        graphics2.drawLine(FramedPaper.menuLineX1, ((WorldMap)object).lineY, FramedPaper.menuLineX2, ((WorldMap)object).lineY);
        if (MainLogic.getGameSubState() == 204) {
            if (((WorldMap)object).currMapIndex != 3) {
                graphics = graphics2;
                Object object3 = object;
                object2 = ((WorldMap)object3).gameLogic.getMenu();
                for (int i = 0; i < ((Container)object2).getRows().length; ++i) {
                    Graphics graphics3;
                    Row row;
                    Object object4 = ((Container)object2).getRowAt(i);
                    int n2 = super.getCastleIndex(i);
                    if (((WorldMap)object3).rmsCastlesLocks[n2]) {
                        GameLogic.setRowColor((Row)object4, -7388160);
                    } else {
                        GameLogic.setRowColor((Row)object4, -5264229);
                    }
                    if (super.isCurrMapUnlocked()) {
                        row = object4;
                        n2 = super.getCastleIndex(i);
                        graphics3 = graphics;
                        object4 = object3;
                        int n3 = ((WorldMap)object4).shieldSprite.getFrameSequenceLength() - 1;
                        if (super.isCastleGained(n2)) {
                            n3 = ((WorldMap)object4).rmsCastlesDifficultyLevels[n2] - 1;
                        }
                        ((WorldMap)object4).shieldSprite.setFrame(n3);
                        super.drawMenuSign$20bfe756(graphics3, row, ((WorldMap)object4).shieldSprite);
                        continue;
                    }
                    row = object4;
                    graphics3 = graphics;
                    object4 = object3;
                    super.drawMenuSign$20bfe756(graphics3, row, ((WorldMap)object4).padlockSprite);
                }
            }
            GameLogic.setDefaultScrollbarColor();
            ((WorldMap)object).gameLogic.getMenu().setPosition(((WorldMap)object).gameLogic.getMenu().getX(), ((WorldMap)object).gameLogic.getMenu().getY());
            ((WorldMap)object).gameLogic.getMenu().draw(graphics2);
        }
        graphics = graphics2;
        Object object5 = object;
        if (((WorldMap)object5).tutorial.isWorldMapTutorial()) {
            ((WorldMap)object5).tutorial.draw(graphics);
        } else {
            GameLogic.drawEnterIcon(graphics);
            if (!((WorldMap)object5).unlockingMapQuestionNotEnoughGems && !((WorldMap)object5).lockedCastleInfo) {
                GameLogic.drawBackIcon(graphics);
            }
        }
        if (((WorldMap)object5).unlockingMapQuestion) {
            Graphics graphics4 = graphics;
            object2 = object5;
            ((WorldMap)object2).framedPaper.drawMenuFramedPaper(graphics4);
            ((WorldMap)object2).worldMapIconsSprite.setFrame((((WorldMap)object2).currMapIndex - 1 << 1) + 1);
            ((WorldMap)object2).worldMapIconsSprite.paint(graphics4);
            ((WorldMap)object2).padlockSprite.setPosition(((WorldMap)object2).worldMapIconsSprite.getX() + (((WorldMap)object2).worldMapIconsSprite.getWidth() - ((WorldMap)object2).padlockSprite.getWidth()) / 2, ((WorldMap)object2).worldMapIconsSprite.getY() + ((WorldMap)object2).worldMapIconsSprite.getHeight() - ((WorldMap)object2).padlockSprite.getHeight() * 3 / 4);
            ((WorldMap)object2).padlockSprite.paint(graphics4);
            graphics4.setColor(-3621766);
            graphics4.drawLine(FramedPaper.menuLineX1, ((WorldMap)object2).questionLine1Y, FramedPaper.menuLineX2, ((WorldMap)object2).questionLine1Y);
            ((WorldMap)object2).gameLogic.getFontWrapper().drawString(graphics4, ((WorldMap)object2).gameLogic.getMenuTitle(), MainLogic.width / 2, ((WorldMap)object2).questionStringY, 17);
            graphics4.drawLine(FramedPaper.menuLineX1, ((WorldMap)object2).questionLine2Y, FramedPaper.menuLineX2, ((WorldMap)object2).questionLine2Y);
            int n4 = (MainLogic.width - ((WorldMap)object2).crystalIconSprite.getWidth() * 3 / 2 - GameLogic.getSystemFont().stringWidth(((WorldMap)object2).worldMapPrice)) / 2;
            ((WorldMap)object2).crystalIconSprite.setPosition(n4, ((WorldMap)object2).questionLine2Y + ((WorldMap)object2).crystalIconSprite.getHeight() / 3);
            ((WorldMap)object2).crystalIconSprite.paint(graphics4);
            n4 = ((WorldMap)object2).crystalIconSprite.getX() + ((WorldMap)object2).crystalIconSprite.getWidth() * 3 / 2;
            int n5 = ((WorldMap)object2).crystalIconSprite.getY() + (((WorldMap)object2).crystalIconSprite.getHeight() - GameLogic.getSystemFont().getHeight()) / 2;
            graphics4.setFont(GameLogic.getSystemFont());
            graphics4.setColor(-7388160);
            graphics4.drawString(((WorldMap)object2).worldMapPrice, n4, n5, 20);
            ((WorldMap)object2).mapInfoContainer.setPosition(((WorldMap)object2).mapInfoContainer.getX(), ((WorldMap)object2).mapInfoContainer.getY());
            ((WorldMap)object2).mapInfoContainer.draw(graphics4);
            ShopManager.drawMoneyWindow(graphics4, ((WorldMap)object2).moneyWindowSprite, ((WorldMap)object2).crystalIconSprite);
        }
        if (((WorldMap)object5).lockedCastleInfo) {
            Graphics graphics5 = graphics;
            object2 = object5;
            ((WorldMap)object2).framedPaper.drawMenuFramedPaper(graphics5);
            super.setLockedCastleInfoCastlePosition();
            ((WorldMap)object2).castleSprite.setFrame(0);
            ((WorldMap)object2).castleSprite.paint(graphics5);
            graphics5.setColor(-3621766);
            graphics5.drawLine(FramedPaper.menuLineX1, ((WorldMap)object2).lockedCastleInfoLine1Y, FramedPaper.menuLineX2, ((WorldMap)object2).lockedCastleInfoLine1Y);
            ((WorldMap)object2).gameLogic.getFontWrapper().drawString(graphics5, ((WorldMap)object2).lockedCastleInfoCastleString, MainLogic.width / 2, ((WorldMap)object2).lockedCastleInfoCastleStringY, 17);
            graphics5.drawLine(FramedPaper.menuLineX1, ((WorldMap)object2).lockedCastleInfoLine2Y, FramedPaper.menuLineX2, ((WorldMap)object2).lockedCastleInfoLine2Y);
            ((WorldMap)object2).mapInfoContainer.setPosition(((WorldMap)object2).mapInfoContainer.getX(), ((WorldMap)object2).mapInfoContainer.getY());
            ((WorldMap)object2).mapInfoContainer.draw(graphics5);
        }
    }

    private void drawPadlock(Graphics g, Sprite sprite) {
        if (!this.isCurrMapUnlocked()) {
            this.padlockSprite.setPosition(sprite.getX() + (sprite.getWidth() - this.padlockSprite.getWidth()) / 2, sprite.getY() + sprite.getHeight() - this.padlockSprite.getHeight() * 3 / 4);
            this.padlockSprite.paint(g);
        }
    }

    private void drawMenuSign$20bfe756(Graphics graphics, Row row, Sprite sprite) {
        Container container = this.gameLogic.getMenu();
        String string = ((TextLabel)row.getCellAt(0)).toString();
        int n = GameLogic.getSystemFont().stringWidth(string);
        n = container.getX() + (container.getWidth() - n) / 2 + n + sprite.getWidth() / 4;
        int n2 = graphics.getClipX();
        int n3 = graphics.getClipY();
        int n4 = graphics.getClipWidth();
        int n5 = graphics.getClipHeight();
        graphics.setClip(container.getX(), container.getY(), container.getWidth(), container.getHeight());
        sprite.setPosition(n, row.getY() + (row.getHeight() - sprite.getHeight()) / 2 + container.getTransY());
        sprite.paint(graphics);
        graphics.setClip(n2, n3, n4, n5);
    }

    public final void keyPressed(int n, int n2, int n3) {
        boolean bl;
        WorldMap worldMap;
        int n4 = n3;
        n3 = n2;
        n2 = n;
        WorldMap worldMap2 = worldMap = this;
        if (worldMap.tutorial.isWorldMapTutorial()) {
            worldMap2.tutorial.keyPressed(n2);
            bl = true;
        } else if (worldMap2.goToShopAnim) {
            bl = true;
        } else if (worldMap2.unlockingMapQuestion) {
            if (worldMap2.unlockingMapQuestionNotEnoughGems) {
                switch (n2) {
                    case 53: 
                    case 89: 
                    case 91: {
                        worldMap2.unlockingMapQuestionNotEnoughGems = false;
                        worldMap2.gameLogic.getShopManager().goToShopGemsAfterGemsQuestion();
                    }
                }
                bl = true;
            } else {
                switch (n2) {
                    case 53: 
                    case 89: 
                    case 91: {
                        if (!SecretItemsManager.getInstance().getCampaigns()[worldMap2.currMapIndex - 1].buy(1)) {
                            worldMap2.unlockingMapQuestionNotEnoughGems = true;
                            worldMap2.mapInfoContainer.setText$40907f8c(MainLogic.strings[276], GameLogic.getSystemFont(), null, 3);
                            GameLogic.changeContainerTextColor(worldMap2.mapInfoContainer);
                            break;
                        }
                        worldMap2.unlockFirstCastleInTheMap(worldMap2.currMapIndex);
                        worldMap2.unlockingMapQuestion = false;
                        worldMap2.deinitUnlockingMapQuestionParams();
                        break;
                    }
                    case 90: 
                    case 95: {
                        worldMap2.unlockingMapQuestion = false;
                        worldMap2.deinitUnlockingMapQuestionParams();
                        break;
                    }
                    case 50: 
                    case 56: 
                    case 85: 
                    case 87: {
                        worldMap2.mapInfoContainer.keyPressed(n2);
                    }
                }
                bl = true;
            }
        } else if (worldMap2.lockedCastleInfo) {
            switch (n2) {
                case 53: 
                case 89: 
                case 91: {
                    worldMap2.lockedCastleInfo = false;
                }
            }
            bl = true;
        } else {
            bl = false;
        }
        if (!bl) {
            switch (n2) {
                case 50: 
                case 85: {
                    if (worldMap.shopSelected) break;
                    if (worldMap.currMapCastleIndex > 0) {
                        --worldMap.currMapCastleIndex;
                        worldMap.gameLogic.getMenu().keyPressed(n2);
                        return;
                    }
                    if (worldMap.currMapCastleIndex != 0 || worldMap.currMapIndex <= 0) break;
                    worldMap.gameLogic.getMenu().keyPressed(n2);
                    worldMap.loadPrevMap();
                    return;
                }
                case 56: 
                case 87: {
                    if (worldMap.shopSelected) break;
                    if (worldMap.currMapCastleIndex < 6) {
                        ++worldMap.currMapCastleIndex;
                        worldMap.gameLogic.getMenu().keyPressed(n2);
                        return;
                    }
                    if (worldMap.currMapCastleIndex != 6 || worldMap.currMapIndex >= 2) break;
                    worldMap.gameLogic.getMenu().keyPressed(n2);
                    worldMap.loadNextMap();
                    return;
                }
                case 52: 
                case 88: {
                    worldMap.loadPrevMap();
                    return;
                }
                case 54: 
                case 86: {
                    worldMap.loadNextMap();
                    return;
                }
                case 53: 
                case 89: 
                case 91: {
                    if (worldMap.shopSelected) {
                        WorldMap.goToShop();
                        return;
                    }
                    if (worldMap.isLevelUnlocked(n3) && worldMap.isCurrMapUnlocked()) {
                        worldMap.initNextCastleToUnlock();
                        GameLogic.changeState(17, 251, 1, false);
                        return;
                    }
                    if (!worldMap.isCurrMapUnlocked()) {
                        worldMap.unlockingMapQuestion = true;
                        worldMap.initUnlockingMapQuestionParams();
                        return;
                    }
                    if (worldMap.isLevelUnlocked(n3) || !worldMap.isCurrMapUnlocked()) break;
                    worldMap.lockedCastleInfo = true;
                    worldMap2 = worldMap;
                    worldMap.castleSprite = GameLogic.loadSprite(84);
                    worldMap2.setLockedCastleInfoCastlePosition();
                    int n5 = worldMap2.castleSprite.getHeight() / 12;
                    worldMap2.lockedCastleInfoLine1Y = worldMap2.castleSprite.getY() + worldMap2.castleSprite.getHeight() + worldMap2.castleSprite.getHeight() / 20;
                    worldMap2.lockedCastleInfoCastleStringY = worldMap2.lockedCastleInfoLine1Y + n5 + 1;
                    worldMap2.lockedCastleInfoLine2Y = worldMap2.lockedCastleInfoLine1Y + worldMap2.gameLogic.getFontWrapper().getHeight() + 1 + (n5 << 1);
                    worldMap2.lockedCastleInfoCastleString = MainLogic.strings[271] + " " + (worldMap2.getCurrCastleIndex() + 1);
                    worldMap2.mapInfoContainer.setSize(FramedPaper.menuLineX2 - FramedPaper.menuLineX1 + 1, worldMap2.framedPaper.getPaperY() + worldMap2.framedPaper.getMenuPaperHeight() - worldMap2.lockedCastleInfoLine2Y);
                    worldMap2.mapInfoContainer.setPosition(FramedPaper.menuLineX1, worldMap2.lockedCastleInfoLine2Y);
                    worldMap2.mapInfoContainer.setText$40907f8c(MainLogic.strings[358], GameLogic.getSystemFont(), null, 3);
                    GameLogic.changeContainerTextColor(worldMap2.mapInfoContainer);
                    return;
                }
                case 90: 
                case 95: {
                    GameLogic.changeState(17, n4, 2, false);
                }
            }
        }
    }

    private void loadNextMap() {
        WorldMap worldMap = this;
        worldMap.currMapIndex = (worldMap.currMapIndex + 1) % 4;
        worldMap.currMapCastleIndex = 0;
        worldMap.reloadMap();
    }

    private void loadPrevMap() {
        WorldMap worldMap = this;
        worldMap.currMapIndex = worldMap.currMapIndex - 1 < 0 ? 3 : worldMap.currMapIndex - 1;
        worldMap.currMapCastleIndex = 6;
        worldMap.reloadMap();
    }

    private void reloadMap() {
        if (this.currMapIndex == 3) {
            this.shopSelected = true;
            this.gameLogic.setMenuTitle(this.gameLogic.getNameMenu(217));
            this.gameLogic.getMenu().setPosition(FramedPaper.menuLineX1, this.lineY + this.fontWrapperVMargin);
            this.gameLogic.getMenu().setSize(FramedPaper.menuLineX2 - FramedPaper.menuLineX1, this.framedPaper.getPaperY() + this.framedPaper.getMenuPaperHeight() - this.gameLogic.getMenu().getY() - this.fontWrapperVMargin);
            this.gameLogic.getMenu().setText$40907f8c(MainLogic.strings[370], GameLogic.getSystemFont(), null, 6);
            return;
        }
        this.shopSelected = false;
        this.gameLogic.setMenuTitle(this.gameLogic.getNameMenu(211));
        WorldMap worldMap = this;
        worldMap.gameLogic.getMenu().setRowSpace(0);
        worldMap.gameLogic.getMenu().setPosition(GameLogic.getStdMenuX(), worldMap.lineY + worldMap.fontWrapperVMargin);
        worldMap.gameLogic.getMenu().setSize(GameLogic.getStdMenuWidth() - worldMap.framedPaper.getWidePaperWidth() / 15, worldMap.framedPaper.getPaperY() + worldMap.framedPaper.getMenuPaperHeight() - worldMap.gameLogic.getMenu().getY() - worldMap.fontWrapperVMargin);
        worldMap.gameLogic.setMenuTitle(worldMap.gameLogic.getNameMenu(211));
        worldMap.gameLogic.initSystemFontMenuOptions(worldMap.gameLogic.getOptionsMenu(worldMap.getCurrMenu()));
        worldMap.gameLogic.getMenu().setSelected(worldMap.currMapCastleIndex);
        GameLogic.scrollContentToCurrResult(worldMap.currMapCastleIndex, worldMap.gameLogic.getMenu());
    }

    private void initUnlockingMapQuestionParams() {
        this.worldMapIconsSprite = GameLogic.loadSprite(3);
        this.castleSprite = GameLogic.loadSprite(84);
        this.worldMapIconsSprite.setPosition((MainLogic.width - this.worldMapIconsSprite.getWidth()) / 2, this.framedPaper.getPaperY() + this.worldMapIconsSprite.getHeight() / 10);
        int n = this.castleSprite.getHeight() / 12;
        this.questionLine1Y = this.worldMapIconsSprite.getY() + this.worldMapIconsSprite.getHeight() + this.worldMapIconsSprite.getHeight() / 8;
        this.questionStringY = this.questionLine1Y + n + 1;
        this.questionLine2Y = this.questionLine1Y + this.gameLogic.getFontWrapper().getHeight() + 1 + (n << 1);
        this.moneyWindowSprite = GameLogic.loadSprite(193);
        this.worldMapPrice = MainLogic.strings[343] + ": " + SecretItemsManager.getInstance().getCampaigns()[this.currMapIndex - 1].getPrice();
        this.crystalIconSprite = GameLogic.loadSprite(132);
        n = (MainLogic.width - this.crystalIconSprite.getWidth() * 3 / 2 - GameLogic.getSystemFont().stringWidth(this.worldMapPrice)) / 2;
        this.crystalIconSprite.setPosition(n, this.questionLine2Y + this.crystalIconSprite.getHeight() / 3);
        this.mapInfoContainer.setSize(FramedPaper.menuLineX2 - FramedPaper.menuLineX1 + 1, this.framedPaper.getPaperY() + this.framedPaper.getMenuPaperHeight() - this.crystalIconSprite.getY() - 3 * this.crystalIconSprite.getHeight());
        this.mapInfoContainer.setPosition(FramedPaper.menuLineX1, this.crystalIconSprite.getY() + 2 * this.crystalIconSprite.getHeight());
        this.mapInfoContainer.setText$40907f8c(MainLogic.strings[341], GameLogic.getSystemFont(), null, 3);
        GameLogic.changeContainerTextColor(this.mapInfoContainer);
    }

    private void deinitUnlockingMapQuestionParams() {
        GameLogic.disposeImage(3);
        GameLogic.disposeImage(132);
        GameLogic.disposeImage(193);
        this.worldMapIconsSprite = null;
        this.crystalIconSprite = null;
        this.moneyWindowSprite = null;
        MainLogic.disposeImage(84);
        this.castleSprite = null;
    }

    public final void setUnlockingMapQuestion$1385ff() {
        this.unlockingMapQuestion = false;
    }

    private static void goToShop() {
        GameLogic.changeState(17, 217, 1, false);
    }

    private boolean isCurrMapUnlocked() {
        switch (this.currMapIndex) {
            case 1: {
                return this.campaigns[0].isActive();
            }
            case 2: {
                return this.campaigns[1].isActive();
            }
        }
        return true;
    }

    public final int getCurrLevelNumber() {
        return this.getCurrCastleIndex() + 1;
    }

    public final int getCurrCastleIndex() {
        return this.getCastleIndex(this.currMapCastleIndex);
    }

    private int getCastleIndex(int mapCastleIndex) {
        return mapCastleIndex + this.currMapIndex * 7;
    }

    public final void loadCastlesLocksFromRMS() {
        String string = this.gameLogic.getGData().loadAsString(7);
        for (int i = 0; i < this.rmsCastlesLocks.length; ++i) {
            this.rmsCastlesLocks[i] = string.charAt(i) == '1';
        }
    }

    public final void initMapParams() {
        boolean paramsSet = false;
        this.shopSelected = false;
        this.currMapIndex = 2;
        this.currMapCastleIndex = 6;
        for (int i = 0; i < this.rmsCastlesLocks.length; ++i) {
            if (paramsSet || this.rmsCastlesLocks[i] || !this.rmsCastlesLocks[i - 1]) continue;
            this.currMapIndex = (i - 1) / 7;
            this.currMapCastleIndex = (i - 1) % 7;
            paramsSet = true;
        }
        this.initNextCastleToUnlock();
    }

    public final void initMapParamsAfterGameVictory() {
        this.shopSelected = false;
        int nextMapCastleIndex = this.currMapIndex * 7 + this.currMapCastleIndex + 1;
        if (nextMapCastleIndex < this.rmsCastlesLocks.length) {
            this.currMapIndex = nextMapCastleIndex / 7;
            this.currMapCastleIndex = nextMapCastleIndex % 7;
        }
        this.initNextCastleToUnlock();
    }

    private void initNextCastleToUnlock() {
        this.nextCastleToUnlock = 21;
        int n = this.getCurrCastleIndex() + 1;
        while (n < 21) {
            int n2;
            if (this.rmsCastlesLocks[n2 = n++]) continue;
            this.nextCastleToUnlock = n;
            return;
        }
    }

    public final void resetWorldMapParams() {
        int n;
        for (n = 0; n < this.rmsCastlesLocks.length; ++n) {
            this.rmsCastlesLocks[n] = false;
        }
        this.rmsCastlesLocks[0] = true;
        if (this.campaigns[0].isUnlocked()) {
            this.rmsCastlesLocks[7] = true;
        }
        if (this.campaigns[1].isUnlocked()) {
            this.rmsCastlesLocks[14] = true;
        }
        this.saveCastlesLocksToRMS();
        for (n = 0; n < this.rmsCastlesDifficultyLevels.length; ++n) {
            this.rmsCastlesDifficultyLevels[n] = 0;
        }
        this.gameLogic.getGData().save(WorldMap.getDefaultCastlesDifficultyLevelesToRMS(), 8);
    }

    private void saveCastlesLocksToRMS() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rmsCastlesLocks.length; ++i) {
            stringBuffer.append(this.rmsCastlesLocks[i] ? "1" : "0");
        }
        this.gameLogic.getGData().save(stringBuffer.toString(), 7);
    }

    public final void loadCastlesDifficultyLevelsFromRMS() {
        String string = this.gameLogic.getGData().loadAsString(8);
        for (int i = 0; i < this.rmsCastlesDifficultyLevels.length; ++i) {
            this.rmsCastlesDifficultyLevels[i] = Integer.parseInt(String.valueOf(string.charAt(i)));
        }
    }

    public final void unlockFirstCastleInTheMap(int n) {
        switch (n) {
            case 1: 
            case 2: {
                if (this.rmsCastlesLocks[n *= 7]) break;
                this.unlockCastle(n);
            }
        }
    }

    public final void unlockCastle(int castleIndex) {
        this.rmsCastlesLocks[castleIndex] = true;
        this.saveCastlesLocksToRMS();
    }

    public static String getDefaultCastlesDifficultyLevelesToRMS() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 21; ++i) {
            stringBuffer.append(Integer.toString(0));
        }
        return stringBuffer.toString();
    }

    private boolean isLevelUnlocked(int menuLevelOption) {
        return this.rmsCastlesLocks[menuLevelOption - 218];
    }

    private boolean isCastleGained(int n) {
        return this.rmsCastlesDifficultyLevels[n] != 0;
    }

    public final boolean isCastleGainedOnDifficultyLevel(int n, int n2) {
        return this.isCastleGained(n) && this.rmsCastlesDifficultyLevels[n] <= n2;
    }

    public final int[] getCastlesDifficultyLevels() {
        return this.rmsCastlesDifficultyLevels;
    }

    public final void gainCastle(int n, int n2) {
        if (this.rmsCastlesLocks[n] && (this.rmsCastlesDifficultyLevels[n] == 0 || this.rmsCastlesDifficultyLevels[n] > n2)) {
            this.rmsCastlesDifficultyLevels[n] = n2;
            WorldMap worldMap = this;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < worldMap.rmsCastlesDifficultyLevels.length; ++i) {
                stringBuffer.append(worldMap.rmsCastlesDifficultyLevels[i]);
            }
            worldMap.gameLogic.getGData().save(stringBuffer.toString(), 8);
        }
    }

    public final void winLevel(int n, int n2) {
        int n3;
        WorldMap worldMap = this;
        if (!(worldMap.nextCastleToUnlock == 21) && n + 1 == worldMap.nextCastleToUnlock && !worldMap.rmsCastlesLocks[n3 = worldMap.nextCastleToUnlock]) {
            worldMap.unlockCastle(worldMap.nextCastleToUnlock);
        }
        this.gainCastle(n, n2);
    }

    public final String getWorldMapName() {
        switch (this.currMapIndex) {
            case 0: {
                return MainLogic.strings[268];
            }
            case 1: {
                return MainLogic.strings[269];
            }
            case 2: {
                return MainLogic.strings[270];
            }
        }
        return "";
    }

    public final void think() {
        if (this.goToShopAnim) {
            long l = System.currentTimeMillis() - this.goToShopAnimStartTime;
            if (!this.stage1Achieved) {
                if (l > 1000L) {
                    this.stage1Achieved = true;
                    this.shopSelected = true;
                    return;
                }
            } else if (l > 2000L) {
                this.goToShopAnim = false;
                WorldMap.goToShop();
            }
        }
    }

    public final void startGoToShopAnim() {
        this.goToShopAnim = true;
        this.stage1Achieved = false;
        this.goToShopAnimStartTime = System.currentTimeMillis();
    }

    private void setLockedCastleInfoCastlePosition() {
        this.castleSprite.setPosition((MainLogic.width - this.castleSprite.getWidth()) / 2, this.framedPaper.getPaperY() + this.framedPaper.getMenuPaperHeight() / 11);
    }

    public final int getCurrMenu() {
        switch (this.currMapIndex) {
            case 0: {
                return 262;
            }
            case 1: {
                return 263;
            }
            case 2: {
                return 264;
            }
        }
        return -1;
    }

    public final int getCurrMapIndex() {
        return this.currMapIndex;
    }
}

