/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop;

import com.tqm.agave.MainLogic;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.menu.WorldMap;
import com.tqm.fantasydefense.shop.AbstractShop;
import com.tqm.fantasydefense.shop.secret.SecretCampaign;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public final class ShopCampaigns
extends AbstractShop {
    private Sprite iconsSprite;
    private Sprite castleIconSprite;
    private Sprite shopCampaign1;
    private Sprite shopCampaign2;
    private int iconSpace;
    private int[] iconsX;
    private int iconsY;
    private WorldMap worldMap;
    private SecretCampaign[] campaigns;

    public ShopCampaigns(SecretCampaign[] campaigns, WorldMap worldMap) {
        this.campaigns = campaigns;
        this.worldMap = worldMap;
    }

    protected final void loadSprites() {
        this.castleIconSprite = GameLogic.loadSprite(125);
        this.iconsSprite = GameLogic.loadSprite(3);
        this.shopCampaign1 = GameLogic.loadSprite(17);
        this.shopCampaign2 = GameLogic.loadSprite(16);
    }

    protected final void setSpritesPositions() {
        this.iconSpace = this.iconsSprite.getWidth() / 5;
        int iconsWidth = this.iconsSprite.getWidth() * this.iconsSprite.getFrameSequenceLength() / 2 + (this.iconsSprite.getFrameSequenceLength() / 2 - 1) * this.iconSpace;
        int firstIconX = (MainLogic.width - iconsWidth) / 2;
        this.iconsY = ShopCampaigns.getRackSprite().getY() + ShopCampaigns.getRackSprite().getHeight() / 2 - this.iconsSprite.getHeight();
        this.iconsX = new int[2];
        for (int i = 0; i < this.iconsX.length; ++i) {
            this.iconsX[i] = firstIconX + i * (this.iconsSprite.getWidth() + this.iconSpace);
        }
        int expandedTitleSpriteX = ShopCampaigns.getItemDesc().getX() + ShopCampaigns.getItemDesc().getWidth() - this.castleIconSprite.getWidth();
        this.castleIconSprite.setPosition(expandedTitleSpriteX, ShopCampaigns.getTitleStressY() - this.castleIconSprite.getHeight());
        ShopCampaigns.setFramedPaperDefaultPosition();
        this.shopCampaign1.setPosition((MainLogic.width - this.shopCampaign1.getWidth()) / 2, ShopCampaigns.getTitleStressY());
        this.shopCampaign2.setPosition((MainLogic.width - this.shopCampaign2.getWidth()) / 2, ShopCampaigns.getTitleStressY());
    }

    protected final void initOthersShopData() {
        ShopCampaigns.setFramedPaperDefaultPosition();
        this.setSelectionDesc();
    }

    public final void disposeSprites() {
        MainLogic.disposeImage(3);
        MainLogic.disposeImage(125);
        MainLogic.disposeImage(17);
        MainLogic.disposeImage(16);
        this.iconsSprite = null;
        this.castleIconSprite = null;
        this.shopCampaign1 = null;
        this.shopCampaign2 = null;
    }

    protected final void drawShopItems(Graphics g) {
        Graphics graphics = g;
        ShopCampaigns shopCampaigns = this;
        for (int i = 0; i < 2; ++i) {
            if (shopCampaigns.getCurrRackItem() == i) continue;
            shopCampaigns.drawIcon(graphics, i << 1);
        }
        graphics = g;
        shopCampaigns = this;
        shopCampaigns.drawIcon(graphics, (shopCampaigns.getCurrRackItem() << 1) + 1);
        graphics = g;
        shopCampaigns = this;
        ShopCampaigns.drawUnlockState(graphics, shopCampaigns.iconsSprite, shopCampaigns.campaigns[0], shopCampaigns.iconsX[0]);
        ShopCampaigns.drawUnlockState(graphics, shopCampaigns.iconsSprite, shopCampaigns.campaigns[1], shopCampaigns.iconsX[1]);
        graphics = g;
        shopCampaigns = this;
        ShopCampaigns.drawActiveState(graphics, shopCampaigns.iconsSprite, shopCampaigns.campaigns[0], shopCampaigns.iconsX[0]);
        ShopCampaigns.drawActiveState(graphics, shopCampaigns.iconsSprite, shopCampaigns.campaigns[1], shopCampaigns.iconsX[1]);
    }

    private void drawIcon(Graphics g, int frame) {
        this.iconsSprite.setFrame(frame);
        this.iconsSprite.setPosition(this.iconsX[frame / 2], this.iconsY);
        this.iconsSprite.paint(g);
    }

    protected final void drawShopItemDesc(Graphics graphics) {
        ShopCampaigns.drawItemDesc(graphics);
        switch (this.getCurrRackItem()) {
            case 0: {
                this.shopCampaign1.paint(graphics);
                break;
            }
            case 1: {
                this.shopCampaign2.paint(graphics);
            }
        }
        ShopCampaigns.drawShopPriceSprite(graphics, this.campaigns[this.getCurrRackItem()].getPrice(), this.campaigns[this.getCurrRackItem()].isUnlocked());
        this.castleIconSprite.paint(graphics);
        graphics.setFont(GameLogic.getSystemFont());
        graphics.drawString("7 x ", this.castleIconSprite.getX(), ShopCampaigns.getTitleStressY(), 40);
    }

    protected final void onEnterKeyPressed() {
        if (this.onEnterForBuyKeyPressed(this.campaigns[this.getCurrRackItem()])) {
            int worldNumber = -1;
            switch (this.getCurrRackItem()) {
                case 0: {
                    worldNumber = 1;
                    break;
                }
                case 1: {
                    worldNumber = 2;
                }
            }
            this.worldMap.unlockFirstCastleInTheMap(worldNumber);
        }
    }

    protected final void onBackKeyPressed() {
        this.onBackForBuyKeyPressed$255f299(217);
    }

    protected final void onOthersKeyPressed(int key) {
        this.onLeftAndRightKeyPressed(key, 2);
    }

    protected final void setSelectionDesc() {
        switch (this.getCurrRackItem()) {
            case 0: {
                ShopCampaigns.setDescTextWithTitle("", MainLogic.strings[201]);
                break;
            }
            case 1: {
                ShopCampaigns.setDescTextWithTitle("", MainLogic.strings[202]);
            }
        }
        ShopCampaigns.setPriceCrystalPosition(this.campaigns[this.getCurrRackItem()].getPrice());
    }
}

