/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.agave.menu;

import com.tqm.agave.MainLogic;
import com.tqm.agave.menu.Cell;
import com.tqm.agave.menu.Row;
import com.tqm.agave.menu.TextLabel;
import com.tqm.agave.ui.GraphicFont;
import com.tqm.agave.ui.Sprite;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Container {
    public static int scrollbarColor = -16711936;
    private int _selectionColor = -256;
    private int _mode;
    private int _x;
    private int _y;
    private int _menuY;
    private int _transY;
    private int _width;
    private int _height;
    private int _menuWidth;
    private int _menuHeight;
    private int _totalHeight;
    private int _currentSelected;
    private int _titleSpace;
    private int _vMargin;
    private Row[] _rows;
    private boolean _showFocus;
    private boolean _showScrollbar;
    private boolean _lastLineReached;
    private int _imgArrowId;
    private Sprite _arrowUp;
    private Sprite _arrowDown;
    private Sprite adjustableScrollBarPartUp;
    private Sprite adjustableScrollBarPartMiddle;
    private Sprite adjustableScrollBarPartDown;
    private Sprite fixedScrollBarSprite;
    private int scrollBarTrackStrokeStyle = 1;
    private int scrollBarTrackWidth = 1;
    private int _scrollbarWidth;
    private int _scrollbarHeight;
    private int _scrollbarX;
    private int _scrollbarY;
    private int _activeTextColor = -16777216;
    private int _inactiveTextColor = -4144960;
    private int _rowSpace;
    private int _scrollBarSpace;

    public Container(int n, int n2, int n3) {
        this._width = n;
        this._height = n2;
        this._transY = 0;
        this._menuY = 0;
        this._currentSelected = 0;
        this._showFocus = true;
        this._showScrollbar = false;
        this._lastLineReached = false;
        this._imgArrowId = n3;
        this._arrowUp = MainLogic.loadTqmSprite(this._imgArrowId);
        this._arrowDown = MainLogic.loadTqmSprite(this._imgArrowId);
        this._rowSpace = 5;
        this._scrollBarSpace = 0;
    }

    public final void setMenu$32322e49(String[] stringArray, Font font, GraphicFont graphicFont, int n) {
        Row[] rowArray = new Row[stringArray.length];
        TextLabel[] textLabelArray = new TextLabel[stringArray.length];
        for (int i = 0; i < rowArray.length; ++i) {
            textLabelArray[i] = new TextLabel(stringArray[i], 1, font, graphicFont, 100);
            textLabelArray[i].setAnchor(n);
            rowArray[i] = new Row(this._width, new Cell[]{textLabelArray[i]});
        }
        this.setRows(rowArray, 2);
    }

    public final void setText$40907f8c(String object, Font font, GraphicFont graphicFont, int n) {
        object = new TextLabel((String)object, 1, font, graphicFont, 100);
        ((TextLabel)object).setAnchor(n);
        this.setRows(new Row[]{new Row(this._width, new Cell[]{object})}, 3);
    }

    public final void setRows(Row[] object, int n) {
        this._mode = n;
        this._rows = object;
        object = this;
        this._transY = 0;
        object._currentSelected = 0;
        object._lastLineReached = false;
        for (int i = 0; i < this._rows.length; ++i) {
            this._rows[i].container = this;
        }
        this.setSize(this._width, this._height);
        this._showFocus = this._mode != 3;
        this.setVAnchor(2);
        this.setTextColors(this._activeTextColor, this._inactiveTextColor);
    }

    public final int getX() {
        return this._x;
    }

    public final int getY() {
        return this._y;
    }

    public final int getWidth() {
        return this._width;
    }

    public final int getHeight() {
        return this._height;
    }

    public final int getMenuWidth() {
        return this._menuWidth;
    }

    public final Row getRowAt(int index) {
        return this._rows[index];
    }

    public final Row[] getRows() {
        return this._rows;
    }

    public final int getTransY() {
        return this._transY;
    }

    public final int getSelectedIndex() {
        return this._currentSelected;
    }

    public final void setVAnchor(int n) {
        switch (n) {
            case 16: {
                this._vMargin = 0;
                break;
            }
            case 2: {
                if (this._totalHeight > this._menuHeight) {
                    this._vMargin = 0;
                    break;
                }
                this._vMargin = this._menuHeight - this._totalHeight >> 1;
                break;
            }
            case 32: {
                if (this._totalHeight > this._menuHeight) {
                    this._vMargin = 0;
                    break;
                }
                this._vMargin = this._menuHeight - this._totalHeight;
                break;
            }
            default: {
                return;
            }
        }
        this.setPosition(this._x, this._y);
    }

    public final void setSize(int n, int n2) {
        if (n > 0) {
            this._width = n;
        }
        if (n2 > 0) {
            this._height = n2;
        }
        this._menuWidth = this._width;
        this._menuHeight = this._height;
        this._totalHeight = 0;
        this._menuHeight = this._height;
        if (this._rows != null) {
            for (n = 0; n < this._rows.length; ++n) {
                this._totalHeight += this._rows[n].getHeight() + this._rowSpace;
            }
        }
        this._totalHeight -= this._rowSpace;
        this._showScrollbar = this._totalHeight > this._menuHeight;
        this.setPosition(this._x, this._y);
    }

    public final void setPosition(int n, int n2) {
        this._x = n;
        this._menuY = n = (this._y = n2);
        if (this._rows != null) {
            for (n2 = 0; n2 < this._rows.length; ++n2) {
                this._rows[n2].setPosition(this._x, n + this._vMargin);
                n += this._rows[n2].getHeight() + this._rowSpace;
            }
        }
        Container container = this;
        if (container._showScrollbar) {
            container._arrowUp.setPosition(container._x + container._width + container._scrollBarSpace, container._menuY);
            container._arrowDown.setPosition(container._x + container._width + container._scrollBarSpace, container._menuY + container._menuHeight - container._arrowDown.getHeight());
            n2 = container._arrowDown.getY() - (container._arrowUp.getY() + container._arrowUp.getHeight());
            container._scrollbarHeight = container.isFixedScrollBar() ? container.fixedScrollBarSprite.getHeight() : Math.max(10, n2 * n2 / container._totalHeight);
            container._scrollbarWidth = 2 * container._arrowUp.getWidth() / 3;
            container._scrollbarX = container._arrowUp.getX() + (container._arrowUp.getWidth() - container._scrollbarWidth) / 2;
            container._scrollbarY = Math.abs(container._transY) * (n2 - container._scrollbarHeight) / (container._totalHeight - container._menuHeight);
            container._scrollbarY += container._arrowUp.getY() + container._arrowUp.getHeight();
        }
    }

    public final void setSelected(int n) {
        this._currentSelected = n;
    }

    public final void setSelectionColor$13462e() {
        this._selectionColor = -16739647;
    }

    public final void setTitleSpace$13462e() {
        this._titleSpace = 0;
        this.setSize(-1, -1);
    }

    public final void next() {
        switch (this._mode) {
            case 3: {
                if (this._transY <= this._menuHeight - this._totalHeight) break;
                this.next(3 * this._menuHeight / 4);
                return;
            }
            default: {
                if (this._currentSelected >= this._rows.length - 1) break;
                ++this._currentSelected;
                this.updateNext();
            }
        }
    }

    public final void updateNext() {
        if (this._totalHeight > this._menuHeight) {
            int n = this._currentSelected;
            if (this._transY + this._rows[n].getY() + this._rows[n = this._currentSelected].getHeight() / 2 - this._menuY > this._menuHeight / 2) {
                n = this._currentSelected;
                int n2 = this._rows[n].getY() - this._menuY + this._transY;
                n = this._currentSelected;
                this.next(n2 + (this._rows[n].getHeight() - this._menuHeight) / 2);
            }
        }
    }

    public final void next(int n) {
        this._transY -= n;
        switch (this._mode) {
            case 3: {
                if (this._transY >= this._menuHeight - this._totalHeight) break;
                this._transY = -(this._totalHeight - this._menuHeight);
                this._lastLineReached = true;
                return;
            }
            default: {
                n = this._rows.length - 1;
                int n2 = this._rows[n].getY();
                n = this._rows.length - 1;
                if (n2 + this._rows[n].getHeight() >= this._menuY + this._menuHeight - this._transY) break;
                this._transY = -(this._totalHeight - this._menuHeight);
                if (this._currentSelected != this._rows.length - 1) break;
                this._lastLineReached = true;
            }
        }
    }

    public final void prev() {
        switch (this._mode) {
            case 3: {
                if (this._transY >= 0) break;
                this.prev(3 * this._menuHeight / 4);
                return;
            }
            default: {
                if (this._currentSelected <= 0) break;
                --this._currentSelected;
                this.updatePrev();
            }
        }
    }

    public final void updatePrev() {
        if (this._totalHeight > this._menuHeight) {
            int n = this._currentSelected;
            if (this._transY + this._rows[n].getY() + this._rows[n = this._currentSelected].getHeight() / 2 - this._menuY < this._menuHeight / 2) {
                n = this._currentSelected;
                int n2 = this._rows[n].getY() - this._menuY + this._transY;
                n = this._currentSelected;
                this.prev(Math.abs(n2 + (this._rows[n].getHeight() - this._menuHeight) / 2));
            }
        }
    }

    private void prev(int n) {
        this._transY += n;
        switch (this._mode) {
            case 3: {
                if (this._transY <= 0) break;
                this._transY = 0;
                break;
            }
            default: {
                if (this._rows[0].getY() <= this._menuY - this._transY) break;
                this._transY = 0;
            }
        }
        this._lastLineReached = false;
    }

    public void drawFocus(Graphics graphics) {
        graphics.translate(0, this._transY);
        graphics.setColor(this._selectionColor);
        int n = this._currentSelected;
        int n2 = this._rows[n].getX();
        n = this._currentSelected;
        int n3 = this._rows[n].getY();
        n = this._currentSelected;
        int n4 = this._rows[n].getWidth();
        n = this._currentSelected;
        graphics.fillRect(n2, n3, n4, this._rows[n].getHeight());
        graphics.translate(0, -this._transY);
    }

    public final void draw(Graphics object) {
        int n = object.getClipX();
        int n2 = object.getClipY();
        int n3 = object.getClipWidth();
        int n4 = object.getClipHeight();
        if (this._showFocus) {
            this.drawFocus((Graphics)object);
        }
        object.setClip(this._x, this._menuY, this._menuWidth + 1, this._menuHeight + 1);
        object.translate(0, this._transY);
        for (int i = 0; i < this._rows.length && this._rows[i].getY() - this._menuY + this._transY < this._menuHeight; ++i) {
            this._rows[i].draw((Graphics)object);
        }
        object.translate(0, -this._transY);
        object.setClip(n, n2, n3, n4);
        Graphics graphics = object;
        object = this;
        if (((Container)object)._showScrollbar) {
            ((Container)object)._arrowUp.setFrame(0);
            ((Container)object)._arrowUp.paint(graphics);
            ((Container)object)._arrowDown.setFrame(((Container)object)._lastLineReached ? 2 : 1);
            ((Container)object)._arrowDown.paint(graphics);
            graphics.setColor(scrollbarColor);
            graphics.setStrokeStyle(((Container)object).scrollBarTrackStrokeStyle);
            if (((Container)object).scrollBarTrackWidth == 1) {
                graphics.drawLine(((Container)object)._arrowUp.getX() + ((Container)object)._arrowUp.getWidth() / 2, ((Container)object)._arrowUp.getY() + ((Container)object)._arrowUp.getHeight(), ((Container)object)._arrowUp.getX() + ((Container)object)._arrowUp.getWidth() / 2, ((Container)object)._arrowDown.getY());
            } else {
                graphics.fillRect(((Container)object)._arrowUp.getX() + (((Container)object)._arrowUp.getWidth() - ((Container)object).scrollBarTrackWidth) / 2, ((Container)object)._arrowUp.getY() + ((Container)object)._arrowUp.getHeight(), ((Container)object).scrollBarTrackWidth, ((Container)object)._arrowDown.getY() - ((Container)object)._arrowUp.getY() - ((Container)object)._arrowUp.getHeight());
            }
            if (super.isFixedScrollBar()) {
                Object object2 = object;
                object = graphics;
                Object object3 = object2;
                int n5 = ((Container)object2)._scrollbarX + ((Container)object3)._scrollbarWidth / 2 - ((Container)object3).fixedScrollBarSprite.getWidth() / 2;
                n3 = ((Container)object3)._scrollbarY + ((Container)object3)._scrollbarHeight / 2 - ((Container)object3).fixedScrollBarSprite.getHeight() / 2;
                ((Container)object3).fixedScrollBarSprite.setPosition(n5, n3);
                ((Container)object3).fixedScrollBarSprite.paint((Graphics)object);
                return;
            }
            Object object4 = object;
            if (((Container)object4).adjustableScrollBarPartUp != null && ((Container)object4).adjustableScrollBarPartMiddle != null && ((Container)object4).adjustableScrollBarPartDown != null) {
                Object object5 = object;
                object = graphics;
                object4 = object5;
                ((Container)object5)._scrollbarX = ((Container)object5)._arrowUp.getX() + (((Container)object4)._arrowUp.getWidth() - ((Container)object4).adjustableScrollBarPartUp.getWidth()) / 2;
                int n6 = ((Container)object4)._scrollbarY;
                n3 = n6 + ((Container)object4)._scrollbarHeight - ((Container)object4).adjustableScrollBarPartDown.getHeight();
                ((Container)object4).adjustableScrollBarPartUp.setPosition(((Container)object4)._scrollbarX, n6);
                ((Container)object4).adjustableScrollBarPartUp.paint((Graphics)object);
                n6 += ((Container)object4).adjustableScrollBarPartUp.getHeight();
                while (n6 < n3) {
                    ((Container)object4).adjustableScrollBarPartMiddle.setPosition(((Container)object4)._scrollbarX, n6);
                    ((Container)object4).adjustableScrollBarPartMiddle.paint((Graphics)object);
                    n6 += ((Container)object4).adjustableScrollBarPartMiddle.getHeight();
                }
                ((Container)object4).adjustableScrollBarPartDown.setPosition(((Container)object4)._scrollbarX, n3);
                ((Container)object4).adjustableScrollBarPartDown.paint((Graphics)object);
                return;
            }
            graphics.setStrokeStyle(0);
            graphics.fillRect(((Container)object)._scrollbarX, ((Container)object)._scrollbarY, ((Container)object)._scrollbarWidth, ((Container)object)._scrollbarHeight);
            graphics.setColor(-16777216);
            graphics.drawRect(((Container)object)._scrollbarX, ((Container)object)._scrollbarY, ((Container)object)._scrollbarWidth - 1, ((Container)object)._scrollbarHeight - 1);
        }
    }

    public void keyPressed(int n) {
        switch (n) {
            case 85: {
                this.prev();
                return;
            }
            case 87: {
                this.next();
            }
        }
    }

    public final String getSelectedItemName() {
        int n = this._currentSelected;
        return this._rows[n].getCells()[0].toString();
    }

    public final void replaceContentAt$f13b8cf(int n, Object object) {
        if (n < 0 || n >= this._rows.length) {
            return;
        }
        Object object2 = this._rows[n];
        if (0 >= ((Row)object2).getCells().length) {
            return;
        }
        object2 = ((Row)object2).getCellAt(0);
        ((Cell)object2).replaceContent(object);
    }

    public final void setTextColors(int n, int n2) {
        this._activeTextColor = n;
        this._inactiveTextColor = n2;
        if (this._rows != null) {
            for (int i = 0; i < this._rows.length; ++i) {
                Cell[] cellArray = this._rows[i].getCells();
                if (cellArray == null) continue;
                for (int j = 0; j < cellArray.length; ++j) {
                    if (!(cellArray[j] instanceof TextLabel)) continue;
                    TextLabel textLabel = (TextLabel)cellArray[j];
                    textLabel.setColor(n, 1);
                    textLabel.setColor(n2, 2);
                }
            }
        }
    }

    public static String[] wrapText(String enumeration, int n, GraphicFont object) {
        char c;
        n /= ((GraphicFont)object).getWidth() + ((GraphicFont)object).spacing;
        if (enumeration == null) {
            return new String[0];
        }
        if (n <= 0) {
            return new String[]{enumeration};
        }
        if (((String)((Object)enumeration)).length() <= n && ((String)((Object)enumeration)).indexOf(10) == -1) {
            return new String[]{enumeration};
        }
        enumeration = (Enumeration)((String)((Object)enumeration)).toCharArray();
        object = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < ((Object)enumeration).length; ++i) {
            stringBuffer2.append((char)enumeration[i]);
            if (enumeration[i] == 32 || enumeration[i] == 10) {
                if (stringBuffer.length() + stringBuffer2.length() > n) {
                    ((Vector)object).addElement(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                }
                stringBuffer.append((Object)stringBuffer2);
                stringBuffer2.delete(0, stringBuffer2.length());
                if (enumeration[i] != 10) continue;
                ((Vector)object).addElement(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                continue;
            }
            if (stringBuffer2.length() <= n) continue;
            if (stringBuffer.length() > 0) {
                ((Vector)object).addElement(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
            }
            c = stringBuffer2.charAt(stringBuffer2.length() - 1);
            stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
            ((Vector)object).addElement(stringBuffer2.toString());
            stringBuffer2.delete(0, stringBuffer2.length());
            stringBuffer2.append(c);
        }
        if (stringBuffer2.length() > 0) {
            if (stringBuffer.length() + stringBuffer2.length() > n) {
                ((Vector)object).addElement(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
            }
            stringBuffer.append((Object)stringBuffer2);
        }
        if (stringBuffer.length() > 0) {
            ((Vector)object).addElement(stringBuffer.toString());
        }
        String[] stringArray = new String[((Vector)object).size()];
        c = '\u0000';
        enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            stringArray[c] = (String)enumeration.nextElement();
            ++c;
        }
        return stringArray;
    }

    public static String[] wrapText(String enumeration, int n, Font font) {
        char c;
        if (enumeration == null) {
            return new String[0];
        }
        if (n <= 0) {
            return new String[]{enumeration};
        }
        if (font.stringWidth((String)((Object)enumeration)) <= n && ((String)((Object)enumeration)).indexOf(10) < 0) {
            return new String[]{enumeration};
        }
        enumeration = (Enumeration)((String)((Object)enumeration)).toCharArray();
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < ((Object)enumeration).length; ++i) {
            stringBuffer2.append((char)enumeration[i]);
            if (enumeration[i] == 32 || enumeration[i] == 10) {
                if (font.stringWidth(stringBuffer.toString()) + font.stringWidth(stringBuffer2.toString()) > n) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                }
                stringBuffer.append((Object)stringBuffer2);
                stringBuffer2.delete(0, stringBuffer2.length());
                if (enumeration[i] != 10) continue;
                vector.addElement(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                continue;
            }
            if (font.stringWidth(stringBuffer2.toString()) <= n) continue;
            if (stringBuffer.length() > 0) {
                vector.addElement(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
            }
            c = stringBuffer2.charAt(stringBuffer2.length() - 1);
            stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
            vector.addElement(stringBuffer2.toString());
            stringBuffer2.delete(0, stringBuffer2.length());
            stringBuffer2.append(c);
        }
        if (stringBuffer2.length() > 0) {
            if (font.stringWidth(stringBuffer.toString()) + font.stringWidth(stringBuffer2.toString()) > n) {
                vector.addElement(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
            }
            stringBuffer.append((Object)stringBuffer2);
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
        }
        String[] stringArray = new String[vector.size()];
        c = '\u0000';
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[c] = (String)enumeration.nextElement();
            ++c;
        }
        return stringArray;
    }

    public final void setAdjustableScrollBarParts$4868d30e() {
        this.adjustableScrollBarPartUp = MainLogic.loadTqmSprite(139);
        this.adjustableScrollBarPartMiddle = MainLogic.loadTqmSprite(138);
        this.adjustableScrollBarPartDown = MainLogic.loadTqmSprite(140);
    }

    public final void setFixedScroolBarSprite$13462e() {
        this.fixedScrollBarSprite = MainLogic.loadTqmSprite(126);
    }

    private boolean isFixedScrollBar() {
        return this.fixedScrollBarSprite != null;
    }

    public final void setScrollBarTrackStrokeStyle$13462e() {
        this.scrollBarTrackStrokeStyle = 0;
    }

    public final void setRowSpace(int rowSpace) {
        this._rowSpace = rowSpace;
    }

    public final void setScrollBarSpace(int scrollBarSpace) {
        this._scrollBarSpace = scrollBarSpace;
    }
}

