/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.agave.menu;

import com.tqm.agave.MainLogic;
import com.tqm.agave.ui.GraphicFont;
import com.tqm.agave.ui.Layer;
import com.tqm.agave.ui.Sprite;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class ProgressBarItem
implements Runnable {
    private int mode;
    private int x;
    private int y;
    private int width;
    private int height;
    public int type;
    private int _barSize;
    private int _pos;
    private int _dir;
    private int _fontColor = -16777216;
    private int _borderColor = -16777216;
    private int _fillColor = -15226393;
    private Font font;
    private GraphicFont gFont;
    private int _fontType;
    private int _offsetX;
    private int _offsetY;
    private int anchor;
    private StringBuffer _text;
    private int margin = 5;
    private int _loadingProgress;
    private int _dotCount;
    private long _time;
    private int _strW;
    private int _dotsW;
    private int _singleDotW;
    private int _fontHeight;

    public ProgressBarItem(int n, int n2, String string, Font object, GraphicFont graphicFont) {
        this.width = n;
        this.height = n2;
        this.type = 1;
        this.mode = 1;
        this._text = new StringBuffer(string);
        this.font = object;
        this.gFont = graphicFont;
        object = this;
        this._fontType = 1;
        ((ProgressBarItem)object)._strW = ((ProgressBarItem)object).font.stringWidth(((ProgressBarItem)object)._text.toString());
        ((ProgressBarItem)object)._dotsW = ((ProgressBarItem)object).font.stringWidth("...");
        ((ProgressBarItem)object)._singleDotW = ((ProgressBarItem)object).font.stringWidth(".");
        ((ProgressBarItem)object)._fontHeight = ((ProgressBarItem)object).font.getHeight();
        this.setAnchor(20);
        if (n < this._strW + this._dotsW + 2 * this.margin || n2 < 3 * this.margin + 2 * this._fontHeight) {
            n2 = Math.max(n2, 3 * this.margin + 2 * this._fontHeight);
            int n3 = Math.max(n, this._strW + this._dotsW + 2 * this.margin);
            object = this;
            this.width = n3;
            ((ProgressBarItem)object).height = n2;
            ((ProgressBarItem)object).setAnchor(((ProgressBarItem)object).anchor);
            ((ProgressBarItem)object).setPosition(((ProgressBarItem)object).x, ((ProgressBarItem)object).y);
        }
        this._barSize = n / 6;
        this._dir = 1;
    }

    public final void init() {
        this._loadingProgress = 0;
        if (this.mode == 1) {
            new Thread(this).start();
        }
    }

    public final void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this._pos = x - this.width / 2 + this.margin + this._barSize / 2;
    }

    public final void setAnchor(int anchor) {
        this._offsetX = 0;
        this._offsetY = 0;
        if ((anchor & 1) != 0) {
            this._offsetX = -(this.width >> 1);
        } else if ((anchor & 8) != 0) {
            this._offsetX = -this.width;
        }
        if ((anchor & 2) != 0) {
            this._offsetY = -(this.height >> 1);
        } else if ((anchor & 0x20) != 0) {
            this._offsetY = -this.height;
        }
        this.anchor = anchor;
    }

    public final boolean update$15a28d67$4f70807c(int n) {
        this._loadingProgress = n;
        return false;
    }

    public final void think() {
        int n = this.margin;
        int n2 = this.x + this.width / 2 - n - 3;
        n = this.x - this.width / 2 + n + 3;
        this._pos += this._dir * 6;
        if (this._dir > 0) {
            if (this._pos + this._barSize / 2 > n2) {
                this._pos = n2 - this._barSize / 2;
                this._dir = -this._dir;
                return;
            }
        } else if (this._pos - this._barSize / 2 < n) {
            this._pos = n + this._barSize / 2;
            this._dir = -this._dir;
        }
    }

    public final void draw(Graphics graphics) {
        switch (this.mode) {
            case 1: {
                int n;
                graphics.setFont(this.font);
                graphics.setColor(this._fontColor);
                int n2 = (this.width - this._strW - this._dotsW) / 2;
                this.drawString(graphics, this._text.toString(), this.x + this._offsetX + n2, this.y + this._offsetY + this.margin, 0, this._fontType);
                n2 += this._strW;
                for (n = 0; n < this._dotCount; ++n) {
                    this.drawString(graphics, ".", this.x + this._offsetX + n2 + n * this._singleDotW, this.y + this._offsetY + this.margin, 0, this._fontType);
                }
                n = this.width - 2 * this.margin;
                n2 = this.y + this._offsetY + 2 * this.margin + this._fontHeight;
                graphics.setColor(this._borderColor);
                graphics.drawRect(this.x + this._offsetX + this.margin, n2, n, this._fontHeight);
                if (this.type == 1) {
                    graphics.setColor(this._fillColor);
                    graphics.fillRect(this.x + this._offsetX + this.margin + 2, n2 + 2, (n - 3) * this._loadingProgress / 100, this._fontHeight - 3);
                    return;
                }
                graphics.setColor(this._fillColor);
                graphics.fillRect(this._pos - this._barSize / 2, n2 + 2, this._barSize, this._fontHeight - 3);
                return;
            }
            case 2: {
                int n = this.width - ((Layer)null).getWidth() >> 1;
                int n3 = this.height - ((Layer)null).getHeight() >> 1;
                ((Layer)null).setPosition(this.x + this._offsetX + n, this.y + this._offsetY + n3);
                ((Sprite)null).paint(graphics);
                graphics.setColor(this._borderColor);
                graphics.drawRect(this.x + this._offsetX + n - 1, this.y + this._offsetY + n3 - 1, ((Layer)null).getWidth() + 1, ((Layer)null).getHeight() + 1);
                int n4 = this._loadingProgress * ((Layer)null).getWidth() / 100;
                graphics.setColor(this._fillColor);
                graphics.fillRect(this.x + this._offsetX + n + n4, this.y + this._offsetY + n3, ((Layer)null).getWidth() - n4, ((Layer)null).getHeight());
                this.drawString(graphics, this._text.toString(), ((Layer)null).getX() + (((Layer)null).getWidth() >> 1), ((Layer)null).getY() + (((Layer)null).getHeight() >> 1), 3, 2);
            }
        }
    }

    private void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        if (n4 == 2) {
            this.gFont.drawString(graphics, string, n, n2, n3);
            return;
        }
        if (n4 == 1) {
            graphics.setFont(this.font);
            graphics.drawString(string, n, n2 + MainLogic.getSystemFontOffset(), n3);
        }
    }

    public final void run() {
        while (this._loadingProgress < 100) {
            if (System.currentTimeMillis() - this._time <= 333L) continue;
            ++this._dotCount;
            this._dotCount %= 4;
            this._time = System.currentTimeMillis();
        }
    }
}

