/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.agave.menu;

import com.tqm.agave.menu.Cell;
import com.tqm.agave.menu.Container;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public final class Row {
    private int _x;
    private int _y;
    private int _width;
    private int _height;
    private Cell[] _cells;
    public Container container;

    public Row(int n, Cell[] cellArray) {
        this._width = n;
        this._cells = cellArray;
        n = 0;
        for (int i = 0; i < this._cells.length; ++i) {
            if (this._cells[i].getPercentageWidth() > 0 && this._cells[i].getPercentageWidth() <= 100) {
                this._cells[i].setSize(this._width * this._cells[i].getPercentageWidth() / 100, -1);
            }
            if (this._cells[i].getHeight() > n) {
                n = this._cells[i].getHeight();
            }
            this._cells[i].parentRow = this;
        }
        this.setSize(this._width, n);
    }

    public final int getX() {
        return this._x;
    }

    public final int getY() {
        return this._y;
    }

    public final int getWidth() {
        return this._width;
    }

    public final int getHeight() {
        return this._height;
    }

    public final void setSize(int newWidth, int newHeight) {
        if (newWidth > 0) {
            this._width = newWidth;
        }
        if (newHeight > 0) {
            this._height = newHeight;
        }
        for (int i = 0; i < this._cells.length; ++i) {
            this._cells[i].setSize(-1, this._height);
        }
    }

    public final void setPosition(int x, int y) {
        this._x = x;
        this._y = y;
    }

    public final void setActive(boolean active) {
        for (int i = 0; i < this._cells.length; ++i) {
            this._cells[i].setActive(active);
        }
    }

    public final Cell[] getCells() {
        return this._cells;
    }

    public final Cell getCellAt(int index) {
        return this._cells[0];
    }

    public final void draw(Graphics g) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        g.clipRect(this._x, this._y, this._width + 1, this._height + 1);
        int tmpX = this._x;
        for (int i = 0; i < this._cells.length; ++i) {
            this._cells[i].setPosition(tmpX, this._y);
            this._cells[i].draw(g);
            tmpX += this._cells[i].getWidth();
        }
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public Row() {
    }

    public static byte[] UTF8Encode(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                int n2 = string.charAt(i);
                if ((n2 = 0 | n2 & 0xFFFF) >= 0 && n2 < 128) {
                    byteArrayOutputStream.write((byte)n2);
                    continue;
                }
                if (n2 > 127 && n2 < 2048) {
                    byteArrayOutputStream.write((byte)(n2 >>> 6 & 0x1F | 0xC0));
                    byteArrayOutputStream.write((byte)(n2 & 0x3F | 0x80));
                    continue;
                }
                if (n2 > 2047 && n2 < 65536) {
                    byteArrayOutputStream.write((byte)(n2 >>> 12 & 0xF | 0xE0));
                    byteArrayOutputStream.write((byte)(n2 >>> 6 & 0x3F | 0x80));
                    byteArrayOutputStream.write((byte)(n2 & 0x3F | 0x80));
                    continue;
                }
                if (n2 <= 65535 || n2 >= 1048575) continue;
                byteArrayOutputStream.write((byte)(n2 >>> 18 & 7 | 0xF0));
                byteArrayOutputStream.write((byte)(n2 >>> 12 & 0x3F | 0x80));
                byteArrayOutputStream.write((byte)(n2 >>> 6 & 0x3F | 0x80));
                byteArrayOutputStream.write((byte)(n2 & 0x3F | 0x80));
            }
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

