/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense;

import com.tqm.agave.MainLogic;
import com.tqm.agave.menu.Container;
import com.tqm.fantasydefense.FramedPaper;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.GameTemplate;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public final class Tutorial {
    private int currTutorialType;
    private int currTutorial;
    private Sprite cursor;
    private Sprite guideWoman;
    private Sprite guideMan;
    private Sprite guideManMouth;
    private Sprite guideManEyebrows;
    private int[] guideManMouthAnimFrames;
    private int[] guideManEyebrowsAnimFrames;
    private int currGuideManAnimFrame;
    private FramedPaper paper;
    private Container text;
    private int[] tutorialTypes;
    private int currTutorialTypeIndex;
    private String[][] tutorialTexts;
    private int[][][] tutorialArrowPositions;
    private int currTutorialTextIndex;
    private boolean worldMapTutorialRMS;
    private boolean gameTutorialRMS;
    private boolean shopTutorialRMS;
    private GameLogic gameLogic;
    private boolean directNextStep;
    private boolean tutorialHandling;
    private int boardSpriteY;
    private int boardSpriteHeight;

    public Tutorial(GameLogic gameLogic) {
        this.gameLogic = gameLogic;
        this.paper = new FramedPaper();
        this.text = new Container(MainLogic.width, MainLogic.height, 129);
        FramedPaper.setContainerParams(this.text);
        this.guideManMouthAnimFrames = new int[]{0, 1, 2, 1, 0, 2, 1, 0, 1, 0};
        this.guideManEyebrowsAnimFrames = new int[]{1, 1, 1, -1, -1, -2, 0, 1, -1, 1};
    }

    public final void initWorldMapTutorial() {
        String[] stringArray = new String[]{MainLogic.strings[172]};
        int[][] nArrayArray = new int[][]{new int[0]};
        Object object = new String[]{MainLogic.strings[173]};
        int[][] nArrayArray2 = new int[][]{new int[0]};
        object = new String[][]{stringArray, object};
        this.tutorialTexts = object;
        int[][][] nArrayArray3 = new int[][][]{nArrayArray, nArrayArray2};
        object = nArrayArray3;
        this.tutorialArrowPositions = nArrayArray3;
        int[] nArray = new int[]{0, 1};
        object = nArray;
        this.tutorialTypes = nArray;
        this.directNextStep = true;
        this.initTutorial(0, 1);
    }

    public final void initGameTutorial() {
        Object object = new String[]{MainLogic.strings[177], MainLogic.strings[174], MainLogic.strings[175], MainLogic.strings[176]};
        int[][] nArrayArray = new int[][]{new int[0], {GameLogic.width / 3, GameLogic.height - GameTemplate.pasekUI.getHeight() * 6 / 7}, {GameLogic.width * 7 / 11, GameLogic.height * 3 / 7}, {GameLogic.width / 3, GameLogic.height - GameTemplate.pasekUI.getHeight() * 6 / 7}};
        object = new String[][]{object};
        this.tutorialTexts = object;
        int[][][] nArrayArray2 = new int[][][]{nArrayArray};
        object = nArrayArray2;
        this.tutorialArrowPositions = nArrayArray2;
        int[] nArray = new int[]{1};
        object = nArray;
        this.tutorialTypes = nArray;
        this.directNextStep = false;
        this.initTutorial(1, 1);
    }

    public final void initShopTutorial$3b4dfe4b(int n, int n2) {
        Object object = new String[]{MainLogic.strings[279]};
        int[][] nArrayArray = new int[][]{new int[0]};
        object = new String[][]{object};
        this.tutorialTexts = object;
        int[][][] nArrayArray2 = new int[][][]{nArrayArray};
        object = nArrayArray2;
        this.tutorialArrowPositions = nArrayArray2;
        int[] nArray = new int[]{0};
        object = nArray;
        this.tutorialTypes = nArray;
        this.directNextStep = true;
        this.boardSpriteY = n;
        this.boardSpriteHeight = n2;
        this.initTutorial(2, 2);
    }

    public final void initShopTipTutorial$ba2c33f(String object, int n, int n2) {
        object = new String[]{object};
        int[][] nArrayArray = new int[][]{new int[0]};
        object = new String[][]{object};
        this.tutorialTexts = object;
        int[][][] nArrayArray2 = new int[][][]{nArrayArray};
        object = nArrayArray2;
        this.tutorialArrowPositions = nArrayArray2;
        int[] nArray = new int[]{2};
        object = nArray;
        this.tutorialTypes = nArray;
        this.directNextStep = true;
        this.boardSpriteY = n;
        this.boardSpriteHeight = n2;
        this.initTutorial(3, 2);
    }

    private void initTutorial(int n, int n2) {
        GameLogic.setMenuScrollbarColor();
        this.currTutorial = n;
        this.currTutorialTextIndex = 0;
        this.currTutorialTypeIndex = 0;
        this.updateCurrTutorialType();
        Tutorial tutorial = this;
        tutorial.paper.loadSprites();
        tutorial.cursor = GameLogic.loadSprite(244);
        switch (n2) {
            case 1: {
                tutorial.loadGuideManSprites();
                break;
            }
            case 2: {
                tutorial.guideWoman = GameLogic.loadSprite(18);
            }
        }
        this.setSpritesPositions();
        this.updateText();
        this.updateCursorPosition();
        this.tutorialHandling = true;
    }

    public final void draw(Graphics graphics) {
        if (this.tutorialHandling) {
            GameLogic.setMenuScrollbarColor();
            switch (this.currTutorialType) {
                case 0: {
                    this.paper.drawWideHighFramedPaper(graphics);
                    break;
                }
                case 1: {
                    this.paper.drawNarrowMediumFramedPaper(graphics);
                    this.drawGuideManSprites(graphics);
                    break;
                }
                case 2: {
                    this.paper.drawNarrowMediumFramedPaper(graphics);
                    this.guideWoman.paint(graphics);
                }
            }
            this.text.setPosition(this.text.getX(), this.text.getY());
            this.text.draw(graphics);
            if (this.isTutorialCursorPresent()) {
                this.cursor.paint(graphics);
            }
            GameLogic.drawEnterIcon(graphics);
        }
    }

    public final void drawGuideManSprites(Graphics g) {
        this.guideMan.paint(g);
        int tempCurrAnimFrame = (int)(((long)this.currGuideManAnimFrame + (MainLogic.counter % 4L + 1L) / 4L) % (long)this.guideManMouthAnimFrames.length);
        this.guideManMouth.setFrame(this.guideManMouthAnimFrames[tempCurrAnimFrame]);
        this.guideManMouth.paint(g);
        if (this.currGuideManAnimFrame != tempCurrAnimFrame) {
            this.guideManEyebrows.setPosition(this.guideManEyebrows.getX(), this.guideManEyebrows.getY() + this.guideManEyebrowsAnimFrames[tempCurrAnimFrame]);
        }
        this.guideManEyebrows.paint(g);
        this.currGuideManAnimFrame = tempCurrAnimFrame;
    }

    private int getCurrFrameHeight() {
        switch (this.currTutorialType) {
            case 0: {
                return this.paper.getHighFrameHeight();
            }
            case 1: 
            case 2: {
                return this.paper.getMediumFrameHeight();
            }
        }
        return 0;
    }

    public final void initGuideManSprites() {
        this.loadGuideManSprites();
        this.setGuideMainSpritesPositions();
    }

    private void loadGuideManSprites() {
        this.guideMan = GameLogic.loadSprite(11);
        this.guideManMouth = GameLogic.loadSprite(22);
        this.guideManEyebrows = GameLogic.loadSprite(98);
    }

    private void setSpritesPositions() {
        switch (this.currTutorialType) {
            case 0: {
                int n;
                Tutorial tutorial = this;
                switch (tutorial.currTutorialType) {
                    case 0: {
                        n = tutorial.paper.getWideFrameWidth();
                        break;
                    }
                    case 1: 
                    case 2: {
                        n = tutorial.paper.getNarrowFrameWidth();
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                this.paper.setFramePosition((MainLogic.width - n) / 2, (MainLogic.height - this.getCurrFrameHeight()) / 2);
                return;
            }
            case 1: {
                this.paper.setFramePosition(0, MainLogic.height * 7 / 8 - this.paper.getMediumFrameHeight());
                this.setGuideMainSpritesPositions();
                return;
            }
            case 2: {
                this.paper.setFramePosition(0, (MainLogic.height - this.getCurrFrameHeight()) * 3 / 4);
                this.guideWoman.setPosition(MainLogic.width - this.guideWoman.getWidth(), this.boardSpriteY + this.boardSpriteHeight * 18 / 54 - this.guideWoman.getHeight());
            }
        }
    }

    private void setGuideMainSpritesPositions() {
        this.guideMan.setPosition(MainLogic.width - this.guideMan.getWidth() * 5 / 6, MainLogic.height - this.guideMan.getHeight());
        this.guideManMouth.setPosition(this.guideMan.getX() + this.guideMan.getWidth() * 9 / 96, this.guideMan.getY() + this.guideMan.getHeight() * 30 / 99);
        this.guideManEyebrows.setPosition(this.guideMan.getX() + this.guideMan.getWidth() * 12 / 96, this.guideMan.getY() + this.guideMan.getHeight() * 9 / 99);
        this.currGuideManAnimFrame = 0;
        if (this.currTutorial == 1) {
            int inc = this.guideMan.getHeight() * 10 / 99;
            this.guideMan.setPosition(this.guideMan.getX(), this.guideMan.getY() + inc);
            this.guideManMouth.setPosition(this.guideManMouth.getX(), this.guideManMouth.getY() + inc);
            this.guideManEyebrows.setPosition(this.guideManEyebrows.getX(), this.guideManEyebrows.getY() + inc);
        }
    }

    public final void disposeGuideManSprites() {
        MainLogic.disposeImage(11);
        MainLogic.disposeImage(22);
        MainLogic.disposeImage(98);
        this.guideMan = null;
        this.guideManMouth = null;
        this.guideManEyebrows = null;
    }

    public final void keyPressed(int n) {
        if (this.tutorialHandling) {
            switch (n) {
                case 50: 
                case 56: 
                case 85: 
                case 87: {
                    this.text.keyPressed(n);
                    return;
                }
                case 53: 
                case 89: 
                case 91: {
                    Tutorial tutorial = this;
                    if (!tutorial.directNextStep) {
                        tutorial.tutorialHandling = false;
                    }
                    ++tutorial.currTutorialTextIndex;
                    if (tutorial.tutorialTexts[tutorial.currTutorialTypeIndex].length == tutorial.currTutorialTextIndex) {
                        ++tutorial.currTutorialTypeIndex;
                        tutorial.currTutorialTextIndex = 0;
                        if (!tutorial.isTutorialFinished()) {
                            tutorial.updateCurrTutorialType();
                            tutorial.setSpritesPositions();
                        }
                    }
                    if (tutorial.isTutorialFinished()) {
                        Tutorial tutorial2 = tutorial;
                        GameLogic.setDefaultScrollbarColor();
                        tutorial2.paper.disposeSprites();
                        MainLogic.disposeImage(244);
                        MainLogic.disposeImage(18);
                        tutorial2.cursor = null;
                        tutorial2.guideWoman = null;
                        tutorial2.disposeGuideManSprites();
                        tutorial2 = tutorial;
                        switch (tutorial2.currTutorial) {
                            case 0: {
                                tutorial2.worldMapTutorialRMS = false;
                                tutorial = tutorial2;
                                tutorial.gameLogic.getGData().save(tutorial.worldMapTutorialRMS ? 1 : 0, 43);
                                return;
                            }
                            case 1: {
                                tutorial2.gameTutorialRMS = false;
                                tutorial = tutorial2;
                                tutorial.gameLogic.getGData().save(tutorial.gameTutorialRMS ? 1 : 0, 44);
                                return;
                            }
                            case 2: {
                                tutorial2.shopTutorialRMS = false;
                                tutorial = tutorial2;
                                tutorial.gameLogic.getGData().save(tutorial.shopTutorialRMS ? 1 : 0, 45);
                                return;
                            }
                            case 3: {
                                tutorial2.gameLogic.getShopManager().setTipShown(true);
                            }
                        }
                        return;
                    }
                    tutorial.updateText();
                    tutorial.updateCursorPosition();
                }
            }
        }
    }

    private boolean isTutorialFinished() {
        return this.tutorialTypes.length == this.currTutorialTypeIndex;
    }

    private boolean isTutorialCursorPresent() {
        return this.tutorialArrowPositions[this.currTutorialTypeIndex][this.currTutorialTextIndex].length > 0;
    }

    public final void loadWorldMapTutorialFromRMS() {
        int n = this.gameLogic.getGData().loadAsInt(43);
        n = n == 1 ? 1 : 0;
        this.worldMapTutorialRMS = n;
    }

    public final void loadGameTutorialFromRMS() {
        int n = this.gameLogic.getGData().loadAsInt(44);
        n = n == 1 ? 1 : 0;
        this.gameTutorialRMS = n;
    }

    public final void loadShopTutorialFromRMS() {
        int n = this.gameLogic.getGData().loadAsInt(45);
        n = n == 1 ? 1 : 0;
        this.shopTutorialRMS = n;
    }

    private void updateText() {
        int n;
        int n2;
        int n3 = this.paper.getPaperX() + this.paper.getHorizontalPaperMargin();
        int n4 = this.paper.getPaperY() + this.paper.getVerticalPaperMargin();
        if (this.currTutorialType == 0) {
            n2 = this.paper.getWidePaperWidth() - 2 * this.paper.getHorizontalPaperMargin();
            n = this.paper.getHighPaperHeight() - 2 * this.paper.getVerticalPaperMargin();
        } else {
            n2 = this.paper.getNarrowPaperWidth() - 2 * this.paper.getHorizontalPaperMargin();
            n = this.paper.getMediumPaperHeight() - 2 * this.paper.getVerticalPaperMargin();
        }
        this.text.setSize(n2, n);
        this.text.setPosition(n3, n4);
        this.text.setText$40907f8c(this.tutorialTexts[this.currTutorialTypeIndex][this.currTutorialTextIndex], GameLogic.getSystemFont(), null, 4);
    }

    private void updateCursorPosition() {
        if (this.isTutorialCursorPresent()) {
            this.cursor.setPosition(this.tutorialArrowPositions[this.currTutorialTypeIndex][this.currTutorialTextIndex][0], this.tutorialArrowPositions[this.currTutorialTypeIndex][this.currTutorialTextIndex][1]);
        }
    }

    private void updateCurrTutorialType() {
        this.currTutorialType = this.tutorialTypes[this.currTutorialTypeIndex];
    }

    public final boolean isWorldMapTutorial() {
        return this.worldMapTutorialRMS;
    }

    public final boolean isGameTutorial() {
        return this.gameTutorialRMS;
    }

    public final boolean isShopTutorial() {
        return this.shopTutorialRMS;
    }

    public final void setTutorialHandling(boolean tutorialHandling) {
        this.tutorialHandling = true;
    }

    public final boolean isTutorialHandling() {
        return this.tutorialHandling;
    }

    public final int getCurrTutorialIndex() {
        int tutorialIndex = 0;
        for (int i = 0; i < this.currTutorialTypeIndex; ++i) {
            tutorialIndex += this.tutorialTexts[i].length;
        }
        return tutorialIndex + this.currTutorialTextIndex;
    }

    public final void resetTutorialParams() {
        this.worldMapTutorialRMS = true;
        this.gameTutorialRMS = true;
        this.shopTutorialRMS = true;
        this.gameLogic.getGData().save(1, 43);
        this.gameLogic.getGData().save(1, 44);
        this.gameLogic.getGData().save(1, 45);
    }
}

