/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.menu;

import com.tqm.agave.MainLogic;
import com.tqm.agave.menu.Container;
import com.tqm.fantasydefense.FramedPaper;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.menu.Highscores;
import com.tqm.fantasydefense.shop.ShopManager;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public final class Nick
implements CommandListener {
    public static Display display;
    private Form form;
    private TextField textField;
    private Displayable prevDisplayed;
    private GameLogic gameLogic;
    private String nick;
    private boolean confirmationWindow;
    private FramedPaper framedPaper;
    private Container confirmationContainer;
    private boolean rmsSaving;

    public Nick(GameLogic commandListener, Highscores highscores) {
        this.gameLogic = commandListener;
        this.framedPaper = new FramedPaper();
        this.confirmationContainer = new Container(MainLogic.width, MainLogic.height, 129);
        FramedPaper.setContainerParams(this.confirmationContainer);
        commandListener = this;
        this.form = new Form(MainLogic.strings[368]);
        ((Nick)commandListener).textField = new TextField(MainLogic.strings[368], "", 20, 0);
        Command command = new Command("OK", 4, 1);
        Command command2 = new Command("BACK", 2, 1);
        ((Nick)commandListener).form.append((Item)((Nick)commandListener).textField);
        ((Nick)commandListener).form.addCommand(command);
        ((Nick)commandListener).form.addCommand(command2);
        ((Nick)commandListener).form.setCommandListener(commandListener);
        highscores.setNick(this);
    }

    public final void loadNickFromRMS() {
        this.nick = this.gameLogic.getGData().loadAsString(57);
        if (this.nick == null) {
            this.nick = "";
        }
        this.rmsSaving = false;
    }

    public final void saveNickToRMS() {
        this.gameLogic.getGData().save(this.nick, 57);
    }

    public final boolean isNickCreated() {
        return !this.isNickEmpty();
    }

    public final boolean isNickEmpty() {
        return this.nick.equals("");
    }

    public final void doRmsSaving() {
        this.saveNickToRMS();
        this.gameLogic.getWrapperController().setNick(this.nick);
        this.gameLogic.resetRMSSettingsByNew();
        this.rmsSaving = false;
    }

    public final boolean isVisible() {
        return display.getCurrent() == this.form;
    }

    public final void commandAction(Command object, Displayable displayable) {
        if (object.getCommandType() == 4) {
            boolean bl;
            object = this.textField.getString();
            displayable = object;
            object = this;
            if (displayable == null || displayable.trim().equals("") || displayable.trim().length() > 20) {
                bl = false;
            } else {
                object.nick = displayable.trim();
                GameLogic.changeState(17, 207, 1, true);
                bl = true;
            }
            if (bl) {
                this.rmsSaving = true;
                this.setVisible(false);
            }
            return;
        }
        if (object.getCommandType() == 2) {
            this.setVisible(false);
        }
    }

    public final void setVisible(boolean bl) {
        if (bl) {
            this.prevDisplayed = display.getCurrent();
            this.textField.setString(this.nick);
            display.setCurrent((Displayable)this.form);
            return;
        }
        display.setCurrent(this.prevDisplayed);
    }

    public final String getNickString() {
        return this.nick;
    }

    public final void setNickString(String nick) {
        this.nick = nick;
    }

    public final void resetNickParams() {
        this.nick = "";
        this.saveNickToRMS();
    }

    public final boolean isRmsSaving() {
        return this.rmsSaving;
    }

    public final boolean isConfirmationWindow() {
        return this.confirmationWindow;
    }

    public final void setConfirmationWindow(boolean confirmationWindow) {
        this.confirmationWindow = true;
    }

    public final void loadConfirmationWindowSprites() {
        this.framedPaper.loadSprites();
    }

    public final void setConfirmationWindowPositions() {
        this.framedPaper.setFramePosition((MainLogic.width - this.framedPaper.getWideFrameWidth()) / 2, (MainLogic.height - this.framedPaper.getLowFrameHeight()) / 2);
        ShopManager.setShopContainerDefaultSize(this.confirmationContainer, this.framedPaper);
        this.confirmationContainer.setPosition(this.framedPaper.getX() + (this.framedPaper.getWideFrameWidth() - this.confirmationContainer.getWidth()) / 2, this.framedPaper.getY() + (this.framedPaper.getLowFrameHeight() - this.confirmationContainer.getHeight()) / 2);
        this.confirmationContainer.setText$40907f8c(MainLogic.strings[364], GameLogic.getSystemFont(), null, 6);
    }

    public final void drawConfirmationWindow(Graphics g) {
        this.framedPaper.drawWideLowFramedPaper(g);
        GameLogic.setMenuScrollbarColor();
        this.confirmationContainer.setPosition(this.confirmationContainer.getX(), this.confirmationContainer.getY());
        this.confirmationContainer.draw(g);
    }

    public final void keyPressed(int n) {
        switch (n) {
            case 53: 
            case 89: 
            case 91: {
                if (!this.confirmationWindow) break;
                this.confirmationWindow = false;
                this.framedPaper.disposeSprites();
                this.setVisible(true);
                return;
            }
            case 90: 
            case 95: {
                if (this.confirmationWindow) {
                    this.confirmationWindow = false;
                    this.framedPaper.disposeSprites();
                    return;
                }
                this.gameLogic.keyPressed(n);
                return;
            }
            case 50: 
            case 56: 
            case 85: 
            case 87: {
                if (!this.confirmationWindow) break;
                this.confirmationContainer.keyPressed(n);
            }
        }
    }
}

