/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman.screen;

import com.nokia.mid.ui.FullCanvas;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ng.games.pacman.Game;
import ng.games.pacman.io.ResourceManager;

public class GameScreen
extends FullCanvas {
    private Vector commands = new Vector();
    private CommandListener commandListener;
    private Game game;
    private static GameScreen instance = null;
    private Command positiveCommand;
    private Command negativeCommand;
    private Image confirmImage;
    private Image declineImage;
    private boolean buttonsVisible = false;

    protected void keyPressed(int n) {
        if (n == -6) {
            this.fireCommandAction(this.positiveCommand);
        } else if (n == -7) {
            this.fireCommandAction(this.negativeCommand);
        } else {
            this.game.keyPressed(n);
        }
    }

    private final void fireCommandAction(Command command) {
        if (command != null && this.commandListener != null) {
            this.commandListener.commandAction(command, (Displayable)this);
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    public void addCommand(Command command) {
        int n = command.getCommandType();
        if (n == 4) {
            this.positiveCommand = command;
        } else {
            this.negativeCommand = n == 2 ? command : command;
        }
    }

    public void removeCommand(Command command) {
        if (this.positiveCommand != null && this.positiveCommand == command) {
            this.positiveCommand = null;
        } else if (this.negativeCommand != null && this.negativeCommand == command) {
            this.negativeCommand = null;
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, 176, 208);
        if (this.game != null) {
            this.game.paint(graphics);
        }
        if (this.buttonsVisible) {
            if (this.positiveCommand != null) {
                graphics.drawImage(this.confirmImage, 4, 204, 36);
            }
            if (this.negativeCommand != null) {
                graphics.drawImage(this.declineImage, 172, 204, 40);
            }
        }
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public static GameScreen getInstance() {
        if (instance == null) {
            instance = new GameScreen();
        }
        return instance;
    }

    private GameScreen() {
    }

    public static int getGMAction(int n) {
        return GameScreen.getInstance().getGameAction(n);
    }

    public void showButtons() {
        if (this.confirmImage == null) {
            this.confirmImage = ResourceManager.getInstance().getImage("confirm_icon");
        }
        if (this.declineImage == null) {
            this.declineImage = ResourceManager.getInstance().getImage("decline_icon");
        }
        this.buttonsVisible = true;
    }

    public void hideButtons() {
        this.buttonsVisible = false;
    }

    protected void hideNotify() {
        this.game.pauseGame();
        super.hideNotify();
    }
}

