/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class ScriptThread {
    public static int touchMe = 1;
    public static final int MAX_SCRIPT_THREADS = 20;
    public static final int MAX_STACK_SIZE = 16;
    public static final int DEFAULT_TIME_SCALE = 100;
    public int unpauseTime;
    public int state = 2;
    public boolean inuse = false;
    public int IP = 0;
    public int FP = 0;
    public int flags;
    public int type;
    public boolean throwAwayLoot;
    private int[] scriptStack = new int[16];
    public int stackPtr = 0;
    private Text debugString = null;
    public static int lootSource = -1;

    public void saveState(DataOutputStream dataOutputStream) throws IOException {
        if (this.unpauseTime == -1 || this.unpauseTime == 0) {
            dataOutputStream.writeInt(this.unpauseTime);
        } else {
            dataOutputStream.writeInt(this.unpauseTime - App.gameTime);
        }
        dataOutputStream.writeByte(this.state);
        dataOutputStream.writeInt(this.IP);
        dataOutputStream.writeInt(this.FP);
        for (int i = 0; i < this.FP; ++i) {
            dataOutputStream.writeInt(this.scriptStack[i]);
        }
    }

    public void loadState(DataInputStream dataInputStream) throws IOException {
        this.init();
        this.unpauseTime = dataInputStream.readInt();
        if (this.unpauseTime != 0 && this.unpauseTime != -1) {
            this.unpauseTime += App.gameTime;
        }
        this.state = dataInputStream.readByte();
        this.IP = dataInputStream.readInt();
        this.FP = dataInputStream.readInt();
        for (int i = 0; i < this.FP; ++i) {
            this.scriptStack[i] = dataInputStream.readInt();
        }
    }

    public int executeTile(int n, int n2, int n3, boolean bl) {
        if (n < 0 || n >= 32 || n2 < 0 || n2 >= 32) {
            this.state = 0;
            return 0;
        }
        Game.skipAdvanceTurn = false;
        int n4 = n2 * 32 + n;
        if ((Render.mapFlags[n4] & 0x40) != 0) {
            int n5 = Render.findEventIndex(n4);
            int n6 = 0;
            while (n5 != -1) {
                int n7 = Render.tileEvents[n5 + 1];
                int n8 = n7 & n3;
                if ((n7 & 0x80000) == 0 && (n8 & 0xF) != 0 && (n8 & 0xFF0) != 0 && ((n7 & 0x7000) == 0 && (n3 & 0x7000) == 0 || (n8 & 0x7000) != 0)) {
                    if ((n7 & 0x40000) != 0) {
                        Game.skipAdvanceTurn = true;
                        Game.queueAdvanceTurn = false;
                    }
                    this.alloc(n5, n3, bl);
                    n6 = this.run();
                }
                n5 = Render.getNextEventIndex();
            }
            return n6;
        }
        this.state = 0;
        return 0;
    }

    int queueTile(int n, int n2, int n3) {
        return this.queueTile(n, n2, n3, false);
    }

    int queueTile(int n, int n2, int n3, boolean bl) {
        int n4;
        if (n < 0 || n >= 32 || n2 < 0 || n2 >= 32) {
            this.state = 0;
            return 0;
        }
        Game.skipAdvanceTurn = false;
        int n5 = n2 * 32 + n;
        if ((Render.mapFlags[n5] & 0x40) != 0 && (n4 = Render.findEventIndex(n5)) != -1) {
            this.alloc(n4, n3, bl);
            this.flags |= 2;
            return 2;
        }
        this.state = 0;
        return this.state;
    }

    private int evWait(int n) {
        if (Game.skippingCinematic) {
            return 1;
        }
        this.unpauseTime = App.gameTime + n;
        if ((this.flags & 1) != 0) {
            if (Canvas.state != 18) {
                Canvas.blockInputTime = this.unpauseTime;
            }
            if (Canvas.state == 6 || Canvas.state == 1) {
                Canvas.setState(3);
            }
            if (Canvas.state == 3) {
                Canvas.clearSoftKeys();
            }
        }
        return 2;
    }

    private boolean evReturn() {
        while (this.FP < this.stackPtr - 2) {
            this.pop();
        }
        this.FP = this.pop();
        int n = this.pop();
        if (n == -1) {
            if (this.stackPtr != 0) {
                App.Error(new Exception("The frame pointer should be zero if the script has completed."), 102);
            }
            return true;
        }
        this.IP = n;
        return false;
    }

    private void alloc(int n, int n2, boolean bl) {
        this.IP = (Render.tileEvents[n] & 0xFFFF0000) >> 16;
        this.FP = 0;
        this.stackPtr = 0;
        this.push(-1);
        this.push(0);
        this.type = n2;
        this.flags = 0;
        if (bl) {
            this.flags = 1;
        }
    }

    public void alloc(int n) {
        this.IP = n;
        this.FP = 0;
        this.stackPtr = 0;
        this.push(-1);
        this.push(0);
        this.type = 0;
        this.flags = 1;
    }

    private final int peekNextCmd() {
        return Render.mapByteCode[this.IP + 1];
    }

    public static void setupCamera(int n) {
        Game.cinUnpauseTime = App.gameTime + 1000;
        Game.activeCameraView = true;
        MayaCamera mayaCamera = Game.mayaCameras[n];
        Game.activeCameraKey = -1;
        Game.activeCamera = mayaCamera;
        mayaCamera.complete = false;
        Game.activeCameraTime = App.gameTime;
        Game.camPlayerX = Canvas.destX << 0;
        Game.camPlayerY = Canvas.destY << 0;
        Game.camPlayerZ = Canvas.destZ << 0;
        Game.camPlayerYaw = Canvas.destAngle & 0x3FF;
        Game.camPlayerPitch = Canvas.viewPitch;
        mayaCamera.x = Game.mayaCameraKeys[Game.OFS_MAYAKEY_X + mayaCamera.keyOffset];
        if (mayaCamera.x == -2) {
            mayaCamera.x = Game.camPlayerX;
        }
        mayaCamera.y = Game.mayaCameraKeys[Game.OFS_MAYAKEY_Y + mayaCamera.keyOffset];
        if (mayaCamera.y == -2) {
            mayaCamera.y = Game.camPlayerY;
        }
        mayaCamera.z = Game.mayaCameraKeys[Game.OFS_MAYAKEY_Z + mayaCamera.keyOffset];
        if (mayaCamera.z == -2) {
            mayaCamera.z = Game.camPlayerZ;
        }
        mayaCamera.x <<= 4;
        mayaCamera.y <<= 4;
        mayaCamera.z <<= 4;
        mayaCamera.pitch = Game.mayaCameraKeys[Game.OFS_MAYAKEY_PITCH + mayaCamera.keyOffset];
        if (mayaCamera.pitch == -2) {
            mayaCamera.pitch = Game.camPlayerPitch;
        }
        mayaCamera.yaw = Game.mayaCameraKeys[Game.OFS_MAYAKEY_YAW + mayaCamera.keyOffset];
        if (mayaCamera.yaw == -2) {
            mayaCamera.yaw = Game.camPlayerYaw;
        }
        mayaCamera.roll = Game.mayaCameraKeys[Game.OFS_MAYAKEY_ROLL + mayaCamera.keyOffset];
    }

    public int run() {
        Game.updateScriptVars();
        if (this.stackPtr == 0) {
            return 1;
        }
        int n = 1;
        int n2 = 0;
        boolean bl = true;
        byte[] byArray = Render.mapByteCode;
        while (this.IP < Render.mapByteCodeSize && n != 2) {
            bl = true;
            n2 = 0;
            switch (byArray[this.IP]) {
                case 0: {
                    int n3;
                    int n4 = this.getByteArg();
                    bl = false;
                    while ((n4 = (int)((short)(n4 - 1))) >= 0) {
                        n3 = this.getByteArg();
                        if ((n3 & 0x40) != 0) {
                            n3 = (n3 & 0x3F) << 8;
                            n3 |= this.getByteArg();
                            n3 = n3 << 18 >> 18;
                            this.push(n3);
                            continue;
                        }
                        if ((n3 & 0x80) != 0) {
                            this.push(Game.scriptStateVars[n3 & 0x7F]);
                            continue;
                        }
                        switch (n3) {
                            case 0: {
                                this.push(this.pop() == 1 && this.pop() == 1);
                                break;
                            }
                            case 1: {
                                this.push(this.pop() == 1 || this.pop() == 1);
                                break;
                            }
                            case 3: {
                                int n5 = this.pop();
                                int n6 = this.pop();
                                this.push(n6 < n5);
                                break;
                            }
                            case 2: {
                                int n5 = this.pop();
                                int n6 = this.pop();
                                this.push(n6 <= n5);
                                break;
                            }
                            case 4: {
                                this.push(this.pop() == this.pop());
                                break;
                            }
                            case 5: {
                                this.push(this.pop() != this.pop());
                                break;
                            }
                            case 6: {
                                int n5 = this.pop();
                                if (n5 == 0) {
                                    this.push(1);
                                    break;
                                }
                                this.push(0);
                                break;
                            }
                        }
                    }
                    n3 = this.getUByteArg();
                    if (this.pop() != 0) break;
                    this.IP += n3;
                    break;
                }
                case 1: {
                    int n4 = this.getUShortArg();
                    this.IP += n4;
                    break;
                }
                case 2: {
                    if (!this.evReturn()) break;
                    return 1;
                }
                case 3: {
                    int n4 = this.getUShortArg();
                    short s = (short)(n4 & Short.MAX_VALUE);
                    int n7 = (n4 & 0x8000) >> 15;
                    if (n7 == 1) {
                        Hud.addMessage(Canvas.loadMapStringID, s, 3);
                        break;
                    }
                    if (Canvas.state == 18) {
                        Hud.msgCount = 0;
                    }
                    Hud.addMessage(Canvas.loadMapStringID, s);
                    break;
                }
                case 4: {
                    int n8 = this.getUByteArg();
                    n8 |= this.getUByteArg() << 8;
                    int n4 = (n8 |= this.getUByteArg() << 16) >> 14 & 0xFF;
                    int n9 = n8 >> 9 & 0x1F;
                    int n10 = n8 >> 4 & 0x1F;
                    int n11 = n8 & 0xF;
                    int n12 = (n11 & 8) == 0 ? this.getUByteArg() - 48 : 32;
                    int n13 = (n11 & 4) == 0 ? this.getUByteArg() * 100 : 0;
                    boolean bl2 = (n11 & 1) != 0;
                    LerpSprite lerpSprite = Game.allocLerpSprite(this, n4, (n11 & 2) != 0);
                    if (lerpSprite == null) {
                        return 0;
                    }
                    lerpSprite.dstX = 32 + (n9 << 6);
                    lerpSprite.dstY = 32 + (n10 << 6);
                    short s = Render.mapSprites[Render.S_ENT + n4];
                    if (s != -1) {
                        Game.entities[s].info |= 0x400000;
                    }
                    lerpSprite.dstZ = Render.getHeight(lerpSprite.dstX, lerpSprite.dstY) + n12;
                    lerpSprite.srcX = Render.mapSprites[Render.S_X + n4];
                    lerpSprite.srcY = Render.mapSprites[Render.S_Y + n4];
                    lerpSprite.srcZ = Render.mapSprites[Render.S_Z + n4];
                    lerpSprite.srcScale = lerpSprite.dstScale = Render.mapSprites[Render.S_SCALEFACTOR + n4];
                    lerpSprite.startTime = App.gameTime;
                    lerpSprite.travelTime = n13;
                    lerpSprite.flags = n11 & 3;
                    lerpSprite.calcDist();
                    if (n13 == 0) {
                        if ((Game.updateLerpSprite(lerpSprite) & 1) != 0) {
                            Canvas.invalidateRect();
                            break;
                        }
                        n = 0;
                        break;
                    }
                    if (bl2) break;
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 59: {
                    int n4 = this.getUByteArg();
                    int n14 = this.getUByteArg() * 100;
                    int n15 = this.getIntArg();
                    int n16 = n15 & 0x7FF;
                    int n17 = n15 >> 11 & 0x7FF;
                    int n18 = n15 >> 22 & 3;
                    int n19 = (n15 >> 24 & 0xFF) - 48;
                    LerpSprite lerpSprite = Game.allocLerpSprite(this, n4, (n18 & 2) != 0);
                    if (lerpSprite == null) {
                        return 0;
                    }
                    lerpSprite.dstX = n17;
                    lerpSprite.dstY = n16;
                    short s = Render.mapSprites[Render.S_ENT + n4];
                    if (s != -1) {
                        Game.entities[s].info |= 0x400000;
                    }
                    lerpSprite.dstZ = Render.getHeight(lerpSprite.dstX, lerpSprite.dstY) + n19;
                    lerpSprite.srcX = Render.mapSprites[Render.S_X + n4];
                    lerpSprite.srcY = Render.mapSprites[Render.S_Y + n4];
                    lerpSprite.srcZ = Render.mapSprites[Render.S_Z + n4];
                    lerpSprite.srcScale = lerpSprite.dstScale = Render.mapSprites[Render.S_SCALEFACTOR + n4];
                    lerpSprite.startTime = App.gameTime;
                    lerpSprite.travelTime = n14;
                    lerpSprite.calcDist();
                    lerpSprite.flags = n18 & 3;
                    if (n14 == 0) {
                        if ((Game.updateLerpSprite(lerpSprite) & 1) != 0) {
                            Canvas.invalidateRect();
                            break;
                        }
                        n = 0;
                        break;
                    }
                    if ((lerpSprite.flags & 1) != 0) break;
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 5: {
                    int n4 = this.getByteArg();
                    ScriptThread.setupCamera(n4);
                    Game.activeCamera.cameraThread = this;
                    if (Canvas.state != 1 && Canvas.state != 18) {
                        Canvas.setState(18);
                    }
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    break;
                }
                case 6: {
                    short s;
                    int n4 = this.getByteArg();
                    Game.scriptStateVars[n4] = s = this.getShortArg();
                    if (n4 != 6 || s != 1) break;
                    Player.removeStatusEffect(13);
                    break;
                }
                case 26: {
                    int n4;
                    int n20 = n4 = (int)this.getByteArg();
                    Game.scriptStateVars[n20] = (short)(Game.scriptStateVars[n20] - 1);
                    if (n4 != 6 || Game.scriptStateVars[n4] != 1) break;
                    Player.removeStatusEffect(13);
                    break;
                }
                case 27: {
                    int n4;
                    int n21 = n4 = (int)this.getByteArg();
                    Game.scriptStateVars[n21] = (short)(Game.scriptStateVars[n21] + 1);
                    if (n4 != 6 || Game.scriptStateVars[n4] != 1) break;
                    Player.removeStatusEffect(13);
                    break;
                }
                case 7: {
                    int n4 = this.getUShortArg();
                    int n22 = this.FP;
                    this.FP = this.stackPtr;
                    this.push(this.IP);
                    this.push(n22);
                    this.IP = n4 - 1;
                    break;
                }
                case 8: {
                    int n4 = this.getUShortArg();
                    int n23 = n4 & 0x1F;
                    int n24 = (n4 & 0x3E0) >> 5;
                    short s = 0;
                    if (n23 == 0) {
                        s = Player.inventory[n24];
                    } else if (n23 == 1) {
                        if ((Player.weapons & 1L << n24) != 0L) {
                            s = 1;
                        }
                    } else if (n23 == 2) {
                        s = Player.ammo[n24];
                    }
                    Game.scriptStateVars[(n4 & 0xFC00) >> 10] = s;
                    break;
                }
                case 9: {
                    int n4 = this.getUShortArg();
                    int n25 = n4 & 0x1F;
                    int n26 = n4 >> 5 & 0x1F;
                    int n27 = n4 >> 10 & 0x3F;
                    short s = 1;
                    Entity entity = Game.entityDb[n25 + 32 * n26];
                    if (entity != null) {
                        while (entity != null) {
                            if ((1 << entity.def.eType & 0x6240) == 0) {
                                s = 0;
                                break;
                            }
                            entity = entity.nextOnTile;
                        }
                    }
                    Game.scriptStateVars[n27] = s;
                    break;
                }
                case 10: {
                    int n4 = this.getByteArg();
                    Game.scriptStateVars[n4 & 0x3F] = (short)Player.ce.weapon;
                    break;
                }
                case 11: {
                    int n4 = this.getUByteArg();
                    int n28 = this.getUShortArg();
                    boolean bl3 = true;
                    short s = (short)(Canvas.loadMapID - 1);
                    Player.completedLevels |= 1 << s;
                    Game.spawnParam = (n4 >> 4 & 7) << 10 | n28 & 0x3FF;
                    MenuSystem.LEVEL_STATS_nextMap = (short)(n4 & 0xF);
                    if (MenuSystem.LEVEL_STATS_nextMap < Canvas.loadMapID) {
                        bl3 = false;
                    }
                    Player.removeStatusEffect(12);
                    Game.snapAllMovers();
                    if ((n4 & 0x80) != 0) {
                        int n29 = 1;
                        n29 = bl3 ? (n29 |= 8) : (n29 |= 4);
                        if (this.state == 6) {
                            Canvas.setState(3);
                        }
                        Render.startFade(1000, n29);
                    } else if (bl3) {
                        Canvas.saveState(51, (short)5, (short)179);
                    } else {
                        Canvas.loadMap(MenuSystem.LEVEL_STATS_nextMap, false);
                    }
                    Canvas.changeMapStarted = true;
                    break;
                }
                case 12: {
                    int n4 = this.getUShortArg();
                    int n30 = this.getUShortArg();
                    if (Game.skippingCinematic) break;
                    short s = (short)(n4 & 0x3FFF);
                    int n31 = (n4 & 0x8000) >> 15;
                    boolean bl4 = Hud.showCinPlayer = (n4 & 0x4000) != 0;
                    if (n31 == 1) {
                        Hud.showCinPlayer = false;
                    }
                    if (n31 == 0) {
                        Hud.subTitleID = Text.STRINGID(Canvas.loadMapStringID, s);
                        Hud.subTitleTime = App.gameTime + n30;
                    } else {
                        Hud.cinTitleID = Text.STRINGID(Canvas.loadMapStringID, s);
                        Hud.cinTitleTime = App.gameTime + n30;
                    }
                    Canvas.repaintFlags |= 0x10;
                    Hud.repaintFlags = 16;
                    break;
                }
                case 13: {
                    int n4 = this.getUByteArg();
                    int n32 = this.getUByteArg();
                    int n33 = n32 >> 4;
                    n32 &= 0xF;
                    if (Canvas.state == 6) {
                        Canvas.setState(3);
                        Canvas.invalidateRect();
                    }
                    if (Game.skipDialog) break;
                    if (n32 == 6 || n32 == 7 || n32 == 1) {
                        Player.inCombat = false;
                    }
                    if (n32 == 2) {
                        boolean bl5 = false;
                        Player.prevWeapon = Player.ce.weapon;
                        for (byte by = 0; by < 20; by = (byte)(by + 1)) {
                            if (Game.scriptThreads[by] != this) continue;
                            bl5 = Canvas.enqueueHelpDialog(Canvas.loadMapStringID, (short)n4, by);
                            break;
                        }
                        if (!bl5) {
                            break;
                        }
                    } else {
                        if (n32 == 4) {
                            Player.prevWeapon = Player.ce.weapon;
                        }
                        Canvas.startDialog(this, Canvas.loadMapStringID, (short)n4, n32, n33, true);
                    }
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 14: {
                    int n4 = this.getUByteArg() * 100;
                    n = this.evWait(n4);
                    break;
                }
                case 15: {
                    if (Game.interpolatingMonsters) {
                        Game.snapMonsters(true);
                    }
                    while (Game.combatMonsters != null) {
                        Game.combatMonsters.undoAttack();
                    }
                    Game.endMonstersTurn();
                    int n4 = this.getUShortArg();
                    boolean bl6 = (n4 & 0x4000) != 0;
                    Canvas.destX = (n4 >> 5 & 0x1F) * 64 + 32;
                    Canvas.destY = (n4 & 0x1F) * 64 + 32;
                    Canvas.destZ = Render.getHeight(Canvas.destX, Canvas.destY) + 36;
                    int n34 = n4 >> 10 & 0xF;
                    Canvas.destPitch = 0;
                    Canvas.viewPitch = 0;
                    Canvas.destRoll = 0;
                    Canvas.viewRoll = 0;
                    Canvas.knockbackDist = 0;
                    if (bl6) {
                        if (n34 != 15) {
                            int n35 = n34 << 7;
                            int n36 = Canvas.viewAngle & 0x3FF;
                            if (n35 - n36 > 512) {
                                n35 -= 1024;
                            } else if (n35 - n36 < -512) {
                                n35 += 1024;
                            }
                            Canvas.viewAngle = n36;
                            Canvas.destAngle = n35;
                        }
                        Canvas.startRotation(false);
                        Canvas.zStep = (Math.abs(Canvas.destZ - Canvas.viewZ) + Canvas.animFrames - 1) / Canvas.animFrames;
                        if (Canvas.destX != Canvas.viewX || Canvas.destY != Canvas.viewY || Canvas.viewAngle != Canvas.destAngle) {
                            Canvas.gotoThread = this;
                            this.unpauseTime = -1;
                            n = 2;
                        } else {
                            Canvas.viewPitch = Canvas.destPitch;
                        }
                    } else {
                        Canvas.viewX = Canvas.destX;
                        Canvas.viewY = Canvas.destY;
                        Canvas.viewZ = Canvas.destZ;
                        if (n34 != 15) {
                            Canvas.destAngle = Canvas.viewAngle = n34 << 7;
                            Canvas.finishRotation(true);
                        }
                        if ((n4 & 0x8000) != 0) {
                            Game.advanceTurn();
                        }
                        if (Canvas.state != 18) {
                            Canvas.startRotation(false);
                            Canvas.viewPitch = Canvas.destPitch;
                        } else {
                            Canvas.destPitch = 0;
                            Canvas.viewPitch = 0;
                        }
                        Game.gotoTriggered = true;
                        Canvas.automapDrawn = false;
                    }
                    Player.relink();
                    Canvas.clearEvents();
                    Canvas.updateFacingEntity = true;
                    Canvas.invalidateRect();
                    break;
                }
                case 69: {
                    int n4 = this.getByteArg();
                    int n37 = Canvas.viewAngle & 0x3FF;
                    int n38 = n4 << 7;
                    if (n38 - n37 > 512) {
                        n38 -= 1024;
                    } else if (n38 - n37 < -512) {
                        n38 += 1024;
                    }
                    if (n37 == n38) break;
                    Canvas.viewAngle = n37;
                    Canvas.destAngle = n38;
                    Canvas.startRotation(false);
                    Canvas.gotoThread = this;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 16: {
                    Canvas.abortMove = true;
                    break;
                }
                case 34: {
                    int n4 = this.getUByteArg();
                    short s = this.getUByteArg();
                    short s2 = Render.mapSprites[Render.S_ENT + n4];
                    if (s2 == -1) break;
                    Entity entity = Game.entities[s2];
                    entity.info |= 0x400000;
                    entity.name = (short)(s | Canvas.loadMapStringID << 10);
                    break;
                }
                case 17: {
                    int n4 = this.getUByteArg();
                    short s = this.getUByteArg();
                    int n39 = this.getUByteArg() * 100;
                    short s3 = Render.mapSprites[Render.S_ENT + n4];
                    int n40 = Render.mapSpriteInfo[n4] & 0xFF;
                    int n41 = (Render.mapSpriteInfo[n4] & 0xFF00) >> 8;
                    Render.mapSpriteInfo[n4] = Render.mapSpriteInfo[n4] & 0xFFFF00FF | s << 8;
                    Canvas.staleView = true;
                    if (s3 != -1) {
                        Game.entities[s3].info |= 0x400000;
                        if (Game.entities[s3].monster != null) {
                            Game.entities[s3].monster.frameTime = Integer.MAX_VALUE;
                        }
                    }
                    if (n40 == 173) {
                        int n42 = n4;
                        Render.mapSpriteInfo[n42] = Render.mapSpriteInfo[n42] & 0xFFFBFFFF;
                        int n43 = n4;
                        Render.mapSpriteInfo[n43] = Render.mapSpriteInfo[n43] | s << 18;
                        if (n41 == 0 && s == 1) {
                            int n44 = Render.S_Z + n4;
                            Render.mapSprites[n44] = (short)(Render.mapSprites[n44] - 11);
                        } else if (n41 == 1 && s == 0) {
                            int n45 = Render.S_Z + n4;
                            Render.mapSprites[n45] = (short)(Render.mapSprites[n45] + 11);
                        }
                    }
                    if (n39 <= 0) break;
                    n = this.evWait(n39);
                    break;
                }
                case 18: {
                    if (Canvas.state == 18) {
                        Game.activeCamera.keyThreadResumeCount = this.getUByteArg();
                        Game.activeCamera.keyThread = this;
                        Game.activeCamera.NextKey();
                        this.unpauseTime = -1;
                        n = 2;
                        break;
                    }
                    this.getUByteArg();
                    break;
                }
                case 19: {
                    int n4 = this.getUByteArg();
                    byte by = this.getByteArg();
                    short s = Render.mapSprites[Render.S_ENT + n4];
                    if (s != -1) {
                        Entity entity = Game.entities[s];
                        if (entity.monster != null) {
                            entity.info |= 0x20000;
                            entity.pain(by, null);
                            if (entity.monster.ce.getStat(0) <= 0) {
                                entity.died(false, null);
                            }
                        } else {
                            entity.died(false, null);
                        }
                    }
                    Canvas.staleView = true;
                    break;
                }
                case 20: {
                    int n4 = this.getByteArg();
                    byte by = this.getByteArg();
                    int n46 = this.getByteArg();
                    if (n4 > 0) {
                        Player.painEvent(null, false);
                        Hud.damageTime = App.time + 1000;
                        if (n46 != -1) {
                            int n47 = 256 - (Canvas.viewAngle & 0x3FF) >> 7;
                            Hud.damageDir = n46 = n46 + n47 + 1 & 7;
                        }
                        Combat.totalDamage = 1;
                        Player.pain(n4, null, true);
                    } else if (n4 < 0) {
                        Player.addHealth(-n4);
                    }
                    Player.addArmor(-by);
                    break;
                }
                case 21: {
                    int n4 = this.getUShortArg();
                    int n48 = n4 >> 10;
                    boolean bl7 = (n48 & 4) == 0 && Canvas.state != 6;
                    n48 &= 3;
                    short s = Render.mapSprites[Render.S_ENT + (n4 &= 0x3FF)];
                    if (s == -1) break;
                    Entity entity = Game.entities[s];
                    if (n48 == 1 || n48 == 0) {
                        if (n48 == 1 && entity.def.eType == 5) {
                            Game.setLineLocked(entity, false);
                        }
                        if (!Game.performDoorEvent(n48, bl7 ? this : null, entity, bl7 ? 1 : 0, false) || !bl7) break;
                        this.unpauseTime = -1;
                        n = 2;
                        break;
                    }
                    if (n48 == 2) {
                        Game.setLineLocked(entity, true);
                        Sound.playSound(14);
                        break;
                    }
                    Game.setLineLocked(entity, false);
                    Sound.playSound(14);
                    break;
                }
                case 22: {
                    int n4 = this.getUByteArg();
                    int n49 = this.getUByteArg();
                    int n50 = n49 >> 6 & 3;
                    n49 = 1 << (n49 & 0x3F);
                    short s = Render.mapSprites[Render.S_ENT + n4];
                    if (s == -1) break;
                    Entity entity = Game.entities[s];
                    if (entity.monster == null) break;
                    if (n50 == 0) {
                        entity.monster.flags = (short)(entity.monster.flags | n49);
                        if (n49 == 1 && entity.def.eSubType == 14) {
                            int n51 = entity.getSprite();
                            Render.mapSpriteInfo[n51] = Render.mapSpriteInfo[n51] | 0x20000;
                        }
                    } else {
                        entity.monster.flags = n50 == 1 ? (short)(entity.monster.flags & ~n49) : (short)n49;
                    }
                    if (n49 == 2048 && (n50 == 0 || n50 == 2)) {
                        entity.info &= 0xFFFDFFFF;
                    } else if (n49 == 2048) {
                        entity.info |= 0x20000;
                    }
                    entity.info |= 0x400000;
                    break;
                }
                case 23: {
                    int n4 = this.getUShortArg();
                    int n52 = (n4 & 0x8000) >> 15 << 19;
                    int n53 = Render.tileEvents[(n4 &= Short.MAX_VALUE) * 2 + 1] & 0xFFF7FFFF;
                    Render.tileEvents[n4 * 2 + 1] = n53 | n52;
                    break;
                }
                case 24: {
                    int n4;
                    int n54 = n4 = (int)this.getUByteArg();
                    Render.mapSpriteInfo[n54] = Render.mapSpriteInfo[n54] | 0x10000;
                    short s = Render.mapSprites[Render.S_ENT + n4];
                    if (s != -1) {
                        Entity entity = Game.entities[s];
                        entity.info |= 0x400000;
                        Game.unlinkEntity(entity);
                        EntityDef entityDef = entity.def;
                        if (entityDef.eType == 10) {
                            if (entityDef.eSubType != 8 && entityDef.eSubType != 10) {
                                Game.destroyedObject(n4);
                            }
                        } else if (entityDef.eType == 6 && (entityDef.eSubType == 1 || entityDef.eSubType == 2 || entityDef.eSubType == 0 && entityDef.parm == 21)) {
                            Game.foundLoot(n4, 1);
                        } else if (entityDef.eType == 2) {
                            ScriptThread.corpsifyMonster(entity.linkIndex % 32, entity.linkIndex / 32, entity);
                            Game.remove(entity);
                            entity.info |= 0x400000;
                        }
                    }
                    Canvas.updateFacingEntity = true;
                    break;
                }
                case 28: {
                    int n4 = this.getUByteArg();
                    short s = Render.mapSprites[Render.S_ENT + n4];
                    if (s == -1 || Game.entities[s].monster == null) {
                        App.Error(23);
                    }
                    Entity entity = Game.entities[s];
                    if (entity.def.eType != 2) break;
                    int n55 = entity.getSprite();
                    entity.monster.frameTime = 0;
                    Render.mapSpriteInfo[n55] = Render.mapSpriteInfo[n55] & 0xFFFF00FF | 0;
                    Game.activate(entity, true, false, false, true);
                    break;
                }
                case 33: {
                    int n4 = this.getUByteArg();
                    short s = this.getUByteArg();
                    byte by = this.getByteArg();
                    if (this.throwAwayLoot) {
                        n2 = 1;
                        Game.foundLoot(Canvas.viewX + Canvas.viewStepX, Canvas.viewY + Canvas.viewStepY, Canvas.viewZ, 1);
                        break;
                    }
                    if (by == 0) {
                        short s4 = Render.mapSprites[Render.S_ENT + (n4 = (int)((short)(n4 << 8 | s)))];
                        if (s4 == -1) {
                            App.Error(new Exception("Sprite index " + n4 + " error."), 16);
                        }
                        if (Game.entities[s4].touched()) break;
                        n2 = 1;
                        break;
                    }
                    EntityDef entityDef = EntityDef.lookup(n4);
                    if (entityDef == null) {
                        App.Error(new Exception("Cannot find an entity to give"), 109);
                    }
                    if ((s = (short)((byte)s)) < 0) {
                        if (Player.give(entityDef.eSubType, entityDef.parm, s, true)) break;
                        n2 = 1;
                        break;
                    }
                    Entity entity = Game.spawnDropItem(0, 0, n4, entityDef, s, false);
                    byte by2 = entity.def.eType;
                    if (!entity.touched()) {
                        Game.remove(entity);
                        n2 = 1;
                        break;
                    }
                    if (by2 == 4 || s <= 0) break;
                    Game.foundLoot(Canvas.viewX + Canvas.viewStepX, Canvas.viewY + Canvas.viewStepY, Canvas.viewZ, 1);
                    break;
                }
                case 25: {
                    int n4 = this.getUShortArg();
                    short s = this.getUByteArg();
                    short s5 = (short)(n4 & 0x1F);
                    short s6 = (short)(n4 >> 5 & 0x1F);
                    short s7 = (short)(n4 >> 10 & 0x1F);
                    EntityDef entityDef = EntityDef.lookup(s);
                    if (entityDef == null) {
                        App.Error(new Exception("Cannot find an entity to drop"), 109);
                    }
                    Game.spawnDropItem((s5 << 6) + 32, (s6 << 6) + 32, s, entityDef.eType, entityDef.eSubType, entityDef.parm, s7, true);
                    Canvas.staleView = true;
                    break;
                }
                case 29: {
                    Game.cinematicWeapon = this.getByteArg();
                    if (Game.skippingCinematic || Canvas.state != 18) break;
                    int n4 = Game.cinematicWeapon * 9;
                    Combat.animLoopCount = Combat.weapons[n4 + 7] - 1;
                    Combat.animTime = Combat.weapons[n4 + 8];
                    Combat.animStartTime = App.gameTime;
                    Combat.animEndTime = Combat.animStartTime + (Combat.animTime *= 10);
                    Combat.flashTime = Game.cinematicWeapon == 3 ? 200 : 0;
                    Combat.flashDoneTime = Combat.animStartTime + Combat.flashTime;
                    break;
                }
                case 30: {
                    int n4 = this.getUByteArg();
                    if (Render.mapSprites[Render.S_ENT + n4] == -1) break;
                    Entity entity = Game.entities[Render.mapSprites[Render.S_ENT + n4]];
                    ParticleSystem.spawnMonsterBlood(entity, false);
                    break;
                }
                case 31: {
                    int n4 = this.getUByteArg();
                    int n56 = n4 >> 4 & 7;
                    int n57 = n4 & 0xF;
                    int n58 = this.getUShortArg();
                    if ((n4 & 0x80) != 0) {
                        int n59 = ((n58 >> 11 & 0x1F) << 6) + 32;
                        int n60 = ((n58 >> 6 & 0x1F) << 6) + 32;
                        int n61 = (n58 & 0x3F) + Render.getHeight(n59, n60);
                        ParticleSystem.spawnParticles(n56, ParticleSystem.levelColors[n57], n59, n60, n61);
                        break;
                    }
                    ParticleSystem.spawnParticles(n56, ParticleSystem.levelColors[n57], n58);
                    break;
                }
                case 32: {
                    boolean bl8;
                    int n4 = this.getUShortArg();
                    boolean bl9 = bl8 = (n4 & 0x8000) == 32768;
                    if (Game.skippingCinematic) {
                        if (!bl8) break;
                        Render.endFade();
                        break;
                    }
                    if (bl8) {
                        Render.startFade(n4 & Short.MAX_VALUE, 2);
                        break;
                    }
                    Render.startFade(n4, 1);
                    break;
                }
                case 35: {
                    int n4 = 0;
                    int n62 = this.getUShortArg();
                    int n63 = this.getUByteArg();
                    if ((n62 & 0x8000) != 0) {
                        n63 <<= 8;
                        n63 |= this.getUByteArg();
                        n62 &= Short.MAX_VALUE;
                        n4 = 1;
                    }
                    short s = this.getUByteArg();
                    short s8 = Render.mapSprites[Render.S_X + n62];
                    short s9 = Render.mapSprites[Render.S_Y + n62];
                    if (n4 == 0) {
                        EntityDef entityDef = EntityDef.lookup(n63);
                        if (entityDef == null) {
                            App.Error(new Exception("Cannot find an entity to drop"), 109);
                        }
                        Game.spawnDropItem(s8, s9, n63, entityDef, s, true);
                    } else {
                        short s10 = Render.mapSprites[Render.S_ENT + n63];
                        Entity entity = Game.entities[s10];
                        int n64 = Render.getHeight(s8, s9);
                        Render.mapSprites[Render.S_X + n63] = s8;
                        Render.mapSprites[Render.S_Y + n63] = s9;
                        Render.mapSprites[Render.S_Z + n63] = (short)(32 + n64);
                        Render.relinkSprite(n63);
                        Game.unlinkEntity(entity);
                        Game.linkEntity(entity, s8 >> 6, s9 >> 6);
                        Game.throwDropItem(s8, s9, n64, entity);
                        entity.info |= 0x400000;
                    }
                    Canvas.staleView = true;
                    break;
                }
                case 36: {
                    int n4 = this.getUByteArg();
                    short s = this.getShortArg();
                    short s11 = Render.mapSprites[Render.S_ENT + n4];
                    if (s11 == -1) break;
                    Entity entity = Game.entities[s11];
                    if (s != -1) {
                        Game.addEntityDeathFunc(entity, s);
                        break;
                    }
                    Game.removeEntityFunc(entity);
                    break;
                }
                case 39: {
                    int n4 = this.getUByteArg();
                    short s = this.getUByteArg();
                    short s12 = this.getUByteArg();
                    short s13 = this.getUByteArg();
                    int n65 = Game.getMixingIndex(n4);
                    if (n65 == -1) break;
                    Game.mixingStations[n65 + 1] = s;
                    Game.mixingStations[n65 + 2] = s12;
                    Game.mixingStations[n65 + 3] = s13;
                    break;
                }
                case 40: {
                    int n4 = this.getUByteArg();
                    int n66 = this.getUShortArg();
                    break;
                }
                case 37: {
                    int n4 = this.getUByteArg();
                    short s = this.getUByteArg();
                    Sound.playSound(n4, 0);
                    break;
                }
                case 38: {
                    int n4 = this.getUShortArg();
                    int n67 = n4 >> 14 & 3;
                    Entity entity = null;
                    if (Render.mapSprites[Render.S_ENT + (n4 &= 0x3FFF)] != -1) {
                        entity = Game.entities[Render.mapSprites[Render.S_ENT + n4]];
                        if (entity.def.eType == 3) {
                            entity.param = n67;
                            break;
                        }
                    }
                    App.Error(14);
                }
                case 41: {
                    if (Canvas.showingLoot) {
                        this.unpauseTime = 1;
                        return 2;
                    }
                    this.composeLootDialog();
                    if (this.throwAwayLoot) break;
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 42: {
                    int n4 = this.getUShortArg();
                    int n68 = n4 & 0xBC00;
                    boolean bl10 = (n68 & 0x8000) != 0;
                    int n69 = n4 >> 5 & 0x1F;
                    int n70 = n4 & 0x1F;
                    if (((n68 &= 0xFFFF7FFF) & 0x400) != 0) {
                        if (bl10) {
                            int n71 = n70;
                            Entity.baseVisitedTiles[n71] = Entity.baseVisitedTiles[n71] & ~(1 << n69);
                        } else {
                            int n72 = n70;
                            Entity.baseVisitedTiles[n72] = Entity.baseVisitedTiles[n72] | 1 << n69;
                        }
                    }
                    n68 &= 0xFFFFFBFF;
                    n68 >>= 8;
                    if (bl10) {
                        int n73 = n70 * 32 + n69;
                        Render.mapFlags[n73] = (byte)(Render.mapFlags[n73] & ~n68);
                        break;
                    }
                    int n74 = n70 * 32 + n69;
                    Render.mapFlags[n74] = (byte)(Render.mapFlags[n74] | n68);
                    break;
                }
                case 43: {
                    int n4 = this.getUByteArg();
                    short s = this.getUByteArg();
                    Player.updateQuests((short)n4, s);
                    if (s != 0) break;
                    Player.showHelp((short)6, true);
                    break;
                }
                case 44: {
                    int n4 = this.getUShortArg();
                    int n75 = 0;
                    if (Render.mapSprites[Render.S_ENT + n4] != -1) {
                        if (Player.give(0, 25, -1, true)) {
                            n75 = 25;
                        } else if (Player.give(0, 26, -1, true)) {
                            n75 = 26;
                        } else if (Player.give(0, 27, -1, true)) {
                            n75 = 27;
                        }
                    }
                    if (n75 == 0) {
                        Game.scriptStateVars[4] = 0;
                        break;
                    }
                    Game.scriptStateVars[4] = 2;
                    break;
                }
                case 45: {
                    int n4 = this.getUByteArg();
                    Player.baseCe.addStat(n4 >> 5 & 7, (n4 & 0x1F) << 27 >> 27);
                    Player.updateStats();
                    break;
                }
                case 46: {
                    int n4 = this.getUByteArg();
                    Player.cocktailDiscoverMask |= 1 << n4 - 5;
                    break;
                }
                case 47: {
                    int n4 = this.getUShortArg();
                    short s = this.getUByteArg();
                    short s14 = this.getUByteArg();
                    Entity entity = null;
                    if (Render.mapSprites[Render.S_ENT + n4] != -1) {
                        Entity entity2;
                        entity = Game.entities[Render.mapSprites[Render.S_ENT + n4]];
                        if ((entity.info & 0x1010000) != 0 && null == (entity2 = Game.findMapEntity(s, s14, 1030))) {
                            entity.resurrect((s << 6) + 32, (s14 << 6) + 32, 32);
                            break;
                        }
                    }
                    n2 = -1;
                    break;
                }
                case 48: {
                    int n76;
                    int n77;
                    int n4 = this.getUShortArg();
                    int n78 = n4 >> 14 & 3;
                    if (n78 > 0) {
                        ++n78;
                    }
                    if ((n77 = n4 >> 7 & 0x7F) > 0) {
                        n77 = n77 + 1 << 4;
                    }
                    if ((n76 = n4 & 0x7F) > 0) {
                        n76 = n76 + 1 << 4;
                    }
                    Canvas.startShake(n77, n78, n76);
                    break;
                }
                case 49: {
                    Hud.showSpeechBubble(this.getUShortArg());
                    break;
                }
                case 51: {
                    int n4 = this.getUShortArg();
                    int n79 = n4 >> 12 & 0xF;
                    byte by = this.getByteArg();
                    if (Render.mapSprites[Render.S_ENT + (n4 &= 0xFFF)] != -1) {
                        Entity entity = Game.entities[Render.mapSprites[Render.S_ENT + n4]];
                        ScriptThread.setAIGoal(entity, n79, by);
                        break;
                    }
                    App.Error(76);
                    break;
                }
                case 50: {
                    Game.awardSecret();
                    break;
                }
                case 52: {
                    if (Game.interpolatingMonsters) {
                        Game.snapMonsters(true);
                    }
                    while (Game.combatMonsters != null) {
                        Game.combatMonsters.undoAttack();
                    }
                    Game.endMonstersTurn();
                    Canvas.clearEvents();
                    Game.advanceTurn();
                    break;
                }
                case 53: {
                    int n4 = this.getByteArg();
                    int n80 = (n4 & 0xF8) >> 3;
                    if ((n4 &= 7) == 1) {
                        Canvas.startKicking(false);
                        Canvas.kickingDir = n80 << 7;
                        break;
                    }
                    CardGames.initGame(n4, this, true);
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 55: {
                    if (!Canvas.isChickenKicking) break;
                    Canvas.endKickingRound();
                    break;
                }
                case 54: {
                    if (!Canvas.isChickenKicking) break;
                    Canvas.endKickingGame();
                    if (Canvas.kickingFromMenu) {
                        Canvas.backToMain(false);
                        MenuSystem.setMenu(24);
                        return 1;
                    }
                    Player.selectPrevWeapon();
                    break;
                }
                case 56: {
                    int n81 = this.getUShortArg();
                    int n4 = n81 >> 12 & 0xF;
                    n81 &= 0xFFF;
                    if (n4 == 0) {
                        if ((Player.weapons & 2L) != 0L) {
                            n4 = 1;
                        } else if ((Player.weapons & 4L) != 0L) {
                            n4 = 2;
                        }
                    }
                    if (Render.mapSprites[Render.S_ENT + n81] != -1) {
                        Entity entity = Game.entities[Render.mapSprites[Render.S_ENT + n81]];
                        Player.ce.weapon = n4;
                        Combat.performAttack(null, entity, 0, 0, true);
                    }
                    n = this.evWait(1);
                    break;
                }
                case 57: {
                    Render.buildFogTables(this.getIntArg());
                    break;
                }
                case 58: {
                    int n4 = this.getIntArg();
                    Render.startFogLerp(n4 & 0x7FF, n4 >> 11 & 0x7FF, (n4 >> 22 & 0xFF) * 100);
                    break;
                }
                case 60: {
                    Player.disabledWeapons = this.getShortArg();
                    if ((Player.disabledWeapons & 1L << Player.ce.weapon) == 0L) break;
                    Player.selectNextWeapon();
                    break;
                }
                case 61: {
                    int n4 = this.getUShortArg();
                    int n82 = this.getUShortArg();
                    short s = this.getUByteArg();
                    LerpSprite lerpSprite = Game.allocLerpSprite(this, n4, false);
                    if (lerpSprite == null) {
                        return 0;
                    }
                    lerpSprite.srcX = lerpSprite.dstX = Render.mapSprites[Render.S_X + n4];
                    lerpSprite.srcY = lerpSprite.dstY = Render.mapSprites[Render.S_Y + n4];
                    lerpSprite.srcZ = lerpSprite.dstZ = Render.mapSprites[Render.S_Z + n4];
                    lerpSprite.srcScale = Render.mapSprites[Render.S_SCALEFACTOR + n4];
                    lerpSprite.dstScale = s << 1;
                    short s15 = Render.mapSprites[Render.S_ENT + n4];
                    if (s15 != -1) {
                        Game.entities[s15].info |= 0x400000;
                    }
                    lerpSprite.startTime = App.gameTime;
                    lerpSprite.travelTime = n82;
                    if (n82 == 0) {
                        if ((Game.updateLerpSprite(lerpSprite) & 1) != 0) {
                            Canvas.invalidateRect();
                            break;
                        }
                        n = 0;
                        break;
                    }
                    if ((lerpSprite.flags & 1) != 0) break;
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 62: {
                    Player.giveMedal(this.getByteArg(), this);
                    this.unpauseTime = 0;
                    n = 2;
                    break;
                }
                case 63: {
                    Player.giveBook(this.getByteArg(), this);
                    this.unpauseTime = 0;
                    n = 2;
                    break;
                }
                case 64: {
                    Player.offerBook(this.getByteArg(), this);
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case 65: {
                    int n4 = Game.getMixingIndex(this.getUByteArg());
                    if (n4 != -1 && !Game.mixingStationEmpty(n4)) {
                        Canvas.curStation = n4;
                        Canvas.setState(20);
                        break;
                    }
                    Hud.addMessage((short)1, (short)142, 2);
                    break;
                }
                case 66: {
                    int n4;
                    if (this.debugString == null) {
                        this.debugString = Text.getLargeBuffer();
                    }
                    if ((n4 = (int)this.getByteArg()) == 0) {
                        char c = (char)this.getUByteArg();
                        while (c != '\u0000') {
                            this.debugString.append(c);
                            c = (char)this.getUByteArg();
                        }
                    } else if (n4 == 1) {
                        short s = this.getUByteArg();
                        this.debugString.append(Game.scriptStateVars[s]);
                    }
                    if (this.peekNextCmd() == 66) break;
                    this.debugString.dispose();
                    this.debugString = null;
                    break;
                }
                case 67: {
                    MenuSystem.setMenu(this.getUByteArg());
                    break;
                }
                case 68: {
                    int n4 = this.getUByteArg();
                    boolean bl11 = (n4 & 0x80) != 0;
                    ScriptThread.setupCamera(n4 & 0x7F);
                    Game.activeCamera.cameraThread = this;
                    break;
                }
                case 70: {
                    int n4 = this.getUByteArg();
                    if ((n4 & 0x80) != 0) {
                        Player.removeStatusEffect(n4 & 0x7F);
                        break;
                    }
                    byte by = this.getByteArg();
                    int n83 = 30;
                    if (n4 == 2) {
                        n83 = 20;
                    } else if (n4 == 9) {
                        n83 = 10;
                    } else if (n4 == 1) {
                        n83 = 10;
                    } else if (n4 == 11) {
                        n83 = 6;
                    } else if (n4 == 17) {
                        n83 = 5;
                    }
                    Player.addStatusEffect(n4, by, n83);
                    Player.translateStatusEffects();
                    break;
                }
                case 71: {
                    int n4 = this.getUByteArg();
                    int n84 = this.getUByteArg() & 0x1F;
                    int n85 = this.getUByteArg() & 0x1F;
                    Player.setQuestTile(n4, n84, n85);
                    break;
                }
                case 72: {
                    int n4 = this.getUShortArg();
                    short s = (short)((this.getUByteArg() << 6) + 32);
                    short s16 = (short)((this.getUByteArg() << 6) + 32);
                    Entity entity = Game.entities[Render.mapSprites[Render.S_ENT + n4]];
                    if (entity.monster == null) break;
                    ScriptThread.corpsifyMonster(s, s16, entity);
                    break;
                }
                case 73: {
                    int n4 = this.getByteArg();
                    if (n4 == 0) {
                        ScriptThread.stripInventory();
                        break;
                    }
                    if (n4 != 1) break;
                    ScriptThread.restoreInventory();
                    break;
                }
                case 74: {
                    Player.gameCompleted = true;
                    Canvas.endingGame = true;
                    Canvas.setState(14);
                    break;
                }
                case 75: {
                    int n4 = this.getIntArg();
                    int n86 = this.getUShortArg();
                    int n87 = n4 >> 22 & 0x3FF;
                    int n88 = n4 >> 17 & 0x1F;
                    int n89 = n4 >> 12 & 0x1F;
                    int n90 = (n4 >> 4 & 0xFF) - 48;
                    int n91 = n4 & 0xF;
                    LerpSprite lerpSprite = Game.allocLerpSprite(this, n87, (n91 & 2) != 0);
                    if (lerpSprite == null) {
                        return 0;
                    }
                    lerpSprite.dstX = 32 + (n88 << 6);
                    lerpSprite.dstY = 32 + (n89 << 6);
                    short s = Render.mapSprites[Render.S_ENT + n87];
                    if (s != -1) {
                        Game.entities[s].info |= 0x400000;
                    }
                    lerpSprite.dstZ = Render.getHeight(lerpSprite.dstX, lerpSprite.dstY);
                    lerpSprite.srcX = Render.mapSprites[Render.S_X + n87];
                    lerpSprite.srcY = Render.mapSprites[Render.S_Y + n87];
                    lerpSprite.srcZ = Render.mapSprites[Render.S_Z + n87];
                    lerpSprite.srcScale = lerpSprite.dstScale = Render.mapSprites[Render.S_SCALEFACTOR + n87];
                    lerpSprite.height = n90;
                    lerpSprite.startTime = App.gameTime;
                    lerpSprite.travelTime = n86;
                    lerpSprite.calcDist();
                    lerpSprite.flags = n91 & 3;
                    lerpSprite.flags |= 4;
                    if (n86 == 0) {
                        if ((Game.updateLerpSprite(lerpSprite) & 1) != 0) {
                            Canvas.invalidateRect();
                            break;
                        }
                        n = 0;
                        break;
                    }
                    if ((lerpSprite.flags & 1) != 0) break;
                    Game.skipAdvanceTurn = true;
                    Game.queueAdvanceTurn = false;
                    this.unpauseTime = -1;
                    n = 2;
                    break;
                }
                case -1: {
                    if (this.stackPtr != 0) {
                        App.Error(new Exception("The frame pointer should be zero if the script has completed."), 102);
                    }
                    return 1;
                }
                default: {
                    App.Error(new Exception("Cannot handle event: " + byArray[this.IP]), 2);
                }
            }
            if (bl) {
                Game.scriptStateVars[7] = n2;
            }
            ++this.IP;
        }
        return n;
    }

    public void init() {
        this.stackPtr = 0;
        this.IP = 0;
        this.FP = 0;
        this.unpauseTime = 0;
        this.state = 2;
        this.throwAwayLoot = false;
    }

    public void reset() {
        this.inuse = false;
        this.init();
    }

    public int attemptResume(int n) {
        if (this.stackPtr == 0) {
            return 1;
        }
        if (this.unpauseTime == -1 || n < this.unpauseTime) {
            return 2;
        }
        this.unpauseTime = 0;
        return this.run();
    }

    public int getIndex() {
        for (int i = 0; i < Game.scriptThreads.length; ++i) {
            if (this != Game.scriptThreads[i]) continue;
            return i;
        }
        return -1;
    }

    private int getStackVar(int n) {
        return this.scriptStack[this.stackPtr - n];
    }

    private int pop() {
        return this.scriptStack[--this.stackPtr];
    }

    private void push(boolean bl) {
        if (bl) {
            this.push(1);
        } else {
            this.push(0);
        }
    }

    private void push(int n) {
        this.scriptStack[this.stackPtr++] = n;
    }

    private short getUByteArg() {
        return (short)(Render.mapByteCode[++this.IP] & 0xFF);
    }

    private byte getByteArg() {
        return Render.mapByteCode[++this.IP];
    }

    private int getUShortArg() {
        int n = (Render.mapByteCode[this.IP + 1] & 0xFF) << 8 | Render.mapByteCode[this.IP + 2] & 0xFF;
        this.IP += 2;
        return n;
    }

    private short getShortArg() {
        short s = (short)(Render.mapByteCode[this.IP + 1] << 8 | Render.mapByteCode[this.IP + 2] & 0xFF);
        this.IP += 2;
        return s;
    }

    private int getIntArg() {
        int n = Render.mapByteCode[this.IP + 1] << 24 | (Render.mapByteCode[this.IP + 2] & 0xFF) << 16 | (Render.mapByteCode[this.IP + 3] & 0xFF) << 8 | Render.mapByteCode[this.IP + 4] & 0xFF;
        this.IP += 4;
        return n;
    }

    private void composeLootDialog() {
        Text text = Text.getLargeBuffer();
        if (lootSource != -1) {
            Text.composeTextField(lootSource, text);
            Text.composeText((short)1, (short)145, text);
            lootSource = -1;
        } else {
            Text.composeText((short)1, (short)146, text);
        }
        if (!this.throwAwayLoot) {
            Canvas.showingLoot = true;
            Canvas.setState(8);
        }
        int n = 0;
        int n2 = this.getByteArg();
        block5: for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = this.getUShortArg();
            int n5 = n4 >> 12 & 0xF;
            if (n5 == 8) {
                n3 = n4 & 0xFFF;
                text.append('\u0088');
                Text.composeText(Canvas.loadMapStringID, (short)n3, text);
                text.append("|");
                continue;
            }
            if (n5 == 7) {
                n3 = (short)(n4 & 0xFFF);
                Player.updateQuests((short)n3, 0);
                continue;
            }
            if (n5 == 9) {
                n3 = (short)(n4 & 0xFFF);
                text.append('\u0088');
                Text.composeText((short)1, (short)177, text);
                Text.composeText((short)0, Player.bookMap[n3 * 4], text);
                text.append("|");
                continue;
            }
            n3 = (n4 & 0xFC0) >> 6;
            int n6 = n4 & 0x3F;
            ++n;
            if (this.throwAwayLoot) continue;
            Text.resetTextArgs();
            Text.addTextArg('\u0088');
            switch (n5) {
                case 0: 
                case 4: 
                case 6: {
                    Player.give(n5, n3, n6, false);
                    EntityDef entityDef = EntityDef.find(6, n5, n3);
                    Text.addTextArg(n6);
                    Text.addTextArg((short)2, entityDef.longName);
                    Text.composeText((short)1, (short)92, text);
                    continue block5;
                }
                case 1: {
                    Player.give(1, n3, n6, true);
                    int n7 = n3 * 9;
                    if (Combat.weapons[n7 + 5] != 0) {
                        Player.give(2, Combat.weapons[n7 + 4], 10, true);
                    }
                    EntityDef entityDef = EntityDef.find(6, n5, n3);
                    Text.addTextArg((short)2, entityDef.longName);
                    Text.composeText((short)1, (short)93, text);
                    continue block5;
                }
                case 2: {
                    if (Game.difficulty == 4 && (1 << n3 & 0x112) == 0) continue block5;
                    Player.give(2, n3, n6, false);
                    EntityDef entityDef = EntityDef.find(6, n5, n3);
                    Text.addTextArg(n6);
                    Text.addTextArg((short)2, entityDef.longName);
                    Text.composeText((short)1, (short)92, text);
                }
            }
        }
        if (!this.throwAwayLoot) {
            text.setLength(text.length() - 1);
            Canvas.startDialog(this, text, 4, 0, true);
        } else {
            text.setLength(0);
            Text.resetTextArgs();
            Text.addTextArg(n2);
            Text.composeText((short)1, (short)186, text);
            Hud.addMessage(text, 3);
        }
        text.dispose();
        Game.foundLoot(Canvas.viewX + Canvas.viewStepX, Canvas.viewY + Canvas.viewStepY, Canvas.viewZ, n);
    }

    private static final void setAIGoal(Entity entity, int n, int n2) {
        entity.monster.resetGoal();
        entity.monster.goalType = (byte)n;
        if (n == 2 || n == 3) {
            entity.monster.goalParam = 1;
        } else if (n == 4 || n == 6) {
            entity.monster.goalParam = n2;
        }
        if (!Player.noclip) {
            if ((entity.info & 0x40000) == 0) {
                Game.activate(entity, true, false, false, true);
            }
            entity.aiThink(true);
        }
        if (n == 3) {
            entity.monster.goalFlags = (byte)(entity.monster.goalFlags & 0xFFFFFFF7);
            if (Game.combatMonsters != null) {
                Combat.performAttack(Game.combatMonsters, Game.combatMonsters.monster.target, 0, 0, false);
            }
        }
    }

    private static final void corpsifyMonster(int n, int n2, Entity entity) {
        int n3 = entity.getSprite();
        Game.snapLerpSprites(n3);
        entity.monster.resetGoal();
        entity.monster.clearEffects();
        entity.undoAttack();
        Game.deactivate(entity);
        Render.mapSpriteInfo[n3] = Render.mapSpriteInfo[n3] & 0xFFFE00FF | 0x7000;
        Render.mapSprites[Render.S_X + n3] = (short)n;
        Render.mapSprites[Render.S_Y + n3] = (short)n2;
        Render.mapSprites[Render.S_Z + n3] = (short)(Render.getHeight(n, n2) + 32);
        Render.relinkSprite(n3);
        entity.info = entity.info & 0xFFFF | 0x1000000 | 0x20000 | 0x400000;
        entity.def = EntityDef.find(9, entity.def.eSubType, entity.def.parm);
        Game.unlinkEntity(entity);
        Game.linkEntity(entity, n >> 6, n2 >> 6);
        entity.checkMonsterDeath(false);
    }

    private static final void stripInventory() {
        int n;
        Player.selectWeapon(0);
        System.arraycopy(Player.inventory, 0, Player.inventoryCopy, 0, Player.inventory.length);
        System.arraycopy(Player.ammo, 0, Player.ammoCopy, 0, Player.ammo.length);
        Player.weaponsCopy = (int)(Player.weapons & 0xFFFFFFFFFFFFFFFFL);
        for (n = 0; n < 29; ++n) {
            Player.inventory[n] = 0;
        }
        for (n = 0; n < 10; ++n) {
            Player.ammo[n] = 0;
        }
        Player.weapons = 9L;
    }

    private static final void restoreInventory() {
        int n;
        for (n = 0; n < 29; ++n) {
            Player.give(0, n, Player.inventoryCopy[n], true);
        }
        for (n = 0; n < 10; ++n) {
            Player.give(2, n, Player.ammoCopy[n], true);
        }
        for (n = 1; n < 17; ++n) {
            int n2 = 1 << n;
            if ((n2 & Player.weaponsCopy) == 0) continue;
            Player.give(1, n, 1, true);
        }
    }
}

