/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

class Player {
    static final int HIT_DELAY = 5;
    static final int PMODE_IDLE = 0;
    static final int PMODE_SHOOTING = 1;
    static final int PMODE_HAPPY = 2;
    boolean playerMovingLeft;
    boolean playerMovingRight;
    boolean playerMovingUp;
    boolean playerMovingDown;
    boolean playerPressingAttack;
    int playerXPx;
    int playerYPx;
    int playerAngle;
    int playerMode;
    int playerFrame;
    int playerPointer;
    int playerPointerDelay;
    int playerBounces;
    int perlBaseXPx;
    int perlBaseYPx;
    int perlX;
    int perlXPx;
    int perlY;
    int perlYPx;
    int perlAngle;
    int perlSpd;
    int perlSpdX;
    int perlSpdY;
    int perlType;
    int iScore;
    int iTargetLeft;
    int iTargetRight;

    Player() {
    }

    void reset() {
        Debug.trace("Player.reset() - in");
        this.initPlayerPos();
        this.playerMode = 0;
        this.playerFrame = 0;
        this.playerAngle = 90;
        this.playerPointer = 8;
        this.perlType = -1979;
        this.iScore = 0;
        this.iTargetLeft = WholeGame.level.perls.iLeft + Resources.sprPerlsWidth / 2;
        this.iTargetRight = WholeGame.level.perls.iRight - Resources.sprPerlsWidth / 2;
        this.playerPointerDelay = 3000;
        Debug.trace("Player.reset() - out");
    }

    void initPlayerPos() {
        this.playerXPx = 84;
        this.playerYPx = 175;
        int pdspx = 2;
        int pdspy = 4;
        this.perlBaseXPx = this.playerXPx - pdspx;
        this.perlBaseYPx = this.playerYPx + pdspy;
    }

    void initPerl(int nextPerlType) {
        this.perlXPx = this.perlBaseXPx;
        this.perlX = this.perlXPx << 4;
        this.perlYPx = this.perlBaseYPx;
        this.perlY = this.perlYPx << 4;
        this.perlSpdX = 0;
        this.perlSpdY = 0;
        this.perlSpd = 0;
        this.perlType = nextPerlType;
    }

    void save(DataOutputStream data) {
        try {
            data.writeInt(this.playerXPx);
            data.writeInt(this.playerYPx);
            data.writeInt(this.playerAngle);
            data.writeInt(this.playerMode);
            data.writeInt(this.playerFrame);
            data.writeInt(this.playerPointer);
            data.writeInt(this.playerPointerDelay);
            data.writeInt(this.playerBounces);
            data.writeInt(this.perlX);
            data.writeInt(this.perlXPx);
            data.writeInt(this.perlY);
            data.writeInt(this.perlYPx);
            data.writeInt(this.perlAngle);
            data.writeInt(this.perlSpd);
            data.writeInt(this.perlSpdX);
            data.writeInt(this.perlSpdY);
            data.writeInt(this.perlType);
            data.writeInt(this.iScore);
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
        }
    }

    void load(DataInputStream data) {
        try {
            this.playerXPx = data.readInt();
            this.playerYPx = data.readInt();
            this.playerAngle = data.readInt();
            this.playerMode = data.readInt();
            this.playerFrame = data.readInt();
            this.playerPointer = data.readInt();
            this.playerPointerDelay = data.readInt();
            this.playerBounces = data.readInt();
            this.perlX = data.readInt();
            this.perlXPx = data.readInt();
            this.perlY = data.readInt();
            this.perlYPx = data.readInt();
            this.perlAngle = data.readInt();
            this.perlSpd = data.readInt();
            this.perlSpdX = data.readInt();
            this.perlSpdY = data.readInt();
            this.perlType = data.readInt();
            this.iScore = data.readInt();
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
        }
    }

    void incScore(int inc) {
        this.iScore += inc;
        if (this.iScore < 0) {
            this.iScore = 0;
        }
        WholeGame.level.bRefreshStatusScore = true;
    }

    void updatePerlMovement() {
        block16: {
            block15: {
                if (this.perlType == -1979) {
                    if (WholeGame.level.perls.bNextPerlReady) {
                        WholeGame.level.nextPerl();
                    }
                    return;
                }
                if (this.perlSpd == 0) {
                    return;
                }
                this.perlX += this.perlSpdX;
                this.perlY += this.perlSpdY;
                this.perlXPx = this.perlX >> 4;
                this.perlYPx = this.perlY >> 4;
                int sprW2 = Resources.sprPerlsWidth / 2;
                if (this.perlXPx - sprW2 <= WholeGame.level.perls.iLeft) {
                    if (this.perlType != 15) {
                        ++this.playerBounces;
                    }
                    X.canvas.createScoreLabelMul(this.perlXPx, this.perlYPx, this.playerBounces + 1);
                    this.perlSpdX = -this.perlSpdX;
                    this.perlXPx = WholeGame.level.perls.iLeft + sprW2;
                    this.perlX = this.perlXPx << 4;
                    WholeGame.particles.createExplosion(this.perlXPx - sprW2, this.perlYPx, Resources.sprStars);
                    WholeGame.sounds.playSound_Bounce();
                    return;
                }
                if (this.perlXPx + sprW2 >= WholeGame.level.perls.iRight) {
                    ++this.playerBounces;
                    X.canvas.createScoreLabelMul(this.perlXPx, this.perlYPx, this.playerBounces + 1);
                    this.perlSpdX = -this.perlSpdX;
                    this.perlXPx = WholeGame.level.perls.iRight - sprW2;
                    this.perlX = this.perlXPx << 4;
                    WholeGame.particles.createExplosion(this.perlXPx + sprW2, this.perlYPx, Resources.sprStars);
                    WholeGame.sounds.playSound_Bounce();
                    return;
                }
                if (this.perlYPx + sprW2 < 0) {
                    if (this.perlType != 15) {
                        this.incScore(-2);
                        X.canvas.createScoreLabel(this.perlXPx, 3 * Resources.sprPerlsWidth, -2);
                        WholeGame.sounds.playSound(1, 9, 10);
                        Level.figState[WholeGame.level.idx_octopus] = 2;
                        GameDef.figStateTimer[WholeGame.level.idx_octopus] = 300;
                    }
                    this.perlType = -1979;
                    WholeGame.level.nextPerl();
                    return;
                }
                if (this.perlYPx + sprW2 > WholeGame.level.perls.getBottom() && this.perlSpdY > 0) {
                    WholeGame.particles.createBubbles(this.perlXPx, this.perlYPx);
                    this.perlType = -1979;
                    WholeGame.level.nextPerl();
                    return;
                }
                if (WholeGame.level.testFigureHit(this.perlXPx, this.perlYPx) != -1) {
                    this.perlType = -1979;
                    WholeGame.level.nextPerl();
                }
                if (WholeGame.level.iLevelNum <= 22) break block15;
                if (WholeGame.level.iLevelNum < 25) break block16;
            }
            if (WholeGame.level.perls.testPerl(this.perlX, this.perlY, this.perlSpdX / 6, this.perlSpdY / 6, this.perlType)) {
                this.perlType = -1979;
                this.perlSpd = 0;
                return;
            }
        }
        if (WholeGame.level.perls.testPerl(this.perlX, this.perlY, this.perlSpdX * 2 / 6, this.perlSpdY * 2 / 6, this.perlType)) {
            this.perlType = -1979;
            this.perlSpd = 0;
        }
    }

    void resetPlayerActions() {
        this.playerMovingLeft = false;
        this.playerMovingRight = false;
        this.playerMovingUp = false;
        this.playerMovingDown = false;
        this.playerPressingAttack = false;
        WholeGame.invalidateKeys();
    }

    void update() {
        this.playerMovingLeft = (WholeGame.keyStates & 4) != 0;
        this.playerMovingRight = (WholeGame.keyStates & 0x20) != 0;
        this.playerMovingUp = (WholeGame.keyStates & 2) != 0;
        this.playerMovingDown = (WholeGame.keyStates & 0x40) != 0;
        boolean bl = this.playerPressingAttack = (WholeGame.keyStates & 0x100) != 0;
        if (this.playerMovingRight && this.playerAngle < 170) {
            this.playerAngle += 2;
        }
        if (this.playerMovingLeft && this.playerAngle > 10) {
            this.playerAngle -= 2;
        }
        if (this.playerPressingAttack && this.perlType != -1979 && this.perlSpd == 0) {
            this.playerMode = 1;
        }
        if (this.playerPointer > 10) {
            if (this.playerPointerDelay > 0) {
                this.playerPointerDelay -= 30;
            } else {
                this.playerPointerDelay = 3000;
                --this.playerPointer;
            }
        }
        this.updatePerlMovement();
    }

    void drawCircle(Graphics g, int cx, int cy, int size) {
        g.fillArc(cx - size / 2, cy - size / 2, size, size, 0, 360);
    }

    int getMaxPlayerFrames() {
        if (this.playerMode == 1) {
            return 14;
        }
        return 9;
    }

    int getRealPerlYPos() {
        int sprW2 = Resources.sprPerlsWidth / 2;
        int ypos = this.perlBaseYPx - sprW2;
        if (this.playerMode == 1) {
            switch (this.playerFrame / 3) {
                case 2: 
                case 4: {
                    ++ypos;
                    break;
                }
                case 3: {
                    ypos += 4;
                }
            }
        }
        return ypos;
    }

    void paintPlayerCharacter(Graphics g) {
        Sprite spr = Resources.sprSas1;
        if (this.playerMode == 1) {
            spr.setFrame(this.playerFrame / 3);
        } else {
            spr.setFrame(this.playerFrame / 5);
        }
        spr.setPosition(this.playerXPx - spr.getWidth() / 2, this.playerYPx);
        spr.paint(g);
    }

    void paintTargeting(Graphics g) {
        int sprW2 = Resources.sprPerlsWidth / 2;
        int WminW2 = Defines.WIDTH - sprW2;
        int dspx = Resources.sprPointerWidth / 2;
        Sprite spr = Resources.sprPointer;
        int idx = WholeGame.level.perls.getPerlVal(this.perlType);
        if (idx < 0 || idx > 6) {
            idx = 7;
        }
        spr.setFrame(idx);
        int py = this.perlBaseYPx;
        for (int i = 0; i < this.playerPointer && py > 0; ++i) {
            int px = this.perlBaseXPx - (Common.COS(this.playerAngle) * ((i + 1) * 7) >> 8);
            py = this.perlBaseYPx - (Common.SIN(this.playerAngle) * ((i + 1) * 7) >> 8);
            if (px < this.iTargetLeft) {
                px = this.iTargetLeft - (px - this.iTargetLeft);
            }
            if (px > this.iTargetRight) {
                px = this.iTargetRight - (px - this.iTargetRight);
            }
            if (px < this.iTargetLeft) {
                px = this.iTargetLeft - (px - this.iTargetLeft);
            }
            if (px > this.iTargetRight) {
                px = this.iTargetRight - (px - this.iTargetRight);
            }
            if (px < this.iTargetLeft) {
                py = -100;
            }
            spr.setPosition(px - dspx, py - dspx);
            spr.paint(g);
        }
    }

    void paintPerl(Graphics g) {
        int realPerlYPos = this.getRealPerlYPos();
        if (this.playerFrame < this.getMaxPlayerFrames()) {
            ++this.playerFrame;
        } else {
            if (this.playerMode == 1) {
                System.out.println("shoting");
                this.playerMode = 0;
                this.perlYPx = this.perlBaseYPx;
                this.perlY = this.perlYPx << 4;
                this.perlSpd = 2;
                this.perlAngle = this.playerAngle;
                this.perlSpdX = -Common.COS(this.perlAngle) / 2;
                this.perlSpdY = -Common.SIN(this.perlAngle) / 2;
            }
            this.playerFrame = 0;
        }
        if (this.perlType != -1979) {
            int sprW2 = Resources.sprPerlsWidth / 2;
            int ypos = this.perlYPx - sprW2;
            if (this.playerMode == 1) {
                ypos = realPerlYPos;
            }
            int v = WholeGame.level.perls.getPerlVal(this.perlType);
            boolean bPointer = this.perlType >= 600 && this.perlType < 700;
            boolean bBomb = this.perlType >= 700 && this.perlType < 800;
            boolean bStop = this.perlType >= 800 && this.perlType < 900;
            Sprite spr = Resources.sprPerls;
            spr.setFrame(v);
            spr.setPosition(this.perlXPx - sprW2, ypos);
            spr.paint(g);
            if (bPointer) {
                Sprite sprP = Resources.sprPtr;
                sprP.setPosition(this.perlXPx - sprW2, ypos);
                sprP.setFrame(Math.abs((int)(WholeGame.lRunCounter % 12L) / 4));
                sprP.paint(g);
            }
            if (bBomb) {
                spr.setFrame(14);
                spr.paint(g);
            }
            if (bStop) {
                spr.setFrame(12);
                spr.paint(g);
            }
            if (this.perlType == 15) {
                WholeGame.particles.createBubbles(this.perlXPx, this.perlYPx);
            }
        }
    }

    void paint(Graphics g) {
        this.paintTargeting(g);
        this.paintPlayerCharacter(g);
    }
}

