/*
 * Decompiled with CFR 0.152.
 */
public final class NoteEvent {
    public static final int SINGLE_PRESS_MAX = 150;
    public static final int[] color = new int[]{65280, 0xFF0000, 0xFFFF00, 255, 60152};
    public static Sprite[] sprStarPower = null;
    public static final byte TYPE_NOTE = 0;
    public static final byte TYPE_STAR_POWER = 1;
    public final int time;
    public int time_with_slack_start = 0;
    public int time_with_slack_end = 0;
    public final int len;
    private int bptype_type_chords;
    private int index_and_chords;
    public static final int NOTE_KEY_TYPE_NONE = -1;
    public static final int NOTE_KEY_TYPE_STRING_LEFT = 0;
    public static final int NOTE_KEY_TYPE_STRING_MIDDLE = 1;
    public static final int NOTE_KEY_TYPE_STRING_RIGHT = 2;
    public static final int NOTE_KEY_TYPE_KICK = 3;
    public static final int NUM_NOTE_KEY_TYPE = 4;

    public int getType() {
        return (this.bptype_type_chords & 0xFF0000) >>> 16;
    }

    public void setType(int type) {
        this.bptype_type_chords &= 0xFF00FFFF;
        this.bptype_type_chords |= type << 16;
    }

    public int getBattlePowerType() {
        return (this.bptype_type_chords & 0xFF000000) >> 24;
    }

    public void setBattlePowerType(int battlePowerType) {
        this.bptype_type_chords &= 0xFFFFFF;
        this.bptype_type_chords |= battlePowerType << 24;
    }

    private int getChordMaster() {
        return this.index_and_chords & 0xFF;
    }

    private void setChordMaster(int b) {
        this.index_and_chords &= 0xFFFFFF00;
        this.index_and_chords |= b << 0;
    }

    private int getChordAccum() {
        return this.bptype_type_chords & 0xFF;
    }

    private void setChordAccum(int b) {
        this.bptype_type_chords &= 0xFFFFFF00;
        this.bptype_type_chords |= b << 0;
    }

    private int getChordCurrent() {
        return this.bptype_type_chords >> 8 & 0xFF;
    }

    private void setChordCurrent(int b) {
        this.bptype_type_chords &= 0xFFFF00FF;
        this.bptype_type_chords |= b << 8;
    }

    public int getIndex() {
        return this.index_and_chords >>> 8;
    }

    private void setIndex(int index) {
        this.index_and_chords &= 0xFF;
        this.index_and_chords |= index << 8;
    }

    public boolean hasSustain() {
        return this.len > 150;
    }

    public NoteEvent(int index, int time, byte type, int noteDuration_a, int noteDuration_b, int noteDuration_c, int noteDuration_d) {
        this.setType(0);
        this.setBattlePowerType(-1);
        boolean verbose = false;
        this.setIndex(index);
        this.setType(type);
        this.time = time;
        int ab = noteDuration_a > noteDuration_b ? noteDuration_a : noteDuration_b;
        int cd = noteDuration_c > noteDuration_d ? noteDuration_c : noteDuration_d;
        this.len = ab > cd ? ab : cd;
        int p = 0;
        if (noteDuration_a > 0) {
            p |= 1;
        }
        if (noteDuration_b > 0) {
            p |= 2;
        }
        if (noteDuration_c > 0) {
            p |= 4;
        }
        if (noteDuration_d > 0) {
            p |= 8;
        }
        this.setChordMaster(p & 0xFF);
    }

    public int getNumNotesForScoringPurposes() {
        int chordMaster = this.getChordMaster();
        return (chordMaster >>> 0 & 1) + (chordMaster >>> 1 & 1) + (chordMaster >>> 2 & 1) + (chordMaster >>> 3 & 1);
    }

    public boolean isNoteKeyTypeActive(int noteKeyType) {
        int chordMaster = this.getChordMaster();
        if (!OptionsViscount.JAD_DPS_KEYPRESS_SUPPORT_DOUBLE) {
            for (int i = 0; i < noteKeyType; ++i) {
                if (0 == (chordMaster >>> i & 1)) continue;
                return false;
            }
        }
        return 0 != (chordMaster >>> noteKeyType & 1);
    }

    public void setNoteKeyTypeUpOrDown(int noteKeyType, boolean pressed) {
        if (-1 == noteKeyType) {
            return;
        }
        if (pressed) {
            this.setChordAccum(this.getChordAccum() | 1 << noteKeyType);
            this.setChordCurrent(this.getChordCurrent() | 1 << noteKeyType);
        } else {
            this.setChordCurrent(this.getChordCurrent() & ~(1 << noteKeyType));
        }
    }

    public boolean hasBeenHit() {
        int chordMaster = this.getChordMaster();
        int chordAccum = this.getChordAccum();
        if (!OptionsViscount.JAD_DPS_KEYPRESS_SUPPORT_DOUBLE) {
            return 0 != (chordMaster & chordAccum);
        }
        return chordMaster == (chordMaster & chordAccum);
    }

    public boolean isSustained() {
        if (!this.hasBeenHit()) {
            return false;
        }
        int chordMaster = this.getChordMaster();
        int chordCurrent = this.getChordCurrent();
        if (!OptionsViscount.JAD_DPS_KEYPRESS_SUPPORT_DOUBLE) {
            return 0 != (chordMaster & chordCurrent);
        }
        return this.hasBeenHit() && chordMaster == chordCurrent;
    }
}

