/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class GameProgress {
    public String mpRankName = "";
    public long mpTotalBattlePoints = 0L;
    public int mpPercentWinGuitar = 0;
    public int mpPercentWinDrums = 0;
    public static boolean bStatsChanged = false;
    private static final int TROPHY_IDX_COMPLETE_5_SONGS = 0;
    private static final int TROPHY_IDX_FIRST_VENUE_DONE = 1;
    private static final int TROPHY_IDX_SECOND_VENUE_DONE = 2;
    private static final int TROPHY_IDX_THIRD_VENUE_DONE = 3;
    private static final int TROPHY_IDX_DRUMS_DONE = 4;
    private static final int TROPHY_IDX_GUITAR_DONE = 5;
    private static final int TROPHY_IDX_5_FIVE_STAR_SONGS = 6;
    private static final int TROPHY_IDX_10_FIVE_STAR_SONGS = 7;
    private static final int TROPHY_IDX_15_FIVE_STAR_SONGS = 8;
    private static final int TROPHY_IDX_HIT_300_NOTES = 9;
    private static final int TROPHY_IDX_GOT_150K_POINTS = 10;
    private static final int TROPHY_IDX_LEGEND_RANK = 11;
    public static final int NUM_TROPHIES = 12;
    public static final int NUM_TROPHIES_AVAILABLE = 8;
    private boolean[] trophies = new boolean[8];
    public int mostRecentTrophiesAttained = 0;
    private final Hashtable starsAndScores = new Hashtable();
    private long totalHighScore = 0L;
    private long careerHighScore = 0L;
    private static final int MIN_SCORE_TO_PASS_SONG = 1;
    private static final int MIN_STARS_TO_PASS_SONG = 3;
    private static final int MAX_STARS = 5;
    private static final int COMPLETE_SONGS_NEEDED = 5;
    private static final int CONSECUTIVE_NOTES_NEEDED = 300;
    private static final int SONG_POINTS_NEEDED = 150000;
    private static final int BPS_NEEDED_FOR_LEGENDARY = 200;

    private String getRmsKey(BSongData songData) {
        if (null == songData) {
            return null;
        }
        return songData.resID_or_jciID;
    }

    private int getIndex(int difficultyLevel, int gameplayMode) {
        return 3 * gameplayMode + difficultyLevel;
    }

    public int getStars(BSongData songData, int difficultyLevel, int gameplayMode) {
        String songKey = this.getRmsKey(songData);
        if (songKey == null) {
            return 0;
        }
        int[] starsAndScoresValue = (int[])this.starsAndScores.get(songKey);
        if (starsAndScoresValue == null) {
            return 0;
        }
        return this.getStars(starsAndScoresValue, difficultyLevel, gameplayMode);
    }

    private int getStars(int[] starsAndScoresValue, int difficultyLevel, int gameplayMode) {
        int index = this.getIndex(difficultyLevel, gameplayMode);
        return starsAndScoresValue[index] >>> 28 & 0xF;
    }

    private void setStars(int[] starsAndScoresValue, int difficultyLevel, int gameplayMode, int stars) {
        int index;
        int n = index = this.getIndex(difficultyLevel, gameplayMode);
        starsAndScoresValue[n] = starsAndScoresValue[n] & 0xFFFFFFF;
        int n2 = index;
        starsAndScoresValue[n2] = starsAndScoresValue[n2] | 0xF0000000 & stars << 28;
    }

    private int getScore(int[] starsAndScoresValue, int difficultyLevel, int gameplayMode) {
        int index = this.getIndex(difficultyLevel, gameplayMode);
        return starsAndScoresValue[index] >>> 0 & 0xFFFFFFF;
    }

    private void setScore(int[] starsAndScoresValue, int difficultyLevel, int gameplayMode, int score) {
        int index;
        int n = index = this.getIndex(difficultyLevel, gameplayMode);
        starsAndScoresValue[n] = starsAndScoresValue[n] & 0xF0000000;
        int n2 = index;
        starsAndScoresValue[n2] = starsAndScoresValue[n2] | 0xFFFFFFF & score << 0;
    }

    public void documentExistanceOfSong(BSongData songData) {
        String songKey = this.getRmsKey(songData);
        if (null == this.starsAndScores.get(songKey)) {
            int[] starsAndScoresValue = new int[6];
            this.starsAndScores.put(songKey, starsAndScoresValue);
        }
    }

    public void update(BSongInfo songInfo, BSongData songData, int score, int stars, int numNoteStreak, int venueID, int difficultyLevel, int gameplayMode) {
        int prevStars;
        int deltaHighScore;
        boolean verbose = false;
        bStatsChanged = true;
        this.mostRecentTrophiesAttained = 0;
        if (stars < 3) {
            return;
        }
        if (score < 1) {
            return;
        }
        if (null == songData) {
            return;
        }
        String songKey = this.getRmsKey(songData);
        if (null == songKey) {
            return;
        }
        this.documentExistanceOfSong(songData);
        int[] starsAndScoresValue = (int[])this.starsAndScores.get(songKey);
        int prevScore = this.getScore(starsAndScoresValue, difficultyLevel, gameplayMode);
        if (prevScore < score) {
            this.setScore(starsAndScoresValue, difficultyLevel, gameplayMode, score);
            deltaHighScore = score - prevScore;
        } else {
            deltaHighScore = 0;
        }
        this.totalHighScore += (long)deltaHighScore;
        if (songInfo.isMainstream(venueID)) {
            this.careerHighScore += (long)deltaHighScore;
        }
        if ((prevStars = this.getStars(starsAndScoresValue, difficultyLevel, gameplayMode)) < stars) {
            this.setStars(starsAndScoresValue, difficultyLevel, gameplayMode, stars);
        }
        if (!songInfo.isMainstream(venueID)) {
            return;
        }
        if (score > 150000) {
            this.achieveTrophy(10);
        }
        if (numNoteStreak > 300) {
            this.achieveTrophy(9);
        }
        int gCount = 0;
        int dCount = 0;
        int numSongsCompleted = 0;
        Enumeration en = this.starsAndScores.keys();
        while (en.hasMoreElements()) {
            String sk = (String)en.nextElement();
            int[] sns = (int[])this.starsAndScores.get(sk);
            if (null == sns) continue;
            boolean completed = false;
            for (int dl = 0; dl < 3; ++dl) {
                for (int gm = 0; gm < 2; ++gm) {
                    int highScore = this.getScore(sns, dl, gm);
                    if (highScore <= 0) continue;
                    completed = true;
                    break;
                }
                if (completed) break;
            }
            if (!completed) continue;
            ++numSongsCompleted;
        }
        int numFiveStarSongs = 0;
        int totalNumSongs = 0;
        int numVenues = songInfo.getNumVenues();
        block8: for (int v = 0; v < numVenues; ++v) {
            if (!songInfo.isMainstream(v)) continue;
            int numSongs = songInfo.getNumSongs(v);
            int numExpert = 0;
            totalNumSongs += numSongs;
            for (int s = 0; s < numSongs; ++s) {
                int[] sns;
                String key;
                BSongData data = songInfo.getSong(v, s);
                if (null == data || null == (key = this.getRmsKey(data)) || null == (sns = (int[])this.starsAndScores.get(key))) continue;
                boolean sawG = false;
                boolean sawD = false;
                boolean saw5 = false;
                for (int dl = 0; dl < 3; ++dl) {
                    boolean sawE = false;
                    for (int gm = 0; gm < 2; ++gm) {
                        int highScore = this.getScore(sns, dl, gm);
                        int highStars = this.getStars(sns, dl, gm);
                        if (highScore < 1) continue;
                        if (0 == gm) {
                            sawG = true;
                        } else {
                            sawD = true;
                        }
                        if (dl != 2 && (!OptionsViscount.JAD_DPS_HANDSET_CAPABILITY_SLOW || dl != 1)) continue;
                        sawE = true;
                        if (highStars < 5) continue;
                        saw5 = true;
                    }
                    if (!sawE) continue;
                    ++numExpert;
                }
                if (sawG) {
                    ++gCount;
                }
                if (sawD) {
                    ++dCount;
                }
                if (!saw5) continue;
                ++numFiveStarSongs;
            }
            if (numExpert < numSongs) continue;
            switch (v) {
                case 0: {
                    this.achieveTrophy(1);
                    continue block8;
                }
                case 1: {
                    this.achieveTrophy(2);
                    continue block8;
                }
                case 2: {
                    this.achieveTrophy(3);
                }
            }
        }
        if (numSongsCompleted >= 5) {
            this.achieveTrophy(0);
        }
        if (dCount >= totalNumSongs) {
            this.achieveTrophy(4);
        }
        if (gCount >= totalNumSongs) {
            this.achieveTrophy(5);
        }
        if (numFiveStarSongs >= 5) {
            this.achieveTrophy(6);
        }
        if (numFiveStarSongs >= 10) {
            this.achieveTrophy(7);
        }
        if (numFiveStarSongs >= 15) {
            this.achieveTrophy(8);
        }
    }

    public void updateMpStats(String rankName, long totalBattlePoints, int percentWinGuitar, int percentWinDrums) {
        boolean verbose = false;
        bStatsChanged = true;
        long oldTotalBattlePoints = this.mpTotalBattlePoints;
        this.mpRankName = rankName;
        this.mpTotalBattlePoints = totalBattlePoints;
        this.mpPercentWinGuitar = percentWinGuitar;
        this.mpPercentWinDrums = percentWinDrums;
        this.mostRecentTrophiesAttained = 0;
        if (this.mpTotalBattlePoints >= 200L && oldTotalBattlePoints != totalBattlePoints) {
            this.achieveTrophy(11);
        }
    }

    private void achieveTrophy(int trophyIndex) {
        if (trophyIndex >= 0 && trophyIndex < 8) {
            if (!this.trophies[trophyIndex]) {
                this.mostRecentTrophiesAttained += 1 << trophyIndex;
            }
            this.trophies[trophyIndex] = true;
        }
    }

    public boolean getTrophyAchieved(int trophyID) {
        if (trophyID >= 0 && trophyID < 8) {
            return this.trophies[trophyID];
        }
        return false;
    }

    public int getHighScore(BSongData songData, int difficultyLevel, int gameplayMode) {
        boolean verbose = false;
        if (null == songData) {
            return 0;
        }
        if (gameplayMode < 0 || gameplayMode >= 2) {
            return 0;
        }
        if (difficultyLevel < 0 || difficultyLevel >= 3) {
            return 0;
        }
        String songKey = this.getRmsKey(songData);
        if (null == songKey) {
            return 0;
        }
        int[] starsAndScoresValue = (int[])this.starsAndScores.get(songKey);
        if (null == starsAndScoresValue) {
            return 0;
        }
        int score = this.getScore(starsAndScoresValue, difficultyLevel, gameplayMode);
        return score;
    }

    public long getTotalHighScore() {
        return this.totalHighScore;
    }

    public long getCareerHighScore() {
        return this.careerHighScore;
    }

    public void setCareerHighScore(long updatedScore) {
        this.careerHighScore = updatedScore;
    }

    public boolean isVenueUnlocked(BSongInfo songInfo, int difficultyLevel, int venueID) {
        boolean verbose = false;
        if (OptionsViscount.DISABLE_SONG_AND_VENUE_LOCKING) {
            return true;
        }
        if (venueID <= 0) {
            return true;
        }
        if (!songInfo.isMainstream(venueID)) {
            return true;
        }
        int prevVenueID = venueID - 1;
        int numSongsInVenue = songInfo.getNumSongs(prevVenueID);
        for (int i = 0; i < numSongsInVenue; ++i) {
            BSongData songData = songInfo.getSong(prevVenueID, i);
            boolean playedOnAnyInstrument = false;
            for (int gm = 0; gm < 2; ++gm) {
                int score = this.getHighScore(songData, difficultyLevel, gm);
                if (score <= 1) continue;
                playedOnAnyInstrument = true;
            }
            if (playedOnAnyInstrument) continue;
            return false;
        }
        return true;
    }

    public boolean areEncoresUnlockedInVenue(BSongInfo songInfo, int difficultyLevel, int venueID) {
        boolean verbose = false;
        if (OptionsViscount.DISABLE_SONG_AND_VENUE_LOCKING) {
            return true;
        }
        if (!songInfo.isMainstream(venueID)) {
            return true;
        }
        int numSongsInVenue = songInfo.getNumSongs(venueID);
        for (int i = 0; i < numSongsInVenue; ++i) {
            BSongData songData = songInfo.getSong(venueID, i);
            if (songData.isEncore) continue;
            boolean playedOnAnyInstrument = false;
            for (int gm = 0; gm < 2; ++gm) {
                int score = this.getHighScore(songData, difficultyLevel, gm);
                if (score <= 1) continue;
                playedOnAnyInstrument = true;
            }
            if (playedOnAnyInstrument) continue;
            return false;
        }
        return true;
    }

    public void save(DataOutputStream dos, boolean is_WORK_PLAYERSTATS) throws IOException {
        boolean verbose = false;
        bStatsChanged = false;
        if (!is_WORK_PLAYERSTATS) {
            dos.writeUTF(this.mpRankName);
            dos.writeLong(this.mpTotalBattlePoints);
            dos.writeInt(this.mpPercentWinGuitar);
            dos.writeInt(this.mpPercentWinDrums);
            dos.writeLong(this.totalHighScore);
        }
        dos.writeLong(this.careerHighScore);
        dos.writeByte(8);
        for (int i = 0; i < 8; ++i) {
            boolean status = this.getTrophyAchieved(i);
            dos.writeByte(status ? 1 : 0);
        }
        byte numSongInfo = (byte)this.starsAndScores.size();
        dos.writeByte(numSongInfo);
        Enumeration en = this.starsAndScores.keys();
        while (en.hasMoreElements()) {
            Object sk = en.nextElement();
            String songKey = (String)sk;
            int[] starsAndScoresValue = (int[])this.starsAndScores.get(songKey);
            dos.writeUTF(songKey);
            dos.writeByte(3);
            for (int dl = 0; dl < 3; ++dl) {
                int diff = dl;
                dos.writeByte(diff);
                for (int gpm = 0; gpm < 2; ++gpm) {
                    if (is_WORK_PLAYERSTATS) {
                        int highScore = this.getScore(starsAndScoresValue, diff, gpm);
                        dos.writeLong(highScore);
                        continue;
                    }
                    int index = this.getIndex(diff, gpm);
                    dos.writeInt(starsAndScoresValue[index]);
                }
            }
        }
    }

    public void load(DataInputStream dis, boolean is_WORK_PLAYERSTATS) throws IOException {
        boolean verbose = false;
        bStatsChanged = false;
        for (int i = 0; i < 8; ++i) {
            this.trophies[i] = false;
        }
        this.starsAndScores.clear();
        if (!is_WORK_PLAYERSTATS) {
            this.mpRankName = dis.readUTF();
            this.mpTotalBattlePoints = dis.readLong();
            this.mpPercentWinGuitar = dis.readInt();
            this.mpPercentWinDrums = dis.readInt();
            this.totalHighScore = dis.readLong();
        }
        this.careerHighScore = dis.readLong();
        int numTrophies = dis.readByte();
        int limT = numTrophies < 8 ? numTrophies : 8;
        for (int i = 0; i < limT; ++i) {
            this.trophies[i] = 1 == dis.readByte();
        }
        int numSongInfo = dis.readByte();
        for (int i = 0; i < numSongInfo; ++i) {
            String songKey = dis.readUTF();
            int numDiff = dis.readByte();
            int limD = numDiff < 3 ? numDiff : 3;
            int[] starsAndScoresValue = new int[6];
            this.starsAndScores.put(songKey, starsAndScoresValue);
            for (int dl = 0; dl < numDiff; ++dl) {
                byte diff = dis.readByte();
                for (int gpm = 0; gpm < 2; ++gpm) {
                    if (is_WORK_PLAYERSTATS) {
                        long highScore = dis.readLong();
                        this.setScore(starsAndScoresValue, diff, gpm, (int)highScore);
                        continue;
                    }
                    int index = this.getIndex(diff, gpm);
                    starsAndScoresValue[index] = dis.readInt();
                }
            }
        }
    }

    public void debugSetScoreOnAllSongs(BSongInfo songInfo, int score, int stars, int noteStreak) {
        int numVenues = songInfo.getNumVenues();
        for (int v = 0; v < numVenues; ++v) {
            int numSongsInVenue = songInfo.getNumSongs(v);
            for (int s = 0; s < numSongsInVenue; ++s) {
                BSongData songData = songInfo.getSong(v, s);
                if (null == songData) continue;
                for (int d = 0; d < 3; ++d) {
                    for (int i = 0; i < 2; ++i) {
                        this.update(songInfo, songData, score, stars, noteStreak, v, d, i);
                    }
                }
            }
        }
    }
}

