/*
 * Decompiled with CFR 0.152.
 */
class Score {
    public int score = 0;
    public boolean debugForceFiveStars = false;
    public int mpBattlePointsAwarded = 0;
    public int mpPlayerID = 0;
    private int rockMeterPercent = 50;
    private int maxRockMeterPercent = 50;
    private int sumRockMeterPercent = 0;
    private int timeAtRockMeterPercent = 0;
    private int lastTAtRockMeterPercent = 0;
    private int starPowerMultiplier = 1;
    public int starPowerPercent = 0;
    public int starPowerComplete = 0;
    public int numStarPowerTriggered = 0;
    public int notesNeeded = 0;
    private int notesHit = 0;
    private int hitStreak = 0;
    private int maxHitStreak = 0;
    private int notesMissed = 0;
    private int missStreak = 0;
    private int maxMissStreak = 0;
    private int scoreMultiplier = 1;
    private int maxScoreMultiplier = 1;
    private int sumScoreMultiplier = 0;
    private int timeAtScoreMultiplier = 0;
    private int lastTAtScoreMultiplier = 0;
    public static final int MAX_BATTLE_POWERS_QUEUESIZE = 2;
    public int[] battlePowerQueue = new int[2];
    public long[] battlePowerQueueReadyTime = new long[2];
    public Sprite sprMulti;
    public Sprite sprNeedle;
    public int xAmp;
    public int yAmp;
    public int xAmpBulb;
    public int yAmpBulb;
    public int wAmpBulb;
    public int hAmpBulb;
    public int xMeter;
    public int yMeter;
    public int xScore;
    public int yScore;
    public int xSPMeter;
    public int ySPMeter;
    static final int CENTER_FRAME = 3;
    static final int CENTER_NEEDLE_X = 21;
    static final int CENTER_NEEDLE_Yt = 4;
    static final int CENTER_NEEDLE_Yb = 12;
    static final int CENTER_NEEDLE_H = 9;
    int drawnNeedleXt;
    int drawnNeedleXb;
    int drawnNeedleYt;
    int drawnNeedleYb;
    int drawnNeedlyH;
    private int lastScore;
    private String myScore;

    public int getRockMeterPercent() {
        return this.rockMeterPercent;
    }

    public int getMaxRockMeterPercent() {
        return this.maxRockMeterPercent;
    }

    public void deltaRockMeterPercent(int delta, int curSongTime) {
        int oldRockMeterPercent = this.rockMeterPercent;
        this.rockMeterPercent = Util.clamp(this.rockMeterPercent + delta, 0, 100);
        if (oldRockMeterPercent != this.rockMeterPercent) {
            this.trackRockMeterPercentStats(curSongTime);
        }
    }

    public int getNotesHit() {
        return this.notesHit;
    }

    public int getHitStreak() {
        return this.hitStreak;
    }

    public int getMaxHitStreak() {
        return this.maxHitStreak;
    }

    public int getNotesMissed() {
        return this.notesMissed;
    }

    public int getMissStreak() {
        return this.missStreak;
    }

    public int getMaxMissStreak() {
        return this.maxMissStreak;
    }

    public int getScoreMultiplier() {
        return this.scoreMultiplier;
    }

    public int getMaxScoreMultiplier() {
        return this.maxScoreMultiplier;
    }

    public int getStarPowerMultiplier() {
        return this.starPowerMultiplier;
    }

    public void setMaxHitStreak(int streak) {
        this.maxHitStreak = streak;
    }

    public void setNoteHit(int curSongTime) {
        ++this.notesHit;
        ++this.hitStreak;
        this.missStreak = 0;
        if (this.hitStreak > this.maxHitStreak) {
            this.maxHitStreak = this.hitStreak;
        }
        int oldScoreMultipier = this.scoreMultiplier;
        this.scoreMultiplier = this.calculateScoreMultiplier();
        if (oldScoreMultipier != this.scoreMultiplier) {
            this.trackScoreMultiplierStats(curSongTime);
        }
        this.fixSprMultiFrames();
    }

    public void setStarPowerMultiplier(int starPowerMultiplier, int curSongTime) {
        this.starPowerMultiplier = starPowerMultiplier;
        int oldScoreMultipier = this.scoreMultiplier;
        this.scoreMultiplier = this.calculateScoreMultiplier();
        if (oldScoreMultipier != this.scoreMultiplier) {
            this.trackScoreMultiplierStats(curSongTime);
        }
        this.fixSprMultiFrames();
    }

    public int calculateScoreMultiplier() {
        this.scoreMultiplier = this.hitStreak > 29 ? 4 * this.starPowerMultiplier : (this.hitStreak > 19 ? 3 * this.starPowerMultiplier : (this.hitStreak > 9 ? 2 * this.starPowerMultiplier : 1 * this.starPowerMultiplier));
        return this.scoreMultiplier;
    }

    public void setNoteMissed(int curSongTime) {
        ++this.missStreak;
        this.hitStreak = 0;
        if (this.missStreak > this.maxMissStreak) {
            this.maxMissStreak = this.missStreak;
        }
        int oldScoreMultipier = this.scoreMultiplier;
        this.scoreMultiplier = 1 * this.starPowerMultiplier;
        if (oldScoreMultipier != this.scoreMultiplier) {
            this.trackScoreMultiplierStats(curSongTime);
        }
        this.fixSprMultiFrames();
    }

    public void trackScoreMultiplierStats(int curSongTime) {
        if (this.scoreMultiplier > this.maxScoreMultiplier) {
            this.maxScoreMultiplier = this.scoreMultiplier;
        }
        this.timeAtScoreMultiplier = curSongTime - this.lastTAtScoreMultiplier;
        this.lastTAtScoreMultiplier = curSongTime;
        this.sumScoreMultiplier += this.scoreMultiplier * this.timeAtScoreMultiplier;
    }

    public void trackRockMeterPercentStats(int curSongTime) {
        if (this.rockMeterPercent > this.maxRockMeterPercent) {
            this.maxRockMeterPercent = this.rockMeterPercent;
        }
        this.timeAtRockMeterPercent = curSongTime - this.lastTAtRockMeterPercent;
        this.lastTAtRockMeterPercent = curSongTime;
        this.sumRockMeterPercent += this.rockMeterPercent * this.timeAtRockMeterPercent;
    }

    public int getAveScoreMultiplier() {
        if (this.sumScoreMultiplier == 0 || this.lastTAtScoreMultiplier == 0) {
            return Util.fraction2int(1, 1);
        }
        return Util.fraction2int(this.sumScoreMultiplier, this.lastTAtScoreMultiplier);
    }

    public int getAveRockMeterPercent() {
        if (this.sumRockMeterPercent == 0 || this.lastTAtRockMeterPercent == 0) {
            return Util.fraction2int(1, 1);
        }
        return Util.fraction2int(this.sumRockMeterPercent, this.lastTAtRockMeterPercent);
    }

    public void setEnemyScoreOverrides(int rockMeterPercent, int hitStreak, int score) {
        this.rockMeterPercent = rockMeterPercent;
        this.hitStreak = hitStreak;
        this.score = score;
        this.scoreMultiplier = this.calculateScoreMultiplier();
        this.fixSprMultiFrames();
    }

    public void fixSprMultiFrames() {
        if (null != this.sprMulti) {
            int frame;
            if (this.starPowerMultiplier == 1) {
                frame = this.scoreMultiplier - 1;
            } else {
                switch (this.scoreMultiplier) {
                    case 4: {
                        frame = 5;
                        break;
                    }
                    case 6: {
                        frame = 6;
                        break;
                    }
                    case 8: {
                        frame = 7;
                        break;
                    }
                    default: {
                        frame = 4;
                    }
                }
            }
            this.sprMulti.setFrame(frame);
        }
    }

    public Score() {
        for (int i = 0; i < this.battlePowerQueue.length; ++i) {
            this.battlePowerQueue[i] = -1;
        }
        this.sprMulti = null;
        this.sprNeedle = null;
        this.xAmp = 0;
        this.yAmp = 0;
        this.xAmpBulb = 0;
        this.yAmpBulb = 0;
        this.wAmpBulb = 0;
        this.hAmpBulb = 0;
        this.xMeter = 0;
        this.yMeter = 0;
        this.xScore = 0;
        this.yScore = 0;
        this.xSPMeter = 0;
        this.ySPMeter = 0;
        this.lastScore = 0;
        this.myScore = "0";
    }

    public Score(int score, int numNotesHit, int numNotesMissed, int maxHitStreak, int maxMissStreak, int maxScoreMultiplier, int maxRockMeterPercent, int finalRockMeterPercent, int numBattlePowersAcquired, int numBattlePowersTriggered, int aveScoreMultiplier, int aveRockMeterPercent) {
        for (int i = 0; i < this.battlePowerQueue.length; ++i) {
            this.battlePowerQueue[i] = -1;
        }
        this.sprMulti = null;
        this.sprNeedle = null;
        this.xAmp = 0;
        this.yAmp = 0;
        this.xAmpBulb = 0;
        this.yAmpBulb = 0;
        this.wAmpBulb = 0;
        this.hAmpBulb = 0;
        this.xMeter = 0;
        this.yMeter = 0;
        this.xScore = 0;
        this.yScore = 0;
        this.xSPMeter = 0;
        this.ySPMeter = 0;
        this.lastScore = 0;
        this.myScore = "0";
        this.score = score;
        this.notesHit = numNotesHit;
        this.notesMissed = numNotesMissed;
        this.maxHitStreak = maxHitStreak;
        this.maxMissStreak = maxMissStreak;
        this.maxScoreMultiplier = maxScoreMultiplier;
        this.maxRockMeterPercent = maxRockMeterPercent;
        this.starPowerComplete = numBattlePowersAcquired;
        this.numStarPowerTriggered = numBattlePowersTriggered;
    }

    public int getPercentComplete() {
        if (this.notesNeeded == 0 || this.notesHit < 0) {
            return 0;
        }
        return Util.PERCENT(this.notesHit, this.notesNeeded);
    }

    public int getStars() {
        if (this.debugForceFiveStars) {
            return 5;
        }
        if (this.score == 0 || this.notesNeeded == 0 || this.notesHit < 0) {
            return 0;
        }
        int pc = this.getPercentComplete();
        return Score.getStars(pc);
    }

    public static int getStars(int percentComplete) {
        if (RealioCanvas.cheatOn) {
            return 5;
        }
        if (percentComplete <= 90) {
            return 3;
        }
        if (percentComplete <= 96) {
            return 4;
        }
        return 5;
    }

    public String toString() {
        if (this.lastScore != this.score) {
            this.lastScore = this.score;
            this.myScore = String.valueOf(this.score);
        }
        return this.myScore;
    }

    public void drawPrimativesNeedle(GraphicsHelper gh) {
        gh.clearClip();
        gh.setColor(0);
        gh.drawLine(this.drawnNeedleXb + 1, this.drawnNeedleYb, this.drawnNeedleXt + 1, this.drawnNeedleYt);
        gh.setColor(0xFFFFFF);
        gh.drawLine(this.drawnNeedleXb, this.drawnNeedleYb, this.drawnNeedleXt, this.drawnNeedleYt);
        gh.setColor(0);
        gh.drawLine(this.drawnNeedleXb - 1, this.drawnNeedleYb, this.drawnNeedleXt - 1, this.drawnNeedleYt);
    }

    public void setNeedlePos(int rockMeterFrame) {
        int diffFromCenterFrame;
        this.drawnNeedleXt = this.xMeter + 21 + (rockMeterFrame - 3) * 5;
        this.drawnNeedleXb = this.xMeter + 21 + (rockMeterFrame - 3) * 2;
        this.drawnNeedleYb = this.yMeter + 12 + ((diffFromCenterFrame *= (diffFromCenterFrame = rockMeterFrame - 3) > 0 ? 1 : -1) + 1) / 2;
        this.drawnNeedleYt = this.drawnNeedleYb - (9 - diffFromCenterFrame * 3 / 2);
    }
}

