/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameSprite;
import game.Tank;
import game.Weapon;
import game.dirtfield.DirtFieldBase;
import game.dirtfield.DirtField_RGBBuffer;
import handson.Handson;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.Menu;
import tinbrain.RM;
import tinbrain.math3d.Point2D;
import tinbrain.mmapi.Sound;
import tinbrain.render2d.sprites.midp10.SpriteRenderer;

public final class Game {
    public static Game instance = null;
    public SpriteRenderer mSpriteRenderer$6be6c80c;
    protected int mFrame;
    private int mMenuDirtFieldX;
    private int mMenuDirtFieldScrollX;
    private boolean mDrawingAttractMode = false;
    private boolean mDontInitShutter = false;
    private int mCurrentUpdateIteration = -1;
    private int mMenuSelectionBarY;
    private int mMenuSelectionBarW;
    private int mMenuSelectionBorderColor;
    private int mShopCurrentItem = -1;
    private int mShopCurrentTank = -1;
    private int SHOP_TITLE_PADDING_TOP = 4;
    private int SHOP_TITLE_PADDING_BOTTOM = 4;
    private int SHOP_TITLE_PADDING_LEFT = 5;
    private boolean mDrawingFinalSplash;
    private int[] mSortedWeapons;
    private int[] mSortedWeaponPrices;
    private Tank[] mScoreBoardTanks = new Tank[4];
    private boolean mResumeMusicAfterInterrupt;
    private int mCurrentRuleset;
    public boolean gamefield_fullscreen = false;
    public DirtFieldBase gamefield_dirtField;
    private Weapon[] gamefield_weapons;
    public Tank[] gamefield_tanks;
    private int[] gamefield_explosions = new int[2000];
    private int gamefield_numExplosions = 0;
    public int gamestate_wind;
    public int gamestate_gravity = 20;
    public int gamestate_round;
    public Tank[] gamestate_players;
    public int gamestate_currentPlayerIndex;
    public boolean gamestate_waitingForWeapons;
    public boolean gamestate_atTitleScreen;
    public int gamestate_rounds;
    public int gamestate_difficulty;
    public int gamestate_humans;
    private boolean gamestate_showTutorial;
    private boolean gamestate_roundInProgress = false;
    public int gamestate_cpus;
    public int gamestate_spawnedWeapons;
    public boolean gamestate_vibration;
    private boolean gamelayer_gameInProgress;
    private boolean gamelayer_cpuSkip;
    private boolean gamelayer_stopped;
    private boolean gamelayer_chromeVisible;
    private int gamelayer_currentSeed;
    GameSprite gamelayer_angleIndicator;
    private boolean mFirstPlayer = false;
    private int mShutterStartFrame = -1;
    private int mSwipeCameraLastX = -1;
    private int mSwipeSpeedX = 0;
    private int mCurrentTouchScreenEvent = -1;
    private int sInternalHotspotId = -1;
    private int mPressedContKey = -1;
    private int newgamepanel_humans = 1;
    private int newgamepanel_cpus = 1;
    private int newgamepanel_difficulty = 1;
    private int newgamepanel_rounds = 5;
    private Tank[] newgamepanel_cpuTanks;
    private static int[] sPlayerColors = new int[]{-8388609, -32769, -8388737, -129};
    private int[] mSaveGame;
    private boolean chrome_powerVisible;
    private int chrome_power;
    private int chrome_wind;
    private int mOldWeapon = -1;
    private int mWeaponChangeFrame = 0;
    private boolean mWeaponChangeUp = false;
    private int COLOR_BAR = 12288;
    private int COLOR_BAR_BORDER = 32768;
    private int COLOR_CINEMASCOPE_BAR = 8192;
    private boolean mRedrawWeaponHud = false;
    private int mCameraX;
    private int mCameraTargetX;
    private Weapon mCameraTargetWeapon;
    private int mCameraTargetWeaponIndex;
    public int mInputMode = 0;
    private int mDeltaAngle;
    private int mDeltaAngleLastDir;
    private int mDeltaAngleSpeedIncreaseFrames;
    private int mLastFrameWithLogicsound = -1;
    private boolean[] mSfxPlayed = new boolean[2];
    private int quote_x;
    private int quote_age = -1;
    private int quote_string = -1;
    private Tank quote_owner = null;
    private int[] quote_lines = new int[20];
    public int mAspectRatio = -1;
    private static int[] sLineScrollers = new int[10];

    public Game() {
        instance = this;
    }

    private void onInit() {
        this.gamestate_init();
        this.menuSelectionBarReset();
        this.mMenuDirtFieldX = 0;
        this.mMenuDirtFieldScrollX = 1;
        this.mSpriteRenderer$6be6c80c = new SpriteRenderer();
        this.mSpriteRenderer$6be6c80c.init(81);
        this.checkForSaveGame();
        this.eaglview_goToTitleScreen();
    }

    private void doRestart() {
        this.newgamepanel_startGame();
    }

    private void draw(Graphics graphics) {
        int n = 0;
        graphics.setColor(0);
        if (!this.mRedrawWeaponHud) {
            n = GCanvas.getHeight() - GCanvas.getFontHeight(0) - 1 + 0;
        }
        graphics.fillRect(0, n, GCanvas.getWidth(), GCanvas.getHeight() - n);
        this.gamelayer_render(graphics);
    }

    public final int updateSoftButtonState$134621() {
        return 0;
    }

    public final void onDraw(Graphics graphics) {
        GCanvas.pushClip(graphics);
        GCanvas.clipRect(graphics, 0, 0, GCanvas.getWidth(), GCanvas.getHeight());
        this.draw(graphics);
        graphics.translate(0, 0);
        GCanvas.popClip(graphics);
    }

    public final void onInput() {
        ++this.mFrame;
        this.updateInput();
        this.updateCamera();
        this.update();
    }

    public final boolean peekInput() {
        return false;
    }

    public final int drawCustomMenu$26c5357f(Graphics graphics, int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                int n3 = Menu.getMenuItemTop();
                int n4 = 0;
                n4 = RM.getHeight(6) + 6;
                if (n3 < n4) {
                    Menu.setMenuCaptionOffset(n4 - n3);
                }
                int n5 = RM.getWidth(6);
                GCanvas.drawImage(graphics, 6, GCanvas.getWidth() - n5 >> 1, 3);
                n2 = 2;
            }
        }
        return n2;
    }

    public final void drawCustomMenuBackground$26c5358c(Graphics graphics, int n) {
        if (Handson.menuDrawOutroScreen(graphics, n)) {
            return;
        }
        if (Menu.getMode() != 0) {
            if (Menu.getCurrentMenu() != 0) {
                graphics.setColor(-16771840);
                graphics.fillRect(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
                this.mDrawingAttractMode = false;
                return;
            }
            this.mDrawingAttractMode = true;
            this.drawAttractMode(graphics);
        }
    }

    private void drawAttractMode(Graphics graphics) {
        this.mMenuDirtFieldX += this.mMenuDirtFieldScrollX;
        if (this.mMenuDirtFieldX < 0 || this.mMenuDirtFieldX > this.gamefield_dirtField.mPixelWidth - GCanvas.getWidth()) {
            this.mMenuDirtFieldScrollX *= -1;
        }
        this.gamefield_dirtField.setViewTopLeft(this.mMenuDirtFieldX, 0);
        this.update();
        this.draw(graphics);
    }

    private void update() {
        Game game = this;
        int n = game.mCurrentUpdateIteration = 0;
        while (this.mCurrentUpdateIteration < 8) {
            this.gamelayer_update();
            Game game2 = this;
            game = game2;
            n = game2.mCurrentUpdateIteration + 1;
        }
        this.gamelayer_updateSwipeCamera();
        if (this.gamestate_currentPlayer() != null && this.gamestate_currentPlayer().controller == 0) {
            this.gamelayer_setAngleIndicatorFromTank(this.gamestate_currentPlayer());
        }
    }

    public final boolean menuHighlightSelection$134632() {
        return true;
    }

    private void menuSelectionBarReset() {
        this.mMenuSelectionBarY = -1;
        this.mMenuSelectionBarW = -1;
    }

    public final boolean menuDrawSelectionBar(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        Game game;
        int n6;
        Game game2;
        int n7 = Menu.getCurrentMenu();
        if (n7 == 24) {
            return true;
        }
        int n8 = 5;
        boolean bl = true;
        boolean bl2 = false;
        switch (n7) {
            case 18: {
                n8 = 0;
                bl = false;
                break;
            }
            case 15: {
                break;
            }
            case 0: {
                bl2 = true;
            }
        }
        int n9 = n3;
        n3 += 0;
        int n10 = n9 - (n3 -= 0) & 0xFFFFFFFE;
        int n11 = (n2 - this.mMenuSelectionBarY) * 800 >> 10;
        if (this.mMenuSelectionBarY == -1 || n11 == 0) {
            game2 = this;
            n6 = n2;
        } else {
            Game game3 = this;
            game2 = game3;
            n6 = game3.mMenuSelectionBarY + n11;
        }
        game2.mMenuSelectionBarY = n6;
        int n12 = Menu.getMenuItemCaption(n7, Menu.getSelection());
        int n13 = GCanvas.getStringWidth(RM.t(n12), 4) + n8 * 2;
        int n14 = (n13 - this.mMenuSelectionBarW) * 800 >> 10;
        if (this.mMenuSelectionBarW == -1 || n14 == 0) {
            game = this;
            n5 = n13;
        } else {
            Game game4 = this;
            game = game4;
            n5 = game4.mMenuSelectionBarW + n14;
        }
        game.mMenuSelectionBarW = n5;
        int n15 = GCanvas.getWidth() - n;
        if (n7 != 18 && n7 != 15) {
            n = (GCanvas.getWidth() - this.mMenuSelectionBarW) / 2;
            n15 = this.mMenuSelectionBarW;
        }
        GCanvas.pushClip(graphics);
        graphics.setClip(n, graphics.getClipY(), GCanvas.getWidth() - n, graphics.getClipHeight());
        if (bl) {
            if (bl2) {
                GCanvas.fillRectWithImage(graphics, 35, n, this.mMenuSelectionBarY + (n10 >> 1), n + n15, this.mMenuSelectionBarY + (n10 >> 1) + n3);
            } else {
                graphics.setColor(-16764928);
                graphics.fillRect(n, this.mMenuSelectionBarY + (n10 >> 1), n15, n3);
            }
        }
        if ((n4 = GCanvas.getGlobalFrameCount() % 32 * 16) > 255) {
            n4 = 511 - n4;
        }
        int n16 = 0;
        n16 = Math.min(210, 128 + 128 * n4 / 255);
        this.mMenuSelectionBorderColor = n16 << 8;
        graphics.setColor(this.mMenuSelectionBorderColor);
        graphics.drawRect(n, this.mMenuSelectionBarY + (n10 >> 1), n15 - 1, n3);
        GCanvas.popClip(graphics);
        return true;
    }

    private void drawShopCaption(Graphics graphics, int n, String string, int n2, int n3) {
        int n4 = GCanvas.getFontHeight(n);
        int n5 = 3 * n4 + this.SHOP_TITLE_PADDING_TOP + this.SHOP_TITLE_PADDING_BOTTOM;
        int n6 = this.gamestate_players[this.mShopCurrentTank].cash;
        graphics.setColor(this.COLOR_BAR);
        graphics.fillRect(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), n5);
        graphics.setColor(this.COLOR_BAR_BORDER);
        graphics.drawRect(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth() - 1, n5);
        n2 = graphics.getClipY() + this.SHOP_TITLE_PADDING_TOP;
        int n7 = Math.max(0, graphics.getClipX() + this.SHOP_TITLE_PADDING_LEFT);
        int n8 = Math.max(0, this.SHOP_TITLE_PADDING_LEFT);
        GCanvas.drawString(graphics, n, string, n7, n2, n3);
        GCanvas.drawString(graphics, n, this.gamestate_players[this.mShopCurrentTank].name, GCanvas.getWidth() - n8, n2, n3 & 0xFFFFFFFB | 8);
        RM.prepareVarText(13, new String[]{String.valueOf(n6)});
        GCanvas.drawString(graphics, n, RM.t(13), n7, n2 += n4, n3);
        int n9 = graphics.getClipWidth() - n8 - Math.max(0, n7 - graphics.getClipX());
        if (Game.lineScrollerDraw(0, graphics, RM.t(315), 1, n7, n2 += n4, n3, n9)) {
            Menu.scheduleMenuRefresh();
        }
    }

    private void drawShopLine(Graphics graphics, int n, String string, int n2, int n3) {
        int n4;
        this.menuGetTextSpacingForMenu(18, n);
        Tank tank = this.gamestate_players[this.mShopCurrentTank];
        int n5 = -1;
        int n6 = instance.getRuleValueInt(16);
        int n7 = instance.getRuleValueInt(17);
        String string2 = RM.t(Menu.getMenuItemCaption(Menu.getCurrentMenu(), Menu.sCurrentDrawnItem));
        for (n4 = n6; n4 <= n7; ++n4) {
            if (!RM.t(RM.getValue(82, n4, 0)).equals(string2)) continue;
            n5 = n4;
            break;
        }
        n4 = RM.getValue(82, n5, 2);
        String string3 = String.valueOf(n4);
        String string4 = String.valueOf((long)n4 * 768L >> 10);
        int n8 = tank.getWeaponAmmo(n5);
        boolean bl = tank.cash >= n4;
        boolean bl2 = n8 > 0;
        int n9 = GCanvas.getStringWidth(String.valueOf(99), n);
        int n10 = GCanvas.getSpriteWidth(2);
        int n11 = GCanvas.getSpriteHeight(2);
        int n12 = GCanvas.getFontHeight(n);
        int n13 = n12 + (Math.max(n12, n11) >> 1);
        int n14 = n13 - (n12 >> 1);
        int n15 = n13 - (GCanvas.getFontHeight(1) >> 1);
        Math.max(n12, n11);
        boolean bl3 = Menu.getMenuItemCaption(18, Menu.getSelection()) == RM.getValue(82, n5, 0);
        graphics.setColor(this.COLOR_BAR);
        graphics.fillRect(graphics.getClipX(), n2 + 1, graphics.getClipWidth(), n12 - 2);
        GCanvas.getStringWidth(string, n);
        if (Game.lineScrollerDraw(1, graphics, string, n, graphics.getClipX(), n2, n3, graphics.getClipWidth())) {
            Menu.scheduleMenuRefresh();
        }
        int n16 = graphics.getClipX() + (graphics.getClipWidth() >> 1);
        if (bl3) {
            this.mShopCurrentItem = n5;
            graphics.setColor(this.mMenuSelectionBorderColor);
            graphics.fillRect(n16 - n9 / 2 - 4, n2 + n14, n9 + 8, n12 - 1);
            GCanvas.drawSpriteWithHotspot(graphics, 2, n16 - 10 - n9 - n10 / 2, n2 + n13, bl2 ? 1 : 3, 0x10000000, 27);
            GCanvas.drawSpriteWithHotspot(graphics, 2, n16 + 10 + n9 - n10 / 2, n2 + n13, bl ? 0 : 2, 0x10000000, 28);
        }
        GCanvas.drawString(graphics, n, String.valueOf(n8), n16, n2 + n14, 1);
        String string5 = "-";
        String string6 = "+";
        int n17 = GCanvas.getStringWidth(string5, 1);
        int n18 = 0;
        n18 = n16 + n10 + n9 / 2 + 20;
        GCanvas.drawString(graphics, 1, string5, n18, n2 + n15, 4);
        GCanvas.drawString(graphics, 1, string3, n17 + n18, n2 + n15, 4);
        n18 = n16 - n10 - n9 / 2 - 20;
        GCanvas.drawString(graphics, 1, string4, n18, n2 + n15, 8);
        GCanvas.drawString(graphics, 1, string6, n18 - GCanvas.getStringWidth(string4, 1), n2 + n15, 8);
    }

    /*
     * Unable to fully structure code
     */
    private void drawGameSettingLine(Graphics var1_1, int var2_2, String var3_3, int var4_4, int var5_5) {
        var6_6 = Menu.getMenuItemIndex(15, var3_3);
        var7_7 = GCanvas.getFontHeight(var2_2);
        var8_8 = Math.max(GCanvas.getSpriteHeight(3), var7_7);
        var9_9 = -1;
        for (var10_10 = 326; var10_10 <= 329; ++var10_10) {
            var11_11 = GCanvas.getStringWidth(RM.t(var10_10), var2_2);
            if (var11_11 <= var9_9) continue;
            var9_9 = var11_11;
        }
        var10_10 = var4_4 + (var8_8 >> 1) - (var7_7 >> 1);
        GCanvas.drawString(var1_1, var2_2, var3_3, var1_1.getClipX(), var10_10, var5_5);
        var12_12 = var11_11 = var1_1.getClipWidth() + var1_1.getClipX();
        var13_13 = GCanvas.getSpriteWidth(3);
        var11_11 -= var9_9 + var13_13 * 2;
        if (var6_6 == Menu.getSelection()) {
            GCanvas.drawSpriteWithHotspot(var1_1, 3, var11_11, var4_4 + (var8_8 >> 1), 1, 0x10000000, 27);
            GCanvas.drawSpriteWithHotspot(var1_1, 3, var12_12 - var13_13, var4_4 + (var8_8 >> 1), 0, 0x10000000, 28);
        }
        var14_14 = null;
        switch (var6_6) {
            case 0: {
                v0 = String.valueOf(this.newgamepanel_humans);
                ** GOTO lbl44
            }
            case 1: {
                v0 = String.valueOf(this.newgamepanel_cpus);
                ** GOTO lbl44
            }
            case 2: {
                v0 = String.valueOf(this.newgamepanel_rounds);
                ** GOTO lbl44
            }
            case 3: {
                var15_15 = this.newgamepanel_difficulty;
                switch (var15_15) {
                    case 0: {
                        v1 = 326;
                        ** GOTO lbl43
                    }
                    case 1: {
                        v1 = 327;
                        ** GOTO lbl43
                    }
                    case 2: {
                        v1 = 328;
                        ** GOTO lbl43
                    }
                    case 3: {
                        v1 = 329;
lbl43:
                        // 4 sources

                        v0 = RM.t(v1);
lbl44:
                        // 4 sources

                        var14_14 = v0;
                    }
                }
            }
        }
        if (var14_14 != null) {
            var15_15 = GCanvas.getStringWidth(var14_14, var2_2);
            var16_16 = var11_11 + (var12_12 - var11_11 >> 1);
            GCanvas.drawString(var1_1, var2_2, var14_14, var16_16 - (var15_15 >> 1), var10_10, var5_5);
        }
    }

    public final boolean menuDrawItem$3971e4ba(Graphics graphics, int n, String string, int n2, int n3, int n4) {
        switch (Menu.getCurrentMenu()) {
            case 18: {
                if (n4 == 1) {
                    this.drawShopCaption(graphics, n, string, n2, n3);
                    return true;
                }
                if (n4 == 0 || n4 == 2) {
                    this.drawShopLine(graphics, n, string, n2, n3);
                    return true;
                }
                return false;
            }
            case 15: {
                if (n4 == 1) break;
                this.drawGameSettingLine(graphics, 1, string, n2, n3);
                return true;
            }
        }
        if (n4 == 1) {
            int n5 = GCanvas.getFontHeight(n);
            graphics.setColor(this.COLOR_BAR);
            graphics.fillRect(0, 0, GCanvas.getWidth(), n5);
            graphics.setColor(this.COLOR_BAR_BORDER);
            graphics.drawLine(0, n5, GCanvas.getWidth(), n5);
            int n6 = Math.min(graphics.getClipX() + graphics.getClipWidth(), GCanvas.getWidth() - 0) - Math.max(graphics.getClipX(), 0);
            if (Game.lineScrollerDraw(2, graphics, string, n, GCanvas.getWidth() >> 1, 0, 17, n6)) {
                Menu.scheduleMenuRefresh();
            }
            return true;
        }
        return false;
    }

    public final boolean menuDrawItemSimple$276ff40f() {
        return false;
    }

    public final void drawFinalSplash$11c44857(Graphics graphics, int n) {
        if (n < 0 || n > 3000) {
            return;
        }
        this.mDrawingFinalSplash = true;
        if (!this.mDontInitShutter) {
            this.mShutterStartFrame = GCanvas.getGlobalFrameCount();
        }
        this.mDontInitShutter = true;
        this.mDrawingAttractMode = true;
        this.drawAttractMode(graphics);
        int n2 = RM.getWidth(6);
        GCanvas.drawImage(graphics, 6, GCanvas.getWidth() - n2 >> 1, 3);
    }

    public final int evaluateCondition(int n, int n2) {
        int n3 = Handson.evaluateCondition$255f288(n);
        if (n3 != 0) {
            return n3;
        }
        switch (n) {
            case 7: {
                if (this.mSaveGame == null || this.mSaveGame.length == 1) {
                    return -1;
                }
                if (this.isSaveGameResumable()) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    public final void prepareSounds$4a224d26(Sound sound) {
        sound.prepare(27, false);
        sound.prepare(28, false);
        sound.prepare(29, false);
        sound.prepare(30, false);
        sound.prepare(31, false);
        sound.prepare(32, false);
        sound.prepare(26, false);
    }

    public final void freeSounds$4a224d26(Sound sound) {
        sound.free(26);
        sound.free(27);
        sound.free(28);
        sound.free(29);
        sound.free(30);
        sound.free(31);
        sound.free(32);
    }

    public final int getSoundConfirmation() {
        return 26;
    }

    public final void init() {
        this.onInit();
    }

    public final void initGame(boolean bl) {
        this.mResumeMusicAfterInterrupt = false;
        if (bl) {
            Menu.startLoading(78);
        }
        this.restart(false);
        if (bl) {
            Menu.stopLoading();
        }
    }

    public final boolean isCycleMenu$134632() {
        return false;
    }

    public final boolean musicShouldStop(int n) {
        return true;
    }

    public final void notify(boolean bl) {
        if (bl) {
            this.hudWeaponSetDirty();
            GCanvas.setSoftButton(10, 11);
            instance.resetTouchScreenQueue();
        }
    }

    public final void onLanguageChanged() {
        Handson.onLanguageChanged();
    }

    private static void insert(int[] nArray, int n, int n2) {
        for (int i = nArray.length - 1; i > n; --i) {
            nArray[i] = nArray[i - 1];
        }
        nArray[n] = n2;
    }

    private void buildSortedWeaponList() {
        int n = this.getRuleValueInt(16);
        int n2 = this.getRuleValueInt(17);
        int n3 = n2 - n + 1;
        this.mSortedWeapons = new int[n3];
        this.mSortedWeaponPrices = new int[n3];
        block0: for (int i = n; i <= n2; ++i) {
            int n4 = RM.getValue(82, i, 2);
            if (n4 <= 0) continue;
            for (int j = 0; j < this.mSortedWeaponPrices.length; ++j) {
                if (this.mSortedWeaponPrices[j] != 0 && this.mSortedWeaponPrices[j] <= n4) continue;
                Game.insert(this.mSortedWeaponPrices, j, n4);
                Game.insert(this.mSortedWeapons, j, i);
                continue block0;
            }
        }
    }

    public final void onPrepareMenuChange(int n, int n2) {
        this.hudWeaponSetDirty();
        this.resetDoubleTappingControls();
        Menu.resetItemBottom();
        Menu.setMenuItemOverlayWith(0);
        this.menuSelectionBarReset();
        Handson.prepareMenuChange$255f295(n);
        if (n == 9) {
            Menu.setDefaultSelection(n, Menu.findMenuItem(9, 46));
            return;
        }
        if (n == 15) {
            this.newgamepanel_humans = 1;
            this.newgamepanel_cpus = 3;
            this.newgamepanel_difficulty = 1;
            this.newgamepanel_rounds = 5;
            this.gamestate_roundInProgress = false;
            return;
        }
        if (n == 0) {
            this.eaglview_goToTitleScreen();
            if (!this.mDontInitShutter) {
                this.mShutterStartFrame = GCanvas.getGlobalFrameCount();
            } else {
                this.mDontInitShutter = false;
            }
            this.mResumeMusicAfterInterrupt = true;
            if (n2 == 13) {
                Menu.saveOptions();
                return;
            }
        } else {
            if (n == 18) {
                Game.lineScrollerInit(1);
                Game.lineScrollerInit(0);
                GCanvas.getFontHeight(0);
                Menu.getMenuSeperatorTop(18);
                if (Menu.getMenuItemCount(n) == 0) {
                    this.buildSortedWeaponList();
                    for (int i = 0; i < this.mSortedWeapons.length && this.mSortedWeaponPrices[i] > 0; ++i) {
                        Menu.addMenuItem(18, RM.getValue(82, this.mSortedWeapons[i], 0), 0, -1, -1);
                    }
                }
                return;
            }
            if (n == 16) {
                this.scoreboard_setup();
            }
        }
    }

    private void scoreboard_sortTanks() {
        int n;
        int n2 = Game.count(this.gamestate_players);
        for (n = 0; n < n2; ++n) {
            this.mScoreBoardTanks[n] = null;
        }
        block1: for (n = 0; n < n2; ++n) {
            Tank tank = this.gamestate_players[n];
            for (int i = 0; i < n2; ++i) {
                if (this.mScoreBoardTanks[i] != null && tank.wins <= this.mScoreBoardTanks[i].wins) continue;
                for (int j = n2 - 1; j > i; --j) {
                    this.mScoreBoardTanks[j] = this.mScoreBoardTanks[j - 1];
                }
                this.mScoreBoardTanks[i] = tank;
                continue block1;
            }
        }
    }

    private void scoreboard_setup() {
        int n = Game.count(this.gamestate_players);
        String string = new String();
        this.scoreboard_sortTanks();
        for (int i = 0; i < n; ++i) {
            Tank tank = this.mScoreBoardTanks[i];
            string = string + tank.name + "\n";
            string = string + RM.t(331) + tank.wins + "\n";
            string = string + RM.t(332) + tank.kills + "\n";
            string = string + RM.t(333) + tank.deaths + "\n\n";
        }
        RM.prepareVarText(16, String.valueOf(this.gamestate_round), String.valueOf(this.gamestate_rounds));
        string = string + RM.t(16);
        RM.setString(15, string);
    }

    private boolean performGameSettingsSpecificMenuAction(int n) {
        int n2 = Menu.getSelection();
        switch (n) {
            case 28: {
                switch (n2) {
                    case 0: {
                        this.newgamepanel_humans = Math.min(4, this.newgamepanel_humans + 1);
                        this.newgamepanel_cpus = Math.min(4 - this.newgamepanel_humans, this.newgamepanel_cpus);
                        break;
                    }
                    case 1: {
                        this.newgamepanel_cpus = Math.min(3, this.newgamepanel_cpus + 1);
                        this.newgamepanel_humans = Math.min(4 - this.newgamepanel_cpus, this.newgamepanel_humans);
                        break;
                    }
                    case 2: {
                        if (this.newgamepanel_rounds < 5) {
                            ++this.newgamepanel_rounds;
                            break;
                        }
                        this.newgamepanel_rounds = Math.min(25, this.newgamepanel_rounds + 5);
                        break;
                    }
                    case 3: {
                        this.newgamepanel_difficulty = Math.min(3, this.newgamepanel_difficulty + 1);
                    }
                }
                Menu.scheduleMenuRefresh();
                return true;
            }
            case 27: {
                switch (n2) {
                    case 0: {
                        this.newgamepanel_humans = Math.max(1, this.newgamepanel_humans - 1);
                        if (this.newgamepanel_humans != 1 || this.newgamepanel_cpus != 0) break;
                        this.newgamepanel_cpus = 1;
                        break;
                    }
                    case 1: {
                        this.newgamepanel_cpus = Math.max(0, this.newgamepanel_cpus - 1);
                        if (this.newgamepanel_humans != 1 || this.newgamepanel_cpus != 0) break;
                        this.newgamepanel_humans = 2;
                        break;
                    }
                    case 2: {
                        int n3;
                        int n4;
                        Game game;
                        if (this.newgamepanel_rounds > 5) {
                            Game game2 = this;
                            game = game2;
                            n4 = game2.newgamepanel_rounds;
                            n3 = 5;
                        } else {
                            Game game3 = this;
                            game = game3;
                            n4 = game3.newgamepanel_rounds;
                            n3 = 1;
                        }
                        game.newgamepanel_rounds = n4 - n3;
                        this.newgamepanel_rounds = Math.max(1, this.newgamepanel_rounds);
                        break;
                    }
                    case 3: {
                        this.newgamepanel_difficulty = Math.max(0, this.newgamepanel_difficulty - 1);
                    }
                }
                Menu.scheduleMenuRefresh();
                return true;
            }
        }
        return false;
    }

    private boolean performShopSpecificMenuAction(int n) {
        switch (n) {
            case 28: {
                if (this.mShopCurrentTank != -1) {
                    this.gamestate_players[this.mShopCurrentTank].buy(this.mShopCurrentItem);
                    Menu.scheduleMenuRefresh();
                }
                return true;
            }
            case 27: {
                if (this.mShopCurrentTank != -1) {
                    this.gamestate_players[this.mShopCurrentTank].sell(this.mShopCurrentItem);
                    Menu.scheduleMenuRefresh();
                }
                return true;
            }
        }
        return false;
    }

    public final boolean performMenuAction(int n, int n2) {
        if (Handson.performMenuAction$255f299(n)) {
            return true;
        }
        switch (n) {
            case 35: {
                Menu.changeMenu(0, false);
                return true;
            }
            case 29: {
                this.newgamepanel_startGame_prestep1(false);
                return true;
            }
            case 33: {
                this.newgamepanel_startGame_prestep1(true);
                return true;
            }
            case 30: {
                this.newgamepanel_startGame_prestep2();
                return true;
            }
            case 26: {
                this.shopForAllTanks();
                return true;
            }
            case 36: {
                this.shopDoneShopping();
                return true;
            }
            case 31: {
                return true;
            }
            case 25: {
                int n3 = RM.getValue(82, this.mShopCurrentItem, 12);
                if (n3 == -1) {
                    n3 = 337;
                }
                Menu.replaceMenuItem(19, 0, n3, 0, 0, 0);
                Menu.changeMenu(19, true);
                return true;
            }
            case 27: 
            case 28: {
                switch (Menu.getCurrentMenu()) {
                    case 15: {
                        return this.performGameSettingsSpecificMenuAction(n);
                    }
                    case 18: {
                        return this.performShopSpecificMenuAction(n);
                    }
                }
                return false;
            }
            case 34: {
                this.scoreboard_done();
                return true;
            }
            case 32: {
                this.resumeSaveGame();
                return true;
            }
        }
        return false;
    }

    public final void restart(boolean bl) {
        if (bl) {
            Menu.startLoading(78);
        }
        this.mFrame = 0;
        this.doRestart();
        Menu.saveOptions();
        if (bl) {
            Menu.stopLoading();
        }
    }

    public final long getDesiredFrameTime() {
        return 42L;
    }

    public final void onGameReset() {
        this.gamestate_showTutorial = true;
        this.clearSaveGame();
    }

    public final boolean getCustomMenuItemPosition$1c96c319(int n) {
        return false;
    }

    public final boolean resumeMusicAfterInterrupt() {
        if (Menu.getMode() == 0) {
            if (Menu.getCurrentSplashScreen() > 4) {
                return Menu.getOption(0) > 0;
            }
            return false;
        }
        if (!Handson.resumeMusic()) {
            return false;
        }
        return this.mResumeMusicAfterInterrupt;
    }

    public final int getRuleValueInt(int n) {
        return RM.getValue(83, this.mCurrentRuleset, n);
    }

    private int gamefield_getWeaponSlot() {
        for (int i = 0; i < this.gamefield_weapons.length; ++i) {
            if (this.gamefield_weapons[i] != null) continue;
            return i;
        }
        return -1;
    }

    public final void gamefield_addWeapon(Weapon weapon) {
        int n = this.gamefield_getWeaponSlot();
        if (n != -1) {
            this.gamefield_weapons[n] = weapon;
        }
    }

    private void gamefield_initWithWidth$255f295() {
        this.gamefield_dirtField = new DirtField_RGBBuffer();
        this.gamefield_dirtField.init(Game.gamefield_getWidth(), this.gamefield_getHeight());
        this.mShutterStartFrame = GCanvas.getGlobalFrameCount();
        this.gamefield_tanks = new Tank[4];
        this.gamefield_weapons = new Weapon[250];
    }

    private void gamefield_reset() {
        int n;
        for (n = 0; n < this.gamefield_tanks.length; ++n) {
            this.gamefield_tanks[n] = null;
        }
        for (n = 0; n < this.gamefield_weapons.length; ++n) {
            this.gamefield_weapons[n] = null;
        }
        Weapon.dirtclods_reset();
    }

    private int gamefield_getNextHumanPlayer(int n) {
        ++n;
        while (n < this.gamestate_players.length) {
            if (this.gamestate_players[n] != null && this.gamestate_players[n].controller == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int gamefield_humanPlayers() {
        int n = 0;
        for (int i = 0; i < this.gamefield_tanks.length; ++i) {
            if (this.gamefield_tanks[i] == null) continue;
            ++n;
        }
        return n - this.gamefield_getCpuPlayers();
    }

    private int gamefield_getCpuPlayers() {
        int n = 0;
        for (int i = 0; i < this.gamefield_tanks.length; ++i) {
            if (this.gamefield_tanks[i] == null || this.gamefield_tanks[i].controller != 1) continue;
            ++n;
        }
        return n;
    }

    public final boolean gamefield_isReady() {
        return Game.count(this.gamefield_weapons) == 0 && this.quote_isFinished() && this.gamefield_dirtField.isReady() && Weapon.whiteout_isFinished() && this.sfxSoundReady();
    }

    public final void gamefield_renderExplosion(int n, int n2, int n3, int n4) {
        int n5 = this.logicalToScreenX(n);
        int n6 = this.logicalToScreenY(n2);
        int n7 = this.logicalToDirtFieldX(n3);
        int n8 = n7 * 2;
        int n9 = n5 - n7;
        int n10 = n6 - n7;
        if (n9 + n8 < 0 || n9 > GCanvas.getWidth() || n10 + n8 < 0 || n10 > GCanvas.getHeight()) {
            return;
        }
        int n11 = this.gamefield_numExplosions++;
        n11 = n11 * 3;
        this.gamefield_explosions[n11] = n9;
        this.gamefield_explosions[n11 + 1] = n10;
        this.gamefield_explosions[n11 + 2] = n8;
        this.gamefield_explosions[n11 + 3] = n4;
    }

    private void gamefield_render(Graphics graphics) {
        int n;
        this.viewportGetWidth();
        this.viewportGetHeight();
        if (!GCanvas.cheatEnabled(-1)) {
            this.gamefield_dirtField.renderSky(graphics);
        }
        this.gamefield_dirtField.render(graphics);
        for (n = 0; n < this.gamefield_tanks.length; ++n) {
            if (this.gamefield_tanks[n] == null) continue;
            this.gamefield_tanks[n].render(graphics);
        }
        this.gamefield_numExplosions = 0;
        for (n = 0; n < this.gamefield_weapons.length; ++n) {
            if (this.gamefield_weapons[n] == null) continue;
            this.gamefield_weapons[n].render(graphics);
        }
        this.mSpriteRenderer$6be6c80c.flushBuffer();
        graphics.setColor(GCanvas.getGlobalFrameCount() % 2 == 0 ? 0xA08000 : 0xFFC0C0);
        for (n = 0; n < this.gamefield_numExplosions * 3; n += 3) {
            graphics.fillArc(this.gamefield_explosions[n], this.gamefield_explosions[n + 1], this.gamefield_explosions[n + 2], this.gamefield_explosions[n + 2], 0, 360);
        }
        Weapon.whiteout_render(graphics);
        Weapon.dirtclods_render(graphics);
    }

    private void gamefield_update() {
        int n;
        if (GCanvas.cheatEnabled(-1)) {
            return;
        }
        if (!GCanvas.cheatEnabled(-1)) {
            this.gamefield_dirtField.update();
        }
        if (!GCanvas.cheatEnabled(-1)) {
            for (n = this.gamefield_tanks.length - 1; n >= 0; --n) {
                if (this.gamefield_tanks[n] == null) continue;
                this.gamefield_tanks[n].update();
                if (!this.gamefield_tanks[n].isFinished()) continue;
                Game.removeObject(this.gamefield_tanks, n);
            }
        }
        for (n = this.gamefield_weapons.length - 1; n >= 0; --n) {
            if (this.gamefield_weapons[n] == null) continue;
            this.gamefield_weapons[n].update();
            if (!this.gamefield_weapons[n].isFinished()) continue;
            Game.removeObject(this.gamefield_weapons, n);
        }
        Weapon.dirtclods_update();
        if (Weapon.whiteout_isEnabled()) {
            Weapon.whiteout_update();
            if (Weapon.whiteout_isFinished()) {
                Weapon.whiteout_disable();
            }
        }
        this.quote_update();
    }

    private void gamestate_init() {
        this.gamestate_humans = 1;
        this.gamestate_cpus = 3;
        this.gamestate_difficulty = 1;
        this.gamestate_rounds = 5;
        this.gamestate_vibration = true;
        this.gamestate_players = new Tank[4];
    }

    private static Tank gamestate_presets(int n) {
        Tank tank = new Tank();
        tank.init();
        RM.prepareVarText(14, String.valueOf(n + 1));
        tank.setName(14);
        tank.initQuotes(-1);
        tank.mColorMask = -1;
        tank.setStyle(GCanvas.getRandom(0, 4));
        return tank;
    }

    public final Tank gamestate_currentPlayer() {
        if (this.gamestate_currentPlayerIndex < this.gamestate_players.length) {
            Tank tank = this.gamestate_players[this.gamestate_currentPlayerIndex];
            if (tank.health > 0) {
                return tank;
            }
        }
        return null;
    }

    private void gamestate_nextPlayer() {
        this.mFirstPlayer = false;
        this.sfxReset();
        this.hudWeaponSetDirty();
        this.gamestate_spawnedWeapons = 0;
        int n = this.gamestate_players.length;
        if (n == 0) {
            this.gamestate_currentPlayerIndex = 0;
            return;
        }
        if (++this.gamestate_currentPlayerIndex >= n) {
            this.gamestate_currentPlayerIndex = 0;
        }
        for (int i = 0; this.gamestate_players[this.gamestate_currentPlayerIndex] == null || this.gamestate_players[this.gamestate_currentPlayerIndex].health <= 0 && i <= n; ++i) {
            ++this.gamestate_currentPlayerIndex;
            if (this.gamestate_currentPlayerIndex < n) continue;
            this.gamestate_currentPlayerIndex = 0;
        }
        if (this.gamestate_currentPlayer() != null) {
            if (this.gamestate_currentPlayer().controller == 0) {
                this.centerCameraOnTank(this.gamestate_currentPlayer());
            }
            this.gamestate_currentPlayer().activate();
            this.mCameraTargetWeapon = null;
            this.mCameraTargetWeaponIndex = -1;
        }
    }

    private void gamelayer_init() {
        this.gamefield_initWithWidth$255f295();
        this.gamelayer_gameInProgress = true;
        this.gamelayer_cpuSkip = true;
        this.gamefield_reset();
        this.gamefield_tanks = new Tank[this.gamestate_players.length];
        for (int i = 0; i < this.gamestate_players.length; ++i) {
            this.gamefield_tanks[i] = this.gamestate_players[i];
        }
        this.gamelayer_angleIndicator = new GameSprite(8);
        this.hudWeaponSetDirty();
    }

    private void gamelayer_initWithRandomLandscape() {
        this.gamelayer_initWithRandomLandscape(true);
    }

    private void gamelayer_initWithRandomLandscape(boolean bl) {
        this.gamelayer_init();
        if (bl) {
            this.gamelayer_resetWithRandomLandscape();
        }
    }

    private void gamelayer_resetWithRandomLandscape() {
        this.gamelayer_resetWithRandomLandscape(true);
    }

    private void gamelayer_resetWithRandomLandscape(boolean bl) {
        int n;
        int n2;
        if (bl) {
            this.gamelayer_currentSeed = (int)GCanvas.getUptimeMillis();
        }
        GCanvas.setRandomSeed(this.gamelayer_currentSeed);
        this.gamelayer_gameInProgress = true;
        int n3 = this.gamelayer_randomLandscape();
        this.gamefield_reset();
        if (GCanvas.getRandom(0, 100) < this.getRuleValueInt(15)) {
            this.gamefield_dirtField.createSplineLandscape();
        } else {
            this.gamefield_dirtField.loadLandscapeFromFile(n3);
        }
        int n4 = Game.count(this.gamestate_players);
        int[] nArray = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = n2;
        }
        GCanvas.shuffle(nArray);
        n2 = Game.instance.mAspectRatio / (n4 + 1);
        for (n = 0; n < n4; ++n) {
            Tank tank = this.gamestate_players[n];
            tank.reset();
            tank.setX((nArray[n] + 1) * n2 + GCanvas.getRandom(-100, 100));
            tank.adjustHeightAndAngleForDirtField(this.gamefield_dirtField);
            this.gamefield_tanks[n] = tank;
        }
        n = this.getRuleValueInt(2);
        this.gamestate_wind = GCanvas.getRandom(-1024, 1024) * n >> 10;
        this.chrome_wind = this.gamestate_wind * 10 / 1000000;
        this.gamestate_wind /= 1000000;
        this.gamelayer_chromeVisible = true;
    }

    private int gamelayer_randomLandscape() {
        int n;
        if (this.getRuleValueInt(18) == -1 && this.getRuleValueInt(19) == -1) {
            return -1;
        }
        do {
            int n2;
            int n3;
            if ((n = GCanvas.getRandom(n3 = this.getRuleValueInt(18), (n2 = this.getRuleValueInt(19)) + 1)) <= n2) continue;
            n = n2;
        } while (n == -1 || RM.getWidth(n) == 0 || RM.getHeight(n) == 0);
        return n;
    }

    public final int gamelayer_randomSky() {
        int n;
        while ((n = GCanvas.getRandom(this.getRuleValueInt(22), this.getRuleValueInt(23))) == -1 || RM.getWidth(n) == 0 || RM.getHeight(n) == 0) {
        }
        return n;
    }

    private void gamelayer_update() {
        if (!this.gamestate_atTitleScreen && this.mFirstPlayer && this.gamestate_currentPlayer().controller == 1 && this.mFrame < 30) {
            return;
        }
        if (this.gamelayer_stopped) {
            return;
        }
        this.handleTouchScreenInput();
        this.gamefield_update();
        boolean bl = false;
        int n = 0;
        int n2 = Game.count(this.gamefield_tanks);
        for (int i = 0; i < n2; ++i) {
            if (this.gamefield_tanks[i].health <= 0) continue;
            ++n;
            if (!this.gamefield_tanks[i].falling) continue;
            bl = true;
        }
        if (n <= 1 && this.gamelayer_gameInProgress && this.gamefield_isReady()) {
            this.gamelayer_roundEnded();
        } else {
            n = n2;
            if (n == 0) {
                return;
            }
            if (!bl) {
                Tank tank;
                if (this.gamestate_waitingForWeapons && this.gamefield_isReady()) {
                    this.gamestate_waitingForWeapons = false;
                    this.gamestate_nextPlayer();
                }
                if ((tank = this.gamestate_currentPlayer()) != null && tank.controller == 1 && tank.health > 0 && tank.cpuMove()) {
                    this.gamestate_nextPlayer();
                }
                if ((tank = this.gamestate_currentPlayer()) == null || tank.health <= 0) {
                    this.gamestate_nextPlayer();
                }
            }
        }
        this.gamelayer_checkForCPUSkip();
    }

    private void gamelayer_checkForCPUSkip() {
        boolean bl;
        if (this.gamelayer_cpuSkip && this.gamelayer_gameInProgress && this.gamefield_humanPlayers() == 0 && (bl = this.getRuleValueInt(7) == 1)) {
            int n;
            for (n = 0; n < 5; ++n) {
                this.gamefield_update();
            }
            n = Game.count(this.gamefield_tanks);
            if (this.mFrame % 10 == 0) {
                for (int i = 0; i < n; ++i) {
                    this.gamefield_tanks[i].applyDamage(1, this.gamefield_tanks[i]);
                }
            }
        }
    }

    private void gamelayer_renderAngleIndicator(Graphics graphics) {
        Tank tank;
        if (this.mInputMode == 1 && this.gamelayer_acceptShots() && (tank = this.gamestate_currentPlayer()).getSelectedWeaponKey() != 41) {
            this.gamelayer_angleIndicator.render$417dcfd4(-1);
        }
    }

    private void gamefield_renderBorders(Graphics graphics) {
        int n;
        boolean bl;
        boolean bl2;
        int n2 = this.viewportGetBorderWidth();
        int n3 = this.viewportGetBorderHeight();
        boolean bl3 = bl2 = GCanvas.getGlobalFrameCount() - this.mShutterStartFrame < 10;
        if (n2 > 0) {
            bl = false;
            if (bl2) {
                this.viewportGetWidth();
                n = 0;
            }
            graphics.setColor(this.COLOR_CINEMASCOPE_BAR);
            graphics.fillRect(0, Game.viewportGetTopWithoutBorder(), n2, this.viewportGetBottomWithoutBorder());
            graphics.fillRect(this.viewportGetRight(), Game.viewportGetTopWithoutBorder(), n2, this.viewportGetBottomWithoutBorder());
        }
        boolean bl4 = bl = GCanvas.getGlobalFrameCount() - this.mShutterStartFrame < 10;
        if (n3 > 0 || bl) {
            n = 0;
            if (bl) {
                n = this.viewportGetHeight() >> 1;
                int n4 = (GCanvas.getGlobalFrameCount() - this.mShutterStartFrame << 10) / 10;
                n4 = 1024 - n4;
                n4 = GCanvas.ipGetLambda(n4, 3);
                n = n * n4 >> 10;
            }
            graphics.setColor(this.COLOR_CINEMASCOPE_BAR);
            graphics.fillRect(Game.viewportGetLeftWithoutBorder(), Game.viewportGetTopWithoutBorder(), Game.viewportGetRightWithoutBorder() - Game.viewportGetLeftWithoutBorder(), n3 + n);
            graphics.fillRect(Game.viewportGetLeftWithoutBorder(), this.viewportGetBottom() - n, Game.viewportGetRightWithoutBorder() - Game.viewportGetLeftWithoutBorder(), n3 + n);
            graphics.setColor(this.COLOR_BAR_BORDER);
            graphics.drawLine(Game.viewportGetLeftWithoutBorder(), this.viewportGetTop() - 2 + n, Game.viewportGetRightWithoutBorder(), this.viewportGetTop() - 2 + n);
            graphics.drawLine(Game.viewportGetLeftWithoutBorder(), this.viewportGetBottom() + 1 - n, Game.viewportGetRightWithoutBorder(), this.viewportGetBottom() + 1 - n);
        }
    }

    private void gamefield_renderPostChrome(Graphics graphics) {
        for (int i = 0; i < this.gamefield_tanks.length; ++i) {
            if (this.gamefield_tanks[i] == null) continue;
            this.gamefield_tanks[i].renderPostChrome(graphics);
        }
    }

    private void gamelayer_render(Graphics graphics) {
        GCanvas.pushClip(graphics);
        GCanvas.clipRect(graphics, graphics.getClipX(), this.viewportGetTop(), graphics.getClipWidth(), this.viewportGetHeight());
        this.mSpriteRenderer$6be6c80c.begin(graphics);
        if (!GCanvas.cheatEnabled(-1)) {
            this.gamefield_render(graphics);
        }
        this.mSpriteRenderer$6be6c80c.end();
        GCanvas.popClip(graphics);
        if (!GCanvas.cheatEnabled(-1)) {
            this.gamefield_renderBorders(graphics);
        }
        if (!GCanvas.cheatEnabled(-1)) {
            if (this.gamelayer_chromeVisible) {
                this.chrome_render(graphics);
            }
            this.gamefield_renderPostChrome(graphics);
            this.mSpriteRenderer$6be6c80c.begin(graphics);
            this.gamelayer_renderAngleIndicator(graphics);
            this.mSpriteRenderer$6be6c80c.end();
        }
    }

    private void gamelayer_roundEnded() {
        this.gamestate_roundInProgress = false;
        this.gamelayer_gameInProgress = false;
        ++this.gamestate_round;
        for (int i = 0; i < this.gamestate_players.length; ++i) {
            Tank tank = this.gamestate_players[i];
            if (tank == null) continue;
            if (tank.health > 0) {
                ++tank.wins;
            }
            tank.cash += Math.min(this.getRuleValueInt(9) + this.gamestate_round * this.getRuleValueInt(10), this.getRuleValueInt(11));
        }
        this.gamelayer_chromeVisible = false;
        if (Handson.demoIsActive()) {
            Menu.changeMenu(22, false);
            return;
        }
        this.saveGame();
        this.gamelayer_chromeVisible = false;
        Game.scoreboard_start();
    }

    private static void scoreboard_start() {
        Menu.changeMenu(16, false);
    }

    private void scoreboard_done() {
        if (this.gamestate_round >= this.gamestate_rounds) {
            this.clearSaveGame();
            RM.prepareVarText(18, this.mScoreBoardTanks[0].name);
            Menu.changeMenu(17, false);
            this.eaglview_goToTitleScreen();
            return;
        }
        this.gamelayer_resetWithRandomLandscape();
        this.startShopping();
    }

    private boolean gamelayer_acceptShots() {
        Tank tank = this.gamestate_currentPlayer();
        return tank != null && tank.controller == 0 && tank.health > 0 && this.gamefield_isReady();
    }

    private void gamelayer_updateTankAngleForAngle(int n) {
        Tank tank = this.gamestate_currentPlayer();
        if (n < -100 || n > 100) {
            return;
        }
        n = GCanvas.clamp(n, -90, 90);
        tank.setAngle(n);
        this.gamelayer_setAngleIndicatorFromTank(tank);
    }

    private void gamelayer_updateTankAngle(int n, int n2) {
        Tank tank = this.gamestate_currentPlayer();
        if (tank == null) {
            return;
        }
        Point2D point2D = Point2D.getLocal();
        point2D.set(this.gamefield_dirtField.logicalToScreenX(tank.x), this.gamefield_dirtField.logicalToScreenY(tank.y));
        point2D.set(n - point2D.x, n2 - point2D.y);
        point2D.unit();
        int n3 = GCanvas.mathAtan2Unit(point2D.y, point2D.x);
        Point2D.freeLocal(point2D);
        n3 *= 180;
        n3 /= 512;
        n3 -= tank.body.angle;
        n3 = GCanvas.mathModWrap(n3, 0, 360);
        if (n3 < 90) {
            n3 = 360;
        }
        n3 = GCanvas.clamp(n3, 180, 360);
        n3 += 90;
        if ((n3 %= 360) > 180) {
            n3 -= 360;
        }
        tank.setAngle(n3);
        this.gamelayer_setAngleIndicatorFromTank(tank);
    }

    private void gamelayer_setAngleIndicatorFromTank(Tank tank) {
        this.gamelayer_angleIndicator.angle = tank.barrel.angle;
        this.gamelayer_angleIndicator.x = tank.body.x;
        this.gamelayer_angleIndicator.y = tank.body.y;
    }

    private void gamelayer_fireWithPower(int n) {
        Tank tank = this.gamestate_currentPlayer();
        tank.fireWithPower(n);
        this.gamestate_waitingForWeapons = true;
    }

    private void gamelayer_previousWeapon() {
        if (this.gamelayer_acceptShots()) {
            this.mOldWeapon = this.gamestate_currentPlayer().getSelectedWeaponKey();
            this.gamestate_currentPlayer().previousWeapon();
            this.mWeaponChangeFrame = this.mFrame;
            this.mWeaponChangeUp = true;
            this.hudWeaponSetDirty();
        }
    }

    private void gamelayer_nextWeapon() {
        if (this.gamelayer_acceptShots()) {
            this.mOldWeapon = this.gamestate_currentPlayer().getSelectedWeaponKey();
            this.gamestate_currentPlayer().nextWeapon();
            this.mWeaponChangeFrame = this.mFrame;
            this.mWeaponChangeUp = false;
            this.hudWeaponSetDirty();
        }
    }

    private void gamelayer_touchBeganAtX(int n, int n2) {
        if (n >= this.viewportGetLeft() && n <= this.viewportGetRight() && n2 >= this.viewportGetTop() && n2 <= this.viewportGetBottom() && this.gamelayer_acceptShots()) {
            this.gamelayer_updateTankAngle(n, n2);
        }
    }

    private void gamelayer_touchMovedToX(int n, int n2) {
        if (n >= this.viewportGetLeft() && n <= this.viewportGetRight() && n2 >= this.viewportGetTop() && n2 <= this.viewportGetBottom() && this.gamelayer_acceptShots()) {
            this.gamelayer_updateTankAngle(n, n2);
        }
    }

    private void gamelayer_updateSwipeCamera() {
        if (this.mCurrentUpdateIteration > 0) {
            return;
        }
        if (this.mSwipeSpeedX != 0 && this.mInputMode == 0) {
            int n = this.gamefield_dirtField.mViewX + this.mSwipeSpeedX;
            this.gamefield_dirtField.setViewTopLeft(n, this.gamefield_dirtField.mViewY);
            this.mSwipeSpeedX = this.mSwipeSpeedX * 95 / 100;
        }
    }

    private void gamelayer_initSwipeCamera(int n) {
        this.mSwipeCameraLastX = n;
        this.mSwipeSpeedX = 0;
    }

    private void gamelayer_updateSwipeCamera(int n) {
        if (this.mSwipeCameraLastX == -1) {
            this.mSwipeCameraLastX = n;
        }
        this.mSwipeSpeedX = this.mSwipeCameraLastX - n;
        this.mSwipeCameraLastX = n;
    }

    private void gamelayer_releaseSwipeCamera() {
        this.mSwipeCameraLastX = -1;
    }

    private void resetTouchScreenQueue() {
        this.mCurrentTouchScreenEvent = GCanvas.sCurrentTouchscreenEvent;
        this.sInternalHotspotId = -1;
        this.mPressedContKey = -1;
    }

    private void handleTouchScreenInput() {
        if (this.gamestate_atTitleScreen) {
            return;
        }
        if (this.mCurrentUpdateIteration > 0) {
            return;
        }
        if (this.mCurrentTouchScreenEvent == -1) {
            this.mCurrentTouchScreenEvent = GCanvas.sCurrentTouchscreenEvent;
        }
        if (this.mCurrentTouchScreenEvent == -1) {
            return;
        }
        while (this.mCurrentTouchScreenEvent != GCanvas.sCurrentTouchscreenEvent) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            ++this.mCurrentTouchScreenEvent;
            if (this.mCurrentTouchScreenEvent >= 40) {
                this.mCurrentTouchScreenEvent = 0;
            }
            int n4 = this.mCurrentTouchScreenEvent * 3;
            n = GCanvas.sTouchscreenEvents[n4];
            n2 = GCanvas.sTouchscreenEvents[n4 + 1];
            n3 = GCanvas.sTouchscreenEvents[n4 + 2];
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    this.sInternalHotspotId = Menu.pickHotspots(n2, n3, 0x4000000);
                    this.mPressedContKey = Menu.pickHotspots(n2, n3, 0x8000000);
                    if (this.mPressedContKey != -1) {
                        GCanvas.simulateVKeyPressTouch(this.mPressedContKey);
                    } else {
                        if (this.mInputMode == 1) {
                            this.gamelayer_touchBeganAtX(n2, n3);
                            break;
                        }
                        this.gamelayer_initSwipeCamera(n2);
                        break;
                    }
                }
                case 2: {
                    if (this.mPressedContKey != -1) break;
                    if (this.mInputMode == 1) {
                        this.gamelayer_touchMovedToX(n2, n3);
                        break;
                    }
                    this.gamelayer_updateSwipeCamera(n2);
                    break;
                }
                case 3: {
                    n4 = Menu.pickHotspots(n2, n3, 0x4000000);
                    if (n4 > 0 && n4 == this.sInternalHotspotId) {
                        GCanvas.simulateVKeyPress(n4);
                    }
                    if (this.mPressedContKey != -1) {
                        GCanvas.simulateVKeyReleaseTouch(this.mPressedContKey);
                        break;
                    }
                    if (this.mInputMode == 1) break;
                    this.gamelayer_releaseSwipeCamera();
                }
            }
            if (this.mInputMode == 1) continue;
            n4 = this.gamefield_dirtField.mViewX + this.mSwipeSpeedX;
            this.gamefield_dirtField.setViewTopLeft(n4, this.gamefield_dirtField.mViewY);
        }
    }

    private void titlescreen_initWithEAGLView() {
        int n;
        this.gamelayer_initWithRandomLandscape();
        this.gamelayer_cpuSkip = false;
        Game.removeAllObjects(this.gamestate_players);
        Game.removeAllObjects(this.gamefield_tanks);
        for (n = 0; n < 4; ++n) {
            Tank tank = new Tank();
            tank.titlescreentank_init();
            tank.setX(Game.instance.mAspectRatio / 5 * (n + 1));
            tank.adjustHeightAndAngleForDirtField(this.gamefield_dirtField);
            tank.mColorMask = sPlayerColors[n];
            Game.addObject(this.gamestate_players, tank);
            Game.addObject(this.gamefield_tanks, tank);
        }
        for (n = 0; n < this.gamestate_players.length; ++n) {
            if (this.gamestate_players[n] == null) continue;
            this.gamestate_players[n].setStyle(GCanvas.mathWrap(n, 0, 3));
        }
        this.gamelayer_chromeVisible = false;
    }

    private void eaglview_goToTitleScreen() {
        if (this.mDrawingFinalSplash) {
            this.mDrawingFinalSplash = false;
            return;
        }
        if (!this.gamestate_atTitleScreen) {
            this.gamestate_atTitleScreen = true;
            this.gamefield_fullscreen = true;
            this.titlescreen_initWithEAGLView();
        }
    }

    private void eaglview_startGame(boolean bl) {
        this.gamestate_gravity = 20 * this.getRuleValueInt(8) / 100;
        this.gamestate_currentPlayerIndex = 0;
        this.gamestate_atTitleScreen = false;
        this.gamefield_fullscreen = false;
        this.mLastFrameWithLogicsound = -1;
        this.gamelayer_initWithRandomLandscape(bl);
    }

    private void newgamepanel_saveSettings() {
        Tank tank;
        int n;
        this.gamestate_humans = this.newgamepanel_humans;
        this.gamestate_cpus = this.newgamepanel_cpus;
        this.gamestate_rounds = this.newgamepanel_rounds > 20 ? 1000000 : this.newgamepanel_rounds;
        this.gamestate_difficulty = this.newgamepanel_difficulty;
        Game.removeAllObjects(this.gamestate_players);
        for (n = 0; n < this.newgamepanel_humans; ++n) {
            tank = Game.gamestate_presets(n);
            Game.gamestate_presets(n).controller = 0;
            Game.addObject(this.gamestate_players, tank);
            tank.cash = this.getRuleValueInt(9);
            tank.wins = 0;
            tank.kills = 0;
            tank.deaths = 0;
            tank.healthVisible = true;
            tank.falling = false;
            tank.mColorMask = sPlayerColors[n];
            tank.resetWeapons();
        }
        this.newgamepanel_createAndShuffleCpuTanks();
        for (n = 0; n < this.newgamepanel_cpus; ++n) {
            tank = this.newgamepanel_cpuTanks[n];
            this.newgamepanel_cpuTanks[n].healthVisible = true;
            Game.addObject(this.gamestate_players, tank);
        }
        for (n = 0; n < this.gamestate_players.length; ++n) {
            if (this.gamestate_players[n] == null) continue;
            this.gamestate_players[n].setStyle(GCanvas.mathWrap(n, 0, 3));
        }
    }

    private void saveGame() {
        int n;
        int n2 = 0;
        int n3 = Game.count(this.gamestate_players);
        for (n = 0; n < n3; ++n) {
            n2 += this.gamestate_players[n].getNumWeapons();
        }
        n = 8 + n3 * 7 + n2 * 2;
        int[] nArray = new int[n];
        this.mSaveGame = nArray;
        nArray[0] = this.gamestate_humans;
        nArray[1] = this.gamestate_cpus;
        nArray[2] = this.gamestate_rounds;
        nArray[4] = this.gamestate_roundInProgress ? 0 : 1;
        nArray[3] = this.gamestate_round;
        nArray[5] = this.gamestate_difficulty;
        nArray[6] = this.gamelayer_currentSeed;
        nArray[7] = this.gamestate_showTutorial ? 1 : 0;
        int n4 = 8;
        for (int i = 0; i < n3; ++i) {
            String cfr_ignored_0 = "savegame index for tank " + n4;
            Tank tank = this.gamestate_players[i];
            nArray[n4 + 0] = tank.cash;
            nArray[n4 + 1] = tank.wins;
            nArray[n4 + 2] = tank.style;
            nArray[n4 + 3] = tank.kills;
            nArray[n4 + 4] = tank.deaths;
            nArray[n4 + 6] = tank.tankid;
            String cfr_ignored_1 = "cash " + tank.cash;
            String cfr_ignored_2 = "wins " + tank.wins;
            String cfr_ignored_3 = "kills " + tank.kills;
            String cfr_ignored_4 = "deaths " + tank.deaths;
            String cfr_ignored_5 = "tankid " + tank.tankid;
            int n5 = tank.getNumWeapons();
            nArray[n4 + 5] = tank.getNumWeapons();
            n4 += 7;
            int n6 = tank.getNextWeapon(-1);
            for (int j = 0; j < n5; ++j) {
                nArray[n4 + 0] = tank.mWeapons[n6];
                nArray[n4 + 1] = tank.mWeaponCounts[n6];
                n4 += 2;
                n6 = tank.getNextWeapon(n6);
            }
        }
        RM.setRMS(2, nArray);
        RM.saveStore(2);
    }

    private void clearSaveGame() {
        this.mSaveGame = new int[1];
        RM.setRMS(2, this.mSaveGame);
        RM.saveStore(2);
        Menu.refreshMenu();
    }

    private void checkForSaveGame() {
        this.mSaveGame = RM.getRMSInts(2);
        if (this.mSaveGame != null && this.mSaveGame.length >= 8) {
            this.gamestate_showTutorial = this.mSaveGame[7] > 0;
            return;
        }
        this.gamestate_showTutorial = true;
    }

    private boolean isSaveGameResumable() {
        boolean bl;
        if (Handson.demoIsActive()) {
            return false;
        }
        int[] nArray = this.mSaveGame;
        if (this.mSaveGame == null) {
            return false;
        }
        int n = nArray[2];
        int n2 = nArray[3];
        boolean bl2 = bl = nArray[4] == 1;
        return n2 < n || !bl;
    }

    private boolean loadGame() {
        int n;
        Tank tank;
        int n2;
        int[] nArray = this.mSaveGame;
        if (this.mSaveGame == null) {
            return false;
        }
        boolean bl = false;
        this.gamestate_humans = nArray[0];
        this.gamestate_cpus = nArray[1];
        this.gamestate_rounds = nArray[2];
        this.gamestate_round = nArray[3];
        bl = nArray[4] == 1;
        this.gamestate_difficulty = nArray[5];
        this.gamelayer_currentSeed = nArray[6];
        this.gamestate_showTutorial = nArray[7] > 0;
        Game.removeAllObjects(this.gamestate_players);
        int n3 = 8;
        for (n2 = 0; n2 < this.gamestate_humans; ++n2) {
            String cfr_ignored_0 = "savegame index for human tank " + n3;
            String cfr_ignored_1 = "Human tank " + n2;
            tank = Game.gamestate_presets(n2);
            Game.gamestate_presets(n2).controller = 0;
            tank.mColorMask = sPlayerColors[n2];
            Game.addObject(this.gamestate_players, tank);
            n = nArray[n3 + 5];
            n3 = Game.loadTank(tank, nArray, n3, true);
            n3 = Game.loadTankWeapons(tank, n, nArray, n3);
        }
        this.newgamepanel_createCpuTanks();
        for (n2 = 0; n2 < this.gamestate_cpus; ++n2) {
            String cfr_ignored_2 = "savegame index for CPU tank " + n3;
            String cfr_ignored_3 = "CPU tankid " + nArray[n3 + 6];
            this.newgamepanel_initCpuTank(n2, nArray[n3 + 6]);
            tank = this.newgamepanel_cpuTanks[n2];
            n = nArray[n3 + 5];
            n3 = Game.loadTank(tank, nArray, n3, false);
            Game.addObject(this.gamestate_players, tank);
            n3 = Game.loadTankWeapons(tank, n, nArray, n3);
        }
        return bl;
    }

    private static int loadTankWeapons(Tank tank, int n, int[] nArray, int n2) {
        tank.resetWeapons();
        for (int i = 0; i < n; ++i) {
            tank.setWeapon(nArray[n2 + 0], nArray[n2 + 1]);
            n2 += 2;
        }
        return n2;
    }

    private static int loadTank(Tank tank, int[] nArray, int n, boolean bl) {
        tank.cash = nArray[n + 0];
        tank.wins = nArray[n + 1];
        if (bl) {
            tank.setStyle(nArray[n + 2]);
        }
        tank.kills = nArray[n + 3];
        tank.deaths = nArray[n + 4];
        tank.healthVisible = true;
        String cfr_ignored_0 = "cash " + tank.cash;
        String cfr_ignored_1 = "wins " + tank.wins;
        String cfr_ignored_2 = "kills " + tank.kills;
        String cfr_ignored_3 = "deaths " + tank.deaths;
        return n + 7;
    }

    private void newgamepanel_createCpuTanks() {
        if (this.newgamepanel_cpuTanks == null) {
            this.newgamepanel_cpuTanks = new Tank[4];
            for (int i = 0; i < 4; ++i) {
                this.newgamepanel_cpuTanks[i] = new Tank();
                this.newgamepanel_cpuTanks[i].init();
            }
        }
    }

    private void newgamepanel_initCpuTank(int n, int n2) {
        this.newgamepanel_cpuTanks[n].init();
        Tank tank = this.newgamepanel_cpuTanks[n];
        tank.setName(RM.getValue(84, n2, 0));
        tank.mColorMask = RM.getValue(84, n2, 5);
        tank.initQuotes(n2);
        tank.setStyle(RM.getValue(84, n2, 1));
        tank.kills = 0;
        tank.deaths = 0;
        tank.wins = 0;
        tank.falling = false;
    }

    private void newgamepanel_createAndShuffleCpuTanks() {
        this.newgamepanel_createCpuTanks();
        int[] nArray = GCanvas.getUniqueRandomValues(0, RM.getHeight(84), 4);
        for (int i = 0; i < 4; ++i) {
            this.newgamepanel_initCpuTank(i, nArray[i]);
        }
    }

    private void newgamepanel_startGame() {
        System.err.println("Resetting touchscreen queue");
        this.mCurrentTouchScreenEvent = -1;
    }

    private void newgamepanel_startGame_prestep1(boolean bl) {
        int n;
        if (!bl && this.evaluateCondition(7, 0) == 1) {
            n = 20;
        } else {
            this.gamestate_round = 0;
            n = 15;
        }
        Menu.changeMenu(n, true);
    }

    private void shopDoneShopping() {
        if (this.gamestate_showTutorial) {
            this.gamestate_showTutorial = false;
            Menu.changeMenu(21, false);
            return;
        }
        this.startRound();
    }

    private void setupInitialInputMode() {
        this.mInputMode = 1;
        this.gamelayer_setAngleIndicatorFromTank(this.gamestate_currentPlayer());
    }

    private void startRound() {
        this.mFirstPlayer = true;
        this.sfxReset();
        this.gamestate_roundInProgress = true;
        if (this.gamestate_round > 0) {
            this.gamelayer_resetWithRandomLandscape();
            Menu.performMenuAction(9, -1);
        } else {
            this.newgamepanel_startGame_prestep3(true);
        }
        this.saveGame();
        this.centerCameraOnTank(this.gamestate_currentPlayer());
        this.setupInitialInputMode();
        this.resetDoubleTappingControls();
        this.hudWeaponSetDirty();
    }

    private void resetDoubleTappingControls() {
        this.chrome_power = 0;
        this.chrome_powerVisible = false;
    }

    private void resumeSaveGame() {
        this.newgamepanel_startGame_prestep3(false);
        if (this.loadGame()) {
            this.startShopping();
            return;
        }
        this.gamelayer_resetWithRandomLandscape(false);
        this.mCameraX = -1;
        this.centerCameraOnTank(this.gamestate_currentPlayer());
        this.setupInitialInputMode();
        this.resetDoubleTappingControls();
    }

    private void shopForAllTanks() {
        this.mShopCurrentTank = this.gamefield_getNextHumanPlayer(this.mShopCurrentTank);
        if (this.mShopCurrentTank == -1) {
            this.shopDoneShopping();
            return;
        }
        if (Menu.getCurrentMenu() == 18) {
            Menu.setSelection(0);
        }
        Menu.changeMenu(18, false);
    }

    private void startShopping() {
        Tank.shopCPU();
        this.mShopCurrentTank = -1;
        this.shopForAllTanks();
    }

    private void newgamepanel_startGame_prestep2() {
        this.newgamepanel_saveSettings();
        this.startShopping();
    }

    private void newgamepanel_startGame_prestep3(boolean bl) {
        Menu.performMenuAction(9, -1);
        this.eaglview_startGame(bl);
    }

    private static int interpolateColor(int n, int n2, int n3) {
        int n4 = (n & 0xFF0000) >> 6;
        int n5 = (n & 0xFF00) << 2;
        int n6 = (n & 0xFF) << 10;
        int n7 = (n2 & 0xFF0000) >> 6;
        int n8 = (n2 & 0xFF00) << 2;
        int n9 = (n2 & 0xFF) << 10;
        int n10 = n4 * (1024 - n3) + n7 * n3 >> 20;
        int n11 = n5 * (1024 - n3) + n8 * n3 >> 20;
        int n12 = n6 * (1024 - n3) + n9 * n3 >> 20;
        return n10 << 16 | n11 << 8 | n12;
    }

    private static int gamefield_getWidth() {
        return 176;
    }

    private int gamefield_getBorderSafeHeight(int n) {
        if (this.gamefield_fullscreen && n < GCanvas.getHeight()) {
            int n2 = GCanvas.getFontHeight(0) + 2;
            int n3 = GCanvas.getHeight() - 2 * n2;
            n = Math.min(n, n3);
        }
        return n;
    }

    private int gamefield_getHeight() {
        int n = this.viewportGetBottomWithoutBorder() - Game.viewportGetTopWithoutBorder();
        n = Math.min(n, 220);
        return this.gamefield_getBorderSafeHeight(n);
    }

    public final int viewportGetTop() {
        return Game.viewportGetTopWithoutBorder() + this.viewportGetBorderHeight();
    }

    private int viewportGetBottom() {
        return this.viewportGetBottomWithoutBorder() - this.viewportGetBorderHeight();
    }

    public final int viewportGetLeft() {
        return Game.viewportGetLeftWithoutBorder() + this.viewportGetBorderWidth();
    }

    private int viewportGetRight() {
        return Game.viewportGetRightWithoutBorder() - this.viewportGetBorderWidth();
    }

    private int viewportGetBorderHeight() {
        int n = this.viewportGetBottomWithoutBorder() - Game.viewportGetTopWithoutBorder();
        int n2 = n - this.gamefield_dirtField.mPixelHeight;
        n2 = Math.max(0, n2);
        if (!this.gamefield_fullscreen) {
            return n2;
        }
        if ((n2 & 1) == 1) {
            ++n2;
        }
        return n2 >> 1;
    }

    private int viewportGetBorderWidth() {
        int n = Game.viewportGetRightWithoutBorder() - Game.viewportGetLeftWithoutBorder();
        int n2 = n - this.gamefield_dirtField.mPixelWidth;
        if (((n2 = Math.max(0, n2)) & 1) == 1) {
            ++n2;
        }
        return n2 >> 1;
    }

    private static int viewportGetTopWithoutBorder() {
        return 0;
    }

    private int viewportGetBottomWithoutBorder() {
        int n = GCanvas.getSpriteHeight(0);
        int n2 = 4 + Math.max(GCanvas.getFontHeight(1), n);
        int n3 = this.gamefield_fullscreen ? GCanvas.getHeight() : GCanvas.getHeight() - GCanvas.getFontHeight(0) - 4 - n2;
        return n3;
    }

    private static int viewportGetLeftWithoutBorder() {
        return 0;
    }

    private static int viewportGetRightWithoutBorder() {
        return GCanvas.getWidth();
    }

    public final int viewportGetWidth() {
        return this.viewportGetRight() - this.viewportGetLeft();
    }

    public final int viewportGetHeight() {
        return this.viewportGetBottom() - this.viewportGetTop();
    }

    private boolean chrome_drawPlayerControls() {
        return this.mInputMode == 1 && this.gamelayer_acceptShots();
    }

    private void hudWeaponSetDirty() {
        this.mRedrawWeaponHud = true;
    }

    private void chrome_render(Graphics graphics) {
        int n;
        int n2;
        int n3;
        String string;
        int n4;
        Graphics graphics2;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = 50 * GCanvas.getWidth() >> 10;
        int n12 = 0x883300;
        int n13 = 0xFF0000;
        int n14 = GCanvas.getWidth();
        int n15 = GCanvas.getHeight();
        int n16 = GCanvas.getSpriteHeight(0);
        int n17 = n14 >> 1;
        int n18 = n14;
        int n19 = n15;
        int n20 = GCanvas.getFontHeight(0) + 4;
        graphics.setColor(this.COLOR_BAR_BORDER);
        graphics.drawLine(0, n19 -= n20, n14, n19);
        int n21 = 0;
        n21 = 4 + Math.max(GCanvas.getFontHeight(1), n16);
        int n22 = n19 - n21 / 2;
        int n23 = n19 - n21 + 1;
        int n24 = n21 - 1;
        if (this.mRedrawWeaponHud || this.mWeaponChangeFrame != -1 && this.mOldWeapon != -1) {
            graphics.drawLine(0, n19 - n21, n14, n19 - n21);
            graphics.setColor(this.COLOR_BAR);
            graphics.fillRect(0, n23, n14, n21 - 1);
        }
        this.quote_render(graphics, n23);
        int n25 = n19 - n21 + 1;
        int n26 = n21 - 1;
        Tank tank = this.gamestate_currentPlayer();
        String string2 = null;
        int n27 = 0;
        if (tank == null) {
            string2 = "";
        } else {
            int n28;
            n10 = tank.controller == 1 ? 1 : 0;
            n9 = tank.getSelectedWeaponKey();
            n8 = tank.getSelectedWeaponAmmo();
            if (n9 == -1) {
                tank.nextWeapon();
                n9 = tank.getSelectedWeaponKey();
                n8 = tank.getSelectedWeaponAmmo();
            }
            string2 = RM.t(RM.getValue(82, n9, 0));
            if (n10 == 0 && n8 >= 0) {
                string2 = string2 + " X" + String.valueOf(n8);
            }
            if (this.chrome_powerVisible && this.gamestate_currentPlayer().controller == 0) {
                n28 = 0;
                n7 = GCanvas.div(this.chrome_power, 10240000);
                n6 = GCanvas.mul(n7, n18 - 0);
                n5 = Game.interpolateColor(n12, n13, n7);
                graphics.setColor(n5);
                graphics.fillRect(0, n23, n6, n24);
                GCanvas.drawString(graphics, 0, String.valueOf(n7 * 100 >> 10), n17, n23 - 2, 40);
                GCanvas.drawString(graphics, 0, "%", n17 + 1, n23 - 2, 36);
            }
            if (this.chrome_drawPlayerControls()) {
                n28 = GCanvas.getSpriteHeight(0) / 2;
                n7 = GCanvas.getSpriteWidth(0);
                GCanvas.drawSprite(graphics, 0, n11, n22, 0, n28, 0);
                GCanvas.drawSprite(graphics, 0, n18 - n11, n22, n7, n28, 1);
            }
        }
        if (this.mWeaponChangeFrame != -1 && this.mOldWeapon != -1) {
            int n29;
            n10 = (this.mFrame - this.mWeaponChangeFrame << 10) / 5;
            n10 = GCanvas.ipGetLambda(n10, 2);
            n9 = Math.max(GCanvas.getFontHeight(0), n16);
            n8 = n10 * n9 >> 10;
            String string3 = RM.t(RM.getValue(82, this.mOldWeapon, 0));
            n7 = tank.getWeaponAmmo(this.mOldWeapon);
            if (n7 >= 0) {
                string3 = string3 + " X" + String.valueOf(n7);
            }
            GCanvas.pushClip(graphics);
            graphics.setClip(0, n25, n14, n26);
            if (this.mWeaponChangeUp) {
                n6 = n22 - n8;
                n29 = n22 + n9 - n8;
            } else {
                n6 = n22 + n8;
                n29 = n22 - n9 + n8;
            }
            n5 = n29;
            GCanvas.drawString(graphics, 1, string3, n17, n6, 3);
            GCanvas.drawString(graphics, 1, string2, n17, n5, 3);
            if (n10 == 1024) {
                this.mWeaponChangeFrame = -1;
                this.mOldWeapon = -1;
            }
            GCanvas.popClip(graphics);
        } else if (this.mRedrawWeaponHud) {
            GCanvas.drawString(graphics, 1, string2, n17, n22, 3);
        }
        n27 = Math.max(8, 0);
        n10 = GCanvas.getFontHeight(1);
        n19 = n10 / 2;
        RM.prepareVarText(17, String.valueOf(Math.abs(this.chrome_wind)));
        n9 = 0;
        if (n19 - n10 < 0) {
            n9 = 1;
            graphics2 = graphics;
            n4 = 1;
            string = RM.t(17);
            n3 = n27;
            n2 = n19;
            n = 6;
        } else {
            graphics2 = graphics;
            n4 = 1;
            string = RM.t(17);
            n3 = n27;
            n2 = n19;
            n = 36;
        }
        GCanvas.drawString(graphics2, n4, string, n3, n2, n);
        if (this.chrome_wind != 0) {
            n8 = GCanvas.getStringWidth(RM.t(17), 1);
            int n30 = 17;
            if (n9 != 0) {
                n27 += n8 + 3;
                n30 = 6;
            } else {
                n27 += n8 >> 1;
            }
            GCanvas.drawImage(graphics, this.chrome_wind > 0 ? 22 : 23, n27, n19, n30);
        }
        if (this.mRedrawWeaponHud) {
            this.mRedrawWeaponHud = false;
        }
    }

    private void chrome_firePressed() {
        if (this.chrome_power >= 1024000) {
            this.gamelayer_fireWithPower(this.chrome_power);
        }
        this.chrome_power = 0;
        this.chrome_powerVisible = false;
    }

    private void centerCameraOnTank(Tank tank) {
        this.mCameraTargetX = this.logicalToDirtFieldX(tank.x);
    }

    private void centerCameraOnWeapons(int n) {
        if (this.mCameraTargetWeapon == null) {
            for (int i = 0; i < n; ++i) {
                if (this.gamefield_weapons[i].xv == 0) continue;
                this.mCameraTargetWeaponIndex = i;
                this.mCameraTargetWeapon = this.gamefield_weapons[i];
                break;
            }
        }
        if (this.mCameraTargetWeapon != null && this.gamefield_weapons[this.mCameraTargetWeaponIndex] == this.mCameraTargetWeapon) {
            this.mCameraTargetX = this.logicalToDirtFieldX(this.mCameraTargetWeapon.x);
        }
    }

    private void clampCamera() {
        int n = GCanvas.getWidth() >> 1;
        this.mCameraX = GCanvas.clamp(this.mCameraX, n, this.gamefield_dirtField.mPixelWidth - n);
        this.mCameraTargetX = GCanvas.clamp(this.mCameraTargetX, n, this.gamefield_dirtField.mPixelWidth - n);
    }

    private void setCamera(int n) {
        this.mCameraTargetX = n;
        this.mCameraX = n;
        this.clampCamera();
        this.gamefield_dirtField.setViewTopLeft(this.mCameraX - (GCanvas.getWidth() >> 1), 0);
    }

    private void updateCamera() {
        int n = Game.count(this.gamefield_weapons);
        if (n > 0) {
            this.centerCameraOnWeapons(n);
        }
        if (this.mCameraX != this.mCameraTargetX) {
            int n2;
            Game game;
            int n3 = (this.mCameraTargetX - this.mCameraX) / 3;
            if (Math.abs(n3) > 0) {
                Game game2 = this;
                game = game2;
                n2 = game2.mCameraX + n3;
            } else {
                game = this;
                n2 = this.mCameraTargetX;
            }
            game.mCameraX = n2;
            this.clampCamera();
            this.gamefield_dirtField.setViewTopLeft(this.mCameraX - (GCanvas.getWidth() >> 1), 0);
        }
    }

    private void updateInput() {
        switch (this.mInputMode) {
            case 0: {
                int n;
                if ((GCanvas.isRIGHT() ? 1 : (n = GCanvas.isLEFT() ? -1 : 0)) == 0) break;
                int n2 = this.mCameraTargetX;
                this.setCamera(n2 += n * 10);
                this.hudWeaponSetDirty();
                return;
            }
            case 1: {
                Tank tank = this.gamestate_currentPlayer();
                if (tank == null || tank.controller != 0) break;
                if (GCanvas.consumeUP()) {
                    this.gamelayer_previousWeapon();
                    return;
                }
                if (GCanvas.consumeDOWN()) {
                    this.gamelayer_nextWeapon();
                    return;
                }
                if (tank.getSelectedWeaponKey() == 41) {
                    this.updateDriving(tank);
                    return;
                }
                this.updateAiming(tank);
                this.updateShooting();
            }
        }
    }

    private void updateShooting() {
        block8: {
            Game game;
            block7: {
                block6: {
                    if (this.mInputMode != 1 || !this.gamelayer_acceptShots()) {
                        return;
                    }
                    if (!GCanvas.isFIRE()) break block6;
                    if (!this.chrome_powerVisible) {
                        this.chrome_powerVisible = true;
                    }
                    int n = 230400;
                    this.chrome_power = Math.min(this.chrome_power + n, 10240000);
                    if (this.chrome_power == 10240000) {
                        this.chrome_firePressed();
                    }
                    game = this;
                    break block7;
                }
                if (!this.chrome_powerVisible) break block8;
                this.chrome_firePressed();
                this.chrome_powerVisible = false;
                game = this;
            }
            game.hudWeaponSetDirty();
        }
    }

    private void updateAiming(Tank tank) {
        int n;
        int n2 = 0;
        if (GCanvas.isLEFT()) {
            n = -1;
        } else if (GCanvas.isRIGHT()) {
            n = n2 = 1;
        }
        if (n2 == 0 || n2 != this.mDeltaAngleLastDir) {
            this.mDeltaAngle = 1;
            this.mDeltaAngleSpeedIncreaseFrames = 0;
            this.mDeltaAngleLastDir = 0;
            this.mDeltaAngleLastDir = n2;
        }
        if (n2 != 0) {
            this.gamelayer_updateTankAngleForAngle(tank.angle + n2 * this.mDeltaAngle);
            ++this.mDeltaAngleSpeedIncreaseFrames;
            if (this.mDeltaAngleSpeedIncreaseFrames >= 4) {
                this.mDeltaAngleSpeedIncreaseFrames = 0;
                ++this.mDeltaAngle;
            }
        }
    }

    private void updateDriving(Tank tank) {
        int n = tank.getSelectedWeaponAmmo();
        if (n <= 0) {
            return;
        }
        if (GCanvas.isLEFT() ? tank.driveLeft() : GCanvas.isRIGHT() && tank.driveRight()) {
            tank.setSelectedWeaponAmmo(n - 1);
            this.hudWeaponSetDirty();
        }
    }

    private static void removeObject(Object[] objectArray, int n) {
        if (objectArray != null) {
            for (int i = n; i < objectArray.length - 1; ++i) {
                objectArray[i] = objectArray[i + 1];
                if (objectArray[i] == null) break;
            }
            objectArray[objectArray.length - 1] = null;
        }
    }

    private static void removeAllObjects(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = null;
            }
        }
    }

    private static void addObject(Object[] objectArray, Object object) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) continue;
                objectArray[i] = object;
                return;
            }
        }
    }

    public static final int count(Object[] objectArray) {
        int n = 0;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length && objectArray[i] != null; ++i) {
                ++n;
            }
        }
        return n;
    }

    public final int logicalToScreenX(int n) {
        return this.gamefield_dirtField.logicalToScreenX(n);
    }

    public final int logicalToScreenY(int n) {
        return this.gamefield_dirtField.logicalToScreenY(n);
    }

    private int logicalToDirtFieldX(int n) {
        return this.gamefield_dirtField.logicalToDirtFieldX(n);
    }

    public static int fastSin(int n) {
        int n2 = n * 1024 / 360;
        return GCanvas.sin(n2);
    }

    public static int fastCos(int n) {
        int n2 = n * 1024 / 360;
        return GCanvas.cos(n2);
    }

    public static int atan2(int n, int n2) {
        int n3 = GCanvas.mathAtan2Unit(n, n2);
        return n3 * 360 / 1024;
    }

    public final boolean drawCustomSoftkeyLeft$276ff40f() {
        return GCanvas.cheatEnabled(-1);
    }

    public final boolean drawCustomSoftkeyRight$276ff40f() {
        if (GCanvas.cheatEnabled(-1)) {
            return true;
        }
        return Menu.getMode() == 2;
    }

    private void sfxReset() {
        if (this.gamestate_atTitleScreen) {
            return;
        }
        for (int i = 0; i < this.mSfxPlayed.length; ++i) {
            this.mSfxPlayed[i] = false;
        }
    }

    private boolean sfxSoundReady() {
        return this.gamefield_humanPlayers() == 0 || GCanvas.getGlobalFrameCount() - this.mLastFrameWithLogicsound >= 10;
    }

    public final void sfxPlayLogicSound(int n, int n2) {
        if (this.gamestate_atTitleScreen) {
            return;
        }
        if (this.gamefield_humanPlayers() == 0) {
            return;
        }
        int n3 = RM.getValue(34, n, 2);
        if (this.mSfxPlayed[n2]) {
            return;
        }
        this.mSfxPlayed[n2] = true;
        int n4 = GCanvas.getGlobalFrameCount();
        if (n3 != 1 && this.mLastFrameWithLogicsound >= 0 && n4 - this.mLastFrameWithLogicsound < 10) {
            return;
        }
        this.mLastFrameWithLogicsound = n4;
        int n5 = RM.getValue(34, n, 0);
        int n6 = RM.getValue(34, n, 1);
        if (n5 >= 0) {
            Menu.playSound(n5);
        }
        if (n6 != 0) {
            int n7 = RM.getValue(33, n6);
            GCanvas.vibrate(n7);
        }
    }

    public final int menuGetTextSpacingForMenu(int n, int n2) {
        switch (n) {
            case 18: {
                int n3 = GCanvas.getFontHeight(n2);
                return n3 + Math.max(GCanvas.getSpriteHeight(2), n3);
            }
            case 15: {
                int n4 = GCanvas.getFontHeight(1);
                return Math.max(GCanvas.getSpriteHeight(3), n4);
            }
        }
        return -1;
    }

    public final boolean menuItemsCustomDrawn(int n) {
        switch (n) {
            case 18: {
                return true;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }

    public final void quote_addQuote(int n, int n2, int n3, Tank tank) {
        if (this.gamestate_atTitleScreen) {
            return;
        }
        this.quote_age = 0;
        this.quote_string = n;
        this.quote_x = n2;
        this.quote_owner = tank;
        int n4 = this.gamefield_dirtField.dirtFieldToLogicalX(GCanvas.getStringWidth(RM.t(n), 0));
        this.quote_x = Math.min(this.quote_x, this.gamefield_dirtField.mWidth - (n4 >> 1));
        this.quote_x = Math.max(this.quote_x, n4 >> 1);
    }

    private boolean quote_isFinished() {
        return this.quote_age == -1 || this.quote_age > 180;
    }

    private void quote_update() {
        if (this.quote_age == -1) {
            return;
        }
        ++this.quote_age;
        if (this.quote_isFinished()) {
            this.quote_age = -1;
            this.quote_string = -1;
            this.quote_owner = null;
        }
    }

    private void quote_render(Graphics graphics, int n) {
        int n2;
        int n3;
        int n4;
        String string;
        int n5;
        int n6;
        String string2;
        String string3;
        block7: {
            int n7;
            block6: {
                int n8;
                block5: {
                    if (this.quote_string == -1) {
                        return;
                    }
                    string3 = this.quote_owner.name;
                    string2 = ": ";
                    n6 = GCanvas.getStringWidth(string3, 1);
                    n5 = n6 + GCanvas.getStringWidth(string2, 1);
                    string = RM.t(this.quote_string);
                    n4 = Menu.breakLine(this.quote_lines, 1, string, graphics.getClipWidth() - n5 - 4);
                    n3 = GCanvas.getFontHeight(1);
                    n2 = n - n4 * n3 - 4;
                    GCanvas.pushClip(graphics);
                    graphics.setClip(graphics.getClipX(), n2, graphics.getClipWidth(), n - n2 - 1);
                    n8 = (this.quote_age << 10) / 180;
                    if (n8 >= 128) break block5;
                    n8 = GCanvas.ipGetLambda(n8 << 3, 2);
                    n7 = n - (n8 * (n3 * n4) >> 10);
                    break block6;
                }
                if (n8 <= 896) break block7;
                n8 -= 896;
                n8 = GCanvas.ipGetLambda(n8 << 3, 1);
                n7 = n2 + (n8 * (n3 * n4) >> 10);
            }
            n2 = n7;
        }
        int n9 = graphics.getClipX();
        int n10 = n2;
        int n11 = graphics.getClipX() + graphics.getClipWidth();
        int n12 = n2 + n3 * n4 + 4;
        GCanvas.fillRectWithImage(graphics, 35, n9, n10, n11, n - 1);
        graphics.setColor(this.COLOR_BAR_BORDER);
        graphics.drawRect(n9, n10, n11 - n9, n12 - n10 - 1 + 4);
        GCanvas.drawString(graphics, 1, string3, graphics.getClipX() + 2, n2 + 2, 4);
        GCanvas.drawString(graphics, 1, string2, graphics.getClipX() + n6 + 2, n2 + 2, 4);
        n2 += 2;
        for (int i = 0; i < n4; ++i) {
            String string4 = string.substring(this.quote_lines[i * 2], this.quote_lines[i * 2 + 1]);
            GCanvas.drawString(graphics, 1, string4, n5 + 2, n2, 4);
            n2 += n3;
        }
        GCanvas.popClip(graphics);
    }

    public final boolean quote_active(Tank tank) {
        return this.quote_owner == tank && !this.quote_isFinished();
    }

    public final void quote_reset(Tank tank) {
        if (this.quote_owner == tank) {
            this.quote_age = -1;
            this.quote_string = -1;
            this.quote_owner = null;
        }
    }

    public final boolean menuHotspotPerItem(int n) {
        if (n == 18) {
            return false;
        }
        return n != 15;
    }

    public final boolean menuEnableDragInMenu(int n) {
        return n == 18;
    }

    public final void calcAspectRatio(int n, int n2) {
        this.mAspectRatio = 100 * n / n2 << 10;
    }

    public final int menuGetCustomItemBottom(int n) {
        switch (n) {
            case 18: {
                return GCanvas.getHeight() - GCanvas.getFontHeight(0);
            }
        }
        return -1;
    }

    public final int menuGetCustomItemTop(int n) {
        switch (n) {
            case 18: {
                int n2 = 3 * GCanvas.getFontHeight(0) + this.SHOP_TITLE_PADDING_TOP + this.SHOP_TITLE_PADDING_BOTTOM;
                return n2;
            }
        }
        return -1;
    }

    public final void demoHandleDemoMode(Graphics graphics) {
        if (!Handson.demoIsActive()) {
            return;
        }
        if (Menu.getMode() == 2) {
            this.demoPrintIngameDemoMode(graphics);
            return;
        }
        this.demoPrintMenuDemoMode(graphics);
    }

    private void demoPrintIngameDemoMode(Graphics graphics) {
        int n = Menu.getCurrentMenu();
        int n2 = Menu.getMode();
        if (n == 24) {
            return;
        }
        if (GCanvas.getGlobalFrameCount() % 20 > 10) {
            int n3 = 0;
            if (this.mDrawingAttractMode || n2 == 2) {
                n3 = this.viewportGetTop();
            }
            int n4 = GCanvas.getStringWidth(RM.t(339), 1);
            int n5 = GCanvas.getFontHeight(1);
            graphics.setColor(this.COLOR_BAR);
            graphics.fillRect(0, n3, n4 + 2, n5 + 2);
            graphics.setColor(this.COLOR_BAR_BORDER);
            graphics.drawRect(0, n3, n4 + 2, n5 + 2);
            GCanvas.drawString(graphics, 1, RM.t(339), 2, n3 + 1, 20);
        }
    }

    private void demoPrintMenuDemoMode(Graphics graphics) {
        this.demoPrintIngameDemoMode(graphics);
    }

    private static void lineScrollerInit(int n) {
        Game.sLineScrollers[n] = GCanvas.getGlobalFrameCount();
    }

    private static boolean lineScrollerDraw(int n, Graphics graphics, String string, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int n10;
        block15: {
            int n11;
            block12: {
                int n12;
                int n13;
                block14: {
                    block13: {
                        block11: {
                            block8: {
                                int n14;
                                int n15;
                                int n16;
                                block10: {
                                    block9: {
                                        block7: {
                                            int n17 = GCanvas.getStringWidth(string, n2);
                                            if (n17 <= n6) {
                                                GCanvas.drawString(graphics, n2, string, n3, n4, n5);
                                                return false;
                                            }
                                            int n18 = n17 - n6;
                                            int n19 = GCanvas.getGlobalFrameCount() - sLineScrollers[n];
                                            n10 = (n19 %= n18 * 4) <= n18 ? n3 - n19 : (n19 <= n18 * 2 ? n3 - n18 : (n19 <= n18 * 3 ? n3 - n18 * 3 + n19 : n3));
                                            GCanvas.pushClip(graphics);
                                            n9 = GCanvas.getFontHeight(n2);
                                            n8 = 0;
                                            n7 = 0;
                                            if ((n5 & 4) <= 0) break block7;
                                            n16 = n3;
                                            break block8;
                                        }
                                        if ((n5 & 8) <= 0) break block9;
                                        n15 = n3;
                                        n14 = n6;
                                        break block10;
                                    }
                                    if ((n5 & 1) <= 0) break block8;
                                    n15 = n3;
                                    n14 = n6 / 2;
                                }
                                n16 = n8 = n15 - n14;
                            }
                            if ((n5 & 0x10) <= 0) break block11;
                            n11 = n4;
                            break block12;
                        }
                        if ((n5 & 0x20) <= 0) break block13;
                        n13 = n4;
                        n12 = n9;
                        break block14;
                    }
                    if ((n5 & 2) <= 0) break block15;
                    n13 = n4;
                    n12 = n9 / 2;
                }
                n11 = n13 - n12;
            }
            n7 = n11;
        }
        GCanvas.clipRect(graphics, n8, n7, n6, n9);
        GCanvas.drawString(graphics, n2, string, n10, n4, n5);
        GCanvas.popClip(graphics);
        return true;
    }
}

