/*
 * Decompiled with CFR 0.152.
 */
package game.dirtfield;

import game.Game;
import game.Tank;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tinbrain.GCanvas;
import tinbrain.RM;
import tinbrain.math3d.AutoBezier;
import tinbrain.math3d.Point2D;

public abstract class DirtFieldBase {
    public int mPixelWidth;
    public int mPixelHeight;
    public int mWidth;
    public int mViewX;
    public int mViewY;
    protected short[] mCachedHeights;
    private int mSkyImage;
    protected int[] mOut = new int[2];

    public void init(int n, int n2) {
        this.mPixelWidth = n;
        this.mPixelHeight = n2;
        Game.instance.calcAspectRatio(n, n2);
        this.mWidth = this.dirtFieldToLogicalX(n);
        this.mSkyImage = Game.instance.gamelayer_randomSky();
    }

    protected final void allocCachedHeights(int n) {
        this.mCachedHeights = new short[n];
        for (int i = 0; i < n; ++i) {
            this.mCachedHeights[i] = 0;
        }
    }

    protected final AutoBezier setupSpline() {
        AutoBezier autoBezier = new AutoBezier(450, false);
        int n = 3 * this.mPixelHeight / 4;
        int n2 = this.mPixelHeight / 4;
        int n3 = 0;
        int n4 = n / 5 + GCanvas.getRandom(0, n * 4 / 10);
        int n5 = 2 + GCanvas.getRandom(0, 6);
        autoBezier.initBlank(n5 + 1);
        autoBezier.setPoint(0, 0, n4);
        for (int i = 0; i < n5; ++i) {
            int n6 = i == n5 - 1 ? this.mPixelWidth : n3 + this.mPixelWidth / n5;
            n4 = n2 + (n / 5 + GCanvas.getRandom(0, n * 4 / 10));
            autoBezier.setPoint(1 + i, n6, n4);
            n3 = n6;
        }
        autoBezier.calculateWeights();
        return autoBezier;
    }

    public abstract void createSplineLandscape();

    public abstract void loadLandscapeFromFile(int var1);

    public abstract boolean isSolid(int var1, int var2);

    public abstract int getGroundLevelForColumn(int var1);

    public final int getGroundLevel(int n) {
        return this.dirtFieldToLogicalY(this.getCachedGroundLevelForColumn(this.logicalToDirtFieldX(n)));
    }

    public final int getAngle(int n) {
        int n2 = this.logicalToDirtFieldX(n);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = Math.max(0, n2 - 5); i < Math.min(n2 + 5, this.mPixelWidth - 1); i += 5) {
            int n8;
            block5: {
                int n9;
                int n10;
                block7: {
                    int n11;
                    int n12;
                    block10: {
                        block9: {
                            block8: {
                                block6: {
                                    ++n7;
                                    n8 = this.getCachedGroundLevelForColumn(i);
                                    if (Game.instance.gamestate_atTitleScreen) break block5;
                                    if ((i < 32 || i >= 87) && (i < 393 || i >= 448)) break block6;
                                    n10 = n8;
                                    n9 = 287;
                                    break block7;
                                }
                                if (i < 97 || i >= 383) break block8;
                                n10 = n8;
                                n9 = 297;
                                break block7;
                            }
                            if (i < 87 || i >= 97) break block9;
                            n10 = n8;
                            n12 = 287 + i;
                            n11 = 86;
                            break block10;
                        }
                        if (i < 384 || i >= 393) break block5;
                        n10 = n8;
                        n12 = 680;
                        n11 = i;
                    }
                    n9 = n12 - n11;
                }
                n8 = Math.min(n10, n9);
            }
            n3 += i;
            n4 += n8;
            n5 += i * i;
            n6 += i * n8;
        }
        long l = n3 << 10;
        long l2 = n4 << 10;
        long l3 = n5 << 10;
        long l4 = n6 << 10;
        if (n7 > 0) {
            int n13 = (int)(l3 - (l * l >> 10) / (long)n7);
            int n14 = (int)(l4 - (l * l2 >> 10) / (long)n7);
            Point2D point2D = Point2D.getLocal(n13, n14);
            point2D.unit();
            int n15 = Game.atan2(point2D.y, point2D.x);
            Point2D.freeLocal(point2D);
            return n15;
        }
        return 0;
    }

    public abstract boolean update();

    public abstract boolean isReady();

    public final void renderSky(Graphics graphics) {
        int n = Game.instance.viewportGetLeft();
        int n2 = Game.instance.viewportGetTop();
        int n3 = this.mViewX;
        int n4 = this.mViewY;
        int n5 = 0;
        int n6 = 0;
        Image image = RM.getImage(this.mSkyImage);
        DirtFieldBase.getClampedCoordX(n3, Game.instance.viewportGetWidth(), image.getWidth(), this.mOut);
        n3 = this.mOut[0];
        n5 = this.mOut[1];
        this.getClampedCoordY(n4, Game.instance.viewportGetHeight(), Math.min(image.getHeight(), this.mPixelHeight), this.mOut);
        n4 = this.mOut[0];
        n6 = this.mOut[1];
        graphics.drawRegion(image, n3, n4, n5, n6, 0, n, n2, 0);
    }

    public abstract void render(Graphics var1);

    public abstract void addClodAtColumn(int var1, int var2, int var3, int var4);

    public abstract void createCircle(int var1, int var2, int var3);

    public abstract void destroyCircle(int var1, int var2, int var3, int var4);

    public abstract void createWall(int var1, int var2);

    public static void checkForFallingTanks(int n, int n2) {
        Game game = Game.instance;
        Tank[] tankArray = game.gamestate_players;
        for (int i = 0; i < tankArray.length; ++i) {
            Tank tank = tankArray[i];
            if (tank == null) continue;
            int n3 = tank.x;
            int n4 = tank.logicalWidth() / 2;
            int n5 = n3 - n4;
            int n6 = n3 + n4;
            int n7 = n - n2;
            int n8 = n + n2;
            if (!(n5 >= n7 && n5 <= n8 || n6 >= n7 && n6 <= n8) && (n5 > n7 || n6 < n8)) continue;
            tank.falling = true;
        }
    }

    protected static void getClampedCoordX(int n, int n2, int n3, int[] nArray) {
        n = Math.max(0, Math.min(n, n3 - n2));
        int n4 = Math.min(n3, n2);
        if (n4 + n > n3) {
            n4 = n3 - n;
        }
        nArray[0] = n;
        nArray[1] = n4;
    }

    protected final void getClampedCoordY(int n, int n2, int n3, int[] nArray) {
        DirtFieldBase.getClampedCoordX(n, n2, n3, nArray);
    }

    public final void setViewTopLeft(int n, int n2) {
        int n3 = GCanvas.clamp(n, 0, this.mPixelWidth - Game.instance.viewportGetWidth());
        int n4 = GCanvas.clamp(n2, 0, this.mPixelHeight - Game.instance.viewportGetHeight());
        this.mViewX = n3;
        this.mViewY = n4;
    }

    public final int logicalToScreenX(int n) {
        return this.logicalToDirtFieldX(n) - this.mViewX + Game.instance.viewportGetLeft();
    }

    public final int logicalToScreenY(int n) {
        return this.logicalToDirtFieldY(n) - this.mViewY + Game.instance.viewportGetTop();
    }

    public final int logicalToDirtFieldX(int n) {
        return (int)(((long)n << 10) / (long)Game.instance.mAspectRatio * (long)this.mPixelWidth >> 10);
    }

    public final int logicalToDirtFieldY(int n) {
        return (int)(((long)n << 10) / 102400L * (long)this.mPixelHeight >> 10);
    }

    public final int dirtFieldToLogicalX(int n) {
        return (n << 10) / this.mPixelWidth * Game.instance.mAspectRatio >> 10;
    }

    public final int dirtFieldToLogicalY(int n) {
        return (n << 10) / this.mPixelHeight * 100;
    }

    public final void initCachedHeights() {
        for (int i = 0; i < this.mPixelWidth; ++i) {
            this.mCachedHeights[i] = (short)(this.getGroundLevelForColumn(i) - 1);
        }
    }

    public final int getCachedGroundLevelForColumn(int n) {
        if (n < 0 || n >= this.mPixelWidth) {
            return 0;
        }
        return this.mCachedHeights[n];
    }
}

