/*
 * Decompiled with CFR 0.152.
 */
package com.am.adlib;

import com.am.adlib.Banner;
import com.am.adlib.Log;
import java.util.Random;
import java.util.Vector;

public class AdData {
    private static AdData instance;
    private boolean sendStatistics = true;
    private boolean isNew = false;
    private boolean active = true;
    private int bannersUpdateRate;
    private Vector bannersArray;
    private Vector banners;

    public static synchronized AdData getInstance() {
        if (instance == null) {
            instance = new AdData();
        }
        return instance;
    }

    public void setData(Vector data, boolean sendStatistics, int bannersUpdateRate, int weightSum, boolean active) {
        this.isNew = true;
        this.sendStatistics = sendStatistics;
        this.banners = data;
        this.bannersUpdateRate = bannersUpdateRate;
        this.active = active;
        Vector sorted = this.sortDown(data);
        this.bannersArray = this.createBannersArray(sorted, bannersUpdateRate, weightSum);
        this.log();
    }

    private Vector createBannersArray(Vector data, int bannersUpdateRate, int weightSum) {
        Vector result = new Vector();
        Random rand = new Random();
        int time1 = 0;
        int time2 = 0;
        if (weightSum > 0) {
            while (time2 < bannersUpdateRate || Math.abs(bannersUpdateRate - time1) > Math.abs(bannersUpdateRate - time2)) {
                int random = rand.nextInt(weightSum);
                time1 = time2;
                int i = 0;
                while (i < data.size()) {
                    if (random < ((Banner)data.elementAt(i)).getWeight()) {
                        time2 += ((Banner)data.elementAt(i)).getRefreshRate();
                        break;
                    }
                    random -= ((Banner)data.elementAt(i)).getWeight();
                    ++i;
                }
                result.addElement(data.elementAt(i));
            }
        }
        return result;
    }

    private void log() {
        Log.i("Banners update rate = " + this.bannersUpdateRate);
        Log.i("Statistics = " + this.sendStatistics);
        Log.i("Active = " + this.active);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.banners.size()) {
            int id = ((Banner)this.banners.elementAt(i)).getId();
            String company = ((Banner)this.banners.elementAt(i)).getCompany();
            int weight = ((Banner)this.banners.elementAt(i)).getWeight();
            int rate = ((Banner)this.banners.elementAt(i)).getRefreshRate();
            String imgSrc = ((Banner)this.banners.elementAt(i)).getImgSrc();
            String link = ((Banner)this.banners.elementAt(i)).getLink();
            sb.append("Banner ");
            sb.append(i + 1);
            sb.append(": id = ");
            sb.append(id);
            sb.append(", company = ");
            sb.append(company);
            sb.append(", weight = ");
            sb.append(weight);
            sb.append(", rate = ");
            sb.append(rate);
            sb.append(", imgSrc = ");
            sb.append(imgSrc);
            sb.append(", link = ");
            sb.append(link);
            Log.i(sb.toString());
            sb.delete(0, sb.length());
            ++i;
        }
        i = 0;
        while (i < this.bannersArray.size()) {
            sb.append(((Banner)this.bannersArray.elementAt(i)).getCompany());
            sb.append(" ");
            ++i;
        }
        Log.i(sb.toString());
    }

    private Vector sortDown(Vector data) {
        int i = data.size();
        while (i > 0) {
            int j = 0;
            while (j < i - 1) {
                if (((Banner)data.elementAt(j)).getWeight() < ((Banner)data.elementAt(j + 1)).getWeight()) {
                    Banner temp = (Banner)data.elementAt(j);
                    data.setElementAt(data.elementAt(j + 1), j);
                    data.setElementAt(temp, j + 1);
                }
                ++j;
            }
            --i;
        }
        return data;
    }

    public boolean haveData() {
        return this.active && this.banners != null && this.banners.size() > 0 && this.bannersArray != null && this.bannersArray.size() > 0;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setIsNew(boolean n) {
        this.isNew = n;
    }

    public boolean isSendStatistics() {
        return this.sendStatistics;
    }

    public Vector getBanners() {
        return this.banners;
    }

    public int getBannersLength() {
        return this.banners.size();
    }

    public Vector getBannersArray() {
        return this.bannersArray;
    }

    public int getBannersArrayLength() {
        return this.bannersArray.size();
    }

    public Banner getBanner(int n) {
        return (Banner)this.bannersArray.elementAt(n);
    }

    public String getImgSrc(int n) {
        return ((Banner)this.bannersArray.elementAt(n)).getImgSrc();
    }

    public String getLink(int n) {
        return ((Banner)this.bannersArray.elementAt(n)).getLink();
    }

    public int getRefreshRate(int n) {
        return ((Banner)this.bannersArray.elementAt(n)).getRefreshRate();
    }

    public String getCompany(int n) {
        return ((Banner)this.bannersArray.elementAt(n)).getCompany();
    }

    public int getId(int n) {
        return ((Banner)this.bannersArray.elementAt(n)).getId();
    }
}

