/*
 * Decompiled with CFR 0.152.
 */
package com.am.otf;

import com.am.adlib.Ad;
import com.am.adlib.BannerSprite;
import com.am.otf.MainMID;
import com.am.otf.component.AudioManager;
import com.am.otf.interfaces.ViewInterface;
import com.am.otf.interfaces.ViewListener;
import com.am.otf.view.ALM;
import com.am.otf.view.AboutView;
import com.am.otf.view.HelpView;
import com.am.otf.view.Highscores;
import com.am.otf.view.MainMenu;
import com.am.otf.view.PauseMenu;
import com.am.tools.L10n;
import com.nokia.mid.ui.DeviceControl;
import com.otf.game.Game;
import com.otf.game.Resources;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class ReactorCanvas
extends GameCanvas
implements CommandListener,
ViewListener {
    public final boolean BANNER_SWITCH;
    public static final int START_NEW_GAME = 1;
    public static final int PAUSE_GAME = 2;
    public static final int EVENT_SHOWABOUT = 10;
    public static final int EVENT_SHOWHELP = 11;
    public static final int EVENT_SHOWMENU = 12;
    public static final int EVENT_SHOW_HIGHSCREEN = 13;
    public static final int RESUME_GAME = 3;
    public static final int NEXT_LEVEL = 4;
    public static final int INTERVAL = 30;
    public static final int EXIT_GAME = 20;
    public static final int SOUND_CHANGE = 21;
    public static final int SOUND_WIN = 35;
    public static final int SOUND_FAIL = 36;
    public static long lastFrameTime;
    public static float deltaTime;
    private Ad ad;
    private BannerSprite bannerSprite;
    private MainMID midlet;
    private Command backCommand;
    private GameThread gameThread;
    private Resources r;
    private Game game;
    private ViewInterface currentView;
    private ViewInterface menuView;
    private ViewInterface gameView;
    private ViewInterface pauseView;
    private ViewInterface aboutView;
    private ViewInterface helpView;
    private ViewInterface highScores;
    private AudioManager audio;
    public boolean sound = true;
    public static int W;
    public static int H;

    public ReactorCanvas(MainMID midlet) {
        super(true);
        this.BANNER_SWITCH = true;
        this.setFullScreenMode(true);
        this.midlet = midlet;
        this.audio = AudioManager.getInstance();
        this.r = new Resources();
        W = this.getWidth();
        H = this.getHeight();
        this.ad = Ad.start(midlet, L10n.getID(H), W, H);
        this.bannerSprite = this.ad.createBannerSprite();
        this.backCommand = new Command("Back", 2, 0);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        ALM.setDisplaySize(W, H);
    }

    public void render() {
        Graphics g = this.getGraphics();
        this.paint(g);
        this.flushGraphics();
    }

    protected void showNotify() {
        this.r.loadResources();
        this.ad.startAd();
        this.startApp();
    }

    protected void init() {
        if (this.menuView == null) {
            this.menuView = new MainMenu(this, W, H);
            this.menuView.initResources(this.r);
        }
        if (this.game == null) {
            this.game = new Game(this, W, H);
            this.game.initResources(this.r);
        }
        if (this.aboutView == null) {
            this.aboutView = new AboutView(this);
            this.aboutView.initResources(this.r);
        }
        if (this.helpView == null) {
            this.helpView = new HelpView(this);
            this.helpView.initResources(this.r);
        }
        if (this.pauseView == null) {
            this.pauseView = new PauseMenu(this, W, H);
            this.pauseView.initResources(this.r);
        }
        if (this.highScores == null) {
            this.highScores = new Highscores(this, W, H);
            this.highScores.initResources(this.r);
        }
    }

    protected void hideNotify() {
        this.game.pauseGame();
        this.audio.stopAll();
        this.ad.stopAd();
        this.pauseApp();
    }

    public void stopApp() {
        this.gameThread.requestStop();
    }

    public void startApp() {
        if (this.gameThread == null) {
            this.gameThread = new GameThread();
        }
        if (this.currentView == null) {
            this.changeView(this.menuView);
        }
        if (this.currentView == this.game) {
            this.changeView(this.pauseView);
        }
        this.gameThread.requestStart();
    }

    public void pauseApp() {
        if (this.currentView == this.game) {
            this.game.pauseGame();
        }
        this.gameThread.requestPause();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            if (this.currentView == this.menuView) {
                this.midlet.exit();
            }
            if (this.currentView == this.game) {
                this.game.pauseGame();
                this.changeView(this.pauseView);
            } else if (this.currentView == this.pauseView) {
                this.changeView(this.game);
                this.handleEvent(3);
            } else {
                this.changeView(this.menuView);
            }
        }
    }

    public void changeView(ViewInterface targetView) {
        this.setCommandListener(this);
        if (this.currentView == this.game && targetView != this.game) {
            this.game.pauseGame();
        }
        this.currentView = targetView;
    }

    public void paint(Graphics g) {
        g.setColor(-16777216);
        try {
            if (this.currentView != null) {
                this.currentView.paint(g, 0, 0);
            }
        }
        catch (NullPointerException exc) {
            exc.printStackTrace();
        }
        this.bannerSprite.paint(g);
    }

    public void changeState(int state) {
    }

    public void handleEvent(int event) {
        switch (event) {
            case 1: {
                this.gameView = this.game;
                this.changeView(this.gameView);
                this.game.startGame();
                break;
            }
            case 2: {
                this.game.pauseGame();
                this.changeView(this.pauseView);
                break;
            }
            case 13: {
                this.game.pauseGame();
                this.highScores.refreshResources();
                this.changeView(this.highScores);
                break;
            }
            case 10: {
                this.game.pauseGame();
                this.changeView(this.aboutView);
                break;
            }
            case 11: {
                this.game.pauseGame();
                this.changeView(this.helpView);
                break;
            }
            case 12: {
                this.game.pauseGame();
                this.changeView(this.menuView);
                break;
            }
            case 3: {
                this.game.resumeGame();
                this.changeView(this.game);
                break;
            }
            case 4: {
                this.game.handleEvent(15);
                this.game.resumeGame();
                this.changeView(this.game);
                break;
            }
            case 20: {
                this.midlet.exit();
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 21: {
                this.sound = !this.sound;
                AudioManager.setAudioEnabled(this.sound);
                this.menuView.refreshResources();
                this.pauseView.refreshResources();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.currentView.pointerPressed(x, y);
        this.bannerSprite.touchDown(x, y);
    }

    public void pointerReleased(int x, int y) {
        this.currentView.pointerReleased(x, y);
        if (this.bannerSprite.touchUp(x, y)) {
            this.pauseApp();
            this.ad.openLink();
        }
    }

    class GameThread
    extends Thread {
        private boolean pause = true;
        private boolean stop = false;
        private boolean started = false;

        GameThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStart() {
            lastFrameTime = this.currentTime();
            this.pause = false;
            if (!this.started) {
                this.start();
                this.started = true;
            } else {
                GameThread gameThread = this;
                synchronized (gameThread) {
                    this.notify();
                }
            }
        }

        public void requestPause() {
            this.pause = true;
        }

        public void requestStop() {
            this.stop = true;
        }

        public long currentTime() {
            long time = 0L;
            time = System.currentTimeMillis();
            return time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long time = 0L;
            while (!this.stop) {
                try {
                    if (this.pause) {
                        GameThread gameThread = this;
                        synchronized (gameThread) {
                            this.wait();
                            continue;
                        }
                    }
                    time = System.currentTimeMillis();
                    deltaTime = (float)(this.currentTime() - lastFrameTime) / 1000.0f;
                    lastFrameTime = this.currentTime();
                    ReactorCanvas.this.game.updateGame();
                    ReactorCanvas.this.render();
                    DeviceControl.setLights((int)0, (int)100);
                    time = 30L - (System.currentTimeMillis() - time);
                    Thread.sleep(time < 0L ? 0L : time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

