/*
 * Decompiled with CFR 0.152.
 */
package com.am.otf.view;

import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public class ALM
extends LayerManager {
    public static final int ANCHOR_TOP_LEFT = 1;
    public static final int ANCHOR_TOP_RIGHT = 2;
    public static final int ANCHOR_BOTTOM_RIGHT = 4;
    public static final int ANCHOR_BOTTOM_LEFT = 8;
    public static final int ANCHOR_CENTER_OF_AREA = 16;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1024;
    private static int displayHeight = 240;
    private static int displayWidth = 400;
    private int bottomleft_indent_v = 0;
    private int bottomright_indent_v = 0;
    private int topleft_indent_v = 0;
    private int topright_indent_v = 0;
    private int bottomleft_indent_h = 0;
    private int bottomright_indent_h = 0;
    private int topleft_indent_h = 0;
    private int topright_indent_h = 0;
    private final int BUTTONS_SPACING;
    private Layer[][] grid;
    private int gridCellHeight;
    private int gridCellWidth;
    private int gridColumns;
    private int gridRows;
    private int leftGridIndent = 0;
    private int rightGridIndent = 0;
    private int topGridIndent = 0;
    private int bottomGridIndent = 0;

    public ALM() {
        this.BUTTONS_SPACING = 2;
    }

    public static final void setDisplaySize(int width, int height) {
        ALM.setDisplayWidth(width);
        ALM.setDisplayHeight(height);
    }

    private static void setDisplayHeight(int displayHeight) {
        ALM.displayHeight = displayHeight;
    }

    private static void setDisplayWidth(int displayWidth) {
        ALM.displayWidth = displayWidth;
    }

    protected static int getDisplayHeight() {
        return displayHeight;
    }

    protected static int getDisplayWidth() {
        return displayWidth;
    }

    public void addToGrid(Layer layer, int index) {
        int row = 0;
        block0: while (row < this.gridRows) {
            int column = 0;
            while (column < this.gridColumns) {
                if (this.grid[row][column] == null) {
                    this.grid[row][column] = layer;
                    super.insert(layer, index);
                    this.positionLayer(layer, 16, this.leftGridIndent + column * this.getGridCellWidth(), this.topGridIndent + row * this.getGridCellHeight(), this.getGridCellWidth(), this.getGridCellHeight());
                    break block0;
                }
                ++column;
            }
            ++row;
        }
    }

    public final void append(Layer layer, int anchor) {
        this.positionLayer(layer, anchor);
        super.append(layer);
    }

    public final void initGrid(int columns, int rows) {
        this.grid = new Layer[rows][columns];
        this.gridColumns = columns;
        this.gridRows = rows;
        this.topGridIndent = 0;
        this.bottomGridIndent = 0;
        this.leftGridIndent = 0;
        this.rightGridIndent = 0;
        this.calculateGridParameters();
    }

    public final void initGrid(int columns, int rows, int topIndent, int bottomIndent, int leftIndent, int rightIndent) {
        this.grid = new Layer[rows][columns];
        this.gridColumns = columns;
        this.gridRows = rows;
        this.topGridIndent = topIndent;
        this.bottomGridIndent = bottomIndent;
        this.leftGridIndent = leftIndent;
        this.rightGridIndent = rightIndent;
        this.calculateGridParameters();
    }

    public final void insert(Layer layer, int index, int anchor) {
        this.positionLayer(layer, anchor);
        super.insert(layer, index);
    }

    public final void insertToGrid(Layer layer, int column, int row, int index) {
        this.grid[row][column] = layer;
        super.insert(layer, index);
        this.positionLayer(layer, 16, this.leftGridIndent + column * this.getGridCellWidth(), this.topGridIndent + row * this.getGridCellHeight(), this.getGridCellWidth(), this.getGridCellHeight());
    }

    private final void calculateGridParameters() {
        this.gridCellWidth = (ALM.getDisplayWidth() - this.leftGridIndent - this.rightGridIndent) / this.gridColumns;
        this.gridCellHeight = (ALM.getDisplayHeight() - this.topGridIndent - this.bottomGridIndent) / this.gridRows;
    }

    private final void positionLayer(Layer layer, int anchor) {
        if (anchor < 0) {
            throw new IllegalArgumentException("wrong anchor: must be between 0 and 4");
        }
        switch (anchor) {
            case 1: {
                layer.setPosition(this.topleft_indent_h + 2, 2);
                this.topleft_indent_h += layer.getWidth() + 2;
                break;
            }
            case 2: {
                layer.setPosition(ALM.getDisplayWidth() - layer.getWidth() - this.topright_indent_h - 2, 2);
                this.topright_indent_h += layer.getWidth() + 2;
                break;
            }
            case 4: {
                layer.setPosition(ALM.getDisplayWidth() - layer.getWidth() - this.bottomright_indent_h - 2, ALM.getDisplayHeight() - layer.getHeight() - 2);
                this.bottomright_indent_h += layer.getWidth() + 2;
                break;
            }
            case 8: {
                layer.setPosition(this.bottomleft_indent_h + 2, ALM.getDisplayHeight() - layer.getHeight() - 2);
                this.bottomleft_indent_h += layer.getWidth() + 2;
                break;
            }
            case 1025: {
                layer.setPosition(2, this.topleft_indent_v + 2);
                this.topleft_indent_v += layer.getHeight() + 2;
                break;
            }
            case 1026: {
                layer.setPosition(ALM.getDisplayWidth() - layer.getWidth() - 2, 2 + this.topright_indent_v);
                this.topright_indent_v += layer.getHeight() + 2;
                break;
            }
            case 1028: {
                layer.setPosition(ALM.getDisplayWidth() - layer.getWidth() - 2, ALM.getDisplayHeight() - layer.getHeight() - 2 - this.bottomright_indent_v);
                this.bottomright_indent_v += layer.getHeight() + 2;
                break;
            }
            case 1032: {
                layer.setPosition(2, ALM.getDisplayHeight() - layer.getHeight() - 2 - this.bottomleft_indent_v);
                this.bottomleft_indent_v += layer.getHeight() + 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong anchor: " + anchor);
            }
        }
    }

    private final void positionLayer(Layer layer, int anchor, int x, int y, int width, int height) {
        switch (anchor) {
            case 1: {
                layer.setPosition(x, y);
                break;
            }
            case 2: {
                layer.setPosition(x + width - layer.getWidth(), y);
                break;
            }
            case 4: {
                layer.setPosition(x + width - layer.getWidth(), y + height - layer.getHeight());
                break;
            }
            case 8: {
                layer.setPosition(x, y + height - layer.getHeight());
                break;
            }
            case 16: {
                layer.setPosition(x + (width - layer.getWidth()) / 2, y + (height - layer.getHeight()) / 2);
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong anchor: " + anchor);
            }
        }
    }

    protected final int getGridCellHeight() {
        return this.gridCellHeight;
    }

    protected final int getGridCellWidth() {
        return this.gridCellWidth;
    }
}

