/*
 * Decompiled with CFR 0.152.
 */
package com.am.otf.view;

import com.am.otf.MainMID;
import com.am.otf.ReactorCanvas;
import com.am.otf.component.Button;
import com.am.otf.component.ImageHelper;
import com.am.otf.component.TextReader;
import com.am.otf.interfaces.ViewInterface;
import com.am.otf.interfaces.ViewListener;
import com.am.otf.view.ALM;
import com.am.tools.L10n;
import com.otf.game.Resources;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;

public class HelpView
extends ALM
implements ViewInterface {
    private String PATH_TO_HELP = "/text/help.txt";
    private String str1 = MainMID.getInstance().getAppProperty("MIDlet-Name");
    private final int FIELD_By_Y;
    public final int COLOR_WHITE;
    public final int COLOR_BLACK;
    static final int SCROLL_STEP = 25;
    int scrollbarWidth = 4;
    int scrollbarHeight = 0;
    int scrollbarTop = 0;
    int scrollbarColor = 0xFFFFFF;
    int borderWidth = 1;
    int borderColor = 0;
    int bgColor = 0;
    Font textFont = Font.getDefaultFont();
    int textColor = 0xFFFFFF;
    int padding = 10;
    int interline = 2;
    static final String VOID_STRING = "";
    static final char SPACE_CHAR = ' ';
    int width = 0;
    int height = 0;
    int innerWidth = 0;
    int innerHeight = 0;
    int currentY = 0;
    int textHeight = 0;
    int currY = 0;
    String[] textRows = null;
    private Button backToMenu;
    private ViewListener listener;
    private TextReader txt;

    public HelpView(ViewListener listener) {
        this.FIELD_By_Y = 30;
        this.COLOR_WHITE = 0xFFFFFF;
        this.COLOR_BLACK = 0;
        this.listener = listener;
    }

    public void ScrollableTextFieldExt(int width, int height) {
        this.width = width;
        this.height = height;
        this.innerWidth = width - 2 * this.borderWidth - 2 * this.padding - this.scrollbarWidth;
        this.innerHeight = height - 2 * this.borderWidth - 2 * this.padding;
    }

    public void setText(String text) {
        this.textRows = HelpView.getTextRows(text, this.textFont, this.innerWidth);
        this.textHeight = this.textRows.length * (this.interline + this.textFont.getHeight());
        this.scrollbarHeight = Math.min(this.innerHeight, this.innerHeight * this.innerHeight / this.textHeight);
        this.scrollbarTop = 0;
        this.currentY = -30;
    }

    public void scrollDown() {
        this.scroll(25);
    }

    public void scrollUp() {
        this.scroll(-25);
    }

    private void scroll(int delta) {
        this.currentY += delta;
        if (this.currentY < 0) {
            this.currentY = -30;
        } else if (this.currentY > this.textHeight - this.innerHeight) {
            this.currentY = Math.max(0, this.textHeight - this.innerHeight);
        }
        this.scrollbarTop = this.innerHeight * this.currentY / this.textHeight;
    }

    public static String[] getTextRows(String text, Font font, int width) {
        char spaceChar = ' ';
        Vector<String> rowsVector = new Vector<String>();
        StringBuffer currentRowText = new StringBuffer();
        int prevIndex = 0;
        int currIndex = text.indexOf(spaceChar);
        if (currIndex == -1) {
            currIndex = text.length();
        }
        int rowWidth = 0;
        int tokenWidth = 0;
        int whitespaceWidth = font.stringWidth(" ");
        String currentToken = null;
        while (currIndex != -1) {
            currentToken = text.substring(prevIndex, currIndex);
            tokenWidth = font.stringWidth(currentToken);
            rowWidth += tokenWidth;
            if (currentRowText.length() > 0) {
                rowWidth += whitespaceWidth;
            }
            if (currentRowText.length() > 0 && rowWidth > width) {
                rowsVector.addElement(currentRowText.toString());
                currentRowText.setLength(0);
                currentRowText.append(currentToken);
                rowWidth = tokenWidth;
            } else {
                if (currentRowText.length() > 0) {
                    currentRowText.append(spaceChar);
                }
                currentRowText.append(currentToken);
            }
            if (currIndex == text.length()) break;
            prevIndex = currIndex + 1;
            if ((currIndex = text.indexOf(spaceChar, prevIndex)) != -1) continue;
            currIndex = text.length();
        }
        if (currentRowText.length() > 0) {
            rowsVector.addElement(currentRowText.toString());
        }
        String[] rowsArray = new String[rowsVector.size()];
        int i = 0;
        while (i < rowsArray.length) {
            rowsArray[i] = (String)rowsVector.elementAt(i);
            ++i;
        }
        return rowsArray;
    }

    public void initResources(Resources res) {
        this.txt = TextReader.getInstance();
        this.ScrollableTextFieldExt(240, ReactorCanvas.H - 40);
        try {
            this.setText(this.txt.readTextToString(this.PATH_TO_HELP));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.backToMenu = new Button(ImageHelper.createImageWithText(50, 30, L10n.get("BACK"), null, 0xFFFFFF, 0), new Button.ButtonListener(){

            public void buttonReleased() {
                HelpView.this.listener.handleEvent(12);
            }

            public void buttonPressed() {
            }
        });
        this.insert((Layer)this.backToMenu, 0, 2);
    }

    public void paint(Graphics g, int x, int y) {
        g.setColor(0);
        g.fillRect(0, 0, 240, 400);
        g.setColor(0xFFFFFF);
        g.setColor(this.borderColor);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(this.bgColor);
        g.fillRect(this.borderWidth, this.borderWidth, this.width - 2 * this.borderWidth, this.height - 2 * this.borderWidth);
        super.paint(g, 0, 0);
        g.setColor(this.textColor);
        g.setFont(this.textFont);
        g.translate(this.borderWidth + this.padding, this.borderWidth + this.padding);
        g.drawString(this.str1, 100, 5, 17);
        g.setClip(0, 30, this.innerWidth, this.innerHeight);
        if (this.textRows != null) {
            int i = 0;
            while (i < this.textRows.length) {
                g.drawString(this.textRows[i], 0, i * (this.textFont.getHeight() + this.interline) - this.currentY, 20);
                ++i;
            }
        }
        g.setClip(0, 30, this.width, this.height);
        g.setColor(this.scrollbarColor);
        g.fillRect(this.innerWidth, this.scrollbarTop, this.scrollbarWidth, this.scrollbarHeight);
        g.translate(-(this.borderWidth + this.padding), -(this.borderWidth + this.padding));
    }

    public boolean pointerPressed(int x, int y) {
        this.currY = y;
        this.backToMenu.pointerPressed(x, y);
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        int Y = y;
        this.scroll(this.currY - Y);
        this.backToMenu.pointerReleased(x, y);
        return false;
    }

    public boolean pointerDragged(int x, int y) {
        return false;
    }

    public void refreshResources() {
    }
}

