/*
 * Decompiled with CFR 0.152.
 */
package com.am.otf.view;

import com.am.otf.component.Button;
import com.am.otf.component.ImageHelper;
import com.am.otf.interfaces.ViewInterface;
import com.am.otf.interfaces.ViewListener;
import com.am.tools.L10n;
import com.otf.game.Resources;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public class MainMenu
extends LayerManager
implements ViewInterface {
    private static final String BG_PIC = "/fon/bg.png";
    private static final String HELP_PIC = "/pics/help.png";
    private static final String ABOUT_PIC = "/pics/about.png";
    private static final String HIGH_SC_PIC = "/L10n/highscores.png";
    private static final String PLAY_PIC = "/L10n/play.png";
    private static final String EXIT_STR = L10n.get("EXIT");
    private ViewListener listener;
    private int w;
    private int h;
    private Button buttonHelp;
    private Button buttonAbout;
    private Button buttonPlay;
    private Button buttonScores;
    private Button buttonExit;
    public Font medFont;
    public Font smalFont;
    public Font largeFont;
    public int gameType = 1;

    public MainMenu(ViewListener l, int width, int height) {
        this.listener = l;
        this.w = width;
        this.h = height;
        this.medFont = Font.getFont((int)64, (int)2, (int)0);
        this.smalFont = Font.getFont((int)64, (int)2, (int)8);
        this.largeFont = Font.getFont((int)64, (int)2, (int)16);
    }

    public void paint(Graphics g, int x, int y) {
        g.drawImage(ImageHelper.loadCached(BG_PIC), this.w / 2, 0, 17);
        super.paint(g, x, y);
        g.setColor(0);
        g.drawString(EXIT_STR, this.buttonExit.getX() + this.buttonExit.getWidth() / 2, this.buttonExit.getY() + 5, 17);
    }

    public void initResources(Resources res) {
        this.buttonPlay = new Button(ImageHelper.loadCached(PLAY_PIC), new Button.ButtonListener(){

            public void buttonReleased() {
                MainMenu.this.listener.handleEvent(1);
            }

            public void buttonPressed() {
            }
        });
        this.buttonHelp = new Button(ImageHelper.loadCached(HELP_PIC), new Button.ButtonListener(){

            public void buttonReleased() {
                MainMenu.this.listener.handleEvent(11);
            }

            public void buttonPressed() {
            }
        });
        this.buttonScores = new Button(ImageHelper.loadCached(HIGH_SC_PIC), new Button.ButtonListener(){

            public void buttonReleased() {
                MainMenu.this.listener.handleEvent(13);
            }

            public void buttonPressed() {
            }
        });
        this.buttonAbout = new Button(ImageHelper.loadCached(ABOUT_PIC), new Button.ButtonListener(){

            public void buttonReleased() {
                MainMenu.this.listener.handleEvent(10);
            }

            public void buttonPressed() {
            }
        });
        this.buttonExit = new Button(ImageHelper.createInvisiblePic(this.largeFont.stringWidth(EXIT_STR) + 5, 30), new Button.ButtonListener(){

            public void buttonReleased() {
                MainMenu.this.listener.handleEvent(20);
            }

            public void buttonPressed() {
            }
        });
        this.append((Layer)this.buttonExit);
        this.append((Layer)this.buttonAbout);
        this.append((Layer)this.buttonHelp);
        this.append((Layer)this.buttonPlay);
        this.append((Layer)this.buttonScores);
        this.buttonExit.setPosition(this.w - this.buttonExit.getWidth(), 2);
        this.buttonAbout.setPosition(10, 10);
        this.buttonHelp.setPosition(10, this.buttonAbout.getY() + this.buttonAbout.getHeight() + 20);
        this.buttonPlay.setPosition(this.w / 2 - this.buttonPlay.getWidth() / 2, this.h / 2 + 20);
        this.buttonScores.setPosition(this.w / 2 - this.buttonScores.getWidth() / 2, this.buttonPlay.getY() + this.buttonPlay.getHeight() + 15);
    }

    public boolean pointerPressed(int x, int y) {
        this.buttonHelp.pointerPressed(x, y);
        this.buttonAbout.pointerPressed(x, y);
        this.buttonExit.pointerPressed(x, y);
        this.buttonPlay.pointerPressed(x, y);
        this.buttonScores.pointerPressed(x, y);
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        this.buttonHelp.pointerReleased(x, y);
        this.buttonAbout.pointerReleased(x, y);
        this.buttonExit.pointerReleased(x, y);
        this.buttonPlay.pointerReleased(x, y);
        this.buttonScores.pointerReleased(x, y);
        return false;
    }

    public boolean pointerDragged(int x, int y) {
        return false;
    }

    public void handleEvent(int event) {
    }

    public void refreshResources() {
    }

    public void updateGame() {
    }
}

