/*
 * Decompiled with CFR 0.152.
 */
package com.am.otf.component;

import com.am.otf.MainMID;
import com.am.otf.ReactorCanvas;
import com.am.otf.component.Button;
import com.am.otf.component.ImageHelper;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class ActiveButton
extends Button {
    private int number;
    private String numStr = " ";
    private Font fontNum = Font.getFont((int)64, (int)2, (int)16);
    private int hNum = this.fontNum.getHeight();
    private static final String RED_PIC = "/pics/red.png";
    private static final String DEG_PIC = "/pics/square.png";
    private static final String BLINC_PIC = "/pics/square_blink.png";
    public static final int EFFECT_OFF = 0;
    public static final int EFFECT_WRONG = 1;
    public static final int EFFECT_RIGHT = 2;
    public static final int EFFECT_HELP = 3;
    private float sec = 0.0f;
    private int currentEffect = 0;
    private int timeToEffect = -1;
    private boolean flash = false;

    public ActiveButton(Image image, Button.ButtonListener listener) {
        super(image, listener);
    }

    public void setNumber(int num) {
        this.number = num;
        this.numStr = Integer.toString(this.number);
        this.hNum = this.fontNum.getHeight();
    }

    public int getNumber() {
        return this.number;
    }

    public void update(Graphics g) {
        if (this.isVisible()) {
            if (this.sec == 0.0f & this.currentEffect == 3) {
                if (!this.flash) {
                    this.flash = true;
                    this.setImage(ImageHelper.loadCached(BLINC_PIC), 40, 40);
                } else {
                    this.flash = false;
                    this.setImage(ImageHelper.loadCached(DEG_PIC), 40, 40);
                }
            }
            this.sec += ReactorCanvas.deltaTime;
            if (this.sec > 1.0f) {
                --this.timeToEffect;
                this.sec = 0.0f;
            }
            if (this.timeToEffect == -5) {
                this.timeToEffect = -1;
            }
            if (this.timeToEffect == 0 & this.currentEffect != 0) {
                this.setEffect(0);
            }
            g.setColor(0xFFFFFF);
            g.setFont(this.fontNum);
            g.drawString(this.numStr, this.getX() + this.getWidth() / 2, this.getY() + this.hNum / 4, 17);
            if (this.timeToEffect > 0) {
                switch (this.currentEffect) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        int i = 0;
                        while (i < 3) {
                            g.setColor(65280);
                            g.drawRect(this.getX() - i, this.getY() - i, this.getWidth() + i * 2, this.getHeight() + i * 2);
                            ++i;
                        }
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
            }
        }
    }

    public void setEffect(int effect) {
        switch (effect) {
            case 1: {
                Display.getDisplay((MIDlet)MainMID.getInstance()).vibrate(1000);
                this.currentEffect = 1;
                this.timeToEffect = 1;
                this.setImage(ImageHelper.loadCached(RED_PIC), 40, 40);
                break;
            }
            case 2: {
                this.currentEffect = 2;
                this.timeToEffect = 1;
                break;
            }
            case 3: {
                this.currentEffect = 3;
                this.timeToEffect = -1;
                break;
            }
            case 0: {
                this.setImage(ImageHelper.loadCached(DEG_PIC), 40, 40);
                this.currentEffect = 0;
            }
        }
    }
}

