/*
 * Decompiled with CFR 0.152.
 */
package com.am.otf.view;

import com.am.otf.component.Button;
import com.am.otf.component.HelperRMS;
import com.am.otf.component.ImageHelper;
import com.am.otf.interfaces.ViewInterface;
import com.am.otf.interfaces.ViewListener;
import com.am.tools.L10n;
import com.otf.game.Resources;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public class Highscores
extends LayerManager
implements ViewInterface {
    private static final String BG = "/fon/bg2.png";
    private final String EXIT_STR = L10n.get("BACK");
    private final String HIGHSCORES_STR = L10n.get("HIGHSCORES");
    private final String BEST_RESULT_STR = L10n.get("BEST_RESULT");
    private final String LAST_RESULT_STR = L10n.get("LAST_RESULT");
    private String bestRes = "0";
    private String lastRes = "0";
    private ViewListener listener;
    private int w;
    private int h;
    private int maxResult = 0;
    private int lastResult = 0;
    private final int fontHeight;
    private Button buttonExit;
    private int textAnchorX;
    private int textAnchorY1;
    private int textAnchorY2;
    private int textAnchorY3;
    private int textAnchorY4;
    public int gameType = 1;

    public Highscores(ViewListener l, int width, int height) {
        this.listener = l;
        this.w = width;
        this.h = height;
        this.fontHeight = Font.getFont((int)64, (int)2, (int)8).getHeight();
    }

    public void paint(Graphics g, int x, int y) {
        g.setColor(0);
        g.fillRect(0, 0, this.w, this.h);
        g.drawImage(ImageHelper.loadCached(BG), 0, 0, 20);
        super.paint(g, x, y);
        g.setColor(0xFFFFFF);
        g.drawString(this.HIGHSCORES_STR, this.textAnchorX, this.textAnchorY1 - 50, 17);
        g.drawString(this.BEST_RESULT_STR, this.textAnchorX, this.textAnchorY1, 17);
        g.drawString(this.bestRes, this.textAnchorX, this.textAnchorY2, 17);
        g.drawString(this.LAST_RESULT_STR, this.textAnchorX, this.textAnchorY3, 17);
        g.drawString(this.lastRes, this.textAnchorX, this.textAnchorY4, 17);
    }

    public void initResources(Resources res) {
        this.textAnchorX = this.w / 2;
        this.textAnchorY1 = 100;
        this.textAnchorY2 = this.textAnchorY1 + this.fontHeight;
        this.textAnchorY3 = this.textAnchorY2 + this.fontHeight + 10;
        this.textAnchorY4 = this.textAnchorY3 + this.fontHeight;
        this.buttonExit = new Button(ImageHelper.createImageWithText(50, 30, this.EXIT_STR, null, 0xFFFFFF, 0), new Button.ButtonListener(){

            public void buttonReleased() {
                Highscores.this.listener.handleEvent(12);
            }

            public void buttonPressed() {
            }
        });
        this.append((Layer)this.buttonExit);
        this.buttonExit.setPosition(this.w - this.buttonExit.getWidth(), 2);
    }

    public boolean pointerPressed(int x, int y) {
        this.buttonExit.pointerPressed(x, y);
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        this.buttonExit.pointerReleased(x, y);
        return false;
    }

    public boolean pointerDragged(int x, int y) {
        return false;
    }

    public void updateGame() {
    }

    public void refreshResources() {
        this.maxResult = HelperRMS.readFromRMS(1);
        this.lastResult = HelperRMS.readFromRMS(2);
        this.bestRes = this.drawTime(this.maxResult);
        this.lastRes = this.drawTime(this.lastResult);
    }

    public String drawTime(int millSeconds) {
        String zero = "";
        String zero1 = "";
        long mil = (long)millSeconds % 100L;
        long sec = (long)millSeconds / 1000L;
        zero1 = mil < 10L ? "0" : "";
        if (sec <= 10L) {
            zero = "00";
        }
        if (sec > 10L & sec <= 100L) {
            zero = "0";
        }
        if (sec > 100L) {
            zero = "";
        }
        return String.valueOf(zero) + Long.toString(sec) + " : " + zero1 + Long.toString(mil);
    }
}

