/*
 * Decompiled with CFR 0.152.
 */
package com.otf.game;

import com.am.otf.ReactorCanvas;
import com.am.otf.component.ActiveButton;
import com.am.otf.component.Button;
import com.am.otf.component.HelperRMS;
import com.am.otf.component.ImageHelper;
import com.am.otf.interfaces.ViewInterface;
import com.am.otf.interfaces.ViewListener;
import com.am.tools.L10n;
import com.otf.game.Resources;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public class Game
extends LayerManager
implements ViewInterface,
ViewListener {
    private static final String FON = "/fon/bg2.png";
    private static final String SQUARE_PIC = "/pics/square.png";
    private static final String PAUSE_STR = L10n.get("PAUSE");
    private static final String MENU_STR = L10n.get("MENU");
    private static final String GAME_OVER_STR = L10n.get("GAME_OVER");
    public static final int HEIGHT_BANNER = 40;
    private static final int START_NEW_GAME = 10;
    private static final int GAME_OVER = 111;
    private static final int HELP = 122;
    private static final int PLAYER_RIGHT = 20;
    private static final int PLAYER_WRONG = 25;
    private static final int START_LEVEL = 0;
    public static final int NEXT_LEVEL = 15;
    private static final int TIME_TO_HELP = 7;
    private int currentLevel = 0;
    private ViewListener listener;
    private int w;
    private int h;
    private ActiveButton[] numbers = new ActiveButton[25];
    private Button menuButton;
    public int pressesBut = 0;
    private boolean[] positionNumbers = new boolean[25];
    private Vector integerNum = new Vector();
    public Font medFont;
    public Font smalFont;
    public Font largeFont;
    private Random rand = new Random();
    private int timerForHelp = 7;
    private float timeOfGame;
    private float SecForEvent = 0.0f;
    private boolean buttonIsPressed = false;
    private int numOfPreessedButton;
    private int lastPressedNumber = 0;
    private String currentResult;
    public boolean pause = true;

    public Game(ViewListener l, int width, int height) {
        this.listener = l;
        this.w = width;
        this.h = height;
        this.medFont = Font.getFont((int)64, (int)2, (int)0);
        this.smalFont = Font.getFont((int)64, (int)2, (int)8);
        this.largeFont = Font.getFont((int)64, (int)2, (int)16);
    }

    public void paint(Graphics g, int x, int y) {
        g.setColor(0);
        g.fillRect(0, 0, this.w, this.h);
        g.drawImage(ImageHelper.loadCached(FON), this.w / 2, this.h / 2, 3);
        super.paint(g, x, y);
        if (this.currentLevel == 10) {
            g.setColor(0xFFFFFF);
            g.drawString(this.drawTimer(this.timeOfGame), this.w / 2, 4, 17);
            int i = 0;
            while (i < this.numbers.length) {
                this.numbers[i].update(g);
                ++i;
            }
            g.setColor(0xFFFFFF);
            g.drawString(PAUSE_STR, this.menuButton.getX() + this.menuButton.getWidth() / 2, this.menuButton.getY() + 5, 17);
        }
        if (this.currentLevel == 111) {
            g.setColor(0xFFFFFF);
            g.setFont(this.largeFont);
            g.drawString(GAME_OVER_STR, this.w / 2, this.h / 2 - 40, 17);
            g.drawString(this.currentResult, this.w / 2, this.h / 2 - 40 + 40, 17);
            g.drawString(MENU_STR, this.menuButton.getX() + this.menuButton.getWidth() / 2, this.menuButton.getY() + 5, 17);
        }
    }

    public void initResources(Resources res) {
        int w = this.largeFont.stringWidth(PAUSE_STR);
        this.menuButton = new Button(ImageHelper.createInvisiblePic(w + 4, 30), new Button.ButtonListener(){

            public void buttonReleased() {
                if (Game.this.currentLevel == 10) {
                    Game.this.listener.handleEvent(2);
                }
                if (Game.this.currentLevel == 111) {
                    Game.this.listener.handleEvent(12);
                }
            }

            public void buttonPressed() {
            }
        });
        this.append((Layer)this.menuButton);
        int boardX = 2;
        int boardY = this.h / 2 - 90 - 40;
        int row = 0;
        int col = 0;
        int i = 0;
        while (i < this.numbers.length) {
            this.numbers[i] = new ActiveButton(ImageHelper.loadCached(SQUARE_PIC), new Button.ButtonListener(){

                public void buttonPressed() {
                }

                public void buttonReleased() {
                }
            });
            this.append((Layer)this.numbers[i]);
            if (col == 5) {
                col = 0;
                ++row;
            }
            this.numbers[i].setPosition(boardX + col * (this.numbers[i].getWidth() + 8), boardY + row * (this.numbers[i].getHeight() + 10));
            ++col;
            ++i;
        }
        this.timerForHelp = 7;
    }

    public boolean pointerPressed(int x, int y) {
        int i = 0;
        while (i < this.numbers.length) {
            this.numbers[i].pointerPressed(x, y);
            ++i;
        }
        this.menuButton.pointerPressed(x, y);
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        int i = 0;
        while (i < this.numbers.length) {
            if (this.numbers[i].pointerReleased(x, y) & !this.buttonIsPressed) {
                this.numOfPreessedButton = i;
                this.buttonIsPressed = true;
                this.checkEvent(this.numOfPreessedButton);
            }
            ++i;
        }
        this.menuButton.pointerReleased(x, y);
        return false;
    }

    public boolean pointerDragged(int x, int y) {
        return false;
    }

    public void refreshResources() {
    }

    public void resumeGame() {
        this.pause = false;
    }

    public void pauseGame() {
        this.pause = true;
    }

    public void startGame() {
        this.pause = false;
        this.handleEvent(10);
    }

    public void updateGame() {
        if (!this.pause && this.currentLevel == 10) {
            this.SecForEvent += ReactorCanvas.deltaTime;
            this.timeOfGame += ReactorCanvas.deltaTime * 1000.0f;
            if (this.SecForEvent > 1.0f) {
                --this.timerForHelp;
                this.SecForEvent = 0.0f;
            }
            if (this.timerForHelp == 0) {
                this.timerForHelp = -1;
                this.handleEvent(122);
            }
        }
    }

    public void changeState(int state) {
    }

    public void handleEvent(int event) {
        switch (event) {
            case 10: {
                this.integerNum.removeAllElements();
                this.menuButton.setPosition(2, 2);
                this.currentLevel = 10;
                this.timeOfGame = 0.0f;
                this.lastPressedNumber = 0;
                int k = 0;
                while (k < this.numbers.length) {
                    this.numbers[k].setVisible(true);
                    this.numbers[k].setEffect(0);
                    ++k;
                }
                int i = 0;
                while (i < this.positionNumbers.length) {
                    this.positionNumbers[i] = false;
                    ++i;
                }
                i = 1;
                while (i <= this.positionNumbers.length) {
                    int position = this.rand.nextInt(this.positionNumbers.length);
                    while (this.positionNumbers[position]) {
                        position = this.rand.nextInt(this.positionNumbers.length);
                    }
                    this.numbers[position].setNumber(i);
                    this.positionNumbers[position] = true;
                    ++i;
                }
                i = 0;
                while (i < this.positionNumbers.length) {
                    this.positionNumbers[i] = false;
                    ++i;
                }
                i = 26;
                while (i <= 50) {
                    Integer k2 = new Integer(i);
                    this.integerNum.addElement(k2);
                    ++i;
                }
                this.timerForHelp = 7;
                break;
            }
            case 111: {
                this.currentResult = String.valueOf(L10n.get("YOUR_RESULT")) + " " + this.drawTimer(this.timeOfGame);
                this.currentLevel = 111;
                this.saveGame();
                break;
            }
            case 20: {
                this.timerForHelp = 7;
                this.numbers[this.numOfPreessedButton].setEffect(0);
                if (this.lastPressedNumber == 50) {
                    this.handleEvent(111);
                }
                if (this.lastPressedNumber <= 25) {
                    int numberToSet = 0;
                    int randomIndex = this.rand.nextInt(this.integerNum.size());
                    numberToSet = (Integer)this.integerNum.elementAt(randomIndex);
                    this.numbers[this.numOfPreessedButton].setNumber(numberToSet);
                    this.integerNum.removeElementAt(randomIndex);
                } else {
                    this.numbers[this.numOfPreessedButton].setVisible(false);
                }
                this.numbers[this.numOfPreessedButton].setEffect(2);
                this.timerForHelp = 7;
                this.buttonIsPressed = false;
                break;
            }
            case 25: {
                this.numbers[this.numOfPreessedButton].setEffect(1);
                this.buttonIsPressed = false;
                break;
            }
            case 122: {
                int next = 0;
                int index = 0;
                int i = 0;
                while (i < this.numbers.length) {
                    next = this.numbers[i].getNumber();
                    if (next == this.lastPressedNumber + 1) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                this.numbers[index].setEffect(3);
            }
        }
    }

    private void checkEvent(int position) {
        int numberForCheck = this.numbers[position].getNumber();
        if (numberForCheck - this.lastPressedNumber == 1) {
            this.lastPressedNumber = numberForCheck;
            this.handleEvent(20);
        } else {
            this.handleEvent(25);
        }
    }

    public String drawTimer(float millSeconds) {
        String zero = "";
        String zero1 = "";
        long mil = (long)millSeconds % 100L;
        long sec = (long)millSeconds / 1000L;
        zero1 = mil < 10L ? "0" : "";
        if (sec <= 10L) {
            zero = "00";
        }
        if (sec > 10L & sec <= 100L) {
            zero = "0";
        }
        if (sec > 100L) {
            zero = "";
        }
        return String.valueOf(zero) + Long.toString(sec) + " : " + zero1 + Long.toString(mil);
    }

    private void saveGame() {
        int currentRes = (int)this.timeOfGame;
        int maxResult = HelperRMS.readFromRMS(1);
        if (currentRes < maxResult || maxResult == 0) {
            HelperRMS.writeToRMS(currentRes, 1);
        }
        HelperRMS.writeToRMS(currentRes, 2);
    }
}

