/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;

public final class DrawUtil {
    static int COLOR_BIT_MASK = 255;
    public static byte[][] FILTER_GAUSSIAN_2 = new byte[][]{{1, 2, 1}, {2, 4, 2}, {1, 2, 1}};
    public static byte[][] FILTER_GAUSSIAN_3 = new byte[][]{{0, 1, 2, 1, 0}, {1, 3, 5, 3, 1}, {2, 5, 9, 5, 2}, {1, 3, 5, 3, 1}, {0, 1, 2, 1, 0}};

    public static final void fillPolygon(int[] xValues, int[] yValues, int color, Graphics g2) {
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g2);
        if ((color & 0xFF0000) == 0) {
            color |= 0xFF0000;
        }
        dg.fillPolygon(xValues, 0, yValues, 0, xValues.length, color);
    }

    public static final int[] getGradient(int startColor, int endColor, int steps) {
        int[] gradient = new int[steps];
        DrawUtil.getGradient(startColor, endColor, gradient);
        return gradient;
    }

    public static void getGradient(int startColor, int endColor, int[] gradient) {
        int steps = gradient.length;
        if (steps == 0) {
            return;
        }
        int startAlpha = startColor >>> 24;
        int startRed = startColor >>> 16 & 0xFF;
        int startGreen = startColor >>> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endAlpha = endColor >>> 24;
        int endRed = endColor >>> 16 & 0xFF;
        int endGreen = endColor >>> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        int stepAlpha = (endAlpha - startAlpha << 8) / (steps - 1);
        int stepRed = (endRed - startRed << 8) / (steps - 1);
        int stepGreen = (endGreen - startGreen << 8) / (steps - 1);
        int stepBlue = (endBlue - startBlue << 8) / (steps - 1);
        startAlpha <<= 8;
        startRed <<= 8;
        startGreen <<= 8;
        startBlue <<= 8;
        gradient[0] = startColor;
        for (int i = 1; i < steps; ++i) {
            gradient[i] = (startAlpha += stepAlpha) << 16 & 0xFF000000 | (startRed += stepRed) << 8 & 0xFF0000 | (startGreen += stepGreen) & 0xFF00 | (startBlue += stepBlue) >>> 8;
        }
    }

    public static int getComplementaryColor(int color) {
        return 0xFF000000 & color | 255 - ((0xFF0000 & color) >> 16) << 16 | 255 - ((0xFF00 & color) >> 8) << 8 | 255 - (0xFF & color);
    }

    public static final void dropShadow(int[] argbData, int width, int height, int xOffset, int yOffset, int size, int innerColor, int outerColor) {
        int iLeft = size - xOffset < 0 ? 0 : size - xOffset;
        int iRight = size + xOffset < 0 ? 0 : size + xOffset;
        int iTop = size - yOffset < 0 ? 0 : size - yOffset;
        int iBottom = size + yOffset < 0 ? 0 : size + yOffset;
        int[] gradient = DrawUtil.getGradient(innerColor, outerColor, size);
        for (int ix = -size + 1; ix < size; ++ix) {
            for (int iy = -size + 1; iy < size; ++iy) {
                int r = (int)Math.sqrt(ix * ix + iy * iy);
                if (r >= size) continue;
                int gColor = gradient[r];
                for (int col = iLeft; col < width - iRight; ++col) {
                    for (int row = iTop; row < height - iBottom - 1; ++row) {
                        if (argbData[row * width + col] >>> 24 != 255 || argbData[(row + yOffset + iy) * width + col + xOffset + ix] >>> 24 >= gColor >>> 24) continue;
                        argbData[(row + yOffset + iy) * width + col + xOffset + ix] = gColor;
                    }
                }
            }
        }
    }

    public static final void applyFilter(byte[][] filterMatrix, int brightness, int[] argbData, int width, int height) {
        if (filterMatrix.length % 2 != 1 || filterMatrix[0].length % 2 != 1) {
            throw new IllegalArgumentException();
        }
        int fhRadius = filterMatrix.length / 2 + 1;
        int fwRadius = filterMatrix[0].length / 2 + 1;
        int currentPixel = 0;
        int divisor = 0;
        for (int fRow = 0; fRow < filterMatrix.length; ++fRow) {
            for (int fCol = 0; fCol < filterMatrix[0].length; ++fCol) {
                divisor += filterMatrix[fRow][fCol];
            }
        }
        if (divisor == 0) {
            return;
        }
        int[] tmpRect = new int[width * filterMatrix.length];
        System.arraycopy(argbData, 0, tmpRect, 0, width * filterMatrix.length);
        int row = fhRadius - 1;
        while (row + fhRadius < height + 1) {
            int col = fwRadius - 1;
            while (col + fwRadius < width + 1) {
                int newTran = 0;
                int newRed = 0;
                int newGreen = 0;
                int newBlue = 0;
                for (int fRow = 0; fRow < filterMatrix.length; ++fRow) {
                    for (int fCol = 0; fCol < filterMatrix[0].length; ++fCol) {
                        currentPixel = tmpRect[fRow * width + col + fCol - fwRadius + 1];
                        if ((currentPixel >>> 24 & COLOR_BIT_MASK) == 0) continue;
                        newTran += filterMatrix[fRow][fCol] * (currentPixel >>> 24 & COLOR_BIT_MASK);
                        newRed += filterMatrix[fRow][fCol] * (currentPixel >>> 16 & COLOR_BIT_MASK);
                        newGreen += filterMatrix[fRow][fCol] * (currentPixel >>> 8 & COLOR_BIT_MASK);
                        newBlue += filterMatrix[fRow][fCol] * (currentPixel & COLOR_BIT_MASK);
                    }
                }
                newTran = newTran * brightness / 100 / divisor;
                newRed = newRed * brightness / 100 / divisor;
                newGreen = newGreen * brightness / 100 / divisor;
                newBlue = newBlue * brightness / 100 / divisor;
                newTran = Math.max(0, Math.min(255, newTran));
                newRed = Math.max(0, Math.min(255, newRed));
                newGreen = Math.max(0, Math.min(255, newGreen));
                newBlue = Math.max(0, Math.min(255, newBlue));
                argbData[row * width + col] = newTran << 24 | newRed << 16 | newGreen << 8 | newBlue;
                ++col;
            }
            if (row + fhRadius != height) {
                System.arraycopy(tmpRect, width, tmpRect, 0, width * (filterMatrix.length - 1));
                System.arraycopy(argbData, width * (row + fhRadius), tmpRect, width * (filterMatrix.length - 1), width);
            }
            ++row;
        }
    }

    public static class FadeUtil {
        public final int FADE_IN;
        public final int FADE_OUT;
        public final int FADE_LOOP;
        public final int FADE_BREAK;
        public int[] gradient;
        public boolean changed;
        public int startColor = -16744193;
        public int endColor = -8323328;
        public int steps;
        public int delay = 0;
        public int stepsIn = 5;
        public int stepsOut = 5;
        public int sWaitTimeIn = 10;
        public int sWaitTimeOut = 0;
        public int mode;
        public int cColor;
        public int cStep;

        public FadeUtil() {
            this.FADE_IN = 1;
            this.FADE_OUT = 2;
            this.FADE_LOOP = 3;
            this.FADE_BREAK = 0;
            this.getClass();
            this.mode = 3;
        }

        private void initialize() {
            this.cStep = 0;
            switch (this.mode) {
                case 2: {
                    this.stepsIn = 0;
                    this.sWaitTimeIn = 0;
                    this.cColor = this.endColor;
                    break;
                }
                case 1: {
                    this.stepsOut = 0;
                    this.sWaitTimeOut = 0;
                    this.cColor = this.startColor;
                    break;
                }
                default: {
                    this.cColor = this.startColor;
                }
            }
            this.cStep -= this.delay;
            this.steps = this.stepsIn + this.stepsOut + this.sWaitTimeIn + this.sWaitTimeOut;
            this.gradient = DrawUtil.getGradient(this.startColor, this.endColor, Math.max(this.stepsIn, this.stepsOut));
        }

        public boolean step() {
            ++this.cStep;
            if (this.gradient == null | this.changed) {
                this.initialize();
            }
            this.changed = false;
            this.getClass();
            if (this.mode == 0) {
                return false;
            }
            if (this.cStep < 0) {
                return true;
            }
            if (this.cStep == this.steps) {
                this.cStep = 0;
                this.getClass();
                if (this.mode != 3) {
                    this.getClass();
                    this.mode = 0;
                    return true;
                }
            }
            if (this.cStep < this.stepsIn) {
                this.cColor = this.gradient[this.cStep];
                return true;
            }
            if (this.cStep < this.stepsIn + this.sWaitTimeIn) {
                if (this.cColor != this.endColor) {
                    this.cColor = this.endColor;
                    return true;
                }
            } else {
                if (this.cStep < this.stepsIn + this.sWaitTimeIn + this.stepsOut) {
                    this.cColor = this.gradient[this.stepsIn + this.sWaitTimeIn + this.stepsOut - this.cStep - 1];
                    return true;
                }
                if (this.cColor != this.startColor) {
                    this.cColor = this.startColor;
                    return true;
                }
            }
            return false;
        }
    }
}

