/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public abstract class Monster {
    private Image monsterImage;
    protected Sprite monster;
    private boolean isFlipBack;
    protected Graphics g;
    public int money;
    public int exp;
    public int weakness;
    public int state;
    public int hp;
    public int maxHp;
    public int atk;
    public int def;
    public int spd;
    public int[] animWalk;
    public int[] animIdle;
    public int nAnimWalk;
    public int nAnimIdle;
    public int damagedFrame;
    public int deathFrame;
    public int idx;
    public int x;
    public int y;
    public int xAwal;
    public int yAwal;
    protected int vY;
    protected int deathCount;

    public Monster(Graphics g, String imageLoc, boolean isFlipBack, int width, int height, int x, int money, int exp, int weakness, int maxHp, int atk, int def, int spd, int[] animWalk, int[] animIdle, int damagedFrame, int deathFrame) {
        this.g = g;
        this.isFlipBack = isFlipBack;
        this.hp = maxHp;
        this.maxHp = maxHp;
        this.atk = atk;
        this.def = def;
        this.spd = spd;
        this.x = x;
        this.animWalk = animWalk;
        this.animIdle = animIdle;
        this.damagedFrame = damagedFrame;
        this.deathFrame = deathFrame;
        this.money = money;
        this.exp = exp;
        this.weakness = weakness;
        this.yAwal = this.y = 232 - height;
        this.xAwal = 320 - width;
        this.idx = 0;
        this.state = 0;
        this.deathCount = 10;
        this.nAnimIdle = animIdle.length;
        this.nAnimWalk = animWalk.length;
        try {
            this.monsterImage = Image.createImage((String)imageLoc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.monster = new Sprite(this.monsterImage, width, height);
    }

    public void idle() {
        this.state = 0;
        this.idx = 0;
    }

    public void damaged(int damage) {
        this.hp -= damage;
        if (this.hp < 0) {
            this.hp = 0;
        }
        this.vY = 5;
        this.state = 3;
        this.idx = 0;
    }

    public void goBack() {
        if (this.isFlipBack) {
            this.monster.setTransform(2);
        }
        this.state = 2;
        this.idx = 0;
    }

    public void walk() {
        this.state = 1;
        this.idx = 0;
    }

    public void drawDeathFrame() {
        this.monster.setRefPixelPosition(this.x, this.y);
        this.monster.setFrame(this.deathFrame);
        this.monster.paint(this.g);
    }

    public void act() {
        switch (this.state) {
            case 0: {
                this.monster.setRefPixelPosition(this.x, this.yAwal);
                this.monster.setFrame(this.animIdle[this.idx]);
                ++this.idx;
                if (this.idx >= this.nAnimIdle) {
                    this.idx = 0;
                }
                this.monster.paint(this.g);
                break;
            }
            case 1: {
                this.monster.setRefPixelPosition(this.x, this.yAwal);
                this.monster.setFrame(this.animWalk[this.idx]);
                ++this.idx;
                if (this.idx >= this.nAnimWalk) {
                    this.idx = 0;
                }
                this.monster.paint(this.g);
                this.x -= 25;
                break;
            }
            case 2: {
                this.monster.setRefPixelPosition(this.x, this.yAwal);
                this.monster.setFrame(this.animWalk[this.idx]);
                ++this.idx;
                if (this.idx >= this.nAnimWalk) {
                    this.idx = 0;
                }
                this.monster.paint(this.g);
                this.x += 25;
                if (this.isFlipBack) {
                    if (this.x < 320) break;
                    this.monster.setTransform(0);
                    this.x = this.xAwal;
                    this.state = 0;
                    break;
                }
                if (this.x < this.xAwal) break;
                this.x = this.xAwal;
                this.state = 0;
                break;
            }
            case 3: {
                this.monster.setRefPixelPosition(this.x, this.y);
                this.monster.setFrame(this.damagedFrame);
                this.y -= this.vY;
                --this.vY;
                this.x += 25;
                if (this.x >= this.xAwal) {
                    this.x = this.xAwal;
                }
                if (this.y >= this.yAwal) {
                    this.y = this.yAwal;
                }
                if (this.x == this.xAwal && this.y == this.yAwal) {
                    this.state = this.hp > 0 ? 0 : 4;
                }
                this.monster.paint(this.g);
                break;
            }
            case 4: {
                if (this.deathCount % 2 == 0) {
                    this.monster.setRefPixelPosition(this.x, this.y);
                    this.monster.setFrame(this.deathFrame);
                    this.monster.paint(this.g);
                }
                --this.deathCount;
                if (this.deathCount > 0) break;
                this.state = 5;
            }
        }
    }
}

