/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SkillBox
extends Box {
    protected Image[] icon;
    protected Image disabledImage;
    protected clsFont kuningText;
    protected boolean isItem;
    protected int delay;
    protected int totDelay;
    protected int opacity;
    protected int[] rgbPixel;
    protected Graphics gText;
    protected int[] qOrC;
    protected boolean blockBox;
    public int activeIcon;
    public int availableItem;

    public SkillBox(Graphics g, Graphics gText, int x, int y, String[] iconLoc, boolean isItem, int[] qOrC, int totDelay, int availableItem) {
        super(g, x, y);
        this.gText = gText;
        this.isItem = isItem;
        this.totDelay = totDelay;
        this.activeIcon = 0;
        this.availableItem = availableItem;
        this.kuningText = new clsFont();
        this.blockBox = false;
        this.delay = 0;
        this.opacity = 0x7D000000;
        this.rgbPixel = new int[1225];
        this.qOrC = qOrC;
        int i = 0;
        while (i < 1225) {
            this.rgbPixel[i] = this.opacity;
            ++i;
        }
        try {
            this.icon = new Image[iconLoc.length];
            i = 0;
            while (i < this.icon.length) {
                this.icon[i] = Image.createImage((String)iconLoc[i]);
                ++i;
            }
            this.disabledImage = Image.createImage((String)"/none.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAvailable(int available) {
        this.availableItem = available;
    }

    public void drawBox() {
        super.drawBox();
        if (this.availableItem > 0) {
            this.g.drawImage(this.icon[this.activeIcon], this.x + 5, this.y + 5, 0);
            if (this.blockBox) {
                this.g.drawRGB(this.rgbPixel, 0, 35, this.x + 5, this.y + 5, 35, 35, true);
                this.g.drawRGB(this.rgbPixel, 0, 35, this.x + 5, this.y + 5, 35, 35, true);
            } else if (this.delay > 0) {
                this.g.drawRGB(this.rgbPixel, 0, 35, this.x + 5, this.y + 5, 35, 35, true);
                this.g.drawRGB(this.rgbPixel, 0, 35, this.x + 5, this.y + 5 + 35 * (this.totDelay - this.delay) / this.totDelay, 35, 35 * this.delay / this.totDelay, true);
                --this.delay;
            }
            if (this.isItem) {
                this.kuningText.drawString(this.gText, "x" + this.qOrC[this.activeIcon], this.x + 10, this.y + 30);
            } else {
                this.kuningText.drawString(this.gText, this.qOrC[this.activeIcon] + "MP", this.x + 10, this.y + 30);
            }
        } else {
            this.g.drawImage(this.disabledImage, this.x + 5, this.y + 5, 0);
        }
    }

    public void cleanUp() {
        this.blockBox = false;
        this.delay = 0;
    }

    public void setQOrC(int[] qOrC) {
        this.qOrC = qOrC;
    }

    public void changeUp() {
        --this.activeIcon;
        if (this.activeIcon < 0) {
            this.activeIcon = this.availableItem - 1;
        }
    }

    public void changeDown() {
        ++this.activeIcon;
        if (this.activeIcon >= this.availableItem) {
            this.activeIcon = 0;
        }
    }

    public boolean selectBox() {
        if (this.delay > 0 || this.availableItem <= 0) {
            return false;
        }
        this.blockBox = false;
        this.delay = this.totDelay;
        return true;
    }

    public boolean blockBox() {
        if (this.blockBox || this.delay > 0 || this.availableItem <= 0) {
            return false;
        }
        this.blockBox = true;
        return true;
    }

    public boolean cekMP(int mp) {
        return mp >= this.qOrC[this.activeIcon];
    }

    public boolean cekAvailable() {
        return this.qOrC[this.activeIcon] > 0;
    }
}

