/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.dymix.PhysicsException;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Matrix2x2;
import com.hardwire.utils.Vector2;

public class DynamicObject
extends PhysicalObject {
    private Vector2 linVel;
    private Vector2 force_shiftedRight;
    private int angle_shifted;
    private int angVel_shifted;
    private long torque_shiftedRight;
    private Matrix2x2 orientation;
    private int mass_shiftedRight;
    private int inertia_shiftedRight;
    private int invMass_shifted2;
    private int invInertia_shifted2;
    private byte sleepCounter;
    private boolean spawned;
    private boolean isBullet;
    private Vector2 draw_centerPos;
    private int draw_angle_shifted2;
    public int _id;
    private static int[] oldAABB = new int[4];
    private static Vector2 tmpVector = new Vector2();

    public void initBody(DynamicWorld pWorld, CollisionProxy pProxy) throws PhysicsException {
        this.initBody(pWorld, pProxy, 512, 512, 1024, false);
    }

    public void initBody(DynamicWorld pWorld, CollisionProxy pProxy, int pCoF, int pCoR, int pDensity, boolean pUseDrawData) throws PhysicsException {
        super._initBody(pWorld, pProxy, pCoF, pCoR);
        this.isDynamic = true;
        this.force_shiftedRight = new Vector2();
        this.torque_shiftedRight = 0L;
        this.linVel = new Vector2();
        this.angVel_shifted = 0;
        this.orientation = new Matrix2x2();
        if (pDensity == 0) {
            this.mass_shiftedRight = 0;
            this.inertia_shiftedRight = 0;
            this.invMass_shifted2 = 0;
            this.invInertia_shifted2 = 0;
        } else {
            this.computeMass(pDensity);
            this.computeInertia(this.mass_shiftedRight);
        }
        this.sleepCounter = 0;
        this.spawned = false;
        this.isBullet = false;
        if (pUseDrawData) {
            this.draw_centerPos = new Vector2();
            this.draw_angle_shifted2 = Integer.MAX_VALUE;
        }
    }

    public void spawnBody(Vector2 pPosition, int pAngle) throws PhysicsException {
        super.spawnBody(pPosition, pAngle);
        this.angle_shifted = pAngle;
        this.orientation.computeFromAngle(this.angle_shifted);
        this.world._addObject(this, true);
        this.spawned = true;
    }

    public void despawnBody() throws PhysicsException {
        this.spawned = false;
        this.world._removeObject(this, true);
    }

    public Vector2 getDrawPosition() {
        if (this.draw_centerPos == null) {
            return this.getPosition();
        }
        return this.draw_centerPos;
    }

    public int getDrawAngle_shifted() {
        if (this.draw_centerPos == null) {
            return this.getAngle_shifted();
        }
        return this.draw_angle_shifted2;
    }

    public void updateDrawData() {
        int angle;
        int da;
        Vector2 pos = this.getPosition();
        int dx = this.draw_centerPos.x - pos.x;
        int dy = this.draw_centerPos.y - pos.y;
        if (dx < -512 || dx > 512 || dy < -512 || dy > 512) {
            this.draw_centerPos.x = pos.x;
            this.draw_centerPos.y = pos.y;
        }
        if ((da = this.draw_angle_shifted2 - (angle = this.getAngle_shifted())) < -91505 || da > 91505) {
            this.draw_angle_shifted2 = angle;
        }
    }

    public void resetDrawData() {
        Vector2 pos = this.getPosition();
        this.draw_centerPos.x = pos.x;
        this.draw_centerPos.y = pos.y;
        this.draw_angle_shifted2 = this.getAngle_shifted();
    }

    public void recomputeBoundingBox() throws PhysicsException {
        if (this.world.getType() == 0) {
            int[] aabb = this.getBoundingBox();
            DynamicObject.oldAABB[0] = aabb[0];
            DynamicObject.oldAABB[1] = aabb[1];
            DynamicObject.oldAABB[2] = aabb[2];
            DynamicObject.oldAABB[3] = aabb[3];
        }
        this._recomputeBoundingBox();
        if (this.world.getType() == 0) {
            this.world._bp_grid_dynamic.updateObject(this._id, oldAABB, this.getBoundingBox());
        }
    }

    public void setBullet(boolean pIsBullet) {
        this.isBullet = pIsBullet;
    }

    public boolean isBullet() {
        return this.isBullet;
    }

    public void setMass(long pMass) throws PhysicsException {
        this.mass_shiftedRight = (int)(pMass >> 10);
        if (this.mass_shiftedRight <= 0) {
            DynamicWorld._error((byte)1);
        }
        this.invMass_shifted2 = (int)(0x10000000000L / pMass);
        if (this.invMass_shifted2 <= 0) {
            DynamicWorld._error((byte)1);
        }
    }

    public void setInertia(long pInertia) throws PhysicsException {
        this.inertia_shiftedRight = (int)(pInertia >> 10);
        if (this.inertia_shiftedRight < 0) {
            DynamicWorld._error((byte)2);
        }
        int n = this.invInertia_shifted2 = this.inertia_shiftedRight == 0 ? 0 : (int)(0x10000000000L / pInertia);
        if (this.invInertia_shifted2 <= 0 && this.inertia_shiftedRight != 0) {
            DynamicWorld._error((byte)2);
        }
    }

    public void addForce(Vector2 pForce) {
        this.force_shiftedRight.add(pForce);
    }

    public void addForceTimesMass(Vector2 pForce) {
        this.force_shiftedRight.x = (int)((long)this.force_shiftedRight.x + ((long)pForce.x * (long)this.mass_shiftedRight >> 10));
        this.force_shiftedRight.y = (int)((long)this.force_shiftedRight.y + ((long)pForce.y * (long)this.mass_shiftedRight >> 10));
    }

    public void addForceAtPoint(Vector2 pForce, Vector2 pPoint) {
        this.force_shiftedRight.add(pForce);
        this.torque_shiftedRight -= (long)pForce.crossProductWithShift(pPoint.minus(this.getPosition()));
    }

    public void addForceAtPointTimesMass(Vector2 pForce, Vector2 pPoint) {
        this.force_shiftedRight.add(pForce.timesWithShift(this.mass_shiftedRight));
        this.torque_shiftedRight -= (long)this.mass_shiftedRight * (long)pForce.crossProductWithShift(pPoint.minus(this.getPosition()));
    }

    public void addForceAtPointInLocalCoords(Vector2 pForce, Vector2 pPoint) {
        this.force_shiftedRight.add(pForce);
        tmpVector.copy(pPoint);
        tmpVector.multiplyTransposedWithShift(this.getOrientation());
        this.torque_shiftedRight -= (long)pForce.crossProduct(tmpVector);
    }

    public void addForceAtPointInLocalCoordsTimesMass(Vector2 pForce, Vector2 pPoint) {
        this.force_shiftedRight.add(pForce.timesWithShift(this.getOrientation()).timesWithShift(this.mass_shiftedRight));
        this.torque_shiftedRight -= (long)this.mass_shiftedRight * (long)pForce.crossProductWithShift(pPoint);
    }

    public void addTorque(long pTorque) {
        this.torque_shiftedRight += pTorque;
    }

    public void addTorqueTimesInertia(long pTorque) {
        this.torque_shiftedRight += pTorque * (long)this.inertia_shiftedRight >> 10;
    }

    public void _updateDynamics() throws PhysicsException {
        if (this.world == null) {
            DynamicWorld._error((byte)6);
            return;
        }
        if (this.mass_shiftedRight == 0) {
            return;
        }
        long threshold = this.world.getSleepLinVelThreshold_squared();
        if (threshold != -1L && this.sleepCounter >= 0) {
            if (this.linVel.length_squared() < threshold && (this.angVel_shifted < 0 ? -this.angVel_shifted : this.angVel_shifted) < this.world.getSleepAngVelThreshold_shifted()) {
                this.sleepCounter = (byte)(this.sleepCounter + 1);
                if (this.sleepCounter > this.world.getSleepMaxCounter()) {
                    this._sleep();
                    return;
                }
            } else {
                this.sleepCounter = 0;
            }
        }
        int tmp_x = this.linVel.x;
        int tmp_y = this.linVel.y;
        this.angle_shifted = MathUtils.wrapAngle(this.angle_shifted + this.angVel_shifted);
        if (this.angVel_shifted != 0) {
            this.orientation.computeFromAngle(this.angle_shifted);
        }
        this.force_shiftedRight.multiplyWithShift(this.invMass_shifted2, 3);
        this.linVel.add(this.force_shiftedRight);
        if (this.inertia_shiftedRight > 0) {
            this.angVel_shifted = (int)((long)this.angVel_shifted + (this.torque_shiftedRight * (long)this.invInertia_shifted2 >> 30));
        }
        Vector2 pos = this.getPosition();
        pos.x += tmp_x;
        pos.y += tmp_y;
        this.recomputeBoundingBox();
        this.notifyFromDynamics();
        this._zeroForces();
    }

    public void translatePosition(Vector2 pChange) throws PhysicsException {
        if (!this.spawned) {
            DynamicWorld._error((byte)15);
            return;
        }
        this.getPosition().add(pChange);
        this.recomputeBoundingBox();
    }

    public void changePosition(Vector2 pNewPos) throws PhysicsException {
        if (!this.spawned) {
            DynamicWorld._error((byte)15);
            return;
        }
        this.getPosition().copy(pNewPos);
        this.recomputeBoundingBox();
    }

    public void _zeroForces() {
        this.force_shiftedRight.zero();
        this.torque_shiftedRight = 0L;
    }

    protected void notifyFromDynamics() {
    }

    private void computeMass(int pDensity) throws PhysicsException {
        if (this.getCollisionProxy().getData().length == 1) {
            this.setMass(10 * pDensity);
        } else if (this.getCollisionProxy().getData().length == 2) {
            this.setMass(this.getCollisionProxy()._getNumer() * (long)pDensity >> 10);
        } else {
            this.setMass(this.getCollisionProxy()._getNumer() * (long)pDensity >> 11);
        }
    }

    private void computeInertia(int pMass_shiftedRight) throws PhysicsException {
        if (this.getCollisionProxy().getData().length == 1) {
            this.setInertia(0L);
        } else {
            this.setInertia((this.getCollisionProxy()._getDenom() * (long)pMass_shiftedRight << 10) / this.getCollisionProxy()._getNumer() / 6L);
        }
    }

    public int getAngle_shifted() {
        return this.angle_shifted;
    }

    public void _setAngle_shifted(int pNewAngle) {
        if (this.angle_shifted != pNewAngle) {
            this.angle_shifted = MathUtils.wrapAngle(pNewAngle);
            this.orientation.computeFromAngle(this.angle_shifted);
        }
    }

    public void setAngle_shifted(int pNewAngle) throws PhysicsException {
        if (this.angle_shifted != pNewAngle) {
            this.angle_shifted = MathUtils.wrapAngle(pNewAngle);
            this.orientation.computeFromAngle(this.angle_shifted);
            this.recomputeBoundingBox();
        }
    }

    public int getAngularVelocity_shifted() {
        return this.angVel_shifted;
    }

    public void setAngularVelocity_shifted(int pNew) {
        this.angVel_shifted = pNew;
    }

    public int getInertia_shiftedRight() {
        return this.inertia_shiftedRight;
    }

    public int getInvInertia_shifted2() {
        return this.invInertia_shifted2;
    }

    public int getInvMass_shifted2() {
        return this.invMass_shifted2;
    }

    public Vector2 getLinearVelocity() {
        return this.linVel;
    }

    public int getMass_shiftedRight() {
        return this.mass_shiftedRight;
    }

    public Matrix2x2 getOrientation() {
        return this.orientation;
    }

    public boolean isAsleep() {
        return this.sleepCounter == -1;
    }

    public void setCanSleep(boolean pCanSleep) {
        if (!pCanSleep) {
            this.sleepCounter = (byte)-2;
        } else if (this.sleepCounter == -2) {
            this.sleepCounter = 0;
        }
    }

    public void _sleep() {
        if (this.sleepCounter != -2) {
            this.sleepCounter = (byte)-1;
        }
    }

    public void forceSleep() {
        if (this.sleepCounter != -2) {
            this.sleepCounter = (byte)-1;
        }
    }

    public void wakeUp() {
        if (this.sleepCounter != -2) {
            this.sleepCounter = 0;
            this._zeroForces();
        }
    }
}

